/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.DataRowExpressionEvaluatorAdapter;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesGroupingImpl;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.AbstractChartBaseQueryGenerator;
import org.eclipse.birt.chart.reportitem.BIRTCubeResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.BaseGroupedQueryResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.ChartBaseQueryHelper;
import org.eclipse.birt.chart.reportitem.ChartCubeQueryHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.SharedCubeResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIActivator;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIFactory;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.DteAdapter;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ColumnBindingInfo;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.DummyEngineTask;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngineFactory;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.re.CrosstabQueryUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.util.CubeUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDataServiceProvider
implements IDataServiceProvider {
    protected ExtendedItemHandle itemHandle;
    protected ChartWizardContext context;
    private final ShareBindingQueryHelper fShareBindingQueryHelper = new ShareBindingQueryHelper();
    static final String OPTION_NONE = Messages.getString("ReportDataServiceProvider.Option.None");
    ChartReportItemUIFactory uiFactory = ChartReportItemUIFactory.instance();
    DteAdapter dteAdapter = this.uiFactory.createDteAdapter();
    protected Object sessionLock = new Object();
    private boolean isErrorFound = false;
    private IProject project = null;
    protected DataRequestSession session = null;
    private ReportEngine engine = null;
    private ChartDummyEngineTask engineTask = null;
    private Object dataSetReference = null;
    protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();

    public ReportDataServiceProvider(ExtendedItemHandle itemHandle) {
        this.itemHandle = itemHandle;
        this.project = UIUtil.getCurrentProject();
    }

    public void initialize() throws ChartException {
        try {
            if (this.isReportDesignHandle()) {
                this.engine = (ReportEngine)new ReportEngineFactory().createReportEngine(new EngineConfig());
                this.engineTask = new ChartDummyEngineTask(this.engine, new ReportEngineHelper(this.engine).openReportDesign((ReportDesignHandle)this.itemHandle.getModuleHandle()), this.itemHandle.getModuleHandle());
            }
            if (this.isReportDesignHandle()) {
                this.session = this.prepareDataRequestSession((EngineTask)this.engineTask, this.getMaxRow(), false);
                this.engineTask.run();
            } else {
                this.session = this.prepareDataRequestSession(this.getMaxRow(), false);
            }
        }
        catch (BirtException e) {
            if (this.engine == null && this.session != null) {
                this.session.shutdown();
            }
            if (this.engineTask != null) {
                this.engineTask.close();
            }
            throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
        }
    }

    public void dispose() {
        if (this.engineTask != null) {
            this.engineTask.close();
        } else if (this.session != null) {
            this.session.shutdown();
        }
    }

    public void setWizardContext(ChartWizardContext context) {
        this.context = context;
    }

    ModuleHandle getReportDesignHandle() {
        return this.itemHandle.getModuleHandle();
    }

    protected String[] getAllDataSets() {
        List list = this.getReportDesignHandle().getVisibleDataSets();
        String[] names = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            names[i] = ((DataSetHandle)list.get(i)).getQualifiedName();
            ++i;
        }
        return names;
    }

    protected String[] getAllDataCubes() {
        List list = this.getReportDesignHandle().getVisibleCubes();
        String[] names = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            names[i] = ((CubeHandle)list.get(i)).getQualifiedName();
            ++i;
        }
        return names;
    }

    String getDataCube() {
        CubeHandle cube = this.itemHandle.getCube();
        if (cube == null) {
            return null;
        }
        return cube.getQualifiedName();
    }

    String getInheritedCube() {
        CubeHandle cube = null;
        DesignElementHandle container = this.itemHandle.getContainer();
        while (container != null) {
            if (container instanceof ReportItemHandle && (cube = ((ReportItemHandle)container).getCube()) != null) break;
            container = container.getContainer();
        }
        if (cube == null) {
            return null;
        }
        return cube.getQualifiedName();
    }

    void setDataCube(String cubeName) {
        try {
            boolean isPreviousDataBindingReference = false;
            if (this.itemHandle.getDataBindingType() == 2) {
                isPreviousDataBindingReference = true;
                this.itemHandle.setDataBindingReference(null);
            }
            this.itemHandle.setDataSet(null);
            if (cubeName == null) {
                this.itemHandle.setCube(null);
                this.clearBindings();
            } else if (!cubeName.equals(this.getDataCube()) || isPreviousDataBindingReference) {
                CubeHandle cubeHandle = this.getReportDesignHandle().findCube(cubeName);
                this.itemHandle.setCube(cubeHandle);
                this.clearBindings();
                this.generateBindings(this.generateComputedColumns(cubeHandle));
            }
            ChartWizard.removeException((String)"ReportDataServiceProvider.setDataCube");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setDataCube", (String)e.getLocalizedMessage());
        }
    }

    public final String[] getPreviewHeader() {
        Iterator iterator = ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)this.itemHandle);
        ArrayList<String> list = new ArrayList<String>();
        boolean bInheritColumnsOnly = this.isInheritColumnsOnly();
        while (iterator.hasNext()) {
            ComputedColumnHandle binding = (ComputedColumnHandle)iterator.next();
            if (bInheritColumnsOnly && binding.getAggregateFunction() != null) continue;
            list.add(binding.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Object[]> getPreviewData() throws ChartException {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.engineTask != null) {
                try {
                    this.engineTask.run();
                }
                catch (EngineException e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
                }
            }
            List<Object[]> values = null;
            values = this.isSharedBinding() || this.isInheritColumnsGroups() ? this.fShareBindingQueryHelper.getPreviewRowData(this.getPreviewHeadersInfo(), -1, true) : this.getPreviewRowData(this.getPreviewHeader(false), -1, true);
            this.dataSetReference = ChartItemUtil.getBindingDataSet((DesignElementHandle)this.itemHandle);
            return values;
        }
    }

    private void removeIndirectRefOfAggregates(List<ComputedColumnHandle> list, Map<String, ComputedColumnHandle> bindingMap) throws BirtException {
        Iterator<ComputedColumnHandle> iter = list.iterator();
        while (iter.hasNext()) {
            ComputedColumnHandle cch = iter.next();
            if (this.isCommonBinding(cch, bindingMap)) continue;
            iter.remove();
        }
    }

    private boolean isCommonBinding(ComputedColumnHandle cch, Map<String, ComputedColumnHandle> bindingMap) throws BirtException {
        ScriptExpression se = ChartReportItemUtil.newExpression((IModelAdapter)this.session.getModelAdaptor(), (StructureHandle)cch);
        List bindings = ExpressionUtil.extractColumnExpressions((String)se.getText(), (String)"row");
        int i = 0;
        while (i < bindings.size()) {
            ComputedColumnHandle refCch = bindingMap.get(((IColumnBinding)bindings.get(i)).getResultSetColumnName());
            if (refCch.getAggregateFunction() != null) {
                return false;
            }
            if (refCch.getExpression() != null && !this.isCommonBinding(refCch, bindingMap)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final ColumnBindingInfo[] getPreviewHeadersInfo() throws ChartException {
        Iterator iterator = ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)this.itemHandle);
        if (iterator == null) {
            return new ColumnBindingInfo[0];
        }
        HashMap<String, ComputedColumnHandle> bindingMap = new HashMap<String, ComputedColumnHandle>();
        ArrayList<ComputedColumnHandle> columnList = new ArrayList<ComputedColumnHandle>();
        boolean bInheritColumnsOnly = this.isInheritColumnsOnly();
        while (iterator.hasNext()) {
            ComputedColumnHandle binding = (ComputedColumnHandle)iterator.next();
            bindingMap.put(binding.getName(), binding);
            if (bInheritColumnsOnly && binding.getAggregateFunction() != null) continue;
            columnList.add(binding);
        }
        try {
            if (bInheritColumnsOnly) {
                this.removeIndirectRefOfAggregates(columnList, bindingMap);
            }
        }
        catch (BirtException e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
        }
        if (columnList.size() == 0) {
            return new ColumnBindingInfo[0];
        }
        ColumnBindingInfo[] columnHeaders = null;
        if (this.isTableSharedBinding() || this.isInheritColumnsGroups()) {
            columnHeaders = this.fShareBindingQueryHelper.getPreviewHeadersInfo(columnList);
        } else {
            columnHeaders = new ColumnBindingInfo[columnList.size()];
            int i = 0;
            while (i < columnHeaders.length) {
                ComputedColumnHandle cch = (ComputedColumnHandle)columnList.get(i);
                columnHeaders[i] = new ColumnBindingInfo(cch.getName(), ExpressionUtil.createJSRowExpression((String)cch.getName()), null, null, (Object)cch);
                ++i;
            }
        }
        ArrayList<ColumnBindingInfo> columnsSet = new ArrayList<ColumnBindingInfo>();
        int i = columnHeaders.length - 1;
        while (i >= 0) {
            columnsSet.add(columnHeaders[i]);
            --i;
        }
        Collections.sort(columnsSet, new ColumnNameComprator());
        columnHeaders = columnsSet.toArray(new ColumnBindingInfo[0]);
        return columnHeaders;
    }

    private String[] getPreviewHeader(boolean isExpression) throws ChartException {
        ColumnBindingInfo[] cbis = this.getPreviewHeadersInfo();
        String[] exps = new String[cbis.length];
        int i = 0;
        ColumnBindingInfo[] columnBindingInfoArray = cbis;
        int n = cbis.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnBindingInfo cbi = columnBindingInfoArray[n2];
            exps[i] = isExpression ? ExpressionUtil.createJSRowExpression((String)cbi.getName()) : cbi.getName();
            ++i;
            ++n2;
        }
        return exps;
    }

    protected final List<Object[]> getPreviewRowData(String[] bindingNames, int rowCount, boolean isStringType) throws ChartException {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader parentLoader = oldContextLoader;
        if (parentLoader == null) {
            parentLoader = this.getClass().getClassLoader();
        }
        ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parentLoader, (ModuleHandle)this.itemHandle.getModuleHandle());
        Thread.currentThread().setContextClassLoader(newContextLoader);
        try {
            try {
                QueryDefinition queryDefn = new QueryDefinition();
                queryDefn.setMaxRows(this.getMaxRow());
                queryDefn.setDataSetName(this.getDataSetFromHandle().getQualifiedName());
                this.setQueryDefinitionWithDataSet(this.itemHandle, queryDefn);
                IQueryResults actualResultSet = this.executeDataSetQuery(queryDefn);
                if (actualResultSet != null) {
                    String[] expressions = bindingNames;
                    int columnCount = expressions.length;
                    IResultIterator iter = actualResultSet.getResultIterator();
                    while (iter.next()) {
                        int n;
                        Object[] record;
                        if (isStringType) {
                            record = new String[columnCount];
                            n = 0;
                            while (n < columnCount) {
                                record[n] = DataTypeUtil.toString((Object)iter.getValue(expressions[n]));
                                ++n;
                            }
                            dataList.add(record);
                            continue;
                        }
                        record = new Object[columnCount];
                        n = 0;
                        while (n < columnCount) {
                            record[n] = iter.getValue(expressions[n]);
                            ++n;
                        }
                        dataList.add(record);
                    }
                    actualResultSet.close();
                }
            }
            catch (BirtException e) {
                throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextLoader);
        }
        return dataList;
    }

    private boolean isReportDesignHandle() {
        return this.itemHandle.getModuleHandle() instanceof ReportDesignHandle;
    }

    private void handleGroup(QueryDefinition queryDefn, ExtendedItemHandle reportItemHandle, IModelAdapter modelAdapter) {
        ReportItemHandle handle = ChartReportItemUtil.getBindingHolder((DesignElementHandle)reportItemHandle);
        if (handle instanceof ListingHandle) {
            SlotHandle groups = ((ListingHandle)handle).getGroups();
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                ChartBaseQueryHelper.handleGroup((GroupHandle)((GroupHandle)iter.next()), (IBaseQueryDefinition)queryDefn, (IModelAdapter)modelAdapter);
            }
        }
    }

    private QueryDefinition resetParametersForDataPreview(DataSetHandle dataSetHandle, QueryDefinition queryDefn) {
        Iterator iterParams;
        LinkedHashMap<String, DataSetParameterHandle> dsphMap = new LinkedHashMap<String, DataSetParameterHandle>();
        if (dataSetHandle != null) {
            iterParams = dataSetHandle.parametersIterator();
            while (iterParams.hasNext()) {
                DataSetParameterHandle dsph = (DataSetParameterHandle)iterParams.next();
                dsphMap.put(dsph.getName(), dsph);
            }
        }
        iterParams = this.itemHandle.getPropertyHandle("paramBindings").iterator();
        LinkedHashMap<String, ParamBindingHandle> pbhMap = new LinkedHashMap<String, ParamBindingHandle>();
        while (iterParams.hasNext()) {
            ParamBindingHandle paramBindingHandle = (ParamBindingHandle)iterParams.next();
            pbhMap.put(paramBindingHandle.getParamName(), paramBindingHandle);
        }
        Object[] names = pbhMap.keySet().toArray();
        int i = 0;
        while (i < names.length) {
            DataSetParameterHandle dsph = (DataSetParameterHandle)dsphMap.get(names[i]);
            ScriptExpression se = null;
            String expr = ((ParamBindingHandle)pbhMap.get(names[i])).getExpression();
            se = dsph.getDefaultValue() != null && (expr == null || expr.indexOf("row[") >= 0 || expr.indexOf("row.") >= 0) ? new ScriptExpression(dsph.getDefaultValue()) : new ScriptExpression(expr);
            InputParameterBinding ipb = new InputParameterBinding((String)names[i], (IBaseExpression)se);
            queryDefn.addInputParamBinding(ipb);
            ++i;
        }
        return queryDefn;
    }

    String getDataSet() {
        if (this.itemHandle.getDataSet() == null) {
            return null;
        }
        return this.itemHandle.getDataSet().getQualifiedName();
    }

    boolean isInheritanceOnly() {
        return this.isInMultiView() || this.isInXTabMeasureCell();
    }

    boolean isInMultiView() {
        return this.itemHandle.getContainer() instanceof MultiViewsHandle;
    }

    String getInheritedDataSet() {
        List list = DEUtil.getDataSetList((DesignElementHandle)this.itemHandle.getContainer());
        if (list.size() > 0) {
            return ((DataSetHandle)list.get(0)).getQualifiedName();
        }
        return null;
    }

    public void setDataSet(String datasetName) {
        try {
            boolean isPreviousDataBindingReference = false;
            if (this.itemHandle.getDataBindingType() == 2) {
                isPreviousDataBindingReference = true;
                this.itemHandle.setDataBindingReference(null);
            }
            this.itemHandle.setCube(null);
            if (datasetName == null) {
                if (this.getDataSet() != null) {
                    this.clearBindings();
                }
                this.itemHandle.setDataSet(null);
            } else {
                DataSetHandle dataset = this.getReportDesignHandle().findDataSet(datasetName);
                if (isPreviousDataBindingReference || this.itemHandle.getDataSet() != dataset) {
                    this.itemHandle.setDataSet(dataset);
                    this.clearBindings();
                    this.generateBindings(this.generateComputedColumns(dataset));
                    EList sds = ChartUIUtil.getBaseSeriesDefinitions((Chart)this.context.getModel());
                    if (sds != null && sds.size() > 0) {
                        SeriesDefinition base = (SeriesDefinition)sds.get(0);
                        if (!"Gantt Chart".equals(this.context.getModel().getType())) {
                            if (base.getGrouping() == null) {
                                base.setGrouping(SeriesGroupingImpl.create());
                            }
                            base.getGrouping().setEnabled(true);
                        }
                    }
                }
            }
            ChartWizard.removeException((String)"ReportDataServiceProvider.setDataSet");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setDataSet", (String)e.getLocalizedMessage());
        }
    }

    private void clearBindings() throws SemanticException {
        this.clearProperty(this.itemHandle.getPropertyHandle("paramBindings"));
        this.clearProperty(this.itemHandle.getPropertyHandle("filter"));
        this.clearProperty(this.itemHandle.getColumnBindings());
    }

    private void clearProperty(PropertyHandle property) throws SemanticException {
        if (property != null) {
            property.clearValue();
        }
    }

    private Iterator<?> getPropertyIterator(PropertyHandle property) {
        if (property != null) {
            return property.iterator();
        }
        return null;
    }

    private void generateBindings(List<ComputedColumn> columnList) throws SemanticException {
        if (columnList.size() > 0) {
            Iterator<ComputedColumn> iter = columnList.iterator();
            while (iter.hasNext()) {
                DEUtil.addColumn((DesignElementHandle)this.itemHandle, (ComputedColumn)iter.next(), (boolean)false);
            }
        }
    }

    private List<ComputedColumn> generateComputedColumns(DataSetHandle dataSetHandle) throws SemanticException {
        if (dataSetHandle != null) {
            List resultSetColumnList = DataUtil.getColumnList((DataSetHandle)dataSetHandle);
            ArrayList<ComputedColumn> columnList = new ArrayList<ComputedColumn>();
            for (ResultSetColumnHandle resultSetColumn : resultSetColumnList) {
                ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)this.itemHandle, (String)resultSetColumn.getColumnName());
                column.setDataType(resultSetColumn.getDataType());
                ExpressionUtility.setBindingColumnExpression((Object)resultSetColumn, (ComputedColumn)column);
                columnList.add(column);
            }
            return columnList;
        }
        return Collections.emptyList();
    }

    private List<ComputedColumn> generateComputedColumns(CubeHandle cubeHandle) {
        if (cubeHandle != null) {
            ComputedColumn column;
            ArrayList<ComputedColumn> columnList = new ArrayList<ComputedColumn>();
            String exprType = UIUtil.getDefaultScriptType();
            IExpressionConverter exprConverter = ExpressionUtility.getExpressionConverter((String)exprType);
            for (LevelHandle levelHandle : ChartCubeUtil.getAllLevels((CubeHandle)cubeHandle)) {
                column = StructureFactory.newComputedColumn((DesignElementHandle)this.itemHandle, (String)ChartCubeUtil.createLevelBindingName((LevelHandle)levelHandle));
                column.setDataType(levelHandle.getDataType());
                column.setExpressionProperty("expression", new Expression((Object)exprConverter.getDimensionExpression(levelHandle.getContainer().getContainer().getName(), levelHandle.getName(), null), exprType));
                columnList.add(column);
            }
            for (MeasureHandle measureHandle : ChartCubeUtil.getAllMeasures((CubeHandle)cubeHandle)) {
                column = StructureFactory.newComputedColumn((DesignElementHandle)this.itemHandle, (String)ChartCubeUtil.createMeasureBindingName((MeasureHandle)measureHandle));
                column.setDataType(measureHandle.getDataType());
                column.setExpressionProperty("expression", new Expression((Object)exprConverter.getMeasureExpression(measureHandle.getName()), exprType));
                column.setAggregateFunction(measureHandle.getFunction());
                columnList.add(column);
            }
            return columnList;
        }
        return Collections.emptyList();
    }

    protected DataSetHandle getDataSetFromHandle() {
        if (this.itemHandle.getDataSet() != null) {
            return this.itemHandle.getDataSet();
        }
        List datasetList = DEUtil.getDataSetList((DesignElementHandle)this.itemHandle.getContainer());
        if (datasetList.size() > 0) {
            return (DataSetHandle)datasetList.get(0);
        }
        return null;
    }

    protected void processQueryDefinition(QueryDefinition queryDefn) {
    }

    private StyleHandle[] getAllStyleHandles() {
        List sLst = this.getReportDesignHandle().getAllStyles();
        StyleHandle[] list = sLst.toArray(new StyleHandle[sLst.size()]);
        Arrays.sort(list, new Comparator<StyleHandle>(){
            Collator collator = Collator.getInstance((ULocale)ULocale.getDefault());

            @Override
            public int compare(StyleHandle s1, StyleHandle s2) {
                return this.collator.compare(s1.getDisplayLabel(), s2.getDisplayLabel());
            }
        });
        return list;
    }

    public String[] getAllStyles() {
        StyleHandle[] handles = this.getAllStyleHandles();
        String[] names = new String[handles.length];
        int i = 0;
        while (i < names.length) {
            names[i] = handles[i].getQualifiedName();
            ++i;
        }
        names = this.filterPreStyles(names);
        return names;
    }

    private String[] filterPreStyles(String[] items) {
        String[] newItems = items;
        if (items == null) {
            newItems = new String[]{};
        }
        List preStyles = new DesignEngine(new DesignConfig()).getMetaData().getPredefinedStyles();
        ArrayList<String> preStyleNames = new ArrayList<String>();
        int i = 0;
        while (i < preStyles.size()) {
            preStyleNames.add(((IPredefinedStyle)preStyles.get(i)).getName());
            ++i;
        }
        ArrayList<String> sytleNames = new ArrayList<String>();
        int i2 = 0;
        while (i2 < newItems.length) {
            if (preStyleNames.indexOf(newItems[i2]) == -1) {
                sytleNames.add(newItems[i2]);
            }
            ++i2;
        }
        return sytleNames.toArray(new String[0]);
    }

    public String[] getAllStyleDisplayNames() {
        List<String> styles = Arrays.asList(this.getAllStyles());
        StyleHandle[] handles = this.getAllStyleHandles();
        String[] names = new String[styles.size()];
        int i = 0;
        int j = 0;
        while (i < handles.length) {
            if (styles.contains(handles[i].getQualifiedName())) {
                names[j++] = handles[i].getDisplayLabel();
            }
            ++i;
        }
        return names;
    }

    public String getCurrentStyle() {
        if (this.itemHandle.getStyle() == null) {
            return null;
        }
        return this.itemHandle.getStyle().getQualifiedName();
    }

    public void setStyle(String styleName) {
        try {
            if (styleName == null) {
                this.itemHandle.setStyle(null);
            } else {
                this.itemHandle.setStyle(this.getStyle(styleName));
            }
            ChartWizard.removeException((String)"ReportDataServiceProvider.setStyle");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setStyle", (String)e.getLocalizedMessage());
        }
    }

    private SharedStyleHandle getStyle(String styleName) {
        return this.getReportDesignHandle().findStyle(styleName);
    }

    public final Object[] getDataForColumns(String[] sExpressions, int iMaxRecords, boolean byRow) throws ChartException {
        return null;
    }

    private int getMaxRow() {
        return PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ChartReportItemUIActivator.getDefault(), this.project).getInt("max_row");
    }

    public boolean isLivePreviewEnabled() {
        return !this.isErrorFound && PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ChartReportItemUIActivator.getDefault(), this.project).getBoolean("enable_live") && ChartReportItemUtil.getBindingHolder((DesignElementHandle)this.itemHandle) != null;
    }

    boolean isInvokingSupported() {
        if (this.isSharedBinding() || this.isInMultiView()) {
            return false;
        }
        ReportItemHandle container = DEUtil.getBindingHolder((DesignElementHandle)this.itemHandle);
        if (container != null) {
            return container.getDataBindingReference() == null;
        }
        return true;
    }

    public DataType getDataType(String expression) {
        if (expression == null || expression.trim().length() == 0) {
            return null;
        }
        Object[] returnObj = this.findDataType(expression, (ReportItemHandle)this.itemHandle);
        if (((Boolean)returnObj[0]).booleanValue()) {
            return (DataType)returnObj[1];
        }
        ReportItemHandle parentHandle = DEUtil.getBindingHolder((DesignElementHandle)this.itemHandle);
        if (parentHandle != null && ((Boolean)(returnObj = this.findDataType(expression, parentHandle))[0]).booleanValue()) {
            return (DataType)returnObj[1];
        }
        try {
            NumberFormat.getInstance().parse(expression);
            return DataType.NUMERIC_LITERAL;
        }
        catch (ParseException parseException) {
            try {
                DateFormat.getInstance().parse(expression);
                return DataType.DATE_TIME_LITERAL;
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
    }

    private String getQueryStringForProcessing(String expression) {
        if (expression.indexOf("[\"") > 0) {
            return expression.substring(expression.indexOf("[\"") + 2, expression.indexOf("\"]"));
        }
        return null;
    }

    private Object[] findDataType(String expression, ReportItemHandle itemHandle) {
        boolean complexScripts = false;
        int i = 0;
        while (i < expression.length()) {
            if (expression.charAt(i) == '\n' && i != expression.length() - 1) {
                complexScripts = true;
                break;
            }
            ++i;
        }
        if (!complexScripts && ChartExpressionUtil.checkStringInExpression((String)expression)) {
            return new Object[]{true, DataType.TEXT_LITERAL};
        }
        this.exprCodec.decode(expression);
        if (!this.exprCodec.isBinding(false)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = false;
            return objectArray;
        }
        Object[] returnObj = new Object[2];
        returnObj[0] = Boolean.FALSE;
        String columnName = this.exprCodec.getBindingName();
        Iterator iterator = ChartReportItemUtil.getAllColumnBindingsIterator((ReportItemHandle)itemHandle);
        while (iterator.hasNext()) {
            String dataType;
            ComputedColumnHandle cc = (ComputedColumnHandle)iterator.next();
            if (!cc.getName().equalsIgnoreCase(columnName) || (dataType = cc.getDataType()) == null) continue;
            if (dataType.equals("string") || dataType.equals("blob")) {
                returnObj[0] = Boolean.TRUE;
                returnObj[1] = DataType.TEXT_LITERAL;
                break;
            }
            if (dataType.equals("decimal") || dataType.equals("float") || dataType.equals("integer") || dataType.equals("boolean")) {
                returnObj[0] = Boolean.TRUE;
                returnObj[1] = DataType.NUMERIC_LITERAL;
                break;
            }
            if (dataType.equals("date-time") || dataType.equals("date") || dataType.equals("time")) {
                returnObj[0] = Boolean.TRUE;
                returnObj[1] = DataType.DATE_TIME_LITERAL;
                break;
            }
            if (!dataType.equals("any")) continue;
            returnObj[0] = Boolean.TRUE;
            returnObj[1] = null;
            break;
        }
        return returnObj;
    }

    protected String[] getAllReportItemReferences() {
        List referenceList = this.itemHandle.getNamedDataBindingReferenceList();
        ArrayList<String> itemsWithName = new ArrayList<String>();
        int i = 0;
        while (i < referenceList.size()) {
            String qualfiedName = ((ReportItemHandle)referenceList.get(i)).getQualifiedName();
            if (qualfiedName != null && qualfiedName.length() > 0) {
                itemsWithName.add(qualfiedName);
            }
            ++i;
        }
        return itemsWithName.toArray(new String[itemsWithName.size()]);
    }

    String getReportItemReference() {
        ReportItemHandle ref = this.itemHandle.getDataBindingReference();
        if (ref == null) {
            return null;
        }
        return ref.getQualifiedName();
    }

    void setReportItemReference(String referenceName) {
        try {
            if (referenceName == null) {
                this.itemHandle.setDataBindingReference(null);
            } else {
                this.itemHandle.setDataSet(null);
                this.itemHandle.setCube(null);
                if (!referenceName.equals(this.getReportItemReference())) {
                    this.itemHandle.setDataBindingReference((ReportItemHandle)this.getReportDesignHandle().findElement(referenceName));
                }
            }
            ChartWizard.removeException((String)"ReportDataServiceProvider.setReportItemReference");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setReportItemReference", (String)e.getLocalizedMessage());
        }
    }

    private void setRowLimit(DataRequestSession session, int rowLimit, boolean isCubeMode) {
        PropertyHandle filterProperty = this.itemHandle.getPropertyHandle("filter");
        if (filterProperty == null || filterProperty.getListValue() == null || filterProperty.getListValue().size() == 0) {
            this.dteAdapter.setRowLimit(session, rowLimit, isCubeMode);
        }
    }

    private boolean needDefineCube(CubeHandle cube) {
        return this.dataSetReference != cube;
    }

    private boolean needDefineDataSet(DataSetHandle dataSetHandle) {
        return this.dataSetReference != dataSetHandle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDataRowExpressionEvaluator prepareRowExpressionEvaluator(Chart cm, List<String> columnExpression, int rowCount, boolean isStringType) throws ChartException {
        Object object = this.sessionLock;
        synchronized (object) {
            ClassLoader oldContextLoader;
            ClassLoader parentLoader;
            if (this.engineTask != null) {
                try {
                    this.engineTask.run();
                }
                catch (EngineException e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
                }
            }
            if ((parentLoader = (oldContextLoader = Thread.currentThread().getContextClassLoader())) == null) {
                parentLoader = this.getClass().getClassLoader();
            }
            ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parentLoader, (ModuleHandle)this.itemHandle.getModuleHandle());
            Thread.currentThread().setContextClassLoader(newContextLoader);
            IDataRowExpressionEvaluator evaluator = null;
            try {
                CubeHandle cube = ChartCubeUtil.getBindingCube((DesignElementHandle)this.itemHandle);
                if (cube != null) {
                    evaluator = this.createCubeEvaluator(cube, cm);
                    this.dataSetReference = cube;
                } else {
                    evaluator = this.isSharedBinding() && !ChartReportItemUtil.isOldChartUsingInternalGroup((ReportItemHandle)this.itemHandle, (Chart)cm) || this.isInheritColumnsGroups() ? (this.isSharingChart(true) ? this.createBaseEvaluator((ExtendedItemHandle)this.itemHandle.getDataBindingReference(), cm, columnExpression) : this.fShareBindingQueryHelper.createShareBindingEvaluator(cm, columnExpression)) : this.createBaseEvaluator(this.itemHandle, cm, columnExpression);
                    this.dataSetReference = ChartItemUtil.getBindingDataSet((DesignElementHandle)this.itemHandle);
                }
                IDataRowExpressionEvaluator iDataRowExpressionEvaluator = evaluator;
                return iDataRowExpressionEvaluator;
            }
            catch (BirtException e) {
                throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextLoader);
            }
        }
    }

    private IDataRowExpressionEvaluator createBaseEvaluator(ExtendedItemHandle handle, Chart cm, List<String> columnExpression) throws ChartException {
        BaseQueryHelper cbqh = new BaseQueryHelper(handle, cm);
        QueryDefinition queryDefn = (QueryDefinition)cbqh.createBaseQuery(columnExpression);
        try {
            this.setQueryDefinitionWithDataSet(handle, queryDefn);
            this.processQueryDefinition(queryDefn);
            IQueryResults actualResultSet = this.executeDataSetQuery(queryDefn);
            if (actualResultSet != null) {
                if (ChartReportItemUtil.isOldChartUsingInternalGroup((ReportItemHandle)this.itemHandle, (Chart)cm)) {
                    return this.createSimpleExpressionEvaluator(actualResultSet);
                }
                return new BaseGroupedQueryResultSetEvaluator(actualResultSet.getResultIterator(), ChartReportItemUtil.isSetSummaryAggregation((Chart)cm), cm);
            }
        }
        catch (BirtException e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
        }
        return null;
    }

    private IQueryResults executeDataSetQuery(QueryDefinition queryDefn) throws AdapterException, BirtException {
        DataSetHandle dataSetHandle = ChartItemUtil.getBindingDataSet((DesignElementHandle)this.itemHandle);
        if (this.needDefineDataSet(dataSetHandle)) {
            this.dteAdapter.defineDataSet(dataSetHandle, this.session, true, false);
        }
        this.dteAdapter.populateApplicationContext(dataSetHandle, this.session);
        this.setRowLimit(this.session, this.getMaxRow(), false);
        IQueryResults actualResultSet = this.dteAdapter.executeQuery(this.session, (IQueryDefinition)queryDefn);
        return actualResultSet;
    }

    private void setQueryDefinitionWithDataSet(ExtendedItemHandle handle, QueryDefinition queryDefn) throws AdapterException, DataException {
        this.resetParametersForDataPreview(this.getDataSetFromHandle(), queryDefn);
        Iterator bindingIt = ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)handle, (boolean)true);
        while (bindingIt != null && bindingIt.hasNext()) {
            Object computedBinding = bindingIt.next();
            IBinding binding = this.session.getModelAdaptor().adaptBinding((ComputedColumnHandle)computedBinding);
            if (binding == null || queryDefn.getBindings().containsKey(binding.getBindingName())) continue;
            queryDefn.addBinding(binding);
        }
        Iterator<FilterConditionHandle> filtersIterator = this.getFiltersIterator();
        if (filtersIterator != null) {
            while (filtersIterator.hasNext()) {
                FilterDefinition filter = this.session.getModelAdaptor().adaptFilter(filtersIterator.next());
                queryDefn.addFilter((IFilterDefinition)filter);
            }
        }
        this.handleGroup(queryDefn, handle, this.session.getModelAdaptor());
    }

    private IDataRowExpressionEvaluator createSimpleExpressionEvaluator(IQueryResults actualResultSet) throws BirtException {
        final IResultIterator resultIterator = actualResultSet.getResultIterator();
        return new DataRowExpressionEvaluatorAdapter(){

            public Object evaluate(String expression) {
                try {
                    return resultIterator.getValue(expression);
                }
                catch (BirtException birtException) {
                    return null;
                }
            }

            public Object evaluateGlobal(String expression) {
                return this.evaluate(expression);
            }

            public boolean next() {
                try {
                    return resultIterator.next();
                }
                catch (BirtException birtException) {
                    return false;
                }
            }

            public void close() {
                try {
                    resultIterator.close();
                }
                catch (BirtException birtException) {
                    return;
                }
            }

            public boolean first() {
                try {
                    return resultIterator.next();
                }
                catch (BirtException birtException) {
                    return false;
                }
            }
        };
    }

    private Iterator<FilterConditionHandle> getFiltersIterator() {
        Iterator filterIterator;
        ArrayList<FilterConditionHandle> filterList = new ArrayList<FilterConditionHandle>();
        PropertyHandle ph = null;
        if (this.getDataSet() == null && this.getReportItemReference() == null) {
            Iterator filterIterator2;
            ReportItemHandle bindingHolder = ChartReportItemUtil.getBindingHolder((DesignElementHandle)this.itemHandle);
            PropertyHandle propertyHandle = ph = bindingHolder == null ? null : bindingHolder.getPropertyHandle("filter");
            if (ph != null && (filterIterator2 = ph.iterator()) != null) {
                while (filterIterator2.hasNext()) {
                    FilterConditionHandle filter = (FilterConditionHandle)filterIterator2.next();
                    if (filter.getValue1() != null && filter.getValue1().indexOf("._outer") >= 0 || filter.getValue2() != null && filter.getValue2().indexOf("._outer") >= 0) continue;
                    filterList.add(filter);
                }
            }
        }
        if ((ph = this.itemHandle.getPropertyHandle("filter")) != null && (filterIterator = ph.iterator()) != null) {
            while (filterIterator.hasNext()) {
                FilterConditionHandle filter = (FilterConditionHandle)filterIterator.next();
                if (filter.getValue1() != null && filter.getValue1().indexOf("._outer") >= 0 || filter.getValue2() != null && filter.getValue2().indexOf("._outer") >= 0) continue;
                filterList.add(filter);
            }
        }
        return filterList.isEmpty() ? null : filterList.iterator();
    }

    private IDataRowExpressionEvaluator createCubeEvaluator(CubeHandle cube, Chart cm) throws BirtException {
        IBaseCubeQueryDefinition qd = null;
        ReportItemHandle referredHandle = ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle);
        boolean isChartCubeReference = ChartItemUtil.isChartReportItemHandle((ReportItemHandle)referredHandle);
        if (referredHandle != null && !isChartCubeReference) {
            ExtendedItemHandle bindingHandle = (ExtendedItemHandle)referredHandle;
            qd = CrosstabQueryUtil.createCubeQuery((CrosstabReportItemHandle)((CrosstabReportItemHandle)bindingHandle.getReportItem()), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        } else {
            qd = new ChartCubeQueryHelper(this.itemHandle, cm, this.session.getModelAdaptor()).createCubeQuery(null);
        }
        if (this.needDefineCube(cube)) {
            this.session.defineCube(cube);
        }
        this.dteAdapter.populateApplicationContext(cube, this.session);
        this.setRowLimit(this.session, this.getMaxRow(), true);
        ICubeQueryResults cqr = this.dteAdapter.executeQuery(this.session, (ICubeQueryDefinition)qd);
        if (referredHandle != null && !isChartCubeReference) {
            return new SharedCubeResultSetEvaluator(cqr, qd, cm);
        }
        return new BIRTCubeResultSetEvaluator(cqr);
    }

    private DataRequestSession prepareDataRequestSession(EngineTask aEngineTask, int maxRow, boolean isCudeMode) throws BirtException {
        PropertyHandle filterProperty = this.itemHandle.getPropertyHandle("filter");
        if (filterProperty == null || filterProperty.getListValue() == null || filterProperty.getListValue().size() == 0) {
            HashMap<String, Integer> appContext = new HashMap<String, Integer>();
            if (!isCudeMode) {
                appContext.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, maxRow);
            } else {
                appContext.put(DataEngine.CUBECURSOR_FETCH_LIMIT_ON_COLUMN_EDGE, maxRow);
                appContext.put(DataEngine.CUBECUSROR_FETCH_LIMIT_ON_ROW_EDGE, maxRow);
            }
            aEngineTask.setAppContext(appContext);
        }
        DataRequestSession aSession = aEngineTask.getDataSession();
        return aSession;
    }

    private DataRequestSession prepareDataRequestSession(int maxRow, boolean isCudeMode) throws BirtException {
        DataSessionContext dsc = new DataSessionContext(3, this.getReportDesignHandle());
        PropertyHandle filterProperty = this.itemHandle.getPropertyHandle("filter");
        if (filterProperty == null || filterProperty.getListValue() == null || filterProperty.getListValue().size() == 0) {
            HashMap<String, Integer> appContext = new HashMap<String, Integer>();
            if (!isCudeMode) {
                appContext.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, maxRow);
            } else {
                appContext.put(DataEngine.CUBECURSOR_FETCH_LIMIT_ON_COLUMN_EDGE, maxRow);
                appContext.put(DataEngine.CUBECUSROR_FETCH_LIMIT_ON_ROW_EDGE, maxRow);
            }
            dsc.setAppContext(appContext);
        }
        DataRequestSession aSession = DataRequestSession.newSession((DataSessionContext)dsc);
        return aSession;
    }

    boolean isInXTabMeasureCell() {
        return ChartCubeUtil.isInXTabMeasureCell((DesignElementHandle)this.itemHandle);
    }

    boolean isPartChart() {
        return ChartCubeUtil.isPlotChart((DesignElementHandle)this.itemHandle) || ChartCubeUtil.isAxisChart((DesignElementHandle)this.itemHandle);
    }

    boolean isSharedBinding() {
        return this.itemHandle.getDataBindingReference() != null || this.isInMultiView();
    }

    boolean isTableSharedBinding() {
        return this.isSharedBinding() && ChartCubeUtil.getBindingCube((DesignElementHandle)this.itemHandle) == null;
    }

    public void setPredefinedExpressions(ColumnBindingInfo[] headers) {
        if (this.isSharedBinding() || this.isInheritColumnsGroups()) {
            this.fShareBindingQueryHelper.setPredefinedExpressions(headers);
        } else {
            this.context.addPredefinedQuery("category", (Object[])headers);
            this.context.addPredefinedQuery("value", (Object[])headers);
            this.context.addPredefinedQuery("optional", (Object[])headers);
        }
    }

    public ReportItemHandle getReportItemHandle() {
        if (this.isSharedBinding()) {
            if (this.isInMultiView()) {
                return (ReportItemHandle)this.itemHandle.getContainer().getContainer();
            }
            return this.itemHandle.getDataBindingReference();
        }
        return this.itemHandle;
    }

    public boolean update(String type, Object value) {
        boolean isUpdated;
        block11: {
            block12: {
                block13: {
                    String[] levelNames;
                    String dimExpr;
                    List names;
                    block10: {
                        isUpdated = false;
                        if (!"CopySeriesDefinition".equals(type)) break block10;
                        this.copySeriesDefinition(value);
                        break block11;
                    }
                    if (!"value".equals(type) || this.getDataCube() == null || !this.isSharedBinding()) break block12;
                    LinkedHashMap<String, ComputedColumnHandle> bindingMap = new LinkedHashMap<String, ComputedColumnHandle>();
                    Iterator bindings = ChartReportItemUtil.getAllColumnBindingsIterator((ReportItemHandle)this.itemHandle);
                    while (bindings.hasNext()) {
                        ComputedColumnHandle column = (ComputedColumnHandle)bindings.next();
                        bindingMap.put(column.getName(), column);
                    }
                    String bindingName = ChartExpressionUtil.getCubeBindingName((String)((String)value), (boolean)false);
                    ComputedColumnHandle computedBinding = (ComputedColumnHandle)bindingMap.get(bindingName);
                    List aggOnList = computedBinding.getAggregateOnList();
                    if (aggOnList.size() > 0 && (names = ChartCubeUtil.getRelatedBindingNames((String)(dimExpr = ExpressionUtil.createJSDimensionExpression((String)(levelNames = CubeUtil.splitLevelName((String)((String)aggOnList.get(0))))[0], (String)levelNames[1])), bindingMap.values())).size() > 0) {
                        SeriesDefinition sd = (SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.context.getModel()).get(0);
                        ((Query)sd.getDesignTimeSeries().getDataDefinition().get(0)).setDefinition(ExpressionUtil.createJSDataExpression((String)((String)names.get(0))));
                        isUpdated = true;
                    }
                    if (aggOnList.size() <= 1) break block13;
                    levelNames = CubeUtil.splitLevelName((String)((String)aggOnList.get(1)));
                    dimExpr = ExpressionUtil.createJSDimensionExpression((String)levelNames[0], (String)levelNames[1]);
                    names = ChartCubeUtil.getRelatedBindingNames((String)dimExpr, bindingMap.values());
                    int size = names.size();
                    if (size <= 0) break block11;
                    for (SeriesDefinition sd : ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.context.getModel())) {
                        sd.getQuery().setDefinition(ExpressionUtil.createJSDataExpression((String)((String)names.get(0))));
                        isUpdated = true;
                    }
                    break block11;
                }
                if (ChartItemUtil.isChartReportItemHandle((ReportItemHandle)ChartItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle))) break block11;
                for (SeriesDefinition sd : ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.context.getModel())) {
                    sd.getQuery().setDefinition("");
                    isUpdated = true;
                }
                break block11;
            }
            if ("category".equals(type) && value instanceof String) {
                EList baseSDs = ChartUtil.getBaseSeriesDefinitions((Chart)this.context.getModel());
                for (SeriesDefinition sd : baseSDs) {
                    EList dds = sd.getDesignTimeSeries().getDataDefinition();
                    Query q = (Query)dds.get(0);
                    if (q.getDefinition() != null && !"".equals(q.getDefinition().trim())) continue;
                    q.setDefinition((String)value);
                }
            } else if ("optional".equals(type) && value instanceof String) {
                List orthSDs = ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)this.context.getModel());
                for (SeriesDefinition sd : orthSDs) {
                    Query q = sd.getQuery();
                    if (q == null) {
                        sd.setQuery(QueryImpl.create((String)((String)value)));
                        continue;
                    }
                    if (q.getDefinition() != null && !"".equals(q.getDefinition().trim())) continue;
                    q.setDefinition((String)value);
                }
            }
        }
        return isUpdated;
    }

    boolean hasMultiCubeDimensions() {
        CubeHandle cube = ChartCubeUtil.getBindingCube((DesignElementHandle)this.itemHandle);
        return ChartCubeUtil.getDimensionCount((CubeHandle)cube) > 1;
    }

    boolean isInXTabAggrCell() {
        try {
            AggregationCellHandle cell = ChartCubeUtil.getXtabContainerCell((DesignElementHandle)this.itemHandle);
            if (cell != null) {
                return ChartCubeUtil.isAggregationCell((AggregationCellHandle)cell);
            }
        }
        catch (BirtException birtException) {}
        return false;
    }

    boolean isInheritColumnsSet() {
        PropertyHandle property = this.itemHandle.getPropertyHandle("inheritColumns");
        return property != null && property.isSet();
    }

    boolean isInheritColumnsOnly() {
        return this.itemHandle.getDataSet() == null && ChartReportItemUtil.isContainerInheritable((ReportItemHandle)this.itemHandle) && this.context.isInheritColumnsOnly();
    }

    boolean isInheritColumnsGroups() {
        return this.itemHandle.getDataSet() == null && ChartReportItemUtil.isContainerInheritable((ReportItemHandle)this.itemHandle) && !this.context.isInheritColumnsOnly();
    }

    public int getState() {
        int states = 0;
        if (this.getDataSet() != null) {
            states |= 1;
        }
        if (this.getDataCube() != null) {
            states |= 2;
        }
        if (this.getInheritedDataSet() != null) {
            states |= 0x1000;
        }
        if (this.getInheritedCube() != null) {
            states |= 0x2000;
        }
        if (this.itemHandle.getDataBindingReference() != null) {
            states |= 4;
        }
        if (this.isInMultiView()) {
            states |= 8;
        }
        if (this.isSharedBinding()) {
            states |= 0x10;
            if (this.isSharingChart(false)) {
                states |= 0x800;
            }
            if (this.isSharingChart(true)) {
                states |= 0x4000;
            }
            if (ChartCubeUtil.getBindingCube((DesignElementHandle)this.itemHandle) != null) {
                states |= 0x100;
            } else if (!this.isSharingChart(false)) {
                states |= 0x80;
            }
        }
        if (this.isPartChart()) {
            states |= 0x20;
        }
        if (this.hasMultiCubeDimensions()) {
            states |= 0x40;
        }
        if (this.isInheritColumnsOnly()) {
            states |= 0x200;
        }
        if (this.isInheritColumnsGroups()) {
            states |= 0x400;
        }
        return states;
    }

    public boolean checkState(int state) {
        return (this.getState() & state) == state;
    }

    public Object checkData(String checkType, Object data) {
        if (("optional".equals(checkType) || "category".equals(checkType)) && (this.checkState(8192) || this.checkState(2) || this.checkState(256))) {
            return ChartXTabUIUtil.checkQueryExpression(checkType, data, this.context.getModel(), this.itemHandle, this);
        }
        return null;
    }

    private ListingHandle findListingInheritance() {
        DesignElementHandle container = this.itemHandle.getContainer();
        while (container != null) {
            if (container instanceof ListingHandle && ((ListingHandle)container).getDataSet() != null) {
                return (ListingHandle)container;
            }
            container = container.getContainer();
        }
        return null;
    }

    int getNumberOfSameDataDefinition(String expr) {
        String s;
        String[] expres;
        if (expr == null) {
            return 0;
        }
        int count = 0;
        Chart chart = this.context.getModel();
        String[] stringArray = expres = ChartUtil.getCategoryExpressions((Chart)chart);
        int n = expres.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (expr.equals(s)) {
                ++count;
            }
            ++n2;
        }
        stringArray = expres = ChartUtil.getValueSeriesExpressions((Chart)chart);
        n = expres.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (expr.equals(s)) {
                ++count;
            }
            ++n2;
        }
        stringArray = expres = ChartUtil.getYOptoinalExpressions((Chart)chart);
        n = expres.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (expr.equals(s)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    boolean isSharingChart(boolean isRecursive) {
        boolean isShare = this.isSharedBinding();
        if (isRecursive) {
            return isShare && ChartItemUtil.isChartReportItemHandle((ReportItemHandle)ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle));
        }
        return isShare && ChartItemUtil.isChartReportItemHandle((ReportItemHandle)this.itemHandle.getDataBindingReference());
    }

    protected void copySeriesDefinition(Object target) {
        ExtendedItemHandle refHandle;
        Chart targetCM = this.context.getModel();
        if (target != null && target instanceof Chart) {
            targetCM = (Chart)target;
        }
        if ((refHandle = ChartItemUtil.getChartReferenceItemHandle((ReportItemHandle)this.itemHandle)) != null) {
            ChartReportItemUtil.copyChartSeriesDefinition((Chart)ChartReportItemUtil.getChartFromHandle((ExtendedItemHandle)refHandle), (Chart)targetCM);
        }
    }

    public String[] getSeriesExpressionsFrom(Object obj, String type) {
        if (!(obj instanceof Chart)) {
            return new String[0];
        }
        if ("category".equals(type)) {
            return ChartUtil.getCategoryExpressions((Chart)((Chart)obj));
        }
        if ("optional".equals(type)) {
            return ChartUtil.getYOptoinalExpressions((Chart)((Chart)obj));
        }
        if ("value".equals(type)) {
            return ChartUtil.getValueSeriesExpressions((Chart)((Chart)obj));
        }
        return new String[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BaseQueryHelper
    extends AbstractChartBaseQueryGenerator {
        public BaseQueryHelper(ExtendedItemHandle handle, Chart chart) {
            super((ReportItemHandle)handle, chart, false, ReportDataServiceProvider.this.session.getModelAdaptor());
        }

        public IDataQueryDefinition createBaseQuery(List<String> columnExpression) throws ChartException {
            QueryDefinition queryDefn = new QueryDefinition();
            int maxRow = ReportDataServiceProvider.this.getMaxRow();
            queryDefn.setMaxRows(maxRow);
            DataSetHandle dsHandle = ReportDataServiceProvider.this.getDataSetFromHandle();
            queryDefn.setDataSetName(dsHandle == null ? null : dsHandle.getQualifiedName());
            int i = 0;
            while (i < columnExpression.size()) {
                String expr = columnExpression.get(i);
                this.exprCodec.decode(expr);
                String name = this.exprCodec.getExpression();
                if (!this.fNameSet.contains(name)) {
                    Binding colBinding = new Binding(name);
                    colBinding.setExpression((IBaseExpression)ChartReportItemUtil.adaptExpression((ChartExpressionUtil.ExpressionCodec)this.exprCodec, (IModelAdapter)this.modelAdapter, (boolean)false));
                    try {
                        queryDefn.addBinding((IBinding)colBinding);
                    }
                    catch (DataException e) {
                        throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                    }
                    this.fNameSet.add(name);
                }
                ++i;
            }
            this.generateExtraBindings((BaseQueryDefinition)queryDefn);
            return queryDefn;
        }

        protected void addValueSeriesAggregateBindingForGrouping(BaseQueryDefinition query, EList<SeriesDefinition> seriesDefinitions, GroupDefinition innerMostGroupDef, Map<String, String[]> valueExprMap, SeriesDefinition baseSD) throws ChartException {
            for (SeriesDefinition orthSD : seriesDefinitions) {
                Series series = orthSD.getDesignTimeSeries();
                List qlist = ChartEngine.instance().getDataSetProcessor(series.getClass()).getDataDefinitionsForGrouping(series);
                for (Query qry : series.getDataDefinition()) {
                    String aggName;
                    String expr = qry.getDefinition();
                    if (expr == null || "".equals(expr) || (aggName = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)qry)) == null || "".equals(aggName)) continue;
                    String bindingName = ChartUtil.generateBindingNameOfValueSeries((Query)qry, (SeriesDefinition)orthSD, (SeriesDefinition)baseSD);
                    String name = ExpressionUtil.createRowExpression((String)bindingName);
                    if (this.fNameSet.contains(name)) {
                        query.getBindings().remove(name);
                    }
                    this.fNameSet.add(name);
                    Binding colBinding = new Binding(name);
                    colBinding.setDataType(0);
                    if (qlist.contains(qry)) {
                        try {
                            this.setBindingExpressionDueToAggregation(colBinding, expr, aggName);
                        }
                        catch (DataException e1) {
                            throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e1);
                        }
                        if (innerMostGroupDef != null) {
                            try {
                                colBinding.addAggregateOn(innerMostGroupDef.getName());
                            }
                            catch (DataException e) {
                                throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                            }
                        }
                        colBinding.setAggrFunction(ChartReportItemUtil.convertToDtEAggFunction((String)aggName));
                        IAggregateFunction aFunc = PluginSettings.instance().getAggregateFunction(aggName);
                        if (aFunc.getParametersCount() > 0) {
                            String[] parameters = ChartUtil.getAggFunParameters((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)qry);
                            int i = 0;
                            while (i < parameters.length && i < aFunc.getParametersCount()) {
                                String param = parameters[i];
                                colBinding.addArgument((IBaseExpression)new ScriptExpression(param));
                                ++i;
                            }
                        }
                    } else {
                        this.exprCodec.decode(expr);
                        colBinding.setExpression((IBaseExpression)ChartReportItemUtil.adaptExpression((ChartExpressionUtil.ExpressionCodec)this.exprCodec, (IModelAdapter)this.modelAdapter, (boolean)false));
                    }
                    String newExpr = this.getExpressionForEvaluator(name);
                    try {
                        query.addBinding((IBinding)colBinding);
                    }
                    catch (DataException e) {
                        throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                    }
                    valueExprMap.put(expr, new String[]{expr, newExpr});
                }
            }
        }

        public IDataQueryDefinition createBaseQuery(IDataQueryDefinition parent) {
            throw new UnsupportedOperationException("Don't be implemented in the class.");
        }
    }

    protected static class ChartDummyEngineTask
    extends DummyEngineTask {
        public ChartDummyEngineTask(ReportEngine engine, IReportRunnable runnable, ModuleHandle moduleHandle) {
            super(engine, runnable, moduleHandle);
        }

        public void run() throws EngineException {
            this.parameterChanged = true;
            super.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ColumnNameComprator
    implements Comparator<ColumnBindingInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;

        ColumnNameComprator() {
        }

        @Override
        public int compare(ColumnBindingInfo src, ColumnBindingInfo target) {
            return src.getName().compareTo(target.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShareBindingQueryHelper {
        protected final ChartExpressionUtil.ExpressionCodec sbqhExprCodec = ChartModelHelper.instance().createExpressionCodec();

        ShareBindingQueryHelper() {
        }

        private void setPredefinedExpressions(ColumnBindingInfo[] headers) {
            Object[] expressionsArray = this.getPredefinedExpressionsForSharing(headers);
            ReportDataServiceProvider.this.context.addPredefinedQuery("category", (Object[])expressionsArray[0]);
            ReportDataServiceProvider.this.context.addPredefinedQuery("optional", (Object[])expressionsArray[1]);
            ReportDataServiceProvider.this.context.addPredefinedQuery("value", (Object[])expressionsArray[2]);
        }

        /*
         * WARNING - void declaration
         */
        private Object[] getPredefinedExpressionsForSharing(ColumnBindingInfo[] headers) {
            LinkedList<ColumnBindingInfo> commons = new LinkedList<ColumnBindingInfo>();
            LinkedList<ColumnBindingInfo> aggs = new LinkedList<ColumnBindingInfo>();
            LinkedList<ColumnBindingInfo> groups = new LinkedList<ColumnBindingInfo>();
            int i = 0;
            while (i < headers.length) {
                int type = headers[i].getColumnType();
                switch (type) {
                    case 0: {
                        commons.add(headers[i]);
                        break;
                    }
                    case 2: {
                        aggs.add(headers[i]);
                        break;
                    }
                    case 1: {
                        groups.add(headers[i]);
                    }
                }
                ++i;
            }
            LinkedList<ColumnBindingInfo> groupsWithAgg = new LinkedList<ColumnBindingInfo>();
            LinkedList groupsWithoutAgg = new LinkedList(groups);
            Iterator iter = groupsWithoutAgg.iterator();
            block6: while (iter.hasNext()) {
                ColumnBindingInfo cbiGroup = (ColumnBindingInfo)iter.next();
                String groupName = cbiGroup.getName();
                for (ColumnBindingInfo columnBindingInfo : aggs) {
                    if (!groupName.equals(((ComputedColumnHandle)columnBindingInfo.getObjectHandle()).getAggregateOn())) continue;
                    iter.remove();
                    groupsWithAgg.add(cbiGroup);
                    continue block6;
                }
            }
            ColumnBindingInfo[] categorys = new ColumnBindingInfo[groups.size() + commons.size()];
            int index = 0;
            for (ColumnBindingInfo cbi : groups) {
                categorys[index++] = cbi;
            }
            for (ColumnBindingInfo cbi : commons) {
                categorys[index++] = cbi;
            }
            ColumnBindingInfo[] optionals = null;
            if (ReportDataServiceProvider.this.isInheritColumnsGroups() && groups.size() > 0) {
                void var10_18;
                LinkedList<ColumnBindingInfo> linkedList = new LinkedList<ColumnBindingInfo>();
                ExtendedItemHandle reh = ReportDataServiceProvider.this.itemHandle;
                block10: while (reh != null) {
                    if (reh.getContainer() instanceof TableGroupHandle) {
                        reh = reh.getContainer();
                        for (ColumnBindingInfo cbi : groups) {
                            linkedList.add(cbi);
                            if (reh.getName().equals(cbi.getName())) break block10;
                        }
                        break;
                    }
                    if (reh.getContainer() instanceof RowHandle && reh.getContainer() != null && !(reh.getContainer().getContainer() instanceof TableGroupHandle)) {
                        ExtendedItemHandle deh = reh;
                        while (deh != null) {
                            if (deh.getContainer() instanceof ListingHandle) {
                                deh = deh.getContainer();
                                break;
                            }
                            deh = deh.getContainer();
                        }
                        if (deh == null || !(deh instanceof ListingHandle)) break;
                        if (((ListingHandle)deh).getDetail().findPosn(reh.getContainer()) >= 0) {
                            LinkedList<ColumnBindingInfo> linkedList2 = groups;
                            break;
                        }
                        if (((ListingHandle)deh).getHeader().findPosn(reh.getContainer()) < 0) break;
                        linkedList.add((ColumnBindingInfo)groups.get(0));
                        break;
                    }
                    if (reh.getContainer() instanceof ListingHandle) {
                        reh = null;
                        break;
                    }
                    reh = reh.getContainer();
                }
                optionals = new ColumnBindingInfo[var10_18.size()];
                int i2 = 0;
                for (ColumnBindingInfo cbi : var10_18) {
                    optionals[i2++] = cbi;
                }
            } else {
                int n = groups.size() > 0 ? 1 : 0;
                optionals = new ColumnBindingInfo[n];
                if (groups.size() > 0) {
                    optionals[0] = (ColumnBindingInfo)groups.get(0);
                }
            }
            ColumnBindingInfo[] columnBindingInfoArray = new ColumnBindingInfo[aggs.size() + commons.size()];
            index = 0;
            for (ColumnBindingInfo cbi : aggs) {
                columnBindingInfoArray[index++] = cbi;
            }
            for (ColumnBindingInfo cbi : commons) {
                columnBindingInfoArray[index++] = cbi;
            }
            return new Object[]{categorys, optionals, columnBindingInfoArray};
        }

        private IDataRowExpressionEvaluator createShareBindingEvaluator(Chart cm, List<String> columnExpression) throws BirtException, AdapterException, DataException, ChartException {
            IQueryResults actualResultSet;
            QueryDefinition queryDefn = new QueryDefinition();
            int maxRow = ReportDataServiceProvider.this.getMaxRow();
            queryDefn.setMaxRows(maxRow);
            final HashMap<String, String> bindingExprsMap = new HashMap<String, String>();
            Iterator iterator = ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)ReportDataServiceProvider.this.itemHandle);
            ArrayList<ComputedColumnHandle> columnList = new ArrayList<ComputedColumnHandle>();
            while (iterator.hasNext()) {
                columnList.add((ComputedColumnHandle)iterator.next());
            }
            this.generateShareBindingsWithTable(this.getPreviewHeadersInfo(columnList), queryDefn, ReportDataServiceProvider.this.session, bindingExprsMap);
            this.addCustomExpressions(queryDefn, cm, columnExpression, bindingExprsMap);
            Iterator filtersIterator = ReportDataServiceProvider.this.getPropertyIterator(ReportDataServiceProvider.this.itemHandle.getPropertyHandle("filter"));
            if (filtersIterator != null) {
                while (filtersIterator.hasNext()) {
                    FilterDefinition filter = ReportDataServiceProvider.this.session.getModelAdaptor().adaptFilter((FilterConditionHandle)filtersIterator.next());
                    queryDefn.addFilter((IFilterDefinition)filter);
                }
            }
            if ((actualResultSet = this.executeSharedQuery(queryDefn)) != null) {
                return new BaseGroupedQueryResultSetEvaluator(actualResultSet.getResultIterator(), ChartReportItemUtil.isSetSummaryAggregation((Chart)cm), cm){

                    public Object evaluate(String expression) {
                        try {
                            String newExpr = (String)bindingExprsMap.get(expression);
                            if (newExpr != null) {
                                return this.fResultIterator.getValue(newExpr);
                            }
                            return this.fResultIterator.getValue(expression);
                        }
                        catch (BirtException e) {
                            sLogger.log((Exception)((Object)e));
                            return null;
                        }
                    }
                };
            }
            return null;
        }

        private IQueryResults executeSharedQuery(QueryDefinition queryDefn) throws AdapterException, BirtException {
            DataSetHandle dataSetHandle = ChartItemUtil.getBindingDataSet((DesignElementHandle)ReportDataServiceProvider.this.itemHandle);
            if (ReportDataServiceProvider.this.needDefineDataSet(dataSetHandle)) {
                ReportDataServiceProvider.this.dteAdapter.defineDataSet(dataSetHandle, ReportDataServiceProvider.this.session, true, false);
            }
            ReportDataServiceProvider.this.dteAdapter.populateApplicationContext(dataSetHandle, ReportDataServiceProvider.this.session);
            ReportDataServiceProvider.this.setRowLimit(ReportDataServiceProvider.this.session, ReportDataServiceProvider.this.getMaxRow(), false);
            IQueryResults actualResultSet = ReportDataServiceProvider.this.dteAdapter.executeQuery(ReportDataServiceProvider.this.session, (IQueryDefinition)queryDefn);
            return actualResultSet;
        }

        private void addCustomExpressions(QueryDefinition queryDefn, Chart cm, List<String> columnExpression, Map<String, String> bindingExprsMap) throws DataException {
            List queryList = ChartBaseQueryHelper.getAllQueryExpressionDefinitions((Chart)cm);
            HashSet<String> exprSet = new HashSet<String>();
            for (Query query : queryList) {
                String expr = query.getDefinition();
                if (expr == null) continue;
                exprSet.add(expr);
            }
            exprSet.addAll(columnExpression);
            for (String expr : exprSet) {
                if (expr.length() <= 0 || bindingExprsMap.containsKey(expr)) continue;
                this.sbqhExprCodec.decode(expr);
                String name = StructureFactory.newComputedColumn((DesignElementHandle)ReportDataServiceProvider.this.itemHandle, (String)ChartUtil.escapeSpecialCharacters((String)this.sbqhExprCodec.getExpression())).getName();
                queryDefn.addBinding((IBinding)new Binding(name, (IBaseExpression)ChartReportItemUtil.adaptExpression((ChartExpressionUtil.ExpressionCodec)this.sbqhExprCodec, (IModelAdapter)ReportDataServiceProvider.this.session.getModelAdaptor(), (boolean)false)));
                bindingExprsMap.put(expr, name);
            }
        }

        private final ColumnBindingInfo[] getPreviewHeadersInfo(List<ComputedColumnHandle> columnList) throws ChartException {
            if (columnList == null || columnList.size() == 0) {
                return new ColumnBindingInfo[0];
            }
            ColumnBindingInfo[] columnHeaders = null;
            List<GroupHandle> groupList = this.getGroupsOfSharedBinding();
            columnHeaders = new ColumnBindingInfo[columnList.size() + groupList.size()];
            int index = 0;
            int i = 0;
            while (i < groupList.size()) {
                GroupHandle gh = groupList.get(i);
                String groupName = gh.getName();
                Expression expr = (Expression)gh.getExpressionProperty("keyExpr").getValue();
                ReportDataServiceProvider.this.exprCodec.setExpression(expr.getStringExpression());
                ReportDataServiceProvider.this.exprCodec.setType(expr.getType());
                String groupKeyExpr = ReportDataServiceProvider.this.exprCodec.encode();
                String tooltip = String.valueOf(Messages.getString("ReportDataServiceProvider.Tooltip.GroupExpression")) + ReportDataServiceProvider.this.exprCodec.getExpression();
                columnHeaders[index++] = new ColumnBindingInfo(groupName, groupKeyExpr, 1, "icons/obj16/group.gif", tooltip, (Object)gh);
                Iterator<ComputedColumnHandle> iter = columnList.iterator();
                while (iter.hasNext()) {
                    ComputedColumnHandle cch = iter.next();
                    String aggOn = cch.getAggregateOn();
                    if (!groupName.equals(aggOn)) continue;
                    iter.remove();
                    tooltip = String.valueOf(Messages.getString("ReportDataServiceProvider.Tooltip.Aggregate")) + cch.getAggregateFunction() + "\n" + Messages.getString("ReportDataServiceProvider.Tooltip.OnGroup") + groupName;
                    columnHeaders[index] = new ColumnBindingInfo(cch.getName(), ExpressionUtil.createJSRowExpression((String)cch.getName()), 2, "icons/obj16/sigma.gif", tooltip, (Object)cch);
                    columnHeaders[index].setChartAggExpression(ChartReportItemUtil.convertToChartAggExpression((String)cch.getAggregateFunction()));
                    ++index;
                }
                ++i;
            }
            Iterator<ComputedColumnHandle> iter = columnList.iterator();
            while (iter.hasNext()) {
                ComputedColumnHandle cch = iter.next();
                if (cch.getAggregateFunction() == null) continue;
                iter.remove();
                String tooltip = String.valueOf(Messages.getString("ReportDataServiceProvider.Tooltip.Aggregate")) + cch.getAggregateFunction() + "\n" + Messages.getString("ReportDataServiceProvider.Tooltip.OnGroup");
                columnHeaders[index] = new ColumnBindingInfo(cch.getName(), ExpressionUtil.createJSRowExpression((String)cch.getName()), 2, "icons/obj16/sigma.gif", tooltip, (Object)cch);
                columnHeaders[index].setChartAggExpression(ChartReportItemUtil.convertToChartAggExpression((String)cch.getAggregateFunction()));
                ++index;
            }
            for (ComputedColumnHandle cch : columnList) {
                columnHeaders[index++] = new ColumnBindingInfo(cch.getName(), ExpressionUtil.createJSRowExpression((String)cch.getName()), 0, null, null, (Object)cch);
            }
            return columnHeaders;
        }

        private List<GroupHandle> getGroupsOfSharedBinding() {
            ArrayList<GroupHandle> groupList = new ArrayList<GroupHandle>();
            ListingHandle table = null;
            if (ReportDataServiceProvider.this.isInheritColumnsGroups()) {
                table = ReportDataServiceProvider.this.findListingInheritance();
            } else {
                ReportItemHandle handle = ReportDataServiceProvider.this.getReportItemHandle();
                table = this.getSharedListingHandle(handle);
            }
            if (table != null) {
                SlotHandle groups = table.getGroups();
                Iterator iter = groups.iterator();
                while (iter.hasNext()) {
                    groupList.add((GroupHandle)iter.next());
                }
            }
            return groupList;
        }

        private ListingHandle getSharedListingHandle(ReportItemHandle aItemHandle) {
            if (aItemHandle instanceof ListingHandle) {
                return (ListingHandle)aItemHandle;
            }
            ReportItemHandle handle = aItemHandle.getDataBindingReference();
            if (handle != null) {
                return this.getSharedListingHandle(handle);
            }
            if (aItemHandle.getContainer() instanceof MultiViewsHandle) {
                return this.getSharedListingHandle((ReportItemHandle)aItemHandle.getContainer().getContainer());
            }
            return null;
        }

        private List<Object[]> getPreviewRowData(ColumnBindingInfo[] headers, int rowCount, boolean isStringType) throws ChartException {
            ArrayList<Object[]> dataList = new ArrayList<Object[]>();
            ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader parentLoader = oldContextLoader;
            if (parentLoader == null) {
                parentLoader = this.getClass().getClassLoader();
            }
            ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parentLoader, (ModuleHandle)ReportDataServiceProvider.this.itemHandle.getModuleHandle());
            Thread.currentThread().setContextClassLoader(newContextLoader);
            try {
                try {
                    IQueryResults actualResultSet;
                    QueryDefinition queryDefn = new QueryDefinition();
                    queryDefn.setMaxRows(ReportDataServiceProvider.this.getMaxRow());
                    List<String> columns = this.generateShareBindingsWithTable(headers, queryDefn, ReportDataServiceProvider.this.session, new HashMap<String, String>());
                    Iterator filtersIterator = ReportDataServiceProvider.this.getPropertyIterator(ReportDataServiceProvider.this.itemHandle.getPropertyHandle("filter"));
                    if (filtersIterator != null) {
                        while (filtersIterator.hasNext()) {
                            FilterDefinition filter = ReportDataServiceProvider.this.session.getModelAdaptor().adaptFilter((FilterConditionHandle)filtersIterator.next());
                            queryDefn.addFilter((IFilterDefinition)filter);
                        }
                    }
                    if ((actualResultSet = this.executeSharedQuery(queryDefn)) != null) {
                        int columnCount = columns.size();
                        IResultIterator iter = actualResultSet.getResultIterator();
                        while (iter.next()) {
                            int n;
                            Object[] record;
                            if (isStringType) {
                                record = new String[columnCount];
                                n = 0;
                                while (n < columnCount) {
                                    record[n] = DataTypeUtil.toString((Object)iter.getValue(columns.get(n)));
                                    ++n;
                                }
                                dataList.add(record);
                                continue;
                            }
                            record = new Object[columnCount];
                            n = 0;
                            while (n < columnCount) {
                                record[n] = iter.getValue(columns.get(n));
                                ++n;
                            }
                            dataList.add(record);
                        }
                        actualResultSet.close();
                    }
                }
                catch (BirtException e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextLoader);
            }
            return dataList;
        }

        private List<String> generateShareBindingsWithTable(ColumnBindingInfo[] headers, QueryDefinition queryDefn, DataRequestSession aSession, Map<String, String> bindingExprsMap) throws AdapterException, DataException {
            ArrayList<String> columns = new ArrayList<String>();
            ReportItemHandle reportItemHandle = ReportDataServiceProvider.this.getReportItemHandle();
            if (ReportDataServiceProvider.this.isInheritColumnsGroups()) {
                reportItemHandle = ReportDataServiceProvider.this.findListingInheritance();
            }
            queryDefn.setDataSetName(reportItemHandle.getDataSet().getQualifiedName());
            IModelAdapter modelAdapter = aSession.getModelAdaptor();
            int i = 0;
            while (i < headers.length) {
                ColumnBindingInfo chi = headers[i];
                int type = chi.getColumnType();
                switch (type) {
                    case 0: 
                    case 2: {
                        IBinding binding = modelAdapter.adaptBinding((ComputedColumnHandle)chi.getObjectHandle());
                        queryDefn.addBinding(binding);
                        columns.add(binding.getBindingName());
                        bindingExprsMap.put(chi.getExpression(), binding.getBindingName());
                        break;
                    }
                    case 1: {
                        GroupDefinition gd = modelAdapter.adaptGroup((GroupHandle)chi.getObjectHandle());
                        queryDefn.addGroup(gd);
                        String name = StructureFactory.newComputedColumn((DesignElementHandle)reportItemHandle, (String)gd.getName()).getName();
                        IBinding binding = new Binding(name);
                        binding.setExpression((IBaseExpression)modelAdapter.adaptExpression(ChartReportItemUtil.getExpression((GroupHandle)((GroupHandle)chi.getObjectHandle()))));
                        queryDefn.addBinding(binding);
                        columns.add(name);
                        bindingExprsMap.put(((ScriptExpression)binding.getExpression()).getText(), binding.getBindingName());
                    }
                }
                ++i;
            }
            if (reportItemHandle instanceof ListingHandle) {
                queryDefn.getSorts().addAll(ChartBaseQueryHelper.createSorts((Iterator)((ListingHandle)reportItemHandle).sortsIterator(), (IModelAdapter)modelAdapter));
            }
            return columns;
        }
    }
}

