/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;

public class DteAdapter {
    public void defineDataSet(DataSetHandle handle, DataRequestSession session, boolean keepDataSetFilter, boolean disAllowAggregation) throws AdapterException, BirtException {
        List computedColumns;
        BaseDataSetDesign baseDS;
        if (handle == null) {
            return;
        }
        DataSourceHandle dataSourceHandle = handle.getDataSource();
        if (dataSourceHandle != null) {
            BaseDataSourceDesign dsourceDesign = session.getModelAdaptor().adaptDataSource(dataSourceHandle);
            session.defineDataSource((IBaseDataSourceDesign)dsourceDesign);
        }
        if (handle instanceof JointDataSetHandle) {
            Iterator iter = ((JointDataSetHandle)handle).dataSetsIterator();
            while (iter.hasNext()) {
                DataSetHandle dsHandle = (DataSetHandle)iter.next();
                if (dsHandle == null) continue;
                this.defineDataSet(dsHandle, session, true, false);
            }
        }
        if (handle instanceof DerivedDataSetHandle) {
            List inputDataSet = ((DerivedDataSetHandle)handle).getInputDataSets();
            int i = 0;
            while (i < inputDataSet.size()) {
                this.defineDataSet((DataSetHandle)inputDataSet.get(i), session, keepDataSetFilter, disAllowAggregation);
                ++i;
            }
        }
        if ((baseDS = session.getModelAdaptor().adaptDataSet(handle)) == null) {
            return;
        }
        if (!keepDataSetFilter && baseDS.getFilters() != null) {
            baseDS.getFilters().clear();
        }
        if (disAllowAggregation && (computedColumns = baseDS.getComputedColumns()) != null && computedColumns.size() != 0) {
            int i = 0;
            while (i < computedColumns.size()) {
                IComputedColumn computedColumn = (IComputedColumn)computedColumns.get(i);
                if (computedColumn.getAggregateFunction() != null) {
                    computedColumns.set(i, new ComputedColumn(computedColumn.getName(), "null"));
                }
                ++i;
            }
        }
        session.defineDataSet((IBaseDataSetDesign)baseDS);
    }

    public void setRowLimit(DataRequestSession session, int rowLimit, boolean isCube) {
        HashMap<String, Integer> appContext = session.getDataSessionContext().getAppContext();
        if (appContext == null) {
            appContext = new HashMap<String, Integer>();
        }
        if (!isCube) {
            appContext.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, rowLimit);
        } else {
            appContext.put(DataEngine.CUBECURSOR_FETCH_LIMIT_ON_COLUMN_EDGE, rowLimit);
            appContext.put(DataEngine.CUBECUSROR_FETCH_LIMIT_ON_ROW_EDGE, rowLimit);
        }
        session.getDataSessionContext().setAppContext(appContext);
    }

    public IQueryResults executeQuery(DataRequestSession session, IQueryDefinition queryDefn) throws BirtException {
        IPreparedQuery pq = session.prepare(queryDefn);
        return (IQueryResults)session.execute((IBasePreparedQuery)pq, null, new ScriptContext());
    }

    public ICubeQueryResults executeQuery(DataRequestSession session, ICubeQueryDefinition queryDefn) throws BirtException {
        IPreparedCubeQuery pq = session.prepare(queryDefn);
        return (ICubeQueryResults)session.execute((IBasePreparedQuery)pq, null, new ScriptContext());
    }

    public void populateApplicationContext(DataSetHandle handle, DataRequestSession session) throws BirtException {
    }

    public void populateApplicationContext(CubeHandle handle, DataRequestSession session) throws BirtException {
    }
}

