/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.chart.computation.withaxes.SharedScaleContext;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IExternalizer;
import org.eclipse.birt.chart.factory.IMessageLookup;
import org.eclipse.birt.chart.factory.IResourceFinder;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.DialChart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportStyleProcessor;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.ui.BIRTDesignerMessageLookup;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DesignerRepresentation
extends Figure {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    private static final String ERROR_MSG = Messages.getString("DesignerRepresentation.error.Error");
    private IDeviceRenderer idr = null;
    private final ChartReportItemImpl crii;
    private transient Chart cm;
    private Image imgChart = null;
    private GC gc = null;
    private transient boolean bDirty = true;
    private static final PaletteData PALETTE_DATA = new PaletteData(0xFF0000, 65280, 255);
    private static final int TRANSPARENT_COLOR = 1193046;
    private boolean bPainting = false;

    DesignerRepresentation(ChartReportItemImpl crii) {
        this.crii = crii;
        this.updateChartModelAndSize();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            logger.log((Exception)((Object)pex));
        }
    }

    private void updateChartModelAndSize() {
        if (this.crii != null) {
            this.cm = (Chart)this.crii.getProperty("chart.instance");
            if (this.cm != null) {
                if (ChartCubeUtil.isPlotChart((DesignElementHandle)this.crii.getHandle())) {
                    this.cm = ChartCubeUtil.updateModelToRenderPlot((Chart)this.cm.copyInstance(), (boolean)this.crii.getHandle().isDirectionRTL());
                } else if (ChartCubeUtil.isAxisChart((DesignElementHandle)this.crii.getHandle())) {
                    this.cm = ChartCubeUtil.updateModelToRenderAxis((Chart)this.cm.copyInstance(), (boolean)this.crii.getHandle().isDirectionRTL());
                }
                if (!ChartCubeUtil.isAxisChart((DesignElementHandle)this.crii.getHandle())) {
                    IDisplayServer idsSWT = ChartUIUtil.getDisplayServer();
                    Bounds bo = this.cm.getBlock().getBounds().scaledInstance((double)idsSWT.getDpiResolution() / 72.0);
                    this.setSize((int)bo.getWidth(), (int)bo.getHeight());
                }
            } else {
                this.setSize(212, 130);
            }
        } else {
            this.setSize(212, 130);
        }
    }

    final void setDirty(boolean bDirty) {
        this.bDirty = bDirty;
        this.updateChartModelAndSize();
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        if (this.minSize != null) {
            return this.minSize;
        }
        DimensionHandle dimWidth = this.crii.getHandle().getWidth();
        DimensionHandle dimHeight = this.crii.getHandle().getHeight();
        boolean isPerWidth = "%".equals(dimWidth.getUnits());
        boolean isPerHeight = "%".equals(dimHeight.getUnits());
        Dimension dim = new Dimension();
        Dimension size = this.getSize();
        if (!isPerWidth) {
            dim.width = Math.max(wHint, size.width);
        }
        if (!isPerHeight) {
            dim.height = Math.max(hHint, size.height);
        }
        return dim;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize != null) {
            return this.prefSize;
        }
        DimensionHandle dimWidth = this.crii.getHandle().getWidth();
        DimensionHandle dimHeight = this.crii.getHandle().getHeight();
        boolean isPerWidth = "%".equals(dimWidth.getUnits());
        boolean isPerHeight = "%".equals(dimHeight.getUnits());
        Dimension dim = this.getSize().getCopy();
        if (isPerWidth && wHint != -1) {
            dim.width = (int)((double)wHint * dimWidth.getMeasure() / 100.0);
        }
        if (isPerHeight && hHint != -1) {
            dim.height = (int)((double)hHint * dimHeight.getMeasure() / 100.0);
        }
        Dimension newSize = dim.getCopy();
        if (dim.width == 0) {
            newSize.width = 72;
        }
        if (dim.height == 0) {
            newSize.height = 72;
        }
        this.setSize(newSize.width, newSize.height);
        if (newSize.equals((Object)dim)) {
            return newSize;
        }
        if (this.cm != null) {
            IDisplayServer ids = ChartUIUtil.getDisplayServer();
            ChartAdapter.beginIgnoreNotifications();
            this.cm.getBlock().getBounds().setWidth(ChartUtil.convertPixelsToPoints((IDisplayServer)ids, (double)dim.width));
            this.cm.getBlock().getBounds().setHeight(ChartUtil.convertPixelsToPoints((IDisplayServer)ids, (double)dim.height));
            ChartAdapter.endIgnoreNotifications();
        }
        return newSize;
    }

    private List<Double> parseSampleData(String s) {
        ArrayList<Double> list = new ArrayList<Double>();
        String[] sa = s.split(",", 100);
        int i = 0;
        while (i < sa.length) {
            try {
                list.add(Double.valueOf(sa[i]));
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
            ++i;
        }
        return list;
    }

    private SharedScaleContext createSharedScaleFromSampleData() {
        Double min = Double.MAX_VALUE;
        Double max = -1.7976931348623157E308;
        SampleData sd = this.cm.getSampleData();
        if (sd == null || sd.getBaseSampleData().size() == 0 || sd.getOrthogonalSampleData().size() == 0) {
            return null;
        }
        OrthogonalSampleData osd = (OrthogonalSampleData)sd.getOrthogonalSampleData().get(0);
        String sData = osd.getDataSetRepresentation();
        List<Double> lData = this.parseSampleData(sData);
        if (lData == null) {
            return null;
        }
        int i = 0;
        while (i < lData.size()) {
            double v = lData.get(i);
            min = Math.min(min, v);
            max = Math.max(max, v);
            ++i;
        }
        return SharedScaleContext.createInstance((Object)min, (Object)max);
    }

    public final void paintClientArea(Graphics g) {
        if (this.bPainting) {
            return;
        }
        Rectangle r = this.getClientArea().getCopy();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        this.bPainting = true;
        if (this.bDirty) {
            this.bDirty = false;
            Display d = Display.getCurrent();
            Dimension dSize = r.getSize();
            if (this.imgChart == null || this.imgChart.getImageData().width != dSize.width || this.imgChart.getImageData().height != dSize.height) {
                if (this.gc != null) {
                    this.gc.dispose();
                }
                if (this.imgChart != null) {
                    this.imgChart.dispose();
                }
                this.bDirty = true;
                ImageData ida = new ImageData(dSize.width, dSize.height, 32, PALETTE_DATA);
                ida.transparentPixel = 1193046;
                this.imgChart = new Image((Device)d, ida);
                this.gc = new GC((Drawable)this.imgChart);
            }
            if ("macosx".equals(Platform.getOS()) && this.gc != null && !this.gc.isDisposed()) {
                this.gc.dispose();
                this.gc = new GC((Drawable)this.imgChart);
            }
            Color clrPreviousBG = this.gc.getBackground();
            this.gc.setBackground(Display.getDefault().getSystemColor(25));
            this.gc.fillRectangle(0, 0, this.imgChart.getImageData().width, this.imgChart.getImageData().height);
            this.gc.setBackground(clrPreviousBG);
            if (this.cm == null) {
                this.showNullChart(dSize);
            } else {
                this.showChart(dSize);
            }
        }
        if (this.imgChart != null) {
            g.drawImage(this.imgChart, r.x, r.y);
        }
        this.bPainting = false;
    }

    private void showNullChart(Dimension dSize) {
        String MSG = Messages.getString("DesignerRepresentation.msg.InvalidChart");
        logger.log(4, Messages.getString("DesignerRepresentation.log.UnableToFind"));
        Display dv = Display.getCurrent();
        Font font = FontManager.getFont((String)"Dialog", (int)10, (int)2);
        this.gc.setFont(font);
        FontMetrics fm = this.gc.getFontMetrics();
        this.gc.setForeground(dv.getSystemColor(3));
        this.gc.setBackground(dv.getSystemColor(1));
        this.gc.fillRectangle(0, 0, dSize.width - 1, dSize.height - 1);
        this.gc.drawRectangle(0, 0, dSize.width - 1, dSize.height - 1);
        String[] texts = DesignerRepresentation.splitOnBreaks(MSG, font, dSize.width - 10);
        int y = 5;
        String[] stringArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            this.gc.drawText(text, 5, y);
            y += fm.getHeight();
            ++n2;
        }
    }

    private List<Axis> findAllAxes(ChartWithAxes cwa) {
        ArrayList<Axis> al = new ArrayList<Axis>();
        Axis axBase = cwa.getPrimaryBaseAxes()[0];
        al.add(axBase);
        al.addAll(Arrays.asList(cwa.getOrthogonalAxes(axBase, true)));
        return al;
    }

    private void removeScaleInfo(Scale scale) {
        if (scale != null) {
            scale.unsetStep();
            scale.unsetStepNumber();
            scale.setMin(null);
            scale.setMax(null);
        }
    }

    private void removeScaleInfoForSample(Chart chart) {
        block4: {
            Series[] aSeries;
            block3: {
                if (!(chart instanceof ChartWithAxes)) break block3;
                ChartWithAxes cwa = (ChartWithAxes)chart;
                List<Axis> axisList = this.findAllAxes(cwa);
                for (Axis ax : axisList) {
                    this.removeScaleInfo(ax.getScale());
                }
                break block4;
            }
            if (!(chart instanceof DialChart)) break block4;
            DialChart dChart = (DialChart)chart;
            Series[] seriesArray = aSeries = dChart.getRunTimeSeries();
            int n = aSeries.length;
            int n2 = 0;
            while (n2 < n) {
                Series series = seriesArray[n2];
                if (series instanceof DialSeries) {
                    this.removeScaleInfo(((DialSeries)series).getDial().getScale());
                }
                ++n2;
            }
        }
    }

    private void showChart(Dimension dSize) {
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)dSize.width, (double)dSize.height);
        bo.scale(72.0 / (double)this.idr.getDisplayServer().getDpiResolution());
        this.idr.setProperty("device.output.context", (Object)this.gc);
        Generator gr = Generator.instance();
        ChartAdapter.beginIgnoreNotifications();
        this.cm.clearSections(3);
        this.cm.createSampleRuntimeSeries();
        ChartAdapter.endIgnoreNotifications();
        try {
            Chart cmRunTime = this.cm.copyInstance();
            this.removeScaleInfoForSample(cmRunTime);
            RunTimeContext rtc = new RunTimeContext();
            rtc.setScriptingEnabled(false);
            rtc.setMessageLookup((IMessageLookup)new BIRTDesignerMessageLookup((DesignElementHandle)this.crii.getHandle()));
            rtc.setRightToLeft(this.crii.isLayoutDirectionRTL());
            rtc.setRightToLeftText(this.crii.getHandle().isDirectionRTL());
            rtc.setResourceFinder((IResourceFinder)this.crii);
            rtc.setExternalizer((IExternalizer)this.crii);
            boolean bPlotChart = ChartCubeUtil.isPlotChart((DesignElementHandle)this.crii.getHandle());
            if (bPlotChart) {
                rtc.setSharedScale(this.createSharedScaleFromSampleData());
            }
            gr.render(this.idr, gr.build(this.idr.getDisplayServer(), cmRunTime, bo, null, rtc, (IStyleProcessor)new ChartReportStyleProcessor((DesignElementHandle)this.crii.getHandle(), true)));
        }
        catch (ChartException gex) {
            this.showException(this.gc, (Exception)((Object)gex));
        }
    }

    private final void showException(GC g2d, Exception ex) {
        Point pTLC = new Point(0, 0);
        Exception th = ex;
        String sMessage = null;
        sMessage = th instanceof BirtException ? ((BirtException)((Object)th)).getLocalizedMessage() : ex.getMessage();
        if (sMessage == null) {
            sMessage = "<null>";
        }
        Dimension d = this.getSize();
        Display dv = Display.getCurrent();
        Font fo = new Font((Device)dv, "Courier", 1, 12);
        g2d.setFont(fo);
        FontMetrics fm = g2d.getFontMetrics();
        g2d.setBackground(dv.getSystemColor(1));
        g2d.fillRectangle(pTLC.x + 20, pTLC.y + 20, d.width - 40, d.height - 40);
        g2d.setForeground(dv.getSystemColor(2));
        g2d.drawRectangle(pTLC.x + 20, pTLC.y + 20, d.width - 40, d.height - 40);
        Region rgPrev = new Region();
        g2d.getClipping(rgPrev);
        g2d.setClipping(pTLC.x + 20, pTLC.y + 20, d.width - 40, d.height - 40);
        int x = pTLC.x + 25;
        int y = pTLC.y + 20 + fm.getHeight();
        g2d.setForeground(dv.getSystemColor(2));
        g2d.drawString(ERROR_MSG, x, y);
        g2d.setForeground(dv.getSystemColor(3));
        g2d.drawText(sMessage, x, y += fm.getHeight());
        g2d.setClipping(rgPrev);
        rgPrev.dispose();
        fo.dispose();
    }

    public final void dispose() {
        if (this.imgChart != null) {
            this.gc.dispose();
            this.imgChart.dispose();
            this.idr.dispose();
            this.gc = null;
            this.imgChart = null;
            this.bDirty = true;
            this.idr = null;
        }
    }

    private static String[] splitOnBreaks(String s, Font font, double maxSize) {
        int n;
        int j;
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        do {
            String ss;
            if ((j = s.indexOf(10, i)) == -1) {
                j = s.length();
            }
            if ((ss = s.substring(i, j)) != null && ss.length() > 0) {
                al.add(ss);
            }
            i = j + 1;
        } while (j != -1 && j < s.length());
        if (maxSize > 0.0) {
            TextLayout tl = new TextLayout((Device)Display.getCurrent());
            tl.setFont(font);
            tl.setWidth((int)maxSize);
            ArrayList<String> nal = new ArrayList<String>();
            for (String ns : al) {
                tl.setText(ns);
                int[] offsets = tl.getLineOffsets();
                i = 1;
                while (i < offsets.length) {
                    String ss = ns.substring(offsets[i - 1], offsets[i]);
                    nal.add(ss);
                    ++i;
                }
            }
            tl.dispose();
            al = nal;
        }
        if ((n = al.size()) == 1 || n == 0) {
            return null;
        }
        String[] sa = new String[n];
        i = 0;
        while (i < al.size()) {
            sa[i] = (String)al.get(i);
            ++i;
        }
        return sa;
    }
}

