/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.apt.pluggable.core.dispatch;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.AnnotationProcessorFactoryLoader;
import org.eclipse.jdt.apt.core.internal.IServiceFactory;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.apt.pluggable.core.Apt6Plugin;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeBuildProcessingEnvImpl;
import org.eclipse.jdt.internal.apt.pluggable.core.dispatch.IdeReconcileProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.apt.dispatch.ProcessorInfo;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.core.CompilationUnitProblemFinder;
import org.eclipse.jdt.internal.core.builder.ICompilationUnitLocator;

public class IdeAnnotationProcessorManager
extends BaseAnnotationProcessorManager {
    private IJavaProject _javaProject;
    private ICompilationUnitLocator _cuLocator;
    private Map<IServiceFactory, FactoryPath.Attributes> _processorFactories;
    private Iterator<Map.Entry<IServiceFactory, FactoryPath.Attributes>> _processorIter;

    public void configureFromPlatform(Compiler compiler, Object compilationUnitLocator, Object javaProject) {
        this._javaProject = (IJavaProject)javaProject;
        this._cuLocator = (ICompilationUnitLocator)compilationUnitLocator;
        if (this._processingEnv != null) {
            throw new IllegalStateException("Calling configure() more than once on an AnnotationProcessorManager is not supported");
        }
        this._processingEnv = compiler instanceof CompilationUnitProblemFinder ? new IdeReconcileProcessingEnvImpl(this, this._javaProject, compiler) : new IdeBuildProcessingEnvImpl(this, this._javaProject, compiler);
        if (Apt6Plugin.DEBUG) {
            Apt6Plugin.trace("Java 6 annotation processor manager initialized for compiler " + compiler.toString() + " on project " + this._javaProject.getElementName());
        }
    }

    public ProcessorInfo discoverNextProcessor() {
        if (this._processorIter.hasNext()) {
            Map.Entry<IServiceFactory, FactoryPath.Attributes> entry = this._processorIter.next();
            try {
                Processor p = (Processor)entry.getKey().newInstance();
                p.init((ProcessingEnvironment)this._processingEnv);
                ProcessorInfo pi = new ProcessorInfo(p);
                if (Apt6Plugin.DEBUG) {
                    Apt6Plugin.trace("Discovered processor " + p.toString());
                }
                this._processors.add(pi);
                return pi;
            }
            catch (CoreException e) {
                Apt6Plugin.log(e, "Unable to create instance of annotation processor " + entry.getKey());
            }
        }
        return null;
    }

    public void reportProcessorException(Processor p, Exception e) {
        Apt6Plugin.log(e, "Exception thrown by Java annotation processor " + p);
    }

    public ICompilationUnit findCompilationUnit(IFile file) {
        return this._cuLocator.fromIFile(file);
    }

    public void processAnnotations(CompilationUnitDeclaration[] units, ReferenceBinding[] referenceBindings, boolean isLastRound) {
        if (this._processorFactories == null) {
            this._processorFactories = AnnotationProcessorFactoryLoader.getLoader().getJava6FactoriesAndAttributesForProject(this._javaProject);
            this._processorIter = this._processorFactories.entrySet().iterator();
        }
        if (!this._processorFactories.isEmpty()) {
            super.processAnnotations(units, referenceBindings, isLastRound);
        }
    }
}

