/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.HTMLDocParser;
import org.eclipse.help.internal.search.LocalSearchManager;
import org.eclipse.help.internal.search.XHTMLSearchParticipant;
import org.eclipse.help.internal.xhtml.XHTMLContentDescriber;
import org.eclipse.help.search.ISearchIndex;
import org.eclipse.help.search.LuceneSearchParticipant;

public class HTMLSearchParticipant
extends LuceneSearchParticipant {
    private static final String HELP_BASE_XHTML = "org.eclipse.help.base.xhtml";
    private HTMLDocParser parser = new HTMLDocParser();
    private String indexPath;
    private IContentDescriber xhtmlDescriber;
    private XHTMLSearchParticipant xhtmlParticipant;

    public HTMLSearchParticipant(String indexPath) {
        this.indexPath = indexPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus addDocument(ISearchIndex index, String pluginId, String name, URL url, String id, Document doc) {
        if (this.isXHTML(pluginId, url)) {
            LocalSearchManager manager = BaseHelpSystem.getLocalSearchManager();
            LuceneSearchParticipant participant = manager.getParticipant(HELP_BASE_XHTML);
            if (participant != null) return participant.addDocument(index, pluginId, name, url, id, doc);
            participant = this.getXhtmlParticipant();
            return participant.addDocument(index, pluginId, name, url, id, doc);
        }
        try {
            try {
                try {
                    this.parser.openDocument(url);
                }
                catch (IOException iOException) {
                    Status status = new Status(4, "org.eclipse.help.base", 4, "Help document " + name + " cannot be opened.", null);
                    this.parser.closeDocument();
                    return status;
                }
                doc.add(new Field("contents", this.parser.getContentReader()));
                doc.add(new Field("exact_contents", this.parser.getContentReader()));
                String title = this.parser.getTitle();
                doc.add(new Field("title", title, Field.Store.NO, Field.Index.TOKENIZED));
                doc.add(new Field("exact_title", title, Field.Store.NO, Field.Index.TOKENIZED));
                doc.add(new Field("raw_title", title, Field.Store.YES, Field.Index.NO));
                doc.add(new Field("summary", this.parser.getSummary(title), Field.Store.YES, Field.Index.NO));
                if (this.parser.getException() == null) return Status.OK_STATUS;
                Status status = new Status(4, "org.eclipse.help.base", 4, "Parse error occurred while adding document " + name + " to search index " + this.indexPath + ".", (Throwable)this.parser.getException());
                return status;
            }
            finally {
                this.parser.closeDocument();
            }
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.help.base", 4, "IO exception occurred while adding document " + name + " to search index " + this.indexPath + ".", (Throwable)e);
        }
    }

    private XHTMLSearchParticipant getXhtmlParticipant() {
        if (this.xhtmlParticipant == null) {
            this.xhtmlParticipant = new XHTMLSearchParticipant();
        }
        return this.xhtmlParticipant;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isXHTML(String pluginId, URL url) {
        boolean bl;
        if (this.xhtmlDescriber == null) {
            this.xhtmlDescriber = new XHTMLContentDescriber();
        }
        InputStream in = null;
        in = url.openStream();
        boolean bl2 = bl = this.xhtmlDescriber.describe(in, null) == 2;
        if (in == null) return bl;
        try {
            in.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        catch (Exception exception) {
            try {
                if (in == null) return false;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
    }
}

