/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.net.URL;
import org.eclipse.birt.core.framework.URLClassLoader;

public class ReloadableClassLoader
extends ClassLoader {
    URL[] urls;
    URLClassLoader loader;
    ClassLoader parent;

    public ReloadableClassLoader(URL[] urls, ClassLoader parent) {
        super(parent);
        this.urls = urls;
        this.parent = parent;
        this.loader = new URLClassLoader(urls, parent);
    }

    public void reload() {
        if (this.loader != null) {
            this.loader.close();
        }
        this.loader = new URLClassLoader(this.urls, this.parent);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clz = this.loadClass(name);
        if (resolve) {
            this.resolveClass(clz);
        }
        return clz;
    }

    public URL[] getUrls() {
        return this.urls;
    }

    public void setUrls(URL[] urls) {
        this.urls = urls;
    }

    public URLClassLoader getLoader() {
        return this.loader;
    }
}

