/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.browsers;

import java.net.URL;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.browsers.BrowserManager;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class BrowserAccessor {
    private static IBrowser browser;
    private static IBrowser internalBrowser;

    public static synchronized IBrowser getPreviewBrowser(boolean forceExternal) {
        if (!forceExternal && BrowserManager.getInstance().isEmbeddedBrowserPresent()) {
            if (internalBrowser == null) {
                internalBrowser = BrowserManager.getInstance().createBrowser(false);
            }
            return internalBrowser;
        }
        if (browser == null) {
            browser = new ExternalWorkbenchBrowser();
        }
        if (browser == null) {
            browser = BrowserManager.getInstance().createBrowser(true);
        }
        return browser;
    }

    static class ExternalWorkbenchBrowser
    implements IBrowser {
        ExternalWorkbenchBrowser() {
        }

        private IWebBrowser getExternalBrowser() throws PartInitException {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            return support.getExternalBrowser();
        }

        public void close() {
        }

        public boolean isCloseSupported() {
            return false;
        }

        public void displayURL(String url) throws Exception {
            try {
                IWebBrowser browser = this.getExternalBrowser();
                if (browser != null) {
                    browser.openURL(new URL(url));
                }
            }
            catch (PartInitException pie) {
                ViewerPlugin.logError(pie.getLocalizedMessage(), pie);
            }
        }

        public boolean isSetLocationSupported() {
            return false;
        }

        public boolean isSetSizeSupported() {
            return false;
        }

        public void setLocation(int x, int y) {
        }

        public void setSize(int width, int height) {
        }
    }
}

