/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.palette.ITagDropSourceData;
import org.eclipse.jst.pagedesigner.itemcreation.ITagDropOverrider;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public final class CreationData {
    private final ITagDropSourceData _creationProvider;
    private final String _prefix;
    private final IDOMPosition _domPosition;
    private final IDOMModel _model;
    private final IAdaptable _customizationData;
    private TagIdentifier _tagId;
    private Entity _tagEntity;
    private final ITaglibDomainMetaDataModelContext _taglibMetaDataContext;
    private IDOMPosition _adjustedPosition;

    public CreationData(ITagDropSourceData creationProvider, IDOMModel model, IDOMPosition domPosition, ITaglibDomainMetaDataModelContext taglibMetaDataContext, IAdaptable customizationData) {
        this._creationProvider = creationProvider;
        this._taglibMetaDataContext = taglibMetaDataContext;
        this._adjustedPosition = this._domPosition = domPosition;
        this._model = model;
        this._customizationData = customizationData;
        this._prefix = CreationData.getPrefix(this.getUri(), model, this.getDefaultPrefix());
    }

    protected static String getPrefix(String uri, IDOMModel model, String suggested) {
        if (uri == null || "html".equalsIgnoreCase(uri) || "jsp".equalsIgnoreCase(uri) || "JSP11".equalsIgnoreCase(uri)) {
            return null;
        }
        return JSPUtil.getOrCreatePrefix(model, uri, suggested);
    }

    public String getUri() {
        ITagDropOverrider overrider = this.getTagDropOverrider();
        if (overrider != null && overrider.getUriOverride() != null) {
            return overrider.getUriOverride();
        }
        return this._creationProvider.getNamespace();
    }

    public String getDefaultPrefix() {
        ITagDropOverrider overrider = this.getTagDropOverrider();
        if (overrider != null && overrider.getDefaultPrefixOverride() != null) {
            return overrider.getDefaultPrefixOverride();
        }
        return this._creationProvider.getDefaultPrefix();
    }

    private ITagDropOverrider getTagDropOverrider() {
        if (this.getDropCustomizationData() != null && this.getDropCustomizationData().getAdapter(ITagDropOverrider.class) != null) {
            return (ITagDropOverrider)this.getDropCustomizationData().getAdapter(ITagDropOverrider.class);
        }
        return null;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getTagName() {
        ITagDropOverrider overrider = this.getTagDropOverrider();
        if (overrider != null && overrider.getTagNameOverride() != null) {
            return overrider.getTagNameOverride();
        }
        return this._creationProvider.getTagName();
    }

    public ITagDropSourceData getTagCreationProvider() {
        return this._creationProvider;
    }

    public Entity getTagEntity() {
        if (this._tagEntity == null) {
            this._tagEntity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)this._taglibMetaDataContext, (String)this.getTagName());
        }
        return this._tagEntity;
    }

    public boolean isHTMLFormRequired() {
        Trait t = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this.getTagEntity(), (String)"requires-html-form");
        if (t != null) {
            return TraitValueHelper.getValueAsBoolean((Trait)t);
        }
        return false;
    }

    public boolean isJSFComponent() {
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)this._taglibMetaDataContext);
        Trait t = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)"is-jsf-component-library");
        if (t != null) {
            return TraitValueHelper.getValueAsBoolean((Trait)t);
        }
        return false;
    }

    public ITaglibDomainMetaDataModelContext getTaglibMetaDataContext() {
        return this._taglibMetaDataContext;
    }

    public IDOMPosition getDomPosition() {
        return this._domPosition;
    }

    public IDOMModel getModel() {
        return this._model;
    }

    public IDOMPosition getAdjustedPosition() {
        return this._adjustedPosition;
    }

    void setAdjustedPosition(IDOMPosition adjustedPosition) {
        this._adjustedPosition = adjustedPosition;
    }

    public TagIdentifier getTagId() {
        if (this._tagId == null) {
            this._tagId = TagIdentifierFactory.createJSPTagWrapper((String)this.getUri(), (String)this.getTagName());
        }
        return this._tagId;
    }

    public IAdaptable getDropCustomizationData() {
        return this._customizationData;
    }
}

