/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.entity.data.model;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.ui.internal.wizards.entity.EntityWizardMsg;
import org.eclipse.jpt.ui.internal.wizards.entity.data.model.EntityRow;
import org.eclipse.jpt.ui.internal.wizards.entity.data.model.IEntityDataModelProperties;
import org.eclipse.jpt.ui.internal.wizards.entity.data.operation.NewEntityClassOperation;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityDataModelProvider
extends NewJavaClassDataModelProvider
implements IEntityDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new NewEntityClassOperation(this.getDataModel());
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IEntityDataModelProperties.INHERITANCE");
        propertyNames.add("IEntityDataModelProperties.ENTITY");
        propertyNames.add("IEntityDataModelProperties.MAPPED_AS_SUPERCLASS");
        propertyNames.add("IEntityDataModelProperties.INHERITANCE_STRATEGY");
        propertyNames.add("IEntityDataModelProperties.XML_SUPPORT");
        propertyNames.add("IEntityDataModelProperties.XML_NAME");
        propertyNames.add("IEntityDataModelProperties.ENTITY_NAME");
        propertyNames.add("IEntityDataModelProperties.TABLE_NAME_DEFAULT");
        propertyNames.add("IEntityDataModelProperties.TABLE_NAME");
        propertyNames.add("IEntityDataModelProperties.ENTITY_FIELDS");
        propertyNames.add("IEntityDataModelProperties.PK_FIELDS");
        propertyNames.add("IEntityDataModelProperties.FIELD_ACCESS_TYPE");
        propertyNames.add("IEntityDataModelProperties.PROPERTY_ACCESS_TYPE");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IEntityDataModelProperties.INHERITANCE")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.MAPPED_AS_SUPERCLASS")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IEntityDataModelProperties.XML_SUPPORT")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IEntityDataModelProperties.XML_NAME")) {
            return "";
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_NAME")) {
            return this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        }
        if (propertyName.equals("IEntityDataModelProperties.TABLE_NAME_DEFAULT")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.TABLE_NAME")) {
            return this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        }
        if (propertyName.equals("IEntityDataModelProperties.INHERITANCE_STRATEGY")) {
            return "";
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return "";
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_FIELDS")) {
            return new ArrayList();
        }
        if (propertyName.equals("IEntityDataModelProperties.PK_FIELDS")) {
            return new ArrayList();
        }
        if (propertyName.equals("IEntityDataModelProperties.FIELD_ACCESS_TYPE")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.PROPERTY_ACCESS_TYPE")) {
            return Boolean.FALSE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("IArtifactEditOperationDataModelProperties.PROJECT_NAME") || propertyName.equals("IEntityDataModelProperties.XML_SUPPORT")) {
            this.model.notifyPropertyChange("IEntityDataModelProperties.XML_NAME", 4);
        }
        return ok;
    }

    public IStatus validate(String propertyName) {
        IStatus result = super.validate(propertyName);
        if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE")) {
            return this.validateJavaPackage(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS") && "".equals(this.getStringProperty(propertyName))) {
            return WTPCommonPlugin.OK_STATUS;
        }
        if (propertyName.equals("IEntityDataModelProperties.XML_NAME")) {
            return this.validateXmlName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_FIELDS")) {
            return this.validateFieldsList((ArrayList)this.getProperty(propertyName));
        }
        return result;
    }

    private IStatus validateJavaPackage(String packName) {
        if (packName == null || packName.equals("")) {
            return WTPCommonPlugin.createWarningStatus((String)EntityWizardMsg.DEFAULT_PACKAGE_WARNING);
        }
        IStatus javaStatus = JavaConventions.validatePackageName((String)packName, (String)"1.5", (String)"1.5");
        if (javaStatus.getSeverity() == 4) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACAKGE_NAME_INVALID) + javaStatus.getMessage();
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (javaStatus.getSeverity() == 2) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACKAGE_NAME_WARNING) + javaStatus.getMessage();
            return WTPCommonPlugin.createWarningStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateXmlName(String xmlName) {
        JpaFile jpaFile;
        String projectName;
        IProject project;
        if (this.getBooleanProperty("IEntityDataModelProperties.XML_SUPPORT") && (project = ProjectUtilities.getProject((String)(projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME")))) != null && (jpaFile = JptCorePlugin.getJpaFile((IProject)project, (String)xmlName)) == null) {
            return new Status(4, "org.eclipse.jpt.ui", EntityWizardMsg.INVALID_XML_NAME);
        }
        return Status.OK_STATUS;
    }

    private IStatus validateFieldsList(ArrayList<EntityRow> entities) {
        if (entities != null && !entities.isEmpty()) {
            boolean dup = this.hasDuplicatesInEntityFields(entities);
            if (dup) {
                String msg = EntityWizardMsg.DUPLICATED_ENTITY_NAMES_MESSAGE;
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
            String errorMsg = this.checkInputElementsTypeValidation(entities);
            if (errorMsg != null) {
                return WTPCommonPlugin.createErrorStatus((String)errorMsg);
            }
            String warningMsg = this.checkInputElementsTypeExistence(entities);
            if (warningMsg != null) {
                return WTPCommonPlugin.createWarningStatus((String)warningMsg);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private String checkInputElementsTypeValidation(List<EntityRow> inputElements) {
        IStatus validateFieldTypeStatus = Status.OK_STATUS;
        for (EntityRow entityRow : inputElements) {
            String elementSignature;
            String sig = null;
            try {
                sig = Signature.createTypeSignature((String)entityRow.getFqnTypeName(), (boolean)true);
            }
            catch (IllegalArgumentException e) {
                String message = MessageFormat.format((String)EntityWizardMsg.EntityDataModelProvider_invalidArgument, (Object[])new Object[]{e.getLocalizedMessage()});
                validateFieldTypeStatus = new Status(4, "org.eclipse.jpt.ui", message);
                break;
            }
            if (sig == null) {
                validateFieldTypeStatus = JavaConventions.validateJavaTypeName((String)entityRow.getType(), (String)"1.5", (String)"1.5");
                break;
            }
            int sigType = Signature.getTypeSignatureKind((String)sig);
            if (sigType != 2 && sigType == 4 && Signature.getTypeSignatureKind((String)(elementSignature = Signature.getElementType((String)sig))) != 2) continue;
        }
        if (!validateFieldTypeStatus.isOK()) {
            return validateFieldTypeStatus.getMessage();
        }
        return null;
    }

    private String checkInputElementsTypeExistence(List<EntityRow> inputElements) {
        IStatus validateFieldTypeStatus = Status.OK_STATUS;
        for (EntityRow entityRow : inputElements) {
            String sig = Signature.createTypeSignature((String)entityRow.getFqnTypeName(), (boolean)true);
            if (sig == null) {
                String message = MessageFormat.format((String)EntityWizardMsg.EntityDataModelProvider_entityNotInProjectClasspath, (Object[])new Object[]{entityRow.getFqnTypeName()});
                validateFieldTypeStatus = new Status(4, "org.eclipse.jpt.ui", message);
                break;
            }
            int sigType = Signature.getTypeSignatureKind((String)sig);
            if (sigType == 2) continue;
            if (sigType == 4) {
                String elementSignature = Signature.getElementType((String)sig);
                if (Signature.getTypeSignatureKind((String)elementSignature) == 2) continue;
                String qualifiedName = Signature.toString((String)elementSignature);
                IProject project = (IProject)this.getProperty("NewJavaClassDataModel.PROJECT");
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType type = null;
                try {
                    type = javaProject.findType(qualifiedName);
                }
                catch (JavaModelException e) {
                    validateFieldTypeStatus = e.getStatus();
                    break;
                }
                if (type != null) continue;
                String message = MessageFormat.format((String)EntityWizardMsg.EntityDataModelProvider_entityNotInProjectClasspath, (Object[])new Object[]{entityRow.getFqnTypeName()});
                validateFieldTypeStatus = new Status(4, "org.eclipse.jpt.ui", message);
                break;
            }
            IProject project = (IProject)this.getProperty("NewJavaClassDataModel.PROJECT");
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType type = null;
            try {
                type = javaProject.findType(entityRow.getFqnTypeName());
            }
            catch (JavaModelException e) {
                validateFieldTypeStatus = e.getStatus();
                break;
            }
            if (type != null) continue;
            String message = MessageFormat.format((String)EntityWizardMsg.EntityDataModelProvider_entityNotInProjectClasspath, (Object[])new Object[]{entityRow.getFqnTypeName()});
            validateFieldTypeStatus = new Status(4, "org.eclipse.jpt.ui", message);
            break;
        }
        if (!validateFieldTypeStatus.isOK()) {
            return validateFieldTypeStatus.getMessage();
        }
        return null;
    }

    private boolean hasDuplicatesInEntityFields(ArrayList<EntityRow> input) {
        if (input == null) {
            return false;
        }
        int n = input.size();
        int i = 0;
        while (i < n) {
            EntityRow entity = input.get(i);
            int j = i + 1;
            while (j < n) {
                EntityRow intEntity = input.get(j);
                if (intEntity.getName().equals(entity.getName())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

