/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.datafeed;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.datafeed.IDataPointEntry;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FractionNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;

public final class BubbleEntry
implements IDataPointEntry {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    private Object oValue;
    private double dSize;
    private int index = 0;

    public BubbleEntry(Object value, Object size, int index) {
        this(value, size);
        this.index = index;
    }

    public BubbleEntry(Object value, Object size) {
        this.oValue = value;
        if (value instanceof Double && ((Double)value).isNaN()) {
            this.oValue = null;
        }
        this.dSize = size instanceof Number ? ((Number)size).doubleValue() : 0.0;
    }

    public String toString() {
        return this.getFormattedString(null, ULocale.getDefault());
    }

    public final Object getValue() {
        if (this.index > 0) {
            return this.index;
        }
        return this.oValue;
    }

    public final void setValue(Object value) {
        this.oValue = value;
    }

    public final double getSize() {
        return this.dSize;
    }

    public final void setSize(double dSize) {
        this.dSize = dSize;
    }

    public String getFormattedString(String type, FormatSpecifier formatter, ULocale locale) {
        String str = null;
        try {
            if ("bubble_value".equals(type)) {
                str = ValueFormatter.format((Object)this.oValue, (FormatSpecifier)formatter, (ULocale)locale, null);
            } else if ("bubble_size".equals(type)) {
                str = ValueFormatter.format((Object)new Double(this.dSize), (FormatSpecifier)formatter, (ULocale)locale, null);
            }
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
        }
        return str;
    }

    public String getFormattedString(FormatSpecifier formatter, ULocale locale) {
        String strSize = String.valueOf(this.dSize);
        if (formatter instanceof NumberFormatSpecifier || formatter instanceof JavaNumberFormatSpecifier || formatter instanceof FractionNumberFormatSpecifier) {
            try {
                strSize = ValueFormatter.format((Object)this.dSize, (FormatSpecifier)formatter, (ULocale)locale, null);
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
            }
        }
        String strValue = "";
        try {
            if (this.oValue == null) {
                return "S" + strSize;
            }
            strValue = ValueFormatter.format((Object)this.oValue, (FormatSpecifier)formatter, (ULocale)locale, null);
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
        }
        return "Y" + strValue + " S" + strSize;
    }

    public boolean isValid() {
        return this.getValue() != null && !Double.isNaN(this.dSize) && this.dSize != 0.0;
    }
}

