/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.comparator;

import org.eclipse.jdt.core.Flags;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.util.Util;

public class DeltaProcessor {
    public static boolean isCompatible(IDelta delta) {
        if (delta.getChildren().length != 0) {
            class CompatibleVisitor
            extends DeltaVisitor {
                boolean isCompatible;

                CompatibleVisitor() {
                    this.isCompatible = true;
                }

                public boolean visit(IDelta delta) {
                    return this.isCompatible;
                }

                public void endVisit(IDelta delta) {
                    if (this.isCompatible) {
                        this.isCompatible = DeltaProcessor.access$0(delta);
                    }
                }
            }
            CompatibleVisitor visitor = new CompatibleVisitor();
            delta.accept(visitor);
            return visitor.isCompatible;
        }
        return DeltaProcessor.isCompatible0(delta);
    }

    private static boolean isCompatible0(IDelta delta) {
        switch (delta.getElementType()) {
            case 3: {
                return DeltaProcessor.isApiProfileCompatible(delta);
            }
            case 2: {
                return DeltaProcessor.isApiComponentCompatible(delta);
            }
            case 8: {
                return DeltaProcessor.isInterfaceCompatible(delta);
            }
            case 1: {
                return DeltaProcessor.isAnnotationCompatible(delta);
            }
            case 9: {
                return DeltaProcessor.isMethodCompatible(delta);
            }
            case 5: {
                return DeltaProcessor.isConstructorCompatible(delta);
            }
            case 7: {
                return DeltaProcessor.isFieldCompatible(delta);
            }
            case 4: {
                return DeltaProcessor.isClassCompatible(delta);
            }
            case 6: {
                return DeltaProcessor.isEnumCompatible(delta);
            }
            case 10: {
                return DeltaProcessor.isTypeParameterCompatible(delta);
            }
        }
        return true;
    }

    private static boolean isApiProfileCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 3: {
                switch (delta.getFlags()) {
                    case 3: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isApiComponentCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 3: {
                switch (delta.getFlags()) {
                    case 46: 
                    case 56: 
                    case 70: 
                    case 71: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isAnnotationCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                switch (delta.getFlags()) {
                    case 16: 
                    case 28: 
                    case 49: {
                        return false;
                    }
                }
                break;
            }
            case 3: {
                switch (delta.getFlags()) {
                    case 16: 
                    case 27: 
                    case 28: 
                    case 48: 
                    case 49: 
                    case 61: 
                    case 65: 
                    case 66: {
                        return false;
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 10: 
                    case 41: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isMethodCompatible(IDelta delta) {
        int restrictions = delta.getRestrictions();
        if (RestrictionModifiers.isReferenceRestriction(restrictions)) {
            return true;
        }
        switch (delta.getKind()) {
            case 3: {
                switch (delta.getFlags()) {
                    case 2: 
                    case 49: {
                        return !Util.isVisible(delta.getOldModifiers());
                    }
                }
                break;
            }
            case 1: {
                switch (delta.getFlags()) {
                    case 37: 
                    case 49: {
                        return !Util.isVisible(delta.getNewModifiers());
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 30: 
                    case 33: 
                    case 38: 
                    case 55: {
                        return !Util.isVisible(delta.getNewModifiers());
                    }
                    case 11: {
                        return !Util.isVisible(delta.getOldModifiers()) || RestrictionModifiers.isExtendRestriction(restrictions);
                    }
                    case 31: {
                        return !Util.isVisible(delta.getOldModifiers()) || !Util.isVisible(delta.getNewModifiers()) || RestrictionModifiers.isExtendRestriction(restrictions) || RestrictionModifiers.isOverrideRestriction(restrictions);
                    }
                }
            }
        }
        return true;
    }

    private static boolean isFieldCompatible(IDelta delta) {
        int restrictions = delta.getRestrictions();
        if (RestrictionModifiers.isReferenceRestriction(restrictions)) {
            return true;
        }
        int newModifiers = delta.getNewModifiers();
        int oldModifiers = delta.getOldModifiers();
        switch (delta.getKind()) {
            case 3: {
                switch (delta.getFlags()) {
                    case 54: {
                        if (Flags.isProtected((int)oldModifiers)) {
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions());
                        }
                        return !Flags.isPublic((int)oldModifiers);
                    }
                    case 47: 
                    case 68: {
                        return !Util.isVisible(oldModifiers);
                    }
                }
                break;
            }
            case 2: {
                if (!Util.isVisible(oldModifiers)) {
                    return true;
                }
                switch (delta.getFlags()) {
                    case 46: {
                        if (Flags.isProtected((int)newModifiers)) {
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions());
                        }
                        return !Util.isVisible(newModifiers);
                    }
                    case 31: 
                    case 33: 
                    case 38: 
                    case 68: {
                        return !Util.isVisible(newModifiers);
                    }
                    case 20: 
                    case 54: {
                        if (Flags.isProtected((int)newModifiers)) {
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions());
                        }
                        return !Flags.isPublic((int)newModifiers);
                    }
                    case 11: {
                        return RestrictionModifiers.isExtendRestriction(delta.getRestrictions());
                    }
                }
                break;
            }
            case 1: {
                switch (delta.getFlags()) {
                    case 68: {
                        return !Util.isVisible(newModifiers);
                    }
                }
            }
        }
        return true;
    }

    private static boolean isConstructorCompatible(IDelta delta) {
        int restrictions = delta.getRestrictions();
        if (RestrictionModifiers.isReferenceRestriction(restrictions)) {
            return true;
        }
        switch (delta.getKind()) {
            case 3: {
                switch (delta.getFlags()) {
                    case 49: {
                        return !Util.isVisible(delta.getOldModifiers());
                    }
                }
                break;
            }
            case 1: {
                switch (delta.getFlags()) {
                    case 49: {
                        return !Util.isVisible(delta.getNewModifiers());
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 30: 
                    case 33: 
                    case 38: 
                    case 55: {
                        return !Util.isVisible(delta.getNewModifiers());
                    }
                    case 11: {
                        return RestrictionModifiers.isExtendRestriction(restrictions);
                    }
                }
            }
        }
        return true;
    }

    private static boolean isEnumCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                switch (delta.getFlags()) {
                    case 16: 
                    case 25: {
                        return !Util.isVisible(delta.getNewModifiers());
                    }
                }
                break;
            }
            case 3: {
                switch (delta.getFlags()) {
                    case 8: 
                    case 12: 
                    case 16: 
                    case 25: 
                    case 48: {
                        return !Util.isVisible(delta.getOldModifiers());
                    }
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: {
                        return false;
                    }
                }
                break;
            }
            case 2: {
                if (!Util.isVisible(delta.getNewModifiers())) {
                    return true;
                }
                switch (delta.getFlags()) {
                    case 10: 
                    case 30: 
                    case 41: {
                        return false;
                    }
                    case 11: {
                        return !Util.isVisible(delta.getOldModifiers());
                    }
                }
            }
        }
        return true;
    }

    private static boolean isClassCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                int newModifiers = delta.getNewModifiers();
                switch (delta.getFlags()) {
                    case 16: {
                        return true;
                    }
                    case 25: {
                        if (Util.isVisible(newModifiers) && Flags.isAbstract((int)newModifiers)) {
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions());
                        }
                        return true;
                    }
                    case 37: 
                    case 49: {
                        return !Util.isVisible(newModifiers);
                    }
                }
                break;
            }
            case 3: {
                switch (delta.getFlags()) {
                    case 16: 
                    case 25: 
                    case 48: 
                    case 61: 
                    case 62: {
                        if (Flags.isPublic((int)delta.getOldModifiers())) {
                            return false;
                        }
                        if (Flags.isProtected((int)delta.getOldModifiers())) {
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions());
                        }
                        return true;
                    }
                    case 8: 
                    case 63: {
                        if (Util.isVisible(delta.getOldModifiers())) {
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions()) && (Flags.isProtected((int)delta.getOldModifiers()) || RestrictionModifiers.isInstantiateRestriction(delta.getRestrictions()));
                        }
                        return true;
                    }
                    case 39: 
                    case 49: {
                        return !Util.isVisible(delta.getOldModifiers());
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 30: {
                        if (Util.isVisible(delta.getNewModifiers())) {
                            return RestrictionModifiers.isInstantiateRestriction(delta.getRestrictions());
                        }
                        return true;
                    }
                    case 10: 
                    case 33: 
                    case 38: 
                    case 41: {
                        return !Util.isVisible(delta.getNewModifiers());
                    }
                    case 31: {
                        if (Util.isVisible(delta.getNewModifiers())) {
                            return RestrictionModifiers.isExtendRestriction(delta.getRestrictions());
                        }
                        return true;
                    }
                    case 11: {
                        return RestrictionModifiers.isExtendRestriction(delta.getRestrictions());
                    }
                }
            }
        }
        return true;
    }

    private static boolean isTypeParameterCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 23: {
                        return false;
                    }
                }
                break;
            }
            case 3: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 23: {
                        return false;
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 6: 
                    case 23: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isInterfaceCompatible(IDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                switch (delta.getFlags()) {
                    case 16: {
                        return RestrictionModifiers.isImplementRestriction(delta.getRestrictions());
                    }
                    case 25: 
                    case 69: {
                        return RestrictionModifiers.isImplementRestriction(delta.getRestrictions());
                    }
                    case 49: {
                        return false;
                    }
                    case 37: {
                        return false;
                    }
                }
                break;
            }
            case 3: {
                switch (delta.getFlags()) {
                    case 16: 
                    case 25: 
                    case 48: 
                    case 49: 
                    case 61: 
                    case 62: {
                        return false;
                    }
                }
                break;
            }
            case 2: {
                switch (delta.getFlags()) {
                    case 10: 
                    case 41: {
                        return false;
                    }
                    case 11: {
                        return RestrictionModifiers.isExtendRestriction(delta.getRestrictions());
                    }
                }
            }
        }
        return true;
    }

    static /* synthetic */ boolean access$0(IDelta iDelta) {
        return DeltaProcessor.isCompatible0(iDelta);
    }
}

