/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;

public class TypeScope
extends ApiElement
implements IApiTypeContainer {
    private IApiComponent fComponent;
    private Map fPackageToTypes;

    public TypeScope(IApiComponent component, IReferenceTypeDescriptor[] types) {
        super(component, 3, null);
        this.fComponent = component;
        this.fPackageToTypes = new HashMap();
        int i = 0;
        while (i < types.length) {
            IReferenceTypeDescriptor type = types[i];
            String name = type.getPackage().getName();
            HashSet<IReferenceTypeDescriptor> set = (HashSet<IReferenceTypeDescriptor>)this.fPackageToTypes.get(name);
            if (set == null) {
                set = new HashSet<IReferenceTypeDescriptor>();
                this.fPackageToTypes.put(name, set);
            }
            set.add(type);
            ++i;
        }
    }

    public String[] getPackageNames() throws CoreException {
        Set pkgs = this.fPackageToTypes.keySet();
        Object[] result = new String[pkgs.size()];
        pkgs.toArray(result);
        Arrays.sort(result);
        return result;
    }

    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this.fComponent)) {
            Set entrySet = this.fPackageToTypes.entrySet();
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String pkg = (String)entry.getKey();
                if (visitor.visitPackage(pkg)) {
                    Set types = (Set)entry.getValue();
                    Iterator typeIter = types.iterator();
                    while (typeIter.hasNext()) {
                        IReferenceTypeDescriptor type = (IReferenceTypeDescriptor)typeIter.next();
                        IApiTypeRoot classFile = this.fComponent.findTypeRoot(type.getQualifiedName());
                        if (classFile == null) continue;
                        visitor.visit(pkg, classFile);
                        visitor.end(pkg, classFile);
                    }
                }
                visitor.endVisitPackage(pkg);
            }
        }
        visitor.end(this.fComponent);
    }

    public void close() throws CoreException {
    }

    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        IReferenceTypeDescriptor descriptor = Factory.typeDescriptor(qualifiedName);
        Set types = (Set)this.fPackageToTypes.get(descriptor.getPackage().getName());
        if (types != null && types.contains(descriptor)) {
            return this.fComponent.findTypeRoot(qualifiedName);
        }
        return null;
    }

    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        if (this.fComponent.getId().equals(id)) {
            return this.findTypeRoot(qualifiedName);
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("*** Type Search Scope ***\n");
        buffer.append("Component: ").append(this.fComponent);
        if (this.fPackageToTypes != null) {
            String pack = null;
            Iterator iter = this.fPackageToTypes.keySet().iterator();
            while (iter.hasNext()) {
                pack = (String)iter.next();
                buffer.append("Package: ").append(pack).append("\n");
                buffer.append("Types: ").append(this.fPackageToTypes.get(pack).toString()).append("\n");
            }
        }
        return buffer.toString();
    }
}

