/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder;
import org.eclipse.pde.api.tools.internal.builder.BuildContext;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;

public class IncrementalApiBuilder {
    ApiAnalysisBuilder builder = null;
    BuildContext context = null;
    StringSet typenames = new StringSet(16);
    StringSet packages = new StringSet(16);

    public IncrementalApiBuilder(ApiAnalysisBuilder builder) {
        this.builder = builder;
    }

    public void build(IApiBaseline baseline, IApiBaseline wbaseline, IResourceDelta[] deltas, State state, BuildState buildstate, IProgressMonitor monitor) throws CoreException {
        IProject project = this.builder.getProject();
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)BuilderMessages.IncrementalBuilder_builder_for_project, (Object)project.getName()), (int)1);
        this.context = new BuildContext();
        try {
            String[] projectNames = buildstate.getReexportedComponents();
            HashSet<IProject> depprojects = null;
            if (projectNames.length != 0) {
                depprojects = new HashSet<IProject>();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject pj = null;
                int i = 0;
                int max = projectNames.length;
                while (i < max) {
                    pj = root.getProject(projectNames[i]);
                    if (pj.isAccessible() && baseline != null && baseline.getApiComponent(projectNames[i]) == null) {
                        depprojects.add(pj);
                    }
                    ++i;
                }
            }
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(project, depprojects);
            int i = 0;
            while (i < deltas.length) {
                deltas[i].accept((IResourceDeltaVisitor)visitor);
                ++i;
            }
            this.build(project, baseline, wbaseline, state, buildstate, (IProgressMonitor)localmonitor.newChild(1));
        }
        finally {
            if (!localmonitor.isCanceled()) {
                localmonitor.done();
            }
            this.context.dispose();
            this.typenames.clear();
            this.packages.clear();
        }
    }

    void build(IProject project, IApiBaseline baseline, IApiBaseline wbaseline, State state, BuildState buildstate, IProgressMonitor monitor) throws CoreException {
        try {
            IPluginModelBase currentModel;
            SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.api_analysis_on_0, (int)6);
            this.collectAffectedSourceFiles(project, state);
            Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            localmonitor.subTask(NLS.bind((String)BuilderMessages.ApiAnalysisBuilder_finding_affected_source_files, (Object)project.getName()));
            Util.updateMonitor((IProgressMonitor)localmonitor, 0);
            if (this.context.hasTypes() && (currentModel = this.builder.getCurrentModel()) != null) {
                String id = currentModel.getBundleDescription().getSymbolicName();
                IApiComponent comp = wbaseline.getApiComponent(id);
                if (comp == null) {
                    return;
                }
                this.extClean(project, buildstate, (IProgressMonitor)localmonitor.newChild(1));
                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                this.builder.getAnalyzer().analyzeComponent(buildstate, null, null, baseline, comp, this.context, (IProgressMonitor)localmonitor.newChild(1));
                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
                this.builder.createMarkers();
                Util.updateMonitor((IProgressMonitor)localmonitor, 1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void addTypeToContext(IFile file) {
        String type = this.resolveTypeName((IResource)file);
        if (type == null) {
            return;
        }
        if (!this.context.containsChangedType(type)) {
            this.builder.cleanupMarkers((IResource)file);
            this.context.recordStructurallyChangedType(type);
            this.collectInnerTypes(file);
        }
    }

    private void addDependentTypeToContext(IFile file) {
        String type = this.resolveTypeName((IResource)file);
        if (type == null) {
            return;
        }
        if (!this.context.containsDependentType(type)) {
            this.builder.cleanupMarkers((IResource)file);
            this.context.recordDependentType(type);
            this.collectInnerTypes(file);
        }
    }

    private void collectInnerTypes(IFile file) {
        ICompilationUnit unit = (ICompilationUnit)JavaCore.create((IFile)file);
        IType[] types = null;
        try {
            types = unit.getAllTypes();
            String typename = null;
            int i = 0;
            while (i < types.length) {
                typename = types[i].getFullyQualifiedName('$');
                if (!this.context.containsChangedType(typename)) {
                    this.context.recordDependentType(typename);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    void collectAffectedSourceFiles(IProject project, State state) {
        char[][] internedSimpleNames;
        char[][][] internedQualifiedNames = ReferenceCollection.internQualifiedNames((StringSet)this.packages);
        if (internedQualifiedNames.length < this.packages.elementSize) {
            internedQualifiedNames = null;
        }
        if ((internedSimpleNames = ReferenceCollection.internSimpleNames((StringSet)this.typenames, (boolean)true)).length < this.typenames.elementSize) {
            internedSimpleNames = null;
        }
        Object[] keyTable = state.getReferences().keyTable;
        Object[] valueTable = state.getReferences().valueTable;
        IFile file = null;
        String typeLocator = null;
        int i = 0;
        while (i < valueTable.length) {
            ReferenceCollection refs;
            typeLocator = (String)keyTable[i];
            if (typeLocator != null && (refs = (ReferenceCollection)valueTable[i]).includes(internedQualifiedNames, internedSimpleNames, null) && (file = project.getFile(typeLocator)) != null) {
                if (ApiAnalysisBuilder.DEBUG) {
                    System.out.println("  adding affected source file " + file.getName());
                }
                this.addDependentTypeToContext(file);
            }
            ++i;
        }
    }

    void findAffectedSourceFiles(IResourceDelta binaryDelta) {
        IResource resource = binaryDelta.getResource();
        if (resource.getType() == 1) {
            String typename = this.resolveTypeName(resource);
            if (typename == null) {
                return;
            }
            switch (binaryDelta.getKind()) {
                case 2: {
                    if (ApiAnalysisBuilder.DEBUG) {
                        System.out.println("Found removed class file " + typename);
                    }
                    this.context.recordStructurallyChangedType(typename);
                    this.context.recordRemovedType(typename);
                }
                case 1: {
                    if (ApiAnalysisBuilder.DEBUG) {
                        System.out.println("Found added class file " + typename);
                    }
                    this.addDependentsOf(typename);
                    return;
                }
                case 4: {
                    if ((binaryDelta.getFlags() & 0x100) == 0) {
                        return;
                    }
                    if (ApiAnalysisBuilder.DEBUG) {
                        System.out.println("Found changed class file " + typename);
                    }
                    this.addDependentsOf(typename);
                }
            }
            return;
        }
    }

    void addDependentsOf(String typename) {
        int idx = typename.lastIndexOf(46);
        String packageName = idx < 0 ? "" : typename.substring(0, idx);
        String typeName = idx < 0 ? typename : typename.substring(idx + 1, typename.length());
        if ((idx = typeName.indexOf(36)) > 0) {
            typeName = typeName.substring(0, idx);
        }
        if (this.typenames.add(typeName) && this.packages.add(packageName) && ApiAnalysisBuilder.DEBUG) {
            System.out.println("  will look for dependents of " + typeName + " in " + packageName);
        }
    }

    void extClean(IProject project, BuildState state, IProgressMonitor monitor) throws CoreException {
        String[] types = this.context.getRemovedTypes();
        int i = 0;
        while (i < types.length) {
            state.cleanup(types[i]);
            ++i;
        }
        Util.updateMonitor(monitor, 0);
        IResource resource = project.findMember(ApiAnalysisBuilder.MANIFEST_PATH);
        if (resource != null) {
            try {
                IMarker[] markers = resource.findMarkers("org.eclipse.pde.api.tools.compatibility", false, 0);
                String tname = null;
                int i2 = 0;
                while (i2 < markers.length) {
                    tname = Util.getTypeNameFromMarker(markers[i2]);
                    if (this.context.containsDependentType(tname) || this.context.containsChangedType(tname)) {
                        markers[i2].delete();
                    }
                    ++i2;
                }
                Util.updateMonitor(monitor, 0);
                markers = resource.findMarkers("org.eclipse.pde.api.tools.unused_filters", false, 0);
                i2 = 0;
                while (i2 < markers.length) {
                    tname = Util.getTypeNameFromMarker(markers[i2]);
                    if (this.context.containsDependentType(tname) || this.context.containsChangedType(tname)) {
                        markers[i2].delete();
                    }
                    ++i2;
                }
                Util.updateMonitor(monitor, 0);
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    String resolveTypeName(IResource resource) {
        IPath typepath = resource.getFullPath();
        HashSet paths = null;
        if (Util.isClassFile(resource.getName())) {
            paths = (HashSet)this.builder.output_locs.get(resource.getProject());
        } else if (Util.isJavaFileName(resource.getName())) {
            paths = (HashSet)this.builder.src_locs.get(resource.getProject());
        }
        if (paths != null) {
            IPath path = null;
            Iterator iterator = paths.iterator();
            while (iterator.hasNext()) {
                path = (IPath)iterator.next();
                if (!path.isPrefixOf(typepath)) continue;
                typepath = typepath.removeFirstSegments(path.segmentCount()).removeFileExtension();
                return typepath.toString().replace('/', '.');
            }
        }
        return null;
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        HashSet projects = null;
        IProject project = null;

        public ResourceDeltaVisitor(IProject project, HashSet projects) {
            this.project = project;
            this.projects = projects;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            switch (delta.getResource().getType()) {
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
                case 1: {
                    IResource resource = delta.getResource();
                    String fileName = resource.getName();
                    if (Util.isClassFile(fileName)) {
                        IncrementalApiBuilder.this.findAffectedSourceFiles(delta);
                        break;
                    }
                    if (!Util.isJavaFileName(fileName)) break;
                    IProject project = resource.getProject();
                    if (this.project.equals((Object)project)) {
                        IncrementalApiBuilder.this.addTypeToContext((IFile)resource);
                        break;
                    }
                    if (this.projects == null || !this.projects.contains(project)) break;
                    IncrementalApiBuilder.this.addTypeToContext((IFile)resource);
                }
            }
            return false;
        }
    }
}

