/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.builder.AbstractProblemDetector;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.util.Signatures;

public abstract class AbstractLeakProblemDetector
extends AbstractProblemDetector {
    private Set fNonApiPackageNames;

    public AbstractLeakProblemDetector(Set nonApiPackageNames) {
        this.fNonApiPackageNames = nonApiPackageNames;
    }

    protected boolean isNonAPIReference(IReference reference) {
        String packageName = Signatures.getPackageName(reference.getReferencedTypeName());
        if (this.fNonApiPackageNames.contains(packageName)) {
            return true;
        }
        IApiMember member = reference.getMember();
        IApiType type = null;
        type = member.getType() == 2 ? (IApiType)member : (IApiType)member.getAncestor(2);
        String origin = Signatures.getPackageName(type.getName());
        return packageName.equals(origin);
    }

    protected boolean isEnclosingTypeVisible(IApiMember member) throws CoreException {
        IApiType type = null;
        type = member.getType() == 2 ? (IApiType)member : member.getEnclosingType();
        while (type != null) {
            if ((5 & type.getModifiers()) == 0) {
                return false;
            }
            type = type.getEnclosingType();
        }
        return true;
    }
}

