/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.SelectionBorder;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.birt.report.designer.ui.util.PixelConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GeneralConfigurationBlock
extends OptionsConfigurationBlock {
    private final OptionsConfigurationBlock.Key PREF_ENABLE_GRADIENT = this.getReportKey("designer.general.preference.selection.enable.gradient.preferencestore");
    private final OptionsConfigurationBlock.Key PREF_ENABLE_ANIMATION = this.getReportKey("designer.general.preference.selection.enable.animation.preferencestore");
    private final OptionsConfigurationBlock.Key PREF_LIABRARY_WARNING = this.getReportKey("designer.library.preference.libraries.warning.preferencestore");
    private static final String ENABLED = "true";
    private static final String DISABLED = "false";
    private PixelConverter fPixelConverter;
    private Button ckGradient;

    public GeneralConfigurationBlock(IStatusChangeListener context, IProject project) {
        super(context, ReportPlugin.getDefault(), project);
        this.setKeys(this.getKeys());
    }

    private OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{this.PREF_ENABLE_GRADIENT, this.PREF_ENABLE_ANIMATION, this.PREF_LIABRARY_WARNING};
        return keys;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite othersComposite = this.createBuildPathTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        othersComposite.setLayoutData((Object)gridData);
        return mainComp;
    }

    private Composite createBuildPathTabContent(Composite parent) {
        Label description = new Label(parent, 0);
        description.setText(Messages.getString((String)"GeneralConfigurationBlock.message.general.description"));
        Composite pageContent = new Composite(parent, 0);
        GridData data = new GridData(1810);
        data.grabExcessHorizontalSpace = true;
        pageContent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        pageContent.setLayout((Layout)layout);
        String[] enableDisableValues = new String[]{ENABLED, DISABLED};
        this.ckGradient = this.addCheckBox(pageContent, Messages.getString((String)"GeneralConfigurationBlock.button.text.enable.gradient"), this.PREF_ENABLE_GRADIENT, enableDisableValues, 0);
        this.addCheckBox(pageContent, Messages.getString((String)"GeneralConfigurationBlock.button.text.enable.animation"), this.PREF_ENABLE_ANIMATION, enableDisableValues, 0);
        this.validateSettings(this.PREF_ENABLE_ANIMATION, null, this.getValue(this.PREF_ENABLE_ANIMATION));
        String[] promptValues = new String[]{"prompt", "never"};
        Group group = new Group(pageContent, 0);
        group.setText(Messages.getString((String)"GeneralConfigurationBlock.group.label"));
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout());
        this.addCheckBox((Composite)group, Messages.getString((String)"GeneralConfigurationBlock.button.text.prompt"), this.PREF_LIABRARY_WARNING, promptValues, 0);
        return pageContent;
    }

    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        super.validateSettings(changedKey, oldValue, newValue);
        if (changedKey == this.PREF_ENABLE_ANIMATION) {
            if (ENABLED.equals(newValue)) {
                this.setValue(this.PREF_ENABLE_GRADIENT, ENABLED);
                this.ckGradient.setSelection(true);
                this.ckGradient.setEnabled(false);
            } else {
                this.ckGradient.setEnabled(true);
            }
        }
    }

    public boolean performApply() {
        boolean rt = super.performApply();
        if (rt) {
            SelectionBorder.enableGradient(ENABLED.equals(this.getValue(this.PREF_ENABLE_GRADIENT)));
            SelectionBorder.enableAnimation(ENABLED.equals(this.getValue(this.PREF_ENABLE_ANIMATION)));
        }
        return rt;
    }

    public void performDefaults() {
        super.performDefaults();
        this.validateSettings(this.PREF_ENABLE_ANIMATION, null, this.getValue(this.PREF_ENABLE_ANIMATION));
    }
}

