/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class SelectValueDialog
extends BaseDialog {
    private boolean multipleSelection = false;
    private TableViewer tableViewer = null;
    private Table table = null;
    private int sortDir = 128;
    private int[] selectedIndices = null;
    private Object[] selectedItems = null;
    private List<Object> modelValueList = new ArrayList<Object>();
    private ParamBindingHandle[] bindingParams = null;
    private final String nullValueDispaly = Messages.getString((String)"SelectValueDialog.SelectValue.NullValue");

    public SelectValueDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public ParamBindingHandle[] getBindingParams() {
        return this.bindingParams;
    }

    public void setBindingParams(ParamBindingHandle[] handles) {
        this.bindingParams = handles;
    }

    public void setSelectedValueList(Collection valueList) {
        this.modelValueList.clear();
        this.modelValueList.addAll(valueList);
    }

    public boolean isMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(composite, (this.isMultipleSelection() ? 2 : 4) | 0x200 | 0x100 | 0x10000);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 0);
        column.setText(Messages.getString((String)"SelectValueDialog.selectValue"));
        column.setWidth(data.widthHint);
        TableItem item = new TableItem(this.table, 0);
        item.setText(0, Messages.getString((String)"SelectValueDialog.retrieving"));
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectValueDialog.this.sortDir = SelectValueDialog.this.sortDir == 128 ? 1024 : 128;
                SelectValueDialog.this.table.setSortDirection(SelectValueDialog.this.sortDir);
                SelectValueDialog.this.tableViewer.setSorter((ViewerSorter)new TableSorter(SelectValueDialog.this.sortDir));
                SelectValueDialog.this.table.setSelection(SelectValueDialog.this.table.getSelectionIndices());
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (SelectValueDialog.this.table.getSelectionCount() > 0) {
                    SelectValueDialog.this.okPressed();
                }
            }
        });
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SelectValueDialog.this.populateList();
            }
        });
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.SelectValueDialog_ID");
        return composite;
    }

    protected void okPressed() {
        this.selectedItems = new Object[this.table.getSelectionCount()];
        int i = 0;
        while (i < this.table.getSelectionCount()) {
            this.selectedItems[i] = this.table.getSelection()[i].getData();
            ++i;
        }
        this.selectedIndices = this.table.getSelectionIndices();
        this.setResult(this.table.getSelection());
        super.okPressed();
    }

    private void populateList() {
        try {
            if (this.getShell() == null || this.getShell().isDisposed()) {
                return;
            }
            if (this.getOkButton() != null && !this.getOkButton().isDisposed()) {
                this.getOkButton().setEnabled(false);
            }
            this.table.removeAll();
            this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
            if (this.modelValueList != null) {
                this.tableViewer.setInput(this.modelValueList);
            } else {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"SelectValueDialog.errorRetrievinglist"), Messages.getString((String)"SelectValueDialog.noExpressionSet"));
            }
            if (this.table.getItemCount() > 0) {
                if (this.getOkButton() != null && !this.getOkButton().isDisposed()) {
                    this.getOkButton().setEnabled(true);
                }
                int i = 0;
                while (i < this.table.getItemCount()) {
                    this.table.getItem(i).setData(this.modelValueList.get(i));
                    ++i;
                }
                this.table.setSortColumn(this.table.getColumn(0));
                this.table.setSortDirection(this.sortDir);
                this.tableViewer.setSorter((ViewerSorter)new TableSorter(this.sortDir));
                this.table.setSelection(0);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public String getSelectedExprValue() {
        String exprValue = null;
        if (this.selectedIndices != null && this.selectedIndices.length > 0) {
            Object modelValue = this.selectedItems[0];
            if (modelValue == null) {
                return "null";
            }
            exprValue = modelValue instanceof Boolean || modelValue instanceof Integer || modelValue instanceof Double ? modelValue.toString() : (modelValue instanceof BigDecimal ? "new java.math.BigDecimal(\"" + modelValue.toString() + "\")" : "\"" + JavascriptEvalUtil.transformToJsConstants((String)modelValue.toString()) + "\"");
        }
        return exprValue;
    }

    public String[] getSelectedExprValues() {
        String[] exprValues = null;
        if (this.selectedIndices != null && this.selectedIndices.length > 0) {
            exprValues = new String[this.selectedIndices.length];
            int i = 0;
            while (i < this.selectedIndices.length) {
                Object modelValue = this.selectedItems[i];
                exprValues[i] = modelValue == null ? "null" : (modelValue instanceof Boolean || modelValue instanceof Integer || modelValue instanceof Double ? modelValue.toString() : (modelValue instanceof BigDecimal ? "new java.math.BigDecimal(\"" + modelValue.toString() + "\")" : "\"" + JavascriptEvalUtil.transformToJsConstants((String)modelValue.toString()) + "\""));
                ++i;
            }
        }
        return exprValues;
    }

    public String getSelectedExprValue(IExpressionConverter convert) {
        String exprValue = null;
        if (this.selectedIndices != null && this.selectedIndices.length > 0) {
            Object modelValue = this.selectedItems[0];
            String dataType = null;
            if (modelValue != null) {
                dataType = DataSetUIUtil.toModelDataType(DataTypeUtil.toApiDataType(modelValue.getClass()));
                String viewerValue = modelValue.toString();
                if (convert != null) {
                    exprValue = convert.getConstantExpression(viewerValue, dataType);
                }
            }
        }
        return exprValue;
    }

    public String[] getSelectedExprValues(IExpressionConverter convert) {
        String[] exprValues = null;
        if (this.selectedIndices != null && this.selectedIndices.length > 0) {
            exprValues = new String[this.selectedIndices.length];
            int i = 0;
            while (i < this.selectedIndices.length) {
                Object modelValue = this.selectedItems[i];
                String dataType = null;
                if (modelValue != null) {
                    dataType = DataSetUIUtil.toModelDataType(DataTypeUtil.toApiDataType(modelValue.getClass()));
                    String viewerValue = modelValue.toString();
                    if (convert != null) {
                        exprValues[i] = convert.getConstantExpression(viewerValue, dataType);
                    }
                }
                ++i;
            }
        }
        return exprValues;
    }

    public class ContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            DateFormatter formatter = new DateFormatter(ULocale.US);
            if (columnIndex == 0) {
                if (element != null) {
                    if (element instanceof Date) {
                        formatter.applyPattern("yyyy-MM-dd");
                        return formatter.format((java.util.Date)element);
                    }
                    if (element instanceof Time) {
                        formatter.applyPattern("HH:mm:ss.SSS");
                        return formatter.format((java.util.Date)element);
                    }
                    if (element instanceof java.util.Date) {
                        formatter.applyPattern("yyyy-MM-dd HH:mm:ss.SSS");
                        return formatter.format((java.util.Date)element);
                    }
                    return element.toString();
                }
                return SelectValueDialog.this.nullValueDispaly;
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    public class TableSorter
    extends ViewerSorter {
        private int sortDir;

        private TableSorter(int sortDir) {
            this.sortDir = sortDir;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this.sortDir == 128) {
                if (e1 instanceof Integer) {
                    return ((Integer)e1).compareTo((Integer)e2);
                }
                if (e1 instanceof Double) {
                    return ((Double)e1).compareTo((Double)e2);
                }
                if (e1 instanceof BigDecimal) {
                    return ((BigDecimal)e1).compareTo((BigDecimal)e2);
                }
                return e1.toString().compareTo(e2.toString());
            }
            if (this.sortDir == 1024) {
                if (e2 instanceof Integer) {
                    return ((Integer)e2).compareTo((Integer)e1);
                }
                if (e2 instanceof Double) {
                    return ((Double)e2).compareTo((Double)e1);
                }
                if (e2 instanceof BigDecimal) {
                    return ((BigDecimal)e2).compareTo((BigDecimal)e1);
                }
                return e2.toString().compareTo(e1.toString());
            }
            return 0;
        }
    }
}

