/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.util.SelectValueFetcher;
import org.eclipse.birt.report.designer.internal.ui.dialogs.PreviewLabel;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionEditor;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.extension.IUseCubeQueryList;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseTitleAreaDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.HighlightHandleProvider;
import org.eclipse.birt.report.designer.ui.widget.ColorBuilder;
import org.eclipse.birt.report.designer.ui.widget.FontSizeBuilder;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class HighlightRuleBuilder
extends BaseTitleAreaDialog {
    public static final int EXPRESSION_CONTROL_COMBO = 0;
    public static final int EXPRESSION_CONTROL_TEXT = 1;
    protected static final Logger logger = Logger.getLogger(HighlightRuleBuilder.class.getName());
    protected static final String[] EMPTY_ARRAY = new String[0];
    protected static final String VALUE_OF_THIS_DATA_ITEM = Messages.getString((String)"HighlightRuleBuilderDialog.choice.ValueOfThisDataItem");
    private static final String DEFAULT_CHOICE = Messages.getString((String)"HighlightRuleBuilderDialog.text.Default");
    private static final String[] SYSTEM_FONT_LIST = DEUtil.getSystemFontNames();
    private static final String NONE_DISPLAY_TEXT = Messages.getString((String)"HighlightRuleBuilderDialog.displayText.None");
    private static final String CHOICE_SELECT_VALUE = Messages.getString((String)"ExpressionValueCellEditor.selectValueAction");
    private final String NULL_STRING;
    protected ExpressionProvider expressionProvider;
    protected String bindingName = null;
    protected ReportElementHandle currentItem = null;
    protected ParamBindingHandle[] bindingParams = null;
    private int exprControlType;
    protected String dlgDescription = "";
    protected String dlgTitle = "";
    protected List<ComputedColumnHandle> columnList;
    protected List<Expression> valueList = new ArrayList<Expression>();
    public static final String[][] OPERATOR;
    private HighlightRuleHandle handle;
    private HighlightHandleProvider provider;
    private int handleCount;
    protected Combo expressionCombo;
    protected Combo stylesChooser;
    protected Text expressionText;
    private Combo operator;
    protected Composite valueListComposite;
    protected Combo addExpressionValue;
    protected Button addBtn;
    protected Button editBtn;
    protected Button delBtn;
    protected Button delAllBtn;
    protected Table table;
    protected TableViewer tableViewer;
    protected int valueVisible;
    protected List<Control> compositeList = new ArrayList<Control>();
    private Combo expressionValue1;
    private Combo expressionValue2;
    private Label andLabel;
    protected Composite dummy1;
    protected Composite dummy2;
    private Combo font;
    private FontSizeBuilder size;
    private ColorBuilder color;
    private ColorBuilder backColor;
    private Button bold;
    private Button italic;
    private Button underline;
    private Button linethrough;
    private PreviewLabel previewLabel;
    protected DesignElementHandle designHandle;
    private boolean isBoldChanged;
    private boolean isItalicChanged;
    private boolean isUnderlineChanged;
    private boolean isLinethroughChanged;
    private Map<String, StyleHandle> styles = new HashMap<String, StyleHandle>();
    protected SelectionListener expSelListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)HighlightRuleBuilder.this.expressionCombo);
            if (converter != null) {
                if (HighlightRuleBuilder.this.getExpression().equals(VALUE_OF_THIS_DATA_ITEM) && HighlightRuleBuilder.this.designHandle instanceof DataItemHandle) {
                    if (HighlightRuleBuilder.this.designHandle.getContainer() instanceof ExtendedItemHandle) {
                        HighlightRuleBuilder.this.setExpression(ExpressionUtility.getDataExpression(((DataItemHandle)HighlightRuleBuilder.this.designHandle).getResultSetColumn(), converter));
                    } else {
                        HighlightRuleBuilder.this.setExpression(ExpressionUtility.getColumnExpression(((DataItemHandle)HighlightRuleBuilder.this.designHandle).getResultSetColumn(), converter));
                    }
                } else {
                    String newValue = HighlightRuleBuilder.this.getExpression();
                    String value = ExpressionUtility.getExpression(HighlightRuleBuilder.this.getResultSetColumn(newValue), converter);
                    if (value != null) {
                        newValue = value;
                    }
                    HighlightRuleBuilder.this.setExpression(newValue);
                }
            }
            HighlightRuleBuilder.this.updateButtons();
        }
    };
    protected ITableLabelProvider tableLableProvier = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof Expression) {
                    return ((Expression)element).getStringExpression();
                }
                return element.toString();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    protected IStructuredContentProvider tableContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }
    };
    private Group condition;

    static {
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet("HighlightRule", "operator");
        IChoice[] chs = chset.getChoices((Comparator)new AlphabeticallyComparator());
        OPERATOR = new String[chs.length][2];
        int i = 0;
        while (i < chs.length) {
            HighlightRuleBuilder.OPERATOR[i][0] = chs[i].getDisplayName();
            HighlightRuleBuilder.OPERATOR[i][1] = chs[i].getName();
            ++i;
        }
    }

    public static String getValueForOperator(String name) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][0].equals(name)) {
                return OPERATOR[i][1];
            }
            ++i;
        }
        return null;
    }

    public static int determineValueVisible(String operatorValue) {
        if ("any".equals(operatorValue) || "is-false".equals(operatorValue) || "is-true".equals(operatorValue) || "is-null".equals(operatorValue) || "is-not-null".equals(operatorValue)) {
            return 0;
        }
        if ("lt".equals(operatorValue) || "le".equals(operatorValue) || "eq".equals(operatorValue) || "ne".equals(operatorValue) || "ge".equals(operatorValue) || "gt".equals(operatorValue) || "like".equals(operatorValue)) {
            return 1;
        }
        if ("between".equals(operatorValue) || "not-between".equals(operatorValue)) {
            return 2;
        }
        if ("in".equals(operatorValue) || "not-in".equals(operatorValue)) {
            return 3;
        }
        return 1;
    }

    public static String getNameForOperator(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return OPERATOR[i][0];
            }
            ++i;
        }
        return "";
    }

    public static int getIndexForOperatorValue(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public HighlightRuleBuilder(Shell parentShell, String title, HighlightHandleProvider provider) {
        super(parentShell);
        this.NULL_STRING = null;
        this.dlgTitle = title;
        this.provider = provider;
    }

    private String[] getDataSetColumns() {
        if (this.columnList.isEmpty()) {
            return EMPTY_ARRAY;
        }
        String[] values = new String[this.columnList.size()];
        int i = 0;
        while (i < this.columnList.size()) {
            values[i] = this.columnList.get(i).getName();
            ++i;
        }
        return values;
    }

    public void setReportElement(ReportElementHandle reportItem) {
        this.currentItem = reportItem;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(composite, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        this.condition = new Group(contents, 0);
        GridData gdata = new GridData(768);
        this.condition.setLayoutData((Object)gdata);
        GridLayout glayout = GridLayoutFactory.createFrom((GridLayout)new GridLayout()).spacing(5, 0).numColumns(5).equalWidth(false).create();
        this.condition.setLayout((Layout)glayout);
        this.condition.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Group.Condition"));
        gdata = new GridData();
        gdata.widthHint = 150;
        if (this.exprControlType == 0) {
            this.expressionCombo = new Combo((Composite)this.condition, 0);
            this.expressionCombo.setLayoutData((Object)gdata);
            this.expressionCombo.setVisibleItemCount(30);
            this.expressionCombo.setItems(this.getDataSetColumns());
            this.fillExpression(this.expressionCombo);
            this.expressionCombo.addSelectionListener(this.expSelListener);
            this.expressionCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    HighlightRuleBuilder.this.updateButtons();
                }
            });
        } else {
            this.expressionText = new Text((Composite)this.condition, 2048);
            this.expressionText.setLayoutData((Object)gdata);
            if (this.handle != null) {
                this.expressionText.setText(this.handle.getTestExpression());
            }
            this.expressionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    HighlightRuleBuilder.this.updateButtons();
                }
            });
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                HighlightRuleBuilder.this.updateButtons();
            }
        };
        ExpressionButtonUtil.createExpressionButton((Composite)this.condition, this.getExpressionControl(), (IExpressionProvider)this.getExpressionProvider(), (Object)this.designHandle, listener);
        this.operator = new Combo((Composite)this.condition, 8);
        int i = 0;
        while (i < OPERATOR.length) {
            this.operator.add(OPERATOR[i][0]);
            ++i;
        }
        this.operator.setVisibleItemCount(30);
        this.create2ValueComposite((Composite)this.condition);
        this.operator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.operatorChange();
            }
        });
        this.createApplyStyleArea(contents);
        Label lb = new Label(contents, 258);
        lb.setLayoutData((Object)new GridData(768));
        return composite;
    }

    protected ExpressionProvider getExpressionProvider() {
        if (this.expressionProvider == null) {
            this.expressionProvider = new ExpressionProvider(this.designHandle);
            this.expressionProvider.addFilter(new ExpressionFilter(){

                public boolean select(Object parentElement, Object element) {
                    return !"Category".equals(parentElement) || !ExpressionProvider.CURRENT_CUBE.equals(element);
                }
            });
        }
        return this.expressionProvider;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        parent.getShell().setText(this.dlgTitle);
        this.setTitle(Messages.getString((String)"HighlightRuleBuilderDialog.text.Title"));
        this.setMessage(this.dlgDescription);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.HighlightRuleBuilder_ID");
        if (this.handle != null) {
            this.syncViewProperties();
        }
        this.updatePreview();
        this.updateButtons();
        return composite;
    }

    protected Object getResultSetColumn(String name) {
        if (this.columnList.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.columnList.size()) {
            ComputedColumnHandle column = this.columnList.get(i);
            if (column.getName().equals(name)) {
                return column;
            }
            ++i;
        }
        return null;
    }

    private Composite createApplyStyleArea(Composite parent) {
        Group styleGroup = new Group(parent, 0);
        styleGroup.setLayoutData((Object)new GridData(768));
        styleGroup.setLayout((Layout)new GridLayout(5, false));
        styleGroup.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Group.Format"));
        Label lb = new Label((Composite)styleGroup, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.applyStyle"));
        lb.setLayoutData((Object)new GridData(128));
        this.stylesChooser = new Combo((Composite)styleGroup, 12);
        GridData gdata = new GridData();
        gdata.widthHint = 100;
        gdata.horizontalSpan = 2;
        this.stylesChooser.setLayoutData((Object)gdata);
        this.stylesChooser.setVisibleItemCount(30);
        this.fillStyles(this.stylesChooser);
        this.stylesChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.updateButtons();
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        this.createDummy((Composite)styleGroup, 3);
        lb = new Label((Composite)styleGroup, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 5;
        lb.setLayoutData((Object)gd);
        lb = new Label((Composite)styleGroup, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Font"));
        lb.setLayoutData((Object)new GridData(128));
        this.font = new Combo((Composite)styleGroup, 8);
        gdata = new GridData();
        gdata.widthHint = 100;
        this.font.setLayoutData((Object)gdata);
        this.font.setVisibleItemCount(30);
        IChoiceSet fontSet = ChoiceSetFactory.getElementChoiceSet("Style", "fontFamily");
        this.font.setData((Object)fontSet);
        this.font.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet(fontSet, (Comparator)new AlphabeticallyComparator()));
        if (SYSTEM_FONT_LIST != null && SYSTEM_FONT_LIST.length > 0) {
            int i = 0;
            while (i < SYSTEM_FONT_LIST.length) {
                this.font.add(SYSTEM_FONT_LIST[i]);
                ++i;
            }
        }
        this.font.add(DEFAULT_CHOICE, 0);
        this.font.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        if (this.font.getItemCount() > 0) {
            this.font.select(0);
        }
        this.createDummy((Composite)styleGroup, 1);
        lb = new Label((Composite)styleGroup, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Size"));
        lb.setLayoutData((Object)new GridData(128));
        this.size = new FontSizeBuilder((Composite)styleGroup, 0);
        if (this.designHandle != null) {
            this.size.setDefaultUnit(this.designHandle.getPropertyHandle("fontSize").getDefaultUnit());
        }
        gdata = new GridData();
        gdata.widthHint = 200;
        this.size.setLayoutData(gdata);
        this.size.setFontSizeValue(null);
        this.size.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        lb = new Label((Composite)styleGroup, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Color"));
        lb.setLayoutData((Object)new GridData(128));
        this.color = new ColorBuilder((Composite)styleGroup, 0);
        gdata = new GridData();
        gdata.widthHint = 100;
        this.color.setLayoutData(gdata);
        this.color.setChoiceSet(ChoiceSetFactory.getElementChoiceSet("Style", "color"));
        this.color.setRGB(null);
        this.color.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                HighlightRuleBuilder.this.previewLabel.setForeground(ColorManager.getColor((RGB)HighlightRuleBuilder.this.color.getRGB()));
                HighlightRuleBuilder.this.previewLabel.redraw();
            }
        });
        this.createDummy((Composite)styleGroup, 2);
        Composite fstyle = new Composite((Composite)styleGroup, 0);
        gdata = new GridData(768);
        fstyle.setLayoutData((Object)gdata);
        fstyle.setLayout((Layout)new GridLayout(4, false));
        this.bold = this.createToggleButton(fstyle);
        this.bold.setImage(ReportPlatformUIImages.getImage("fontWeight"));
        this.bold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.isBoldChanged = true;
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        this.bold.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.Bold"));
        this.italic = this.createToggleButton(fstyle);
        this.italic.setImage(ReportPlatformUIImages.getImage("fontStyle"));
        this.italic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.isItalicChanged = true;
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        this.italic.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.Italic"));
        this.underline = this.createToggleButton(fstyle);
        this.underline.setImage(ReportPlatformUIImages.getImage("textUnderline"));
        this.underline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.isUnderlineChanged = true;
                HighlightRuleBuilder.this.previewLabel.setUnderline(HighlightRuleBuilder.this.underline.getSelection());
                HighlightRuleBuilder.this.previewLabel.redraw();
            }
        });
        this.underline.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.Underline"));
        this.linethrough = this.createToggleButton(fstyle);
        this.linethrough.setImage(ReportPlatformUIImages.getImage("textLineThrough"));
        this.linethrough.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.isLinethroughChanged = true;
                HighlightRuleBuilder.this.previewLabel.setLinethrough(HighlightRuleBuilder.this.linethrough.getSelection());
                HighlightRuleBuilder.this.previewLabel.redraw();
            }
        });
        this.linethrough.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.Text_Line_Through"));
        lb = new Label((Composite)styleGroup, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.BackgroundColor"));
        lb.setLayoutData((Object)new GridData(128));
        this.backColor = new ColorBuilder((Composite)styleGroup, 0);
        gdata = new GridData();
        gdata.widthHint = 100;
        this.backColor.setLayoutData(gdata);
        this.backColor.setChoiceSet(ChoiceSetFactory.getElementChoiceSet("Style", "backgroundColor"));
        this.backColor.setRGB(null);
        this.backColor.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                HighlightRuleBuilder.this.previewLabel.setBackground(ColorManager.getColor((RGB)HighlightRuleBuilder.this.backColor.getRGB()));
                HighlightRuleBuilder.this.previewLabel.redraw();
            }
        });
        this.createDummy((Composite)styleGroup, 3);
        Composite preview = new Composite((Composite)styleGroup, 0);
        GridLayout glayout = new GridLayout();
        preview.setLayout((Layout)glayout);
        gdata = new GridData(1808);
        gdata.horizontalSpan = 5;
        preview.setLayoutData((Object)gdata);
        lb = new Label(preview, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Preview"));
        Composite previewPane = new Composite(preview, 2048);
        glayout = new GridLayout();
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        previewPane.setLayout((Layout)glayout);
        gdata = new GridData(1808);
        gdata.heightHint = 60;
        previewPane.setLayoutData((Object)gdata);
        this.previewLabel = new PreviewLabel(previewPane, 0);
        this.previewLabel.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.PreviewContent"));
        gdata = new GridData(1808);
        this.previewLabel.setLayoutData(gdata);
        this.updatePreview();
        return styleGroup;
    }

    private List getSelectValueList() throws BirtException {
        List selectValueList = new ArrayList();
        ReportItemHandle reportItem = DEUtil.getBindingHolder((DesignElementHandle)this.currentItem);
        if (this.bindingName != null && reportItem != null) {
            Object[] arrays;
            Object[] obj;
            if (reportItem instanceof ExtendedItemHandle && (obj = ElementAdapterManager.getAdapters(reportItem, IUseCubeQueryList.class)) instanceof Object[] && (arrays = obj).length == 1 && arrays[0] != null) {
                List valueList = ((IUseCubeQueryList)arrays[0]).getQueryList(this.getExpression(), (ExtendedItemHandle)reportItem);
                selectValueList.addAll(valueList);
            }
            if (selectValueList.size() == 0) {
                selectValueList = SelectValueFetcher.getSelectValueFromBinding(ExpressionButtonUtil.getExpression(this.getExpressionControl()), reportItem.getDataSet(), DEUtil.getVisiableColumnBindingsList((DesignElementHandle)this.designHandle).iterator(), false);
            }
        } else {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"SelectValueDialog.errorRetrievinglist"), Messages.getString((String)"SelectValueDialog.noExpressionSet"));
        }
        return selectValueList;
    }

    private Composite createDummy(Composite parent, int colSpan) {
        Composite dummy = new Composite(parent, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 22;
        gdata.horizontalSpan = colSpan;
        gdata.heightHint = 10;
        dummy.setLayoutData((Object)gdata);
        return dummy;
    }

    private Button createToggleButton(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        wrapper.setLayout((Layout)layout);
        Button btn = new Button(wrapper, 2);
        GridData gdata = new GridData();
        gdata.widthHint = 22;
        gdata.heightHint = 22;
        btn.setLayoutData((Object)gdata);
        return btn;
    }

    private void updatePreview() {
        if (this.stylesChooser.getText().equals(NONE_DISPLAY_TEXT)) {
            String familyValue = this.getFontFamily();
            int sizeValue = this.getFontSize();
            this.previewLabel.setFontFamily(familyValue);
            this.previewLabel.setFontSize(sizeValue);
            this.previewLabel.setBold(this.bold.getSelection());
            this.previewLabel.setItalic(this.italic.getSelection());
            this.previewLabel.setForeground(ColorManager.getColor((RGB)this.color.getRGB()));
            this.previewLabel.setBackground(ColorManager.getColor((RGB)this.backColor.getRGB()));
            this.previewLabel.setUnderline(this.underline.getSelection());
            this.previewLabel.setLinethrough(this.linethrough.getSelection());
            this.previewLabel.setOverline(false);
            this.previewLabel.updateView();
        } else {
            StyleHandle style = this.styles.get(this.stylesChooser.getText());
            String familyValue = DEUtil.removeQuote((String)style.getFontFamilyHandle().getStringValue());
            int sizeValue = DEUtil.getFontSize((String)style.getFontSize().getDisplayValue());
            this.previewLabel.setFontFamily(familyValue);
            this.previewLabel.setFontSize(sizeValue);
            this.previewLabel.setForeground(ColorManager.getColor((int)style.getColor().getRGB()));
            this.previewLabel.setBackground(ColorManager.getColor((int)style.getBackgroundColor().getRGB()));
            if (style.getFontWeight().equals("bold")) {
                this.previewLabel.setBold(true);
            } else {
                this.previewLabel.setBold(false);
            }
            if (style.getFontStyle().equals("italic")) {
                this.previewLabel.setItalic(true);
            } else {
                this.previewLabel.setItalic(false);
            }
            if (style.getTextUnderline().equals("underline")) {
                this.previewLabel.setUnderline(true);
            } else {
                this.previewLabel.setUnderline(false);
            }
            if (style.getTextLineThrough().equals("line-through")) {
                this.previewLabel.setLinethrough(true);
            } else {
                this.previewLabel.setLinethrough(false);
            }
            if (style.getTextOverline().equals("overline")) {
                this.previewLabel.setOverline(true);
            } else {
                this.previewLabel.setOverline(false);
            }
            this.previewLabel.updateView();
        }
    }

    public void updateHandle(HighlightRuleHandle handle, int handleCount) {
        this.handle = handle;
        this.handleCount = handleCount;
    }

    public void setDesignHandle(DesignElementHandle handle) {
        this.designHandle = handle;
        this.initializeProviderType();
        this.inilializeColumnList(handle);
        this.initializeParamterBinding(handle);
        this.initilizeDlgDescription(handle);
        this.exprControlType = this.getHighlightExpCtrType(this.designHandle);
    }

    protected void inilializeColumnList(DesignElementHandle handle) {
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)handle);
    }

    private void initializeParamterBinding(DesignElementHandle handle) {
        if (handle instanceof ReportItemHandle) {
            ReportItemHandle inputHandle = (ReportItemHandle)handle;
            ArrayList<ParamBindingHandle> list = new ArrayList<ParamBindingHandle>();
            Iterator iterator = inputHandle.paramBindingsIterator();
            while (iterator.hasNext()) {
                ParamBindingHandle paramBindingHandle = (ParamBindingHandle)iterator.next();
                list.add(paramBindingHandle);
            }
            this.bindingParams = new ParamBindingHandle[list.size()];
            list.toArray(this.bindingParams);
        }
    }

    public HighlightRuleHandle getHandle() {
        return this.handle;
    }

    private void fillStyles(Combo stylesChooser) {
        stylesChooser.removeAll();
        this.styles.clear();
        stylesChooser.add(NONE_DISPLAY_TEXT);
        Iterator iter = DEUtil.getStyles();
        while (iter.hasNext()) {
            StyleHandle styleHandle = (StyleHandle)iter.next();
            if (styleHandle.isPredefined()) continue;
            String styleName = styleHandle.getName();
            stylesChooser.add(styleName);
            this.styles.put(styleName, styleHandle);
        }
        if (this.handle != null && this.handle.getStyle() != null) {
            stylesChooser.setText(this.handle.getStyle().getName());
        } else {
            stylesChooser.setText(NONE_DISPLAY_TEXT);
        }
    }

    private void fillExpression(Combo control) {
        if (this.designHandle instanceof DataItemHandle && ((DataItemHandle)this.designHandle).getResultSetColumn() != null) {
            control.add(VALUE_OF_THIS_DATA_ITEM);
        }
        if (control.getItemCount() == 0) {
            control.add(DEUtil.resolveNull(null));
            control.select(control.getItemCount() - 1);
        }
    }

    protected void updateButtons() {
        this.enableInput(this.isExpressionOK());
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.isConditionOK());
        }
    }

    private void enableInput(boolean val) {
        boolean val2 = val;
        this.operator.setEnabled(val);
        if (this.valueVisible != 3) {
            if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
                this.expressionValue1.setEnabled(val);
            }
            if (this.expressionValue2 != null && !this.expressionValue2.isDisposed()) {
                this.expressionValue2.setEnabled(val);
            }
            if (this.andLabel != null && !this.andLabel.isDisposed()) {
                this.andLabel.setEnabled(val);
            }
        } else {
            this.setControlEnable((Control)this.valueListComposite, val);
            if (val) {
                this.checkAddButtonStatus();
                this.checkEditDelButtonStatus();
            }
        }
        if (this.stylesChooser != null && !this.stylesChooser.isDisposed()) {
            this.stylesChooser.setEnabled(val);
            if (!this.stylesChooser.getText().equals(NONE_DISPLAY_TEXT) || !this.stylesChooser.isEnabled()) {
                val2 = false;
            }
            this.font.setEnabled(val2);
            this.size.setEnabled(val2);
            this.color.setEnabled(val2);
            this.bold.setEnabled(val2);
            this.italic.setEnabled(val2);
            this.underline.setEnabled(val2);
            this.linethrough.setEnabled(val2);
            this.backColor.setEnabled(val2);
        }
    }

    private boolean isExpressionOK() {
        if (this.getExpressionControl() == null) {
            return false;
        }
        return this.getExpression() != null && this.getExpression().length() != 0;
    }

    private boolean isConditionOK() {
        if (this.getExpressionControl() == null) {
            return false;
        }
        if (!this.isExpressionOK()) {
            return false;
        }
        return this.checkValues();
    }

    private boolean checkValues() {
        if (this.valueVisible == 3) {
            return this.valueList.size() > 0;
        }
        if (this.expressionValue1.getVisible() && (this.expressionValue1.getText() == null || this.expressionValue1.getText().length() == 0)) {
            return false;
        }
        return !this.expressionValue2.getVisible() || this.expressionValue2.getText() != null && this.expressionValue2.getText().length() != 0;
    }

    private void removeLocalStyleProperties() {
        try {
            this.handle.getFontFamilyHandle().setStringValue(null);
            this.handle.getFontSize().setStringValue(null);
            this.handle.getColor().setValue(null);
            this.handle.getBackgroundColor().setValue(null);
            this.handle.setFontStyle(null);
            this.handle.setFontWeight(null);
            this.handle.setTextUnderline(null);
            this.handle.setTextLineThrough(null);
        }
        catch (Exception e) {
            ExceptionUtil.handle(e);
        }
    }

    private void syncViewProperties() {
        if (this.handle != null) {
            ExpressionButtonUtil.initExpressionButtonControl(this.getExpressionControl(), this.handle, "testExpr");
            this.operator.select(HighlightRuleBuilder.getIndexForOperatorValue(this.handle.getOperator()));
            String value = HighlightRuleBuilder.getValueForOperator(this.operator.getText());
            this.valueVisible = HighlightRuleBuilder.determineValueVisible(value);
            if (this.valueVisible == 3) {
                this.createValueListComposite(this.operator.getParent());
                if (this.handle != null) {
                    this.valueList = new ArrayList<Expression>();
                    if (this.handle.getValue1ExpressionList().getListValue() != null && this.handle.getValue1ExpressionList().getListValue().size() > 0) {
                        this.valueList.addAll(this.handle.getValue1ExpressionList().getListValue());
                    }
                }
                this.tableViewer.setInput(this.valueList);
            } else {
                this.create2ValueComposite(this.operator.getParent());
                if (this.handle != null && this.handle != null) {
                    if (this.handle.getValue1ExpressionList() != null && this.handle.getValue1ExpressionList().getListValue().size() > 0) {
                        ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionValue1, (Expression)this.handle.getValue1ExpressionList().getListValue().get(0));
                    }
                    ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionValue2, this.handle, "value2");
                }
            }
            if (this.valueVisible == 0) {
                this.expressionValue1.setVisible(false);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(false);
                this.expressionValue2.setVisible(false);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
                this.andLabel.setVisible(false);
            } else if (this.valueVisible == 1) {
                this.expressionValue1.setVisible(true);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(true);
                this.expressionValue2.setVisible(false);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
                this.andLabel.setVisible(false);
            } else if (this.valueVisible == 2) {
                this.expressionValue1.setVisible(true);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(true);
                this.expressionValue2.setVisible(true);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(true);
                this.andLabel.setVisible(true);
                this.andLabel.setEnabled(true);
            } else if (this.valueVisible == 3) {
                if (this.getExpression().length() == 0) {
                    this.valueListComposite.setEnabled(false);
                } else {
                    this.valueListComposite.setEnabled(true);
                }
            }
        }
        this.syncFamily();
        this.syncSize();
        if (this.handle != null && this.handle.getStyle() == null) {
            if (this.handle.getColor().isSet()) {
                this.color.setRGB(DEUtil.getRGBValue((int)this.handle.getColor().getRGB()));
            }
            if (this.handle.getBackgroundColor().isSet()) {
                this.backColor.setRGB(DEUtil.getRGBValue((int)this.handle.getBackgroundColor().getRGB()));
            }
            this.bold.setSelection("bold".equals(this.handle.getFontWeight()));
            this.italic.setSelection("italic".equals(this.handle.getFontStyle()));
            this.underline.setSelection("underline".equals(this.handle.getTextUnderline()));
            this.linethrough.setSelection("line-through".equals(this.handle.getTextLineThrough()));
        }
    }

    private void syncFamily() {
        String fm;
        if (this.handle != null && this.handle.getStyle() == null && this.innerSyncFamily(fm = DEUtil.removeQuote((String)this.handle.getFontFamilyHandle().getDisplayValue()))) {
            return;
        }
    }

    private boolean innerSyncFamily(String fm) {
        String[] items = this.font.getItems();
        int idx = this.getSelectionIndex(fm, items);
        if (idx >= 0) {
            this.font.select(idx);
            return true;
        }
        if (SYSTEM_FONT_LIST != null && SYSTEM_FONT_LIST.length > 0) {
            int i = 0;
            while (i < SYSTEM_FONT_LIST.length) {
                if (SYSTEM_FONT_LIST[i].equals(fm)) {
                    this.font.select(items.length + i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private int getSelectionIndex(String fm, String[] items) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equalsIgnoreCase(fm)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void syncSize() {
        if (this.handle != null && this.handle.getStyle() == null) {
            this.size.setFontSizeValue(this.handle.getFontSize().getStringValue());
        }
    }

    private String getFontFamily() {
        String rfm = this.getRawFontFamily();
        if (rfm == null) {
            rfm = this.designHandle != null ? (this.designHandle instanceof StyleHandle ? ((StyleHandle)this.designHandle).getFontFamilyHandle().getStringValue() : this.designHandle.getPrivateStyle().getFontFamilyHandle().getStringValue()) : "serif";
        }
        return HighlightHandleProvider.getFontFamily(rfm);
    }

    private String getRawFontFamily() {
        String ftName = this.font.getText();
        IChoiceSet cs = (IChoiceSet)this.font.getData();
        IChoice ci = cs.findChoiceByDisplayName(ftName);
        if (ci != null) {
            return ci.getName();
        }
        if (SYSTEM_FONT_LIST != null && SYSTEM_FONT_LIST.length > 0) {
            int i = 0;
            while (i < SYSTEM_FONT_LIST.length) {
                if (SYSTEM_FONT_LIST[i].equals(ftName)) {
                    return ftName;
                }
                ++i;
            }
        }
        return null;
    }

    private int getFontSize() {
        String rfs = this.getRawFontSize();
        if (rfs == null && this.designHandle != null) {
            rfs = this.designHandle instanceof StyleHandle ? ((StyleHandle)this.designHandle).getFontSize().getStringValue() : this.designHandle.getPrivateStyle().getFontSize().getStringValue();
        }
        return DEUtil.getFontSize((String)rfs);
    }

    private String getRawFontSize() {
        return this.size.getFontSizeValue();
    }

    protected void okPressed() {
        try {
            String lingthroughValue;
            String familyValue = this.getRawFontFamily();
            String sizeValue = this.getRawFontSize();
            int colorValue = DEUtil.getRGBInt((RGB)this.color.getRGB());
            int backColorValue = DEUtil.getRGBInt((RGB)this.backColor.getRGB());
            String italicValue = this.italic.getSelection() ? "italic" : "normal";
            String weightValue = this.bold.getSelection() ? "bold" : "normal";
            String underlineValue = this.underline.getSelection() ? "underline" : "none";
            String string = lingthroughValue = this.linethrough.getSelection() ? "line-through" : "none";
            if (this.handle == null) {
                HighlightRule rule = StructureFactory.createHighlightRule();
                rule.setProperty("operator", (Object)DEUtil.resolveNull((String)HighlightRuleBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible == 3) {
                    rule.setValue1(this.valueList);
                    rule.setValue2("");
                } else {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        ArrayList<Expression> valueList = new ArrayList<Expression>();
                        valueList.add(ExpressionButtonUtil.getExpression((Control)this.expressionValue1));
                        rule.setValue1(valueList);
                    } else {
                        rule.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionValue2, rule, "value2");
                    } else {
                        rule.setValue2(this.NULL_STRING);
                    }
                }
                ExpressionButtonUtil.saveExpressionButtonControl(this.getExpressionControl(), rule, "testExpr");
                if (!this.stylesChooser.getText().equals(NONE_DISPLAY_TEXT)) {
                    rule.setStyle(this.styles.get(this.stylesChooser.getText()));
                } else {
                    if (this.color.getRGB() != null) {
                        rule.setProperty("color", (Object)colorValue);
                    }
                    if (this.backColor.getRGB() != null) {
                        rule.setProperty("backgroundColor", (Object)backColorValue);
                    }
                    if (familyValue != null) {
                        rule.setProperty("fontFamily", (Object)familyValue);
                    }
                    if (sizeValue != null) {
                        rule.setProperty("fontSize", (Object)sizeValue);
                    }
                    if (this.isItalicChanged) {
                        rule.setProperty("fontStyle", (Object)italicValue);
                    }
                    if (this.isBoldChanged) {
                        rule.setProperty("fontWeight", (Object)weightValue);
                    }
                    if (this.isLinethroughChanged) {
                        rule.setProperty("textLineThrough", (Object)lingthroughValue);
                    }
                    if (this.isUnderlineChanged) {
                        rule.setProperty("textUnderline", (Object)underlineValue);
                    }
                }
                this.handle = this.provider.doAddItem(rule, this.handleCount);
            } else {
                ExpressionButtonUtil.saveExpressionButtonControl(this.getExpressionControl(), this.handle, "testExpr");
                this.handle.setOperator(DEUtil.resolveNull((String)HighlightRuleBuilder.getValueForOperator(this.operator.getText())));
                if (this.valueVisible != 3) {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        ArrayList<Expression> valueList = new ArrayList<Expression>();
                        valueList.add(ExpressionButtonUtil.getExpression((Control)this.expressionValue1));
                        this.handle.setValue1(valueList);
                    } else {
                        this.handle.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionValue2, this.handle, "value2");
                    } else {
                        this.handle.setValue2(this.NULL_STRING);
                    }
                } else {
                    this.handle.setValue1(this.valueList);
                    this.handle.setValue2("");
                }
                if (!this.stylesChooser.getText().equals(NONE_DISPLAY_TEXT)) {
                    if (this.handle.getStyle() == null) {
                        this.handle.setStyle(this.styles.get(this.stylesChooser.getText()));
                    } else if (!this.stylesChooser.getText().equals(this.handle.getStyle().getName())) {
                        this.handle.setStyle(this.styles.get(this.stylesChooser.getText()));
                    }
                    this.removeLocalStyleProperties();
                } else {
                    this.handle.setStyle(null);
                    this.handle.getFontFamilyHandle().setStringValue(DEUtil.resolveNull((String)familyValue));
                    this.handle.getFontSize().setStringValue(DEUtil.resolveNull((String)sizeValue));
                    if (this.color.getRGB() != null) {
                        this.handle.getColor().setRGB(colorValue);
                    } else {
                        this.handle.getColor().setValue(null);
                    }
                    if (this.backColor.getRGB() != null) {
                        this.handle.getBackgroundColor().setRGB(backColorValue);
                    } else {
                        this.handle.getBackgroundColor().setValue(null);
                    }
                    if (this.isItalicChanged) {
                        this.handle.setFontStyle(italicValue);
                    }
                    if (this.isBoldChanged) {
                        this.handle.setFontWeight(weightValue);
                    }
                    if (this.isUnderlineChanged) {
                        this.handle.setTextUnderline(underlineValue);
                    }
                    if (this.isLinethroughChanged) {
                        this.handle.setTextLineThrough(lingthroughValue);
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.handle(e);
        }
        super.okPressed();
    }

    private void initializeProviderType() {
        if (this.designHandle instanceof DataItemHandle) {
            DataItemHandle dataItem = (DataItemHandle)this.designHandle;
            if (dataItem.getContainer() instanceof ExtendedItemHandle) {
                this.provider.setExpressionType(1);
            } else {
                this.provider.setExpressionType(0);
            }
        }
    }

    private int create2ValueComposite(Composite condition) {
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            return 0;
        }
        if (this.valueListComposite != null && !this.valueListComposite.isDisposed()) {
            this.valueListComposite.dispose();
            this.valueListComposite = null;
        }
        GridData expgd = new GridData(768);
        expgd.widthHint = 120;
        this.expressionValue1 = this.createExpressionValue(condition);
        this.expressionValue1.add(CHOICE_SELECT_VALUE);
        this.expressionValue1.setLayoutData((Object)expgd);
        this.dummy1 = this.createDummy(condition, 3);
        this.andLabel = new Label(condition, 0);
        this.andLabel.setText(Messages.getString((String)"HightlightRuleBuilder.text.AND"));
        this.andLabel.setEnabled(false);
        this.dummy2 = this.createDummy(condition, 3);
        this.expressionValue2 = this.createExpressionValue(condition);
        this.expressionValue2.add(CHOICE_SELECT_VALUE);
        this.expressionValue2.setLayoutData((Object)expgd);
        if (this.operator.getItemCount() > 0 && this.operator.getSelectionIndex() == -1) {
            this.operator.setText(HighlightRuleBuilder.getNameForOperator("eq"));
            this.operatorChange();
        }
        condition.getParent().layout(true, true);
        if (this.getButtonBar() != null) {
            this.layout();
        }
        return 1;
    }

    private Combo createExpressionValue(Composite parent) {
        final Combo expressionValue = new Combo(parent, 2048);
        expressionValue.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String selection = e.text;
                if (expressionValue.indexOf(selection) == -1) {
                    e.doit = true;
                    return;
                }
                e.doit = !selection.equals(CHOICE_SELECT_VALUE);
            }
        });
        expressionValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value;
                if (expressionValue.getSelectionIndex() == -1) {
                    return;
                }
                String selection = expressionValue.getItem(expressionValue.getSelectionIndex());
                if (selection.equals(CHOICE_SELECT_VALUE) && (value = HighlightRuleBuilder.this.getSelectionValue(expressionValue)) != null) {
                    expressionValue.setText(value);
                }
            }
        });
        expressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HighlightRuleBuilder.this.updateButtons();
            }
        });
        this.createComplexExpressionButton(parent, expressionValue);
        return expressionValue;
    }

    private Combo createMultiExpressionValue(Composite parent) {
        final Combo expressionValue = new Combo(parent, 2048);
        expressionValue.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String selection = e.text;
                if (expressionValue.indexOf(selection) == -1) {
                    e.doit = true;
                    return;
                }
                e.doit = !selection.equals(CHOICE_SELECT_VALUE);
            }
        });
        expressionValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (expressionValue.getSelectionIndex() == -1) {
                    return;
                }
                String selection = expressionValue.getItem(expressionValue.getSelectionIndex());
                if (selection.equals(CHOICE_SELECT_VALUE)) {
                    HighlightRuleBuilder.this.selectMultiValues(expressionValue);
                }
            }
        });
        expressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HighlightRuleBuilder.this.updateButtons();
            }
        });
        this.createComplexExpressionButton(parent, expressionValue);
        return expressionValue;
    }

    private void createComplexExpressionButton(Composite parent, Combo combo) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                HighlightRuleBuilder.this.updateButtons();
            }
        };
        ExpressionButtonUtil.createExpressionButton(parent, (Control)combo, (IExpressionProvider)this.getExpressionProvider(), (Object)this.handle, listener);
    }

    private int createValueListComposite(Composite parent) {
        if (this.valueListComposite != null && !this.valueListComposite.isDisposed()) {
            return 0;
        }
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().dispose();
            this.expressionValue1.dispose();
            this.expressionValue1 = null;
            this.dummy1.dispose();
            this.dummy1 = null;
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().dispose();
            this.expressionValue2.dispose();
            this.expressionValue2 = null;
            this.dummy2.dispose();
            this.dummy2 = null;
            this.andLabel.dispose();
            this.andLabel = null;
        }
        this.valueListComposite = new Composite(parent, 0);
        GridData gdata = new GridData(1808);
        gdata.horizontalSpan = 4;
        this.valueListComposite.setLayoutData((Object)gdata);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.valueListComposite.setLayout((Layout)layout);
        Group group = new Group(this.valueListComposite, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 5;
        group.setLayout((Layout)layout);
        new Label((Composite)group, 0).setText(Messages.getString((String)"HightlightRuleBuilder.label.value"));
        GridData expgd = new GridData();
        expgd.widthHint = 100;
        this.addExpressionValue = this.createMultiExpressionValue((Composite)group);
        this.addExpressionValue.setLayoutData((Object)expgd);
        this.addExpressionValue.add(CHOICE_SELECT_VALUE);
        this.addBtn = new Button((Composite)group, 8);
        this.addBtn.setText(Messages.getString((String)"HightlightRuleBuilder.button.add"));
        this.addBtn.setToolTipText(Messages.getString((String)"HightlightRuleBuilder.button.add.tooltip"));
        this.setButtonLayoutData(this.addBtn);
        this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Expression value = ExpressionButtonUtil.getExpression((Control)HighlightRuleBuilder.this.addExpressionValue);
                if (HighlightRuleBuilder.this.valueList.indexOf(value) < 0) {
                    HighlightRuleBuilder.this.valueList.add(value);
                    HighlightRuleBuilder.this.tableViewer.refresh();
                    HighlightRuleBuilder.this.updateButtons();
                    HighlightRuleBuilder.this.addExpressionValue.setFocus();
                    HighlightRuleBuilder.this.addExpressionValue.setText("");
                } else {
                    HighlightRuleBuilder.this.addBtn.setEnabled(false);
                }
            }
        });
        new Label((Composite)group, 0);
        int tableStyle = 68356;
        this.table = new Table((Composite)group, tableStyle);
        data = new GridData(1808);
        data.horizontalSpan = 5;
        data.heightHint = 75;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(true);
        String[] columNames = new String[]{Messages.getString((String)"HightlightRuleBuilder.list.item1")};
        int[] columLength = new int[]{288};
        int i = 0;
        while (i < columNames.length) {
            TableColumn column = new TableColumn(this.table, 0, i);
            column.setText(columNames[i]);
            column.setWidth(columLength[i]);
            ++i;
        }
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.checkEditDelButtonStatus();
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    HighlightRuleBuilder.this.delTableValue();
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                HighlightRuleBuilder.this.editTableValue();
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columNames);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableLableProvier);
        this.tableViewer.setContentProvider((IContentProvider)this.tableContentProvider);
        Composite rightPart = new Composite(this.valueListComposite, 0);
        data = new GridData(128);
        rightPart.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        rightPart.setLayout((Layout)layout);
        this.editBtn = new Button(rightPart, 8);
        this.editBtn.setText(Messages.getString((String)"HightlightRuleBuilder.button.edit"));
        this.editBtn.setToolTipText(Messages.getString((String)"HightlightRuleBuilder.button.edit.tooltip"));
        this.setButtonLayoutData(this.editBtn);
        GridData gd = (GridData)this.editBtn.getLayoutData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 0x1000008;
        this.editBtn.setLayoutData((Object)gd);
        this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.editTableValue();
            }
        });
        this.delBtn = new Button(rightPart, 8);
        this.delBtn.setText(Messages.getString((String)"HightlightRuleBuilder.button.delete"));
        this.delBtn.setToolTipText(Messages.getString((String)"HightlightRuleBuilder.button.delete.tooltip"));
        this.setButtonLayoutData(this.delBtn);
        this.delBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.delTableValue();
            }
        });
        this.delAllBtn = new Button(rightPart, 8);
        this.delAllBtn.setText(Messages.getString((String)"HightlightRuleBuilder.button.deleteall"));
        this.delAllBtn.setToolTipText(Messages.getString((String)"HightlightRuleBuilder.button.deleteall.tooltip"));
        this.setButtonLayoutData(this.delAllBtn);
        gd = (GridData)this.delAllBtn.getLayoutData();
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 1;
        this.delAllBtn.setLayoutData((Object)gd);
        this.delAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int count = HighlightRuleBuilder.this.valueList.size();
                if (count > 0) {
                    HighlightRuleBuilder.this.valueList.clear();
                    HighlightRuleBuilder.this.tableViewer.refresh();
                    HighlightRuleBuilder.this.updateButtons();
                } else {
                    HighlightRuleBuilder.this.delAllBtn.setEnabled(false);
                }
            }
        });
        this.addExpressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HighlightRuleBuilder.this.checkAddButtonStatus();
                HighlightRuleBuilder.this.updateButtons();
            }
        });
        parent.getParent().layout(true, true);
        if (this.getButtonBar() != null) {
            this.layout();
        }
        return 1;
    }

    protected void checkEditDelButtonStatus() {
        StructuredSelection selection;
        boolean enabled;
        if (this.tableViewer == null) {
            return;
        }
        boolean bl = enabled = this.tableViewer.getSelection() != null;
        if (enabled && this.tableViewer.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)this.tableViewer.getSelection()).toList().size() <= 0) {
            enabled = false;
        }
        this.editBtn.setEnabled(enabled);
        this.delBtn.setEnabled(enabled);
        enabled = this.table.getItemCount() > 0;
        this.delAllBtn.setEnabled(enabled);
    }

    protected void checkAddButtonStatus() {
        if (this.addExpressionValue != null) {
            String value = this.addExpressionValue.getText();
            if (value == null || value.length() == 0 || value.trim().length() == 0) {
                this.addBtn.setEnabled(false);
                return;
            }
            if (value != null) {
                value = value.trim();
            }
            if (this.valueList.indexOf(ExpressionButtonUtil.getExpression((Control)this.addExpressionValue)) < 0) {
                this.addBtn.setEnabled(true);
            } else {
                this.addBtn.setEnabled(false);
            }
        }
    }

    protected void setControlEnable(Control control, boolean bool) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setEnabled(bool);
        Composite tmp = null;
        if (control instanceof Composite) {
            tmp = (Composite)control;
        }
        if (tmp != null && tmp.getChildren() != null) {
            int i = 0;
            while (i < tmp.getChildren().length) {
                this.setControlEnable(tmp.getChildren()[i], bool);
                ++i;
            }
        }
    }

    protected int getHighlightExpCtrType(DesignElementHandle handle) {
        int type = 0;
        HashSet<Class<GridHandle>> comboClassSet = new HashSet<Class<GridHandle>>();
        comboClassSet.add(TableHandle.class);
        comboClassSet.add(ListHandle.class);
        comboClassSet.add(GridHandle.class);
        Class<?> handleClass = handle.getClass();
        if (comboClassSet.contains(handleClass)) {
            type = 1;
        }
        return type;
    }

    protected void initilizeDlgDescription(DesignElementHandle handle) {
        Class[] classList = new Class[]{TableHandle.class, ListHandle.class, GridHandle.class, RowHandle.class, ColumnHandle.class, DataItemHandle.class, CellHandle.class};
        String[] desList = new String[]{Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.Table"), Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.List"), Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.Grid"), Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.Row"), Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.Column"), Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.DataItem"), Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.Cell")};
        Class<?> handleClass = handle.getClass();
        int i = 0;
        while (i < classList.length) {
            if (classList[i] == handleClass) {
                this.dlgDescription = desList[i];
                break;
            }
            ++i;
        }
        if (this.dlgDescription == null || this.dlgDescription.length() == 0) {
            this.dlgDescription = Messages.getString((String)"HighlightRuleBuilderDialog.text.Description.Element.ReportElement");
        }
        this.dlgDescription = Messages.getFormattedString((String)"HighlightRuleBuilderDialog.text.Description", (Object[])new Object[]{this.dlgDescription});
    }

    protected void setExpression(String exp) {
        if (this.exprControlType == 1 && this.expressionText != null) {
            this.expressionText.setText(exp);
        } else if (this.exprControlType == 0 && this.expressionCombo != null) {
            this.expressionCombo.setText(exp);
        }
    }

    protected String getExpression() {
        if (this.exprControlType == 1 && this.expressionText != null) {
            return this.expressionText.getText().trim();
        }
        if (this.exprControlType == 0 && this.expressionCombo != null) {
            return this.expressionCombo.getText().trim();
        }
        return "";
    }

    protected Control getExpressionControl() {
        if (this.exprControlType == 1 && this.expressionText != null) {
            return this.expressionText;
        }
        if (this.exprControlType == 0 && this.expressionCombo != null) {
            return this.expressionCombo;
        }
        return null;
    }

    protected void operatorChange() {
        if (this.operator.getSelectionIndex() == -1) {
            return;
        }
        this.valueVisible = HighlightRuleBuilder.determineValueVisible(DEUtil.resolveNull((String)HighlightRuleBuilder.getValueForOperator(this.operator.getText())));
        if (this.valueVisible == 3) {
            int ret = this.createValueListComposite(this.operator.getParent());
            if (ret != 0) {
                this.valueList = new ArrayList<Expression>();
                if (this.handle != null && this.handle.getValue1ExpressionList().getListValue() != null && this.handle.getValue1ExpressionList().getListValue().size() > 0) {
                    this.valueList.addAll(this.handle.getValue1ExpressionList().getListValue());
                }
                this.tableViewer.setInput(this.valueList);
            }
        } else {
            int ret = this.create2ValueComposite(this.operator.getParent());
            if (ret != 0 && this.handle != null) {
                if (this.handle.getValue1ExpressionList() != null && this.handle.getValue1ExpressionList().getListValue().size() > 0) {
                    ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionValue1, (Expression)this.handle.getValue1ExpressionList().getListValue().get(0));
                }
                ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionValue2, this.handle, "value2");
            }
        }
        if (this.valueVisible == 0) {
            this.expressionValue1.setVisible(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(false);
            this.expressionValue2.setVisible(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
            this.andLabel.setVisible(false);
        } else if (this.valueVisible == 1) {
            this.expressionValue1.setVisible(true);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(true);
            this.expressionValue2.setVisible(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
            this.andLabel.setVisible(false);
        } else if (this.valueVisible == 2) {
            this.expressionValue1.setVisible(true);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(true);
            this.expressionValue2.setVisible(true);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(true);
            this.andLabel.setVisible(true);
            this.andLabel.setEnabled(true);
        }
        this.updateButtons();
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        this.updateButtons();
        return super.open();
    }

    public void setExpressionProvider(ExpressionProvider expressionProvider) {
        this.expressionProvider = expressionProvider;
    }

    private void layout() {
        GridData gd = (GridData)this.condition.getLayoutData();
        Point size = this.condition.computeSize(-1, -1);
        if (gd.widthHint < size.x) {
            gd.widthHint = size.x;
        }
        if (gd.heightHint < size.y) {
            gd.heightHint = size.y;
        }
        this.condition.setLayoutData((Object)gd);
        this.condition.getShell().layout();
        if (this.getButtonBar() != null) {
            this.condition.getShell().pack();
        }
    }

    protected String getSelectionValue(Combo combo) {
        String retValue = null;
        this.bindingName = this.getExpressionBindingName();
        if (this.bindingName == null && this.getExpression().length() > 0) {
            this.bindingName = this.getExpression();
        }
        if (this.bindingName != null) {
            try {
                List selectValueList = this.getSelectValueList();
                SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                dialog.setSelectedValueList(selectValueList);
                if (this.bindingParams != null) {
                    dialog.setBindingParams(this.bindingParams);
                }
                if (dialog.open() == 0) {
                    IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)combo);
                    retValue = dialog.getSelectedExprValue(converter);
                }
            }
            catch (Exception ex) {
                MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
            }
        } else {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
        }
        return retValue;
    }

    private String getExpressionBindingName() {
        Iterator<ComputedColumnHandle> iter = this.columnList.iterator();
        while (iter.hasNext()) {
            String columnName = this.getColumnName(iter.next());
            if (this.designHandle instanceof DataItemHandle) {
                if (!(this.designHandle.getContainer() instanceof ExtendedItemHandle ? ExpressionUtility.getDataExpression(columnName, ExpressionUtility.getExpressionConverter(ExpressionButtonUtil.getExpression(this.getExpressionControl()).getType())).equals(this.getExpression()) : ExpressionUtility.getColumnExpression(columnName, ExpressionUtility.getExpressionConverter(ExpressionButtonUtil.getExpression(this.getExpressionControl()).getType())).equals(this.getExpression()))) continue;
                return columnName;
            }
            Expression expr = ExpressionButtonUtil.getExpression(this.getExpressionControl());
            if (expr == null) continue;
            String exprType = expr.getType();
            IExpressionConverter converter = ExpressionUtility.getExpressionConverter(exprType);
            if (!this.getExpression().equals(ExpressionUtility.getColumnExpression(columnName, converter))) continue;
            return columnName;
        }
        return null;
    }

    protected String getColumnName(Object obj) {
        if (obj instanceof DataSetViewData) {
            return ((DataSetViewData)obj).getName();
        }
        if (obj instanceof ComputedColumnHandle) {
            return ((ComputedColumnHandle)obj).getName();
        }
        if (obj instanceof ResultSetColumnHandle) {
            return ((ResultSetColumnHandle)obj).getColumnName();
        }
        return "";
    }

    protected void selectMultiValues(Combo combo) {
        String[] retValue = null;
        this.bindingName = this.getExpressionBindingName();
        if (this.bindingName == null && this.getExpression().length() > 0) {
            this.bindingName = this.getExpression();
        }
        if (this.bindingName != null) {
            try {
                List selectValueList = this.getSelectValueList();
                SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                dialog.setMultipleSelection(true);
                dialog.setSelectedValueList(selectValueList);
                if (this.bindingParams != null) {
                    dialog.setBindingParams(this.bindingParams);
                }
                if (dialog.open() == 0) {
                    retValue = dialog.getSelectedExprValues(ExpressionButtonUtil.getCurrentExpressionConverter((Control)combo));
                }
            }
            catch (Exception ex) {
                MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(String.valueOf(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable")) + "\n" + ex.getMessage()));
            }
        } else {
            MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
        }
        if (retValue != null) {
            this.addBtn.setEnabled(false);
            if (retValue.length == 1) {
                combo.setText(DEUtil.resolveNull((String)retValue[0]));
            } else if (retValue.length > 1) {
                combo.setText("");
            }
            boolean change = false;
            int i = 0;
            while (i < retValue.length) {
                Expression expression = new Expression((Object)retValue[i], ExpressionButtonUtil.getExpression((Control)combo).getType());
                if (this.valueList.indexOf(expression) < 0) {
                    this.valueList.add(expression);
                    change = true;
                }
                ++i;
            }
            if (change) {
                this.tableViewer.refresh();
                this.updateButtons();
                combo.setFocus();
            }
        }
    }

    protected void delTableValue() {
        int index = this.table.getSelectionIndex();
        if (index > -1) {
            this.valueList.remove(index);
            this.tableViewer.refresh();
            if (this.valueList.size() > 0) {
                if (this.valueList.size() <= index) {
                    --index;
                }
                this.table.select(index);
            }
            this.updateButtons();
        } else {
            this.delBtn.setEnabled(false);
        }
    }

    protected void editTableValue() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.getFirstElement() != null && selection.getFirstElement() instanceof Expression) {
            Expression initValue = (Expression)selection.getFirstElement();
            ExpressionEditor editor = new ExpressionEditor(Messages.getString((String)"ExpressionEditor.Title"));
            editor.setExpression(initValue);
            editor.setInput(this.handle, this.getExpressionProvider(), false);
            if (editor.open() == 0) {
                Expression result = editor.getExpression();
                if (result == null || result.getStringExpression() == null || result.getStringExpression().length() == 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString((String)"HightlightRuleBuilder.MsgDlg.Title"), (String)Messages.getString((String)"HightlightRuleBuilder.MsgDlg.Msg"));
                    return;
                }
                int index = this.table.getSelectionIndex();
                this.valueList.remove(index);
                this.valueList.add(index, result);
                this.tableViewer.refresh();
                this.table.select(index);
            }
            this.updateButtons();
        } else {
            this.editBtn.setEnabled(false);
        }
    }
}

