/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.preference.IPreferences;
import org.eclipse.birt.report.designer.core.CorePlugin;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.ReportClasspathResolver;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDService;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.SelectionBorder;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceFilter;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.ReportResourceSynchronizer;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.IReportClasspathResolver;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportPlugin
extends AbstractUIPlugin {
    public static final String DEFAULT_UNIT_AUTO = "Auto";
    protected static final Logger logger = Logger.getLogger(ReportPlugin.class.getName());
    public static final String LTR_BIDI_DIRECTION = "report.designer.ui.preferences.bidiproperties.ltrdirection";
    public static final String DEFAULT_UNIT_PREFERENCE = "report.designer.ui.preferences.default.unit";
    public static final String DEFAULT_SCRIPT_TYPE = "report.designer.ui.preferences.default.scripttype";
    private List<String> ignore = new ArrayList<String>();
    public static final String REPORT_UI = "org.eclipse.birt.report.designer.ui";
    private static ReportPlugin plugin;
    private BundleContext bundleContext;
    private ServiceRegistration syncService;
    private ServiceRegistration reportClasspathService;
    private Cursor cellLeftCursor;
    private Cursor cellRightCursor;
    public static final String NATURE_ID = "org.eclipse.birt.report.designer.ui.reportprojectnature";
    public static final String PREFERENCE_DELIMITER = ";";
    public static final String SPACE = " ";
    public static final String ENABLE_GRADIENT_SELECTION_PREFERENCE = "designer.general.preference.selection.enable.gradient.preferencestore";
    public static final String ENABLE_ANIMATION_SELECTION_PREFERENCE = "designer.general.preference.selection.enable.animation.preferencestore";
    public static final String DEFAULT_NAME_PREFERENCE = "designer.preview.preference.elementname.defaultname.preferencestore";
    public static final String CUSTOM_NAME_PREFERENCE = "designer.preview.preference.elementname.customname.preferencestore";
    public static final String DESCRIPTION_PREFERENCE = "designer.preview.preference.elementname.description.preferencestore";
    public static final String LIBRARY_PREFERENCE = "designer.library.preference.libraries.description.preferencestore";
    public static final String LIBRARY_WARNING_PREFERENCE = "designer.library.preference.libraries.warning.preferencestore";
    public static final String TEMPLATE_PREFERENCE = "designer.preview.preference.template.description.preferencestore";
    public static final String RESOURCE_PREFERENCE = "org.eclipse.birt.report.designer.ui.preferences.resourcestore";
    public static final String CLASSPATH_PREFERENCE = "org.eclipse.birt.report.designer.ui.preferences.classpath";
    public static final String COMMENT_PREFERENCE = "org.eclipse.birt.report.designer.ui.preference.comment.description.preferencestore";
    public static final String ENABLE_COMMENT_PREFERENCE = "org.eclipse.birt.report.designer.ui.preference.enable.comment.description.preferencestore";
    public static final String BIRT_RESOURCE = "resources";
    private static final List<String> elementToFilter;
    private List<String> reportExtensionNames;
    private static LinkedHashMap<String, ResourceFilter> filterMap;

    static {
        elementToFilter = Arrays.asList("AutoText", "DataSet", "DataSource", "ExtendedItem", "FreeForm", "GraphicMasterPage", "JointDataSet", "Line", "MasterPage", "OdaDataSet", "OdaDataSource", "Rectangle", "ReportItem", "ScriptDataSet", "ScriptDataSource", "DataMartDataSet", "DataMartDataSource", "SimpleDataSet", "TemplateDataSet", "TemplateElement", "TemplateParameterDefinition", "Parameter", "AbstractScalarParameter", "OdaHierarchy", "TabularHierarchy", "Dimension", "OdaCube", "TabularLevel", "Hierarchy", "TabularMeasureGroup", "OdaDimension", "MeasureGroup", "Measure", "TabularCube", "Cube", "OdaMeasure", "OdaLevel", "OdaMeasureGroup", "TabularMeasure", "Level", "TabularDimension", "DynamicFilterParameter", "DerivedDataSet");
        filterMap = new LinkedHashMap();
    }

    public ReportPlugin() {
        plugin = this;
    }

    public IReportResourceSynchronizer getResourceSynchronizerService() {
        ServiceReference serviceRef;
        if (this.bundleContext != null && (serviceRef = this.bundleContext.getServiceReference(IReportResourceSynchronizer.class.getName())) != null) {
            return (IReportResourceSynchronizer)this.bundleContext.getService(serviceRef);
        }
        return null;
    }

    public IReportClasspathResolver getReportClasspathResolverService() {
        ServiceReference serviceRef;
        if (this.bundleContext != null && (serviceRef = this.bundleContext.getServiceReference(IReportClasspathResolver.class.getName())) != null) {
            return (IReportClasspathResolver)this.bundleContext.getService(serviceRef);
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.bundleContext = context;
        PreferenceFactory.getInstance().getPreferences(this).setDefault("Dock location", 130);
        PreferenceFactory.getInstance().getPreferences(this).setDefault("Palette state", 2);
        this.initCellCursor();
        this.setDefaultBiDiSettings();
        this.setDefaultUnitSettings();
        this.setDefaultScriptType();
        this.setDefaultElementNamePreference(PreferenceFactory.getInstance().getPreferences(this));
        this.setDefaultLibraryPreference();
        this.setDefaultTemplatePreference();
        this.setDefaultResourcePreference();
        this.setDefaultClassPathPreference();
        this.setDefaultCommentPreference();
        this.setDefaultEnableCommentPreference();
        PlatformUI.getWorkbench().getContextSupport().setKeyFilterEnabled(true);
        this.syncService = context.registerService(IReportResourceSynchronizer.class.getName(), (Object)new ReportResourceSynchronizer(), null);
        this.reportClasspathService = context.registerService(IReportClasspathResolver.class.getName(), (Object)new ReportClasspathResolver(), null);
        this.addIgnoreViewID("org.eclipse.birt.report.designer.ui.editors.ReportEditor");
        this.addIgnoreViewID("org.eclipse.birt.report.designer.ui.editors.TemplateEditor");
        this.addIgnoreViewID("org.eclipse.ui.views.ContentOutline");
        this.addIgnoreViewID("org.eclipse.gef.ui.palette_view");
        this.setDefaultSelectionPreference();
        SelectionBorder.enableGradient(this.getEnableGradientSelectionPreference());
        SelectionBorder.enableAnimation(this.getEnableAnimatedSelectionPreference());
        CorePlugin.RESOURCE_FOLDER = this.getResourcePreference();
        SessionHandleAdapter.getInstance().getSessionHandle();
        SessionHandle.setBirtResourcePath((String)this.getResourcePreference());
        SessionHandleAdapter.getInstance().getSessionHandle().setResourceFolder(this.getResourcePreference());
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)DNDService.getInstance());
    }

    public static String getVersion() {
        return (String)ReportPlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
    }

    public static String getBuildInfo() {
        return ReportPlugin.getResourceString("Build");
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = Platform.getResourceBundle((Bundle)ReportPlugin.getDefault().getBundle());
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    private void initCellCursor() {
        ImageData source = ReportPlugin.getImageDescriptor("icons/point/cellcursor.bmp").getImageData();
        ImageData mask = ReportPlugin.getImageDescriptor("icons/point/cellcursormask.bmp").getImageData();
        this.cellLeftCursor = new Cursor(null, source, mask, 16, 16);
        source = ReportPlugin.getImageDescriptor("icons/point/cellrightcursor.bmp").getImageData();
        mask = ReportPlugin.getImageDescriptor("icons/point/cellrightcursormask.bmp").getImageData();
        this.cellRightCursor = new Cursor(null, source, mask, 16, 16);
    }

    public Cursor getLeftCellCursor() {
        return this.cellLeftCursor;
    }

    public Cursor getRightCellCursor() {
        return this.cellRightCursor;
    }

    public void stop(BundleContext context) throws Exception {
        this.bundleContext = null;
        if (this.syncService != null) {
            this.syncService.unregister();
            this.syncService = null;
        }
        if (this.reportClasspathService != null) {
            this.reportClasspathService.unregister();
            this.reportClasspathService = null;
        }
        this.ignore.clear();
        if (this.cellLeftCursor != null) {
            this.cellLeftCursor.dispose();
        }
        if (this.cellRightCursor != null) {
            this.cellRightCursor.dispose();
        }
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)DNDService.getInstance());
        BaseBorder.cleanWidthCache();
        FormWidgetFactory.close();
        super.stop(context);
    }

    public static ReportPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageRegistry imageRegistry = ReportPlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(key);
        if (imageDescriptor == null) {
            URL url = ReportPlugin.getDefault().find((IPath)new Path(key));
            if (url != null) {
                imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            }
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            imageRegistry.put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static Image getImage(String key) {
        ImageRegistry imageRegistry = ReportPlugin.getDefault().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            URL url = ReportPlugin.getDefault().find((IPath)new Path(key));
            if (url == null) {
                try {
                    url = new URL("file:///" + key);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (url != null) {
                image = ImageDescriptor.createFromURL((URL)url).createImage();
            }
            if (image == null) {
                image = ImageDescriptor.getMissingImageDescriptor().createImage();
            }
            imageRegistry.put(key, image);
        }
        return image;
    }

    public static boolean readCheatSheetPreference() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            String property = workspace.getRoot().getPersistentProperty(new QualifiedName("org.eclipse.birt.property", "showCheatSheet"));
            if (property != null) {
                return Boolean.valueOf(property);
            }
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return true;
    }

    public static void writeCheatSheetPreference(boolean value) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            workspace.getRoot().setPersistentProperty(new QualifiedName("org.eclipse.birt.property", "showCheatSheet"), String.valueOf(value));
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private void setDefaultElementNamePreference(IPreferences store) {
        List tmpList = DEUtil.getMetaDataDictionary().getElements();
        List tmpList2 = DEUtil.getMetaDataDictionary().getExtensions();
        tmpList.addAll(tmpList2);
        List<IElementDefn> invExtElements = UIUtil.getInvisibleExtensionElements();
        StringBuffer bufferDefaultName = new StringBuffer();
        StringBuffer bufferCustomName = new StringBuffer();
        StringBuffer bufferPreference = new StringBuffer();
        int i = 0;
        while (i < tmpList.size()) {
            IElementDefn elementDefn = (IElementDefn)tmpList.get(i);
            int nameOption = elementDefn.getNameOption();
            if (nameOption != 0 && !elementToFilter.contains(elementDefn.getName()) && !invExtElements.contains(elementDefn)) {
                bufferDefaultName.append(elementDefn.getName());
                bufferDefaultName.append(PREFERENCE_DELIMITER);
                bufferCustomName.append("");
                bufferCustomName.append(PREFERENCE_DELIMITER);
                this.appendDefaultPreference(elementDefn.getName(), bufferPreference);
            }
            ++i;
        }
        store.setDefault(DEFAULT_NAME_PREFERENCE, bufferDefaultName.toString());
        store.setDefault(CUSTOM_NAME_PREFERENCE, bufferCustomName.toString());
        store.setDefault(DESCRIPTION_PREFERENCE, bufferPreference.toString());
        ReportPlugin.initFilterMap(store, ResourceFilter.generateCVSFilter());
        ReportPlugin.initFilterMap(store, ResourceFilter.generateDataResourceFilter());
        ReportPlugin.initFilterMap(store, ResourceFilter.generateDotResourceFilter());
        ReportPlugin.initFilterMap(store, ResourceFilter.generateEmptyFolderFilter());
    }

    private void appendDefaultPreference(String defaultName, StringBuffer preference) {
        if (defaultName.equals("Data")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.dataReportItem"));
        } else if (defaultName.equals("Grid")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.gridReportItem"));
        } else if (defaultName.equals("Image")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.imageReportItem"));
        } else if (defaultName.equals("Label")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.labelReportItem"));
        } else if (defaultName.equals("List")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.listReportItem"));
        } else if (defaultName.equals("Table")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.tableReportItem"));
        } else if (defaultName.equals("Text")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.textReportItem"));
        } else if (defaultName.equals("TextData")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.textDataReportItem"));
        } else {
            preference.append(this.getExtendedPaletteEntryDescription(defaultName));
        }
        preference.append(PREFERENCE_DELIMITER);
    }

    public String[] getDefaultDefaultNamePreference() {
        return ReportPlugin.convert(PreferenceFactory.getInstance().getPreferences(this).getDefaultString(DEFAULT_NAME_PREFERENCE));
    }

    public String[] getDefaultCustomNamePreference() {
        return ReportPlugin.convert(PreferenceFactory.getInstance().getPreferences(this).getDefaultString(CUSTOM_NAME_PREFERENCE));
    }

    public String[] getDefaultDescriptionPreference() {
        return ReportPlugin.convert(PreferenceFactory.getInstance().getPreferences(this).getDefaultString(DESCRIPTION_PREFERENCE));
    }

    public String[] getDefaultNamePreference() {
        return ReportPlugin.convert(PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).getString(DEFAULT_NAME_PREFERENCE));
    }

    public String[] getCustomNamePreference() {
        return ReportPlugin.convert(PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).getString(CUSTOM_NAME_PREFERENCE));
    }

    public String[] getDescriptionPreference() {
        return ReportPlugin.convert(PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).getString(DESCRIPTION_PREFERENCE));
    }

    public String getCustomName(String defaultName) {
        String[] customNameArray;
        String[] defaultNameArray = this.getDefaultNamePreference();
        if (defaultNameArray.length != (customNameArray = this.getCustomNamePreference()).length) {
            return null;
        }
        int i = 0;
        while (i < defaultNameArray.length) {
            if (defaultNameArray[i].trim().equals(defaultName)) {
                if (customNameArray[i].equals("")) {
                    return null;
                }
                return customNameArray[i];
            }
            ++i;
        }
        return null;
    }

    public static String[] convert(String preferenceValue) {
        String preferenceValueCopy = PREFERENCE_DELIMITER + preferenceValue;
        String replaceString = ";;";
        String regrex = "; ;";
        while (preferenceValueCopy.indexOf(replaceString) != -1) {
            preferenceValueCopy = preferenceValueCopy.replaceFirst(replaceString, regrex);
        }
        StringTokenizer tokenizer = new StringTokenizer(preferenceValueCopy, PREFERENCE_DELIMITER);
        int tokenCount = tokenizer.countTokens();
        String[] elements = new String[tokenCount];
        int i = 0;
        while (i < tokenCount) {
            elements[i] = tokenizer.nextToken().trim();
            ++i;
        }
        return elements;
    }

    public String convertStrArray2Str(String[] elements) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            buffer.append(elements[i]);
            buffer.append(PREFERENCE_DELIMITER);
            ++i;
        }
        return buffer.toString();
    }

    public void setDefaultNamePreference(String[] elements) {
        PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).setValue(DEFAULT_NAME_PREFERENCE, this.convertStrArray2Str(elements));
    }

    public void setDefaultNamePreference(String element) {
        PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).setValue(DEFAULT_NAME_PREFERENCE, element);
    }

    public void setCustomNamePreference(String[] elements) {
        PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).setValue(CUSTOM_NAME_PREFERENCE, this.convertStrArray2Str(elements));
    }

    public void setCustomNamePreference(String element) {
        PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).setValue(CUSTOM_NAME_PREFERENCE, element);
    }

    public void setDescriptionPreference(String[] elements) {
        PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).setValue(DESCRIPTION_PREFERENCE, this.convertStrArray2Str(elements));
    }

    public void setDescriptionPreference(String element) {
        PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).setValue(DESCRIPTION_PREFERENCE, element);
    }

    public void setLibraryPreference(String[] elements) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            buffer.append(elements[i]);
            buffer.append(PREFERENCE_DELIMITER);
            ++i;
        }
        PreferenceFactory.getInstance().getPreferences(this).setValue(LIBRARY_PREFERENCE, buffer.toString());
    }

    public String[] getLibraryPreference() {
        return ReportPlugin.convert(PreferenceFactory.getInstance().getPreferences(this).getString(LIBRARY_PREFERENCE));
    }

    public void setDefaultLibraryPreference() {
        PreferenceFactory.getInstance().getPreferences(this).setDefault(LIBRARY_PREFERENCE, "");
        PreferenceFactory.getInstance().getPreferences(this).setDefault(LIBRARY_WARNING_PREFERENCE, "prompt");
    }

    public String[] getDefaultLibraryPreference() {
        return ReportPlugin.convert(PreferenceFactory.getInstance().getPreferences(this).getDefaultString(LIBRARY_PREFERENCE));
    }

    public String getDefaultTemplatePreference() {
        return PreferenceFactory.getInstance().getPreferences(this).getDefaultString(TEMPLATE_PREFERENCE);
    }

    public void setDefaultTemplatePreference() {
        String defaultRootDir = UIUtil.getFragmentDirectory();
        File templateFolder = new File(defaultRootDir, "/custom-templates/");
        PreferenceFactory.getInstance().getPreferences(this).setDefault(TEMPLATE_PREFERENCE, templateFolder.getAbsolutePath());
    }

    public String getTemplatePreference() {
        return PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).getString(TEMPLATE_PREFERENCE);
    }

    public void setTemplatePreference(String preference) {
        PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).setValue(TEMPLATE_PREFERENCE, preference);
    }

    public void setDefaultResourcePreference() {
        PreferenceFactory.getInstance().getPreferences(this).setDefault(RESOURCE_PREFERENCE, "");
    }

    public String getDefaultResourcePreference() {
        return PreferenceFactory.getInstance().getPreferences(this).getDefaultString(RESOURCE_PREFERENCE);
    }

    public void setDefaultClassPathPreference() {
        PreferenceFactory.getInstance().getPreferences(this).setDefault(CLASSPATH_PREFERENCE, "");
    }

    public String getResourcePreference() {
        return PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).getString(RESOURCE_PREFERENCE);
    }

    public String getResourcePreference(IProject project) {
        return PreferenceFactory.getInstance().getPreferences(this, project).getString(RESOURCE_PREFERENCE);
    }

    public void setResourcePreference(String preference) {
        PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).setValue(RESOURCE_PREFERENCE, preference);
        CorePlugin.RESOURCE_FOLDER = preference;
    }

    public void addIgnoreViewID(String str) {
        this.ignore.add(str);
    }

    public void removeIgnoreViewID(String str) {
        this.ignore.remove(str);
    }

    public boolean containIgnoreViewID(String str) {
        return this.ignore.contains(str);
    }

    public void setDefaultCommentPreference() {
        PreferenceFactory.getInstance().getPreferences(this).setDefault(COMMENT_PREFERENCE, Messages.getString((String)"org.eclipse.birt.report.designer.ui.preference.commenttemplates.defaultcomment"));
    }

    public String getDefaultCommentPreference() {
        return PreferenceFactory.getInstance().getPreferences(this).getDefaultString(COMMENT_PREFERENCE);
    }

    public String getCommentPreference() {
        return PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).getString(COMMENT_PREFERENCE);
    }

    public String getCommentPreference(IProject project) {
        return PreferenceFactory.getInstance().getPreferences(this, project).getString(COMMENT_PREFERENCE);
    }

    public void setCommentPreference(String preference) {
        PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).setValue(COMMENT_PREFERENCE, preference);
    }

    public void setDefaultEnableCommentPreference() {
        PreferenceFactory.getInstance().getPreferences(this).setDefault(ENABLE_COMMENT_PREFERENCE, false);
    }

    public boolean getDefaultEnabelCommentPreference() {
        return PreferenceFactory.getInstance().getPreferences(this).getDefaultBoolean(ENABLE_COMMENT_PREFERENCE);
    }

    public boolean getEnableCommentPreference() {
        return PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).getBoolean(ENABLE_COMMENT_PREFERENCE);
    }

    public boolean getEnableCommentPreference(IProject project) {
        return PreferenceFactory.getInstance().getPreferences(this, project).getBoolean(ENABLE_COMMENT_PREFERENCE);
    }

    private void setDefaultSelectionPreference() {
        PreferenceFactory.getInstance().getPreferences(this).setDefault(ENABLE_GRADIENT_SELECTION_PREFERENCE, true);
        PreferenceFactory.getInstance().getPreferences(this).setDefault(ENABLE_ANIMATION_SELECTION_PREFERENCE, false);
    }

    public boolean getEnableGradientSelectionPreference() {
        return PreferenceFactory.getInstance().getPreferences(this).getBoolean(ENABLE_GRADIENT_SELECTION_PREFERENCE);
    }

    public boolean getEnableAnimatedSelectionPreference() {
        return PreferenceFactory.getInstance().getPreferences(this).getBoolean(ENABLE_ANIMATION_SELECTION_PREFERENCE);
    }

    public void setEnableCommentPreference(boolean preference) {
        PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).setValue(ENABLE_COMMENT_PREFERENCE, preference);
    }

    public List<String> getReportExtensionNameList() {
        if (this.reportExtensionNames == null) {
            this.reportExtensionNames = new ArrayList<String>();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.editors");
            int i = 0;
            while (i < elements.length) {
                String id = elements[i].getAttribute("id");
                if ("org.eclipse.birt.report.designer.ui.editors.ReportEditor".equals(id) && elements[i].getAttribute("extensions") != null) {
                    String[] extensionNames = elements[i].getAttribute("extensions").split(",");
                    int j = 0;
                    while (j < extensionNames.length) {
                        extensionNames[j] = extensionNames[j].trim();
                        if (!this.reportExtensionNames.contains(extensionNames[j])) {
                            this.reportExtensionNames.add(extensionNames[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            IContentType contentType = contentTypeManager.getContentType("org.eclipse.birt.report.designer.ui.editors.reportdesign");
            String[] fileSpecs = contentType.getFileSpecs(8);
            int i2 = 0;
            while (i2 < fileSpecs.length) {
                this.reportExtensionNames.add(fileSpecs[i2]);
                ++i2;
            }
        }
        return this.reportExtensionNames;
    }

    public boolean isReportDesignFile(String filename) {
        if (filename != null) {
            Iterator<String> iter = ReportPlugin.getDefault().getReportExtensionNameList().iterator();
            while (iter.hasNext()) {
                if (!filename.endsWith("." + iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public String getResourceFolder(IProject project) {
        return this.getResourceFolder(project, SessionHandleAdapter.getInstance().getReportDesignHandle());
    }

    public String getResourceFolder(IProject project, ModuleHandle module) {
        return this.getResourceFolder(project, module == null ? "" : module.getResourceFolder());
    }

    public String getResourceFolder(IProject project, String parentPath) {
        String resourceFolder = ReportPlugin.getDefault().getResourcePreference(project);
        if (resourceFolder == null || resourceFolder.equals("")) {
            resourceFolder = parentPath;
        }
        if (resourceFolder == null) {
            resourceFolder = "";
        }
        String str = resourceFolder;
        try {
            IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
            str = mgr.performStringSubstitution(resourceFolder);
        }
        catch (CoreException coreException) {
            str = resourceFolder;
        }
        resourceFolder = str;
        File file = new File(resourceFolder);
        if (!file.isAbsolute()) {
            if (project != null && project.getLocation() != null) {
                resourceFolder = project.getLocation().append(resourceFolder).toOSString();
            } else {
                if (resourceFolder != null && !resourceFolder.startsWith(File.separator)) {
                    resourceFolder = String.valueOf(File.separator) + resourceFolder;
                }
                resourceFolder = String.valueOf(parentPath) + resourceFolder;
            }
        }
        return resourceFolder;
    }

    public String getResourceFolder() {
        return this.getResourceFolder(UIUtil.getCurrentProject());
    }

    private static void initFilterMap(IPreferences store, ResourceFilter filter) {
        if (store.contains(filter.getType())) {
            filter.setEnabled(store.getBoolean(filter.getType()));
        }
        filterMap.put(filter.getType(), filter);
    }

    public static LinkedHashMap<String, ResourceFilter> getFilterMap() {
        return filterMap;
    }

    public static LinkedHashMap<String, ResourceFilter> getFilterMap(boolean showEmptyFolderFilter) {
        if (!showEmptyFolderFilter) {
            LinkedHashMap map = (LinkedHashMap)filterMap.clone();
            map.remove("empty_folder");
            return map;
        }
        return filterMap;
    }

    public void setDefaultBiDiSettings() {
        PreferenceFactory.getInstance().getPreferences(this).setDefault(LTR_BIDI_DIRECTION, true);
    }

    public void setDefaultUnitSettings() {
        PreferenceFactory.getInstance().getPreferences(this).setDefault(DEFAULT_UNIT_PREFERENCE, DEFAULT_UNIT_AUTO);
    }

    public void setDefaultScriptType() {
        PreferenceFactory.getInstance().getPreferences(this).setDefault(DEFAULT_SCRIPT_TYPE, "javascript");
    }

    public boolean getLTRReportDirection(IProject project) {
        return PreferenceFactory.getInstance().getPreferences(this, project).getBoolean(LTR_BIDI_DIRECTION);
    }

    public boolean getLTRReportDirection() {
        return PreferenceFactory.getInstance().getPreferences(this).getBoolean(LTR_BIDI_DIRECTION);
    }

    public void setLTRReportDirection(boolean ltrDirection) {
        PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).setValue(LTR_BIDI_DIRECTION, ltrDirection);
    }

    private String getExtendedPaletteEntryDescription(String defaultName) {
        List<ExtendedElementUIPoint> points;
        PaletteEntryExtension[] entries = EditpartExtensionManager.getPaletteEntries();
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getItemName().equals(defaultName)) {
                    return entries[i].getDescription() != null ? entries[i].getDescription() : "";
                }
                ++i;
            }
        }
        if ((points = ExtensionPointManager.getInstance().getExtendedElementPoints()) != null) {
            for (ExtendedElementUIPoint point : points) {
                if (!point.getExtensionName().equals(defaultName)) continue;
                return point.getAttribute("description") != null ? (String)point.getAttribute("description") : "";
            }
        }
        return "";
    }

    public String getDefaultUnitPreference(IProject project) {
        String unit = PreferenceFactory.getInstance().getPreferences(this, project).getString(DEFAULT_UNIT_PREFERENCE);
        if (unit == DEFAULT_UNIT_AUTO) {
            return null;
        }
        return unit;
    }

    public String getDefaultUnitPreference() {
        String unit = PreferenceFactory.getInstance().getPreferences(this).getString(DEFAULT_UNIT_PREFERENCE);
        if (unit == DEFAULT_UNIT_AUTO) {
            return null;
        }
        return unit;
    }

    public void setDefaultUnitPreference(String unit) {
        PreferenceFactory.getInstance().getPreferences(this, UIUtil.getCurrentProject()).setValue(DEFAULT_UNIT_PREFERENCE, unit);
    }
}

