/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.widget.WidgetConstants;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WidgetUtil
implements WidgetConstants {
    public static GridLayout createGridLayout(int columns) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 8;
        return layout;
    }

    public static void setGridData(Control control, int hSpan, boolean grabSpace) {
        GridData data = new GridData();
        data.horizontalSpan = hSpan;
        data.grabExcessHorizontalSpace = grabSpace;
        if (control instanceof Text || control instanceof Combo) {
            data.widthHint = 80;
        }
        data.horizontalAlignment = 4;
        control.setLayoutData((Object)data);
    }

    public static void setGridData(Control control, int hSpan, int width) {
        GridData data = new GridData();
        data.horizontalSpan = hSpan;
        data.widthHint = width;
        control.setLayoutData((Object)data);
    }

    public static GridLayout createSpaceGridLayout(int columns, int space) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginHeight = space;
        layout.marginWidth = space;
        layout.horizontalSpacing = space;
        layout.verticalSpacing = space;
        return layout;
    }

    public static FormLayout createFormLayout() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.spacing = 8;
        return layout;
    }

    public static FormLayout createSpaceFormLayout(int space) {
        FormLayout layout = new FormLayout();
        layout.marginHeight = space;
        layout.marginWidth = space;
        layout.spacing = space;
        return layout;
    }

    public static Composite buildGridComposite(Composite parent, int hSpan, boolean grabSpace) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = hSpan;
        data.grabExcessHorizontalSpace = grabSpace;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public static Label createGridPlaceholder(Composite parent, int hSpan, boolean grabSpace) {
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalSpan = hSpan;
        data.grabExcessHorizontalSpace = grabSpace;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Label createHorizontalLine(Composite parent, int hSpan) {
        Label label = new Label(parent, 258);
        GridData data = new GridData();
        data.horizontalSpan = hSpan;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    public static void processError(Shell shell, Exception e) {
        WidgetUtil.processError(e);
    }

    public static void processError(Exception e) {
        ExceptionHandler.handle(e);
    }

    public static void setExcludeGridData(Control control, boolean exclude) {
        Object obj = control.getLayoutData();
        if (obj == null) {
            control.setLayoutData((Object)new GridData());
        } else if (!(obj instanceof GridData)) {
            return;
        }
        GridData data = (GridData)control.getLayoutData();
        data.exclude = exclude;
        control.setLayoutData((Object)data);
        control.setVisible(!exclude);
    }

    public static void setHorizontalSpan(Control control, int span) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalSpan = span;
        } else if (span != 1) {
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            control.setLayoutData((Object)gd);
        }
    }

    public static void setWidthHint(Control control, int widthHint) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).widthHint = widthHint;
        }
    }

    public static void setHeightHint(Control control, int heightHint) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).heightHint = heightHint;
        }
    }

    public static void setHorizontalIndent(Control control, int horizontalIndent) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalIndent = horizontalIndent;
        }
    }

    public static void setHorizontalGrabbing(Control control) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).grabExcessHorizontalSpace = true;
        }
    }
}

