/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.palette;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDService;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportDesignEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.AbstractToolHandleExtends;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.LibraryElementsToolHandleExtends;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportCreationTool;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.palette.BasePaletteFactory;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportElementFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertInLayoutAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.dnd.DropTargetEvent;

public class ReportTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    private static final String TRANS_LABEL_CREATE_ELEMENT = Messages.getString((String)"ReportTemplateTransferDropTargetListener.transLabel.createElement");
    private static final String IMG_TRANS_MSG = Messages.getString((String)"ImageEditPart.trans.editImage");

    public ReportTemplateTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer);
    }

    protected CreationFactory getFactory(Object template) {
        if (this.handleValidateDrag(template)) {
            if (template instanceof String) {
                return new ReportElementFactory(template);
            }
            return new ReportElementFactory(this.getSingleTransferData(template), template);
        }
        return null;
    }

    protected void handleDrop() {
        Object dragObj;
        this.updateTargetRequest();
        this.updateTargetEditPart();
        if (DNDService.getInstance().performDrop(TemplateTransfer.getInstance().getTemplate(), this.getTargetEditPart(), 16, new DNDLocation(this.getDropLocation()))) {
            return;
        }
        boolean isScalarparameter = false;
        boolean isResultSetColumn = false;
        boolean isEmbeddImage = false;
        Object template = TemplateTransfer.getInstance().getTemplate();
        Assert.isNotNull((Object)template);
        Assert.isTrue((boolean)this.handleValidateDrag(template));
        AbstractToolHandleExtends preHandle = null;
        String transName = null;
        if (template instanceof String) {
            PaletteEntryExtension[] entries = EditpartExtensionManager.getPaletteEntries();
            if (template.toString().startsWith("Extended")) {
                String extensionName = template.toString().substring("Extended".length());
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getItemName().equals(extensionName)) {
                        try {
                            CommandUtils.setVariable("targetEditPart", this.getTargetEditPart());
                            CommandUtils.setVariable("request", this.getTargetRequest());
                            this.getCreateRequest().getExtendedData().put("newObject", entries[i].executeCreate());
                            this.selectAddedObject();
                            return;
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle(e);
                        }
                    }
                    ++i;
                }
            }
            transName = TRANS_LABEL_CREATE_ELEMENT;
            preHandle = BasePaletteFactory.getAbstractToolHandleExtendsFromPaletteName(template);
        } else if (this.handleValidateInsert(template)) {
            transName = InsertInLayoutAction.DISPLAY_TEXT;
            Object objectType = this.getFactory(template).getObjectType();
            if (objectType instanceof DataSetHandle) {
                preHandle = new BasePaletteFactory.DataSetToolExtends();
            } else if (objectType instanceof DataSetItemModel) {
                preHandle = new BasePaletteFactory.DataSetColumnToolExtends();
            } else if (objectType instanceof ResultSetColumnHandle) {
                isResultSetColumn = true;
                preHandle = new BasePaletteFactory.DataSetColumnToolExtends();
            } else if (objectType instanceof ScalarParameterHandle) {
                isScalarparameter = true;
                preHandle = new BasePaletteFactory.ParameterToolExtends();
            } else if (objectType instanceof DimensionHandle) {
                preHandle = new BasePaletteFactory.DimensionHandleToolExtends();
            } else if (objectType instanceof MeasureHandle) {
                preHandle = new BasePaletteFactory.MeasureHandleToolExtends();
            }
        } else if (this.handleValidateLibrary(template)) {
            dragObj = this.getSingleTransferData(template);
            if (dragObj instanceof EmbeddedImageHandle) {
                isEmbeddImage = true;
                preHandle = new BasePaletteFactory.ImageToolExtends();
            } else {
                preHandle = new LibraryElementsToolHandleExtends((DesignElementHandle)dragObj);
            }
        } else if (this.handleValidateOutline(template) && (dragObj = this.getSingleTransferData(template)) instanceof EmbeddedImageHandle) {
            isEmbeddImage = true;
            preHandle = new BasePaletteFactory.ImageToolExtends();
        }
        if (preHandle != null) {
            Command command;
            Object dragObj2;
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(transName);
            preHandle.setRequest(this.getCreateRequest());
            preHandle.setTargetEditPart(this.getTargetEditPart());
            if (isEmbeddImage && (dragObj2 = this.getSingleTransferData(template)) instanceof EmbeddedImageHandle && ((EmbeddedImageHandle)dragObj2).getElementHandle().getRoot() instanceof LibraryHandle) {
                ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                LibraryHandle library = (LibraryHandle)((EmbeddedImageHandle)dragObj2).getElementHandle().getRoot();
                try {
                    if (UIUtil.includeLibrary(moduleHandle, library)) {
                        EmbeddedImage image = StructureFactory.newEmbeddedImageFrom((EmbeddedImageHandle)((EmbeddedImageHandle)dragObj2), (ModuleHandle)moduleHandle);
                        image.setType(((EmbeddedImageHandle)dragObj2).getType());
                        DNDUtil.addEmbeddedImageHandle((Object)this.getTargetEditPart().getModel(), (EmbeddedImage)image);
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
            }
            if ((command = this.getCommand()) != null && command.canExecute() && !preHandle.preHandleMouseUp()) {
                stack.rollback();
                return;
            }
            boolean isTheme = this.checkTheme(preHandle, this.getSingleTransferData(template));
            if (!isTheme) {
                super.handleDrop();
                if (!preHandle.postHandleCreation()) {
                    stack.rollback();
                    return;
                }
                Request request = new Request();
                if (this.getCreateRequest().getExtendedData().get("newObject from library") != null) {
                    request.getExtendedData().put("newObject from library", this.getCreateRequest().getExtendedData().get("newObject from library"));
                }
                if (isScalarparameter || isResultSetColumn) {
                    request.setType((Object)"create scalarparameter or resultsetcolumn");
                    Object model = this.getCreateRequest().getExtendedData().get("newObject");
                    if (model instanceof GroupHandle) {
                        GroupHandle handle = (GroupHandle)model;
                        this.getCreateRequest().getExtendedData().put("newObject", ((CellHandle)((RowHandle)handle.getHeader().get(0)).getCells().get(0)).getContent().get(0));
                    }
                    this.selectAddedObject(request);
                } else if (isEmbeddImage) {
                    Object dragObj3 = this.getSingleTransferData(template);
                    Object model = this.getCreateRequest().getExtendedData().get("newObject");
                    try {
                        ((ImageHandle)model).setImageName(((EmbeddedImageHandle)dragObj3).getName());
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                    request.setType((Object)"selection");
                    this.selectAddedObject(request);
                } else {
                    request.setType((Object)"create element");
                    this.selectAddedObject(request);
                }
            }
            stack.commit();
        }
    }

    private boolean checkTheme(AbstractToolHandleExtends preHandle, Object obj) {
        return preHandle instanceof LibraryElementsToolHandleExtends && obj instanceof ThemeHandle;
    }

    private boolean handleValidateDrag(Object dragObj) {
        if (DNDService.getInstance().validDrop(TemplateTransfer.getInstance().getTemplate(), this.getTargetEditPart(), 16, new DNDLocation(this.getDropLocation()))) {
            return true;
        }
        return dragObj != null && (this.handleValidatePalette(dragObj) || this.handleValidateOutline(dragObj) || this.handleValidateInsert(dragObj) || this.handleValidateLibrary(dragObj));
    }

    private boolean handleValidatePalette(Object dragObj) {
        return dragObj instanceof String && (this.getTargetEditPart() == null || ReportCreationTool.handleValidatePalette(dragObj, this.getTargetEditPart()));
    }

    private boolean handleValidateInsert(Object template) {
        return InsertInLayoutUtil.handleValidateInsert(template) && (this.getTargetEditPart() == null || InsertInLayoutUtil.handleValidateInsertToLayout(template, this.getTargetEditPart()));
    }

    private boolean isCrossType(Object obj) {
        return obj instanceof DimensionHandle || obj instanceof MeasureHandle;
    }

    private boolean handleValidateOutline(Object dragSource) {
        EditPart targetEditPart = this.getTargetEditPart();
        if (targetEditPart == null) {
            return true;
        }
        if (dragSource != null) {
            Object[] dragObjs = dragSource instanceof Object[] ? (Object[])dragSource : new Object[]{dragSource};
            if (dragObjs.length == 0) {
                return false;
            }
            int i = 0;
            if (i < dragObjs.length) {
                return dragObjs[i] instanceof EmbeddedImageHandle && !(((EmbeddedImageHandle)dragObjs[i]).getElementHandle().getRoot() instanceof LibraryHandle);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleValidateLibrary(Object dragObj) {
        EditPart targetEditPart = this.getTargetEditPart();
        if (targetEditPart == null) {
            return true;
        }
        if (dragObj == null) return false;
        Object[] dragObjs = dragObj instanceof Object[] ? (Object[])dragObj : new Object[]{dragObj};
        if (dragObjs.length == 0) {
            return false;
        }
        int i = 0;
        while (i < dragObjs.length) {
            dragObj = dragObjs[i];
            if (dragObj instanceof ReportElementHandle) {
                if (!(((ReportElementHandle)dragObj).getRoot() instanceof LibraryHandle)) return false;
                if ((dragObj instanceof DataSetHandle || dragObj instanceof ParameterHandle) && this.getTargetEditPart() == null) {
                    return true;
                }
                if (dragObj instanceof DataSourceHandle || dragObj instanceof MasterPageHandle) {
                    return targetEditPart instanceof ReportDesignEditPart && ((ReportElementHandle)dragObj).getRoot() != targetEditPart.getModel();
                }
                if (!DNDUtil.handleValidateTargetCanContain((Object)targetEditPart.getModel(), (Object)dragObj) || !DNDUtil.handleValidateTargetCanContainMore((Object)targetEditPart.getModel(), (int)1)) {
                    return false;
                }
            } else {
                if (!(dragObj instanceof EmbeddedImageHandle) || !(((EmbeddedImageHandle)dragObj).getElementHandle().getRoot() instanceof LibraryHandle)) return false;
                int canContain = DNDUtil.handleValidateTargetCanContain((Object)targetEditPart.getModel(), (Object)dragObj, (boolean)true);
                return canContain == 1;
            }
            ++i;
        }
        return true;
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
        if (!this.handleValidateDrag(TemplateTransfer.getInstance().getTemplate())) {
            event.detail = 0;
        }
    }

    private void selectAddedObject() {
        Object model = this.getCreateRequest().getExtendedData().get("newObject");
        EditPartViewer viewer = this.getViewer();
        viewer.getControl().setFocus();
        ReportCreationTool.selectAddedObject(model, viewer);
    }

    private void selectAddedObject(Request request) {
        Object model = this.getCreateRequest().getExtendedData().get("newObject");
        EditPartViewer viewer = this.getViewer();
        viewer.getControl().setFocus();
        ReportCreationTool.selectAddedObject(model, viewer, request);
    }

    private Object getSingleTransferData(Object template) {
        if (template instanceof Object[]) {
            return ((Object[])template)[0];
        }
        return template;
    }
}

