/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import org.eclipse.birt.report.designer.internal.ui.layout.TableLayoutData;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayoutDataProvider;
import org.eclipse.birt.report.designer.util.ITableLayoutCalculator;

public class TableLayoutHelper {
    public static void calculateColumnWidth(TableLayoutData.ColumnData[] columnWidths, final int containerWidth, ITableLayoutCalculator calculator) {
        int size = columnWidths.length;
        final int[] hintWidth = calculator.getIntColWidth();
        final int[] minWidth = new int[size];
        final int[] maxWidth = new int[size];
        int i = 0;
        while (i < size) {
            TableLayoutData.ColumnData colData = columnWidths[i];
            minWidth[i] = Math.max(colData.minColumnWidth, colData.trueMinColumnWidth);
            maxWidth[i] = Math.max(containerWidth, minWidth[i]);
            ++i;
        }
        int[] width = TableLayoutHelper.refineColumnWidth(new TableLayoutDataProvider(){

            public int getAvailableWidth() {
                return containerWidth;
            }

            public int[] getHintColumnWidth() {
                return hintWidth;
            }

            public int[] getMaxColumnWidth() {
                return maxWidth;
            }

            public int[] getMinColumnWidth() {
                return minWidth;
            }
        });
        int i2 = 0;
        while (i2 < size) {
            TableLayoutData.ColumnData colData = columnWidths[i2];
            colData.width = width[i2];
            ++i2;
        }
    }

    public static int[] refineColumnWidth(TableLayoutDataProvider provider) {
        int[] hintWidth;
        block15: {
            int totalHintWidth;
            int size;
            int availableWidth;
            int[] minWidth;
            block16: {
                hintWidth = provider.getHintColumnWidth();
                minWidth = provider.getMinColumnWidth();
                int[] maxWidth = provider.getMaxColumnWidth();
                availableWidth = provider.getAvailableWidth();
                assert (hintWidth.length == minWidth.length);
                assert (minWidth.length == maxWidth.length);
                TableLayoutHelper.checkValid(hintWidth, minWidth);
                TableLayoutHelper.checkValid(maxWidth, minWidth);
                size = hintWidth.length;
                totalHintWidth = TableLayoutHelper.getSum(hintWidth);
                int totalMinWidth = TableLayoutHelper.getSum(minWidth);
                int totalMaxWidth = TableLayoutHelper.getSum(maxWidth);
                if (totalMinWidth >= availableWidth) {
                    int i = 0;
                    while (i < size) {
                        hintWidth[i] = minWidth[i];
                        ++i;
                    }
                    return hintWidth;
                }
                if (totalMaxWidth <= availableWidth) {
                    int i = 0;
                    while (i < size) {
                        hintWidth[i] = maxWidth[i];
                        ++i;
                    }
                    return hintWidth;
                }
                if (totalMaxWidth <= availableWidth || totalMinWidth >= availableWidth) break block15;
                if (totalHintWidth >= (availableWidth = Math.max(totalMinWidth, availableWidth))) break block16;
                int T = availableWidth - totalHintWidth;
                int delta = 0;
                int i = 0;
                while (i < size) {
                    int n;
                    int xdelta = T * hintWidth[i] / totalHintWidth;
                    hintWidth[i] = n = hintWidth[i] + xdelta;
                    delta += xdelta;
                    ++i;
                }
                if (delta >= T) break block15;
                int xx = T - delta;
                block3: while (xx > 0) {
                    int i2 = 0;
                    while (i2 < size) {
                        if (xx <= 0) continue block3;
                        int n = i2++;
                        hintWidth[n] = hintWidth[n] + 1;
                        --xx;
                    }
                }
                break block15;
            }
            if (totalHintWidth > availableWidth) {
                int T = totalHintWidth - availableWidth;
                int delta = 0;
                int i = 0;
                while (i < size) {
                    int xdelta = T * hintWidth[i] / totalHintWidth;
                    int n = Math.max(hintWidth[i] - xdelta, minWidth[i]);
                    delta += hintWidth[i] - n;
                    hintWidth[i] = n;
                    ++i;
                }
                if (delta < T) {
                    int xx = T - delta;
                    block6: while (xx > 0) {
                        int i3 = 0;
                        while (i3 < size) {
                            if (xx <= 0) continue block6;
                            if (hintWidth[i3] > minWidth[i3]) {
                                int n = i3;
                                hintWidth[n] = hintWidth[n] - 1;
                                --xx;
                            }
                            ++i3;
                        }
                    }
                }
            }
        }
        return hintWidth;
    }

    private static void checkValid(int[] width, int[] minWidth) {
        int i = 0;
        while (i < width.length) {
            if (width[i] < minWidth[i]) {
                width[i] = minWidth[i];
            }
            ++i;
        }
    }

    private static int getSum(int[] width) {
        int rt = 0;
        int i = 0;
        while (i < width.length) {
            rt += width[i];
            ++i;
        }
        return rt;
    }
}

