/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions.IExtension;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedEditPart;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.CommandCombinedTemplateCreationEntry;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.palette.BasePaletteFactory;
import org.eclipse.birt.report.designer.internal.ui.palette.PaletteCategory;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportCombinedTemplateCreationEntry;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportElementFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.extensions.IReportItemFigureProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.resource.ImageDescriptor;

public class GuiExtensionManager {
    public static final String PALETTE_DESIGNER = "pallet_designer";
    public static final String PALETTE_MASTERPAGE = "pallet_masterpage";
    public static final String DESIGNER_FACTORY = "designer_factory";
    private static final String EXT_MGR_LABEL = Messages.getString((String)"GuiExtensionManager.label.name");

    public static Object doExtension(IExtension extension, Object object) {
        Object retValue = null;
        if (PALETTE_DESIGNER.equals(extension.getExtendsionIdentify()) || PALETTE_MASTERPAGE.equals(extension.getExtendsionIdentify())) {
            retValue = GuiExtensionManager.doPalette(object, extension.getExtendsionIdentify());
        } else if (DESIGNER_FACTORY.equals(extension.getExtendsionIdentify())) {
            retValue = GuiExtensionManager.doDesignerFactory(object);
        }
        return retValue;
    }

    private static Object doDesignerFactory(Object object) {
        if (object instanceof ExtendedItemHandle) {
            ExtendedItemHandle model = (ExtendedItemHandle)object;
            ExtendedEditPart part = new ExtendedEditPart(model);
            String id = GuiExtensionManager.getExtendedElementID(model);
            ExtendedElementUIPoint point = ExtensionPointManager.getInstance().getExtendedElementPoint(id);
            if (point == null) {
                return null;
            }
            IReportItemFigureProvider UI = ExtensionPointManager.getInstance().getExtendedElementPoint(id).getReportItemUI();
            if (UI == null) {
                return null;
            }
            part.setExtendedElementUI(UI);
            return part;
        }
        return null;
    }

    public static String getExtendedElementID(ExtendedItemHandle model) {
        return model.getExtensionName();
    }

    public static String getExtensionDisplayName(Object obj) {
        String name;
        String value = EXT_MGR_LABEL;
        if (obj instanceof ExtendedItemHandle && (name = ((ExtendedItemHandle)obj).getDefn().getDisplayName()) != null) {
            value = name;
        }
        return value;
    }

    private static Object doPalette(Object object, String type) {
        String category;
        assert (object instanceof PaletteRoot);
        PaletteRoot root = (PaletteRoot)object;
        List list = root.getChildren();
        List<ExtendedElementUIPoint> exts = ExtensionPointManager.getInstance().getExtendedElementPoints();
        Comparator<CombinedTemplateCreationEntry> entryComparator = new Comparator<CombinedTemplateCreationEntry>(){

            @Override
            public int compare(CombinedTemplateCreationEntry o1, CombinedTemplateCreationEntry o2) {
                return Collator.getInstance().compare(o1.getLabel(), o2.getLabel());
            }
        };
        if (exts == null) {
            return root;
        }
        HashMap<String, TreeSet<CombinedTemplateCreationEntry>> containerEntriesMap = new HashMap<String, TreeSet<CombinedTemplateCreationEntry>>();
        for (ExtendedElementUIPoint point : exts) {
            if (point == null) {
                return root;
            }
            category = (String)point.getAttribute("category");
            ImageDescriptor icon = (ImageDescriptor)point.getAttribute("paletteIcon");
            IReportItemFigureProvider UI = point.getReportItemUI();
            if (UI == null) {
                return root;
            }
            if (PALETTE_DESIGNER.equals(type)) {
                Boolean bool = (Boolean)point.getAttribute("showInDesigner");
                if (!bool.booleanValue()) {
                    continue;
                }
            } else if (PALETTE_MASTERPAGE.equals(type)) {
                Boolean cfr_ignored_0 = (Boolean)point.getAttribute("showInMasterPage");
                continue;
            }
            String displayName = DEUtil.getMetaDataDictionary().getExtension(point.getExtensionName()).getDisplayName();
            ReportCombinedTemplateCreationEntry combined = new ReportCombinedTemplateCreationEntry(displayName, Messages.getFormattedString((String)"GuiExtensionManager.tooltip.insert", (Object[])new Object[]{displayName}), GuiExtensionManager.getExtendedPalletTemplateName(point), new ReportElementFactory("Extended" + point.getExtensionName()), icon, icon, BasePaletteFactory.getAbstractToolHandleExtendsFromPaletteName(GuiExtensionManager.getExtendedPalletTemplateName(point)));
            PaletteCategory entry = GuiExtensionManager.findCategory(list, category);
            if (entry == null) {
                String categoryLabel = (String)point.getAttribute("categoryDisplayName");
                if (categoryLabel == null) {
                    categoryLabel = category;
                }
                entry = new PaletteCategory(category, categoryLabel, null);
                root.add((PaletteEntry)entry);
            }
            if (!containerEntriesMap.containsKey(category)) {
                containerEntriesMap.put(category, new TreeSet<CombinedTemplateCreationEntry>(entryComparator));
            }
            ((SortedSet)containerEntriesMap.get(category)).add(combined);
        }
        PaletteEntryExtension[] entries = EditpartExtensionManager.getPaletteEntries();
        int i = 0;
        while (i < entries.length) {
            if (!PALETTE_MASTERPAGE.equals(type)) {
                category = entries[i].getCategory();
                PaletteCategory entry = GuiExtensionManager.findCategory(list, category);
                if (entry == null) {
                    String categoryLabel = entries[i].getCategoryDisplayName();
                    if (categoryLabel == null) {
                        categoryLabel = category;
                    }
                    entry = new PaletteCategory(category, categoryLabel, null);
                    root.add((PaletteEntry)entry);
                }
                CommandCombinedTemplateCreationEntry combined = new CommandCombinedTemplateCreationEntry(entries[i]);
                if (!containerEntriesMap.containsKey(category)) {
                    containerEntriesMap.put(category, new TreeSet<CombinedTemplateCreationEntry>(entryComparator));
                }
                ((SortedSet)containerEntriesMap.get(category)).add(combined);
            }
            ++i;
        }
        for (Map.Entry entry : containerEntriesMap.entrySet()) {
            PaletteCategory container = GuiExtensionManager.findCategory(list, (String)entry.getKey());
            for (CommandCombinedTemplateCreationEntry combined : (SortedSet)entry.getValue()) {
                container.add((PaletteEntry)combined);
            }
        }
        return root;
    }

    public static Object getExtendedPalletTemplateName(ExtendedElementUIPoint point) {
        return "Extended" + point.getExtensionName();
    }

    private static PaletteCategory findCategory(List list, String category) {
        for (Object entry : list) {
            if (!(entry instanceof PaletteCategory) || !((PaletteCategory)((Object)entry)).getCategoryName().equals(category)) continue;
            return (PaletteCategory)((Object)entry);
        }
        return null;
    }
}

