/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.util.logging.Level;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseStylePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatDateTimePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceStore;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FormatDateTimePreferencePage
extends BaseStylePreferencePage {
    private String name;
    private IFormatPage formatPage;

    public FormatDateTimePreferencePage(Object model) {
        super(model);
        this.setTitle(Messages.getString((String)"FormatDateTimePreferencePage.formatDateTime.title"));
        this.setPreferenceName("DateTimeFormatValue");
    }

    protected void adjustGridLayout() {
        ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns = 1;
    }

    private void setPreferenceName(String name) {
        this.name = name;
    }

    public String getPreferenceName() {
        return this.name;
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Composite parent = this.getFieldEditorParent();
        this.formatPage = new FormatDateTimePage(parent, 3, 0);
        ((Composite)this.formatPage).setLayoutData((Object)new GridData(768));
        this.initiateFormatPage();
        UIUtil.bindHelp((Control)this.getFieldEditorParent().getParent(), "org.eclipse.birt.cshelp.StyleBuilderFormatDateTime_ID");
    }

    private void initiateFormatPage() {
        String category = ((StylePreferenceStore)this.getPreferenceStore()).getDateTimeFormatCategory();
        String pattern = ((StylePreferenceStore)this.getPreferenceStore()).getDateTimeFormat();
        ULocale locale = ((StylePreferenceStore)this.getPreferenceStore()).getDateTimeFormatLocale();
        this.formatPage.setInput(category, pattern, locale);
    }

    public boolean performOk() {
        IPreferenceStore ps = this.getPreferenceStore();
        if (ps instanceof StylePreferenceStore) {
            ((StylePreferenceStore)ps).clearError();
        }
        boolean rt = this.doStore();
        if (ps instanceof StylePreferenceStore) {
            return !((StylePreferenceStore)ps).hasError();
        }
        return rt;
    }

    protected boolean doStore() {
        if (this.formatPage == null || !this.formatPage.isFormatModified() || !this.formatPage.isDirty()) {
            return true;
        }
        try {
            ((StylePreferenceStore)this.getPreferenceStore()).setDateTimeFormatCategory(this.formatPage.getCategory());
            ((StylePreferenceStore)this.getPreferenceStore()).setDateTimeFormat(this.formatPage.getPattern());
            ((StylePreferenceStore)this.getPreferenceStore()).setDateTimeFormatLocale(this.formatPage.getLocale());
            return true;
        }
        catch (SemanticException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    protected String[] getPreferenceNames() {
        return new String[0];
    }
}

