/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.util.DummyEngineTask;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngineFactory;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;

public final class DataSetUIUtil {
    private static Logger logger = Logger.getLogger(DataSetUIUtil.class.getName());

    public static void updateColumnCache(DataSetHandle dataSetHandle) throws SemanticException {
        DataSetUIUtil.updateColumnCache(dataSetHandle, false);
    }

    public static void updateColumnCacheAfterCleanRs(DataSetHandle dataSetHandle) throws SemanticException {
        if (dataSetHandle instanceof OdaDataSetHandle && dataSetHandle.getPropertyHandle("resultSet").isLocal()) {
            dataSetHandle.getPropertyHandle("resultSet").setValue(new ArrayList());
        }
        DataSetUIUtil.updateColumnCache(dataSetHandle);
    }

    public static void updateColumnCache(DataSetHandle dataSetHandle, boolean holdEvent) {
        try {
            if (dataSetHandle.getModuleHandle() instanceof ReportDesignHandle) {
                EngineConfig ec = new EngineConfig();
                ReportEngine engine = (ReportEngine)new ReportEngineFactory().createReportEngine(ec);
                ReportDesignHandle copy = (ReportDesignHandle)dataSetHandle.getModuleHandle().copy().getHandle(null);
                DummyEngineTask engineTask = new DummyEngineTask(engine, new ReportEngineHelper(engine).openReportDesign(copy), (ModuleHandle)copy);
                DataRequestSession session = engineTask.getDataSession();
                HashMap<String, Integer> appContext = new HashMap<String, Integer>();
                appContext.put(DataEngine.MEMORY_DATA_SET_CACHE, dataSetHandle.getRowFetchLimit());
                engineTask.setAppContext(appContext);
                engineTask.run();
                session.refreshMetaData(dataSetHandle, holdEvent);
                engineTask.close();
                engine.destroy();
            } else {
                DataSessionContext context = new DataSessionContext(3, dataSetHandle.getRoot(), null);
                DataRequestSession drSession = DataRequestSession.newSession((DataSessionContext)context);
                drSession.refreshMetaData(dataSetHandle, holdEvent);
                drSession.shutdown();
            }
        }
        catch (BirtException ex) {
            logger.entering(DataSetUIUtil.class.getName(), "updateColumnCache", new Object[]{ex});
        }
    }

    public static CachedMetaDataHandle getCachedMetaDataHandle(DataSetHandle dataSetHandle) throws SemanticException {
        if (dataSetHandle.getCachedMetaDataHandle() == null) {
            DataSetUIUtil.updateColumnCache(dataSetHandle, true);
        }
        return dataSetHandle.getCachedMetaDataHandle();
    }

    public static boolean hasMetaData(DataSetHandle dataSetHandle) {
        CachedMetaDataHandle metaData = dataSetHandle.getCachedMetaDataHandle();
        if (metaData == null) {
            return false;
        }
        Iterator iter = metaData.getResultSet().iterator();
        return iter.hasNext();
    }

    public static String toModelDataType(int modelDataType) {
        if (modelDataType == 2) {
            return "integer";
        }
        if (modelDataType == 5) {
            return "string";
        }
        if (modelDataType == 6) {
            return "date-time";
        }
        if (modelDataType == 4) {
            return "decimal";
        }
        if (modelDataType == 3) {
            return "float";
        }
        if (modelDataType == 9) {
            return "date";
        }
        if (modelDataType == 10) {
            return "time";
        }
        if (modelDataType == 1) {
            return "boolean";
        }
        if (modelDataType == 11) {
            return "javaObject";
        }
        return "any";
    }

    public static void clearPropertyBindingMap(DataSetHandle dsHandle, Map dataSetMap, Map dataSourceMap) throws SemanticException {
        block7: {
            PropertyBinding binding;
            block6: {
                if (dsHandle.getExtends() != null) {
                    return;
                }
                if (!(dsHandle instanceof JointDataSetHandle)) break block6;
                Iterator iter = ((JointDataSetHandle)dsHandle).dataSetsIterator();
                while (iter.hasNext()) {
                    DataSetHandle ds = (DataSetHandle)iter.next();
                    if (dsHandle == null) continue;
                    DataSetUIUtil.clearPropertyBindingMap(ds, dataSetMap, dataSourceMap);
                }
                break block7;
            }
            if (!(dsHandle instanceof OdaDataSetHandle)) break block7;
            List dataSetBindingList = dsHandle.getPropertyBindings();
            List dataSourceBindingList = dsHandle.getDataSource().getPropertyBindings();
            if (!dataSetBindingList.isEmpty()) {
                dataSetMap.put(dsHandle.getName(), dataSetBindingList);
            }
            if (!dataSourceBindingList.isEmpty()) {
                dataSourceMap.put(dsHandle.getDataSource().getName(), dataSourceBindingList);
            }
            int i = 0;
            while (i < dataSetBindingList.size()) {
                binding = (PropertyBinding)dataSetBindingList.get(i);
                dsHandle.setPropertyBinding(binding.getName(), null);
                ++i;
            }
            i = 0;
            while (i < dataSourceBindingList.size()) {
                binding = (PropertyBinding)dataSourceBindingList.get(i);
                dsHandle.getDataSource().setPropertyBinding(binding.getName(), null);
                ++i;
            }
        }
    }

    public static void resetPropertyBinding(DataSetHandle dsHandle, Map dataSetMap, Map dataSourceMap) throws SemanticException {
        block7: {
            PropertyBinding binding;
            int i;
            List pList;
            block6: {
                if (dsHandle.getExtends() != null) {
                    return;
                }
                if (!(dsHandle instanceof JointDataSetHandle)) break block6;
                Iterator iter = ((JointDataSetHandle)dsHandle).dataSetsIterator();
                while (iter.hasNext()) {
                    DataSetHandle ds = (DataSetHandle)iter.next();
                    if (dsHandle == null) continue;
                    DataSetUIUtil.resetPropertyBinding(ds, dataSetMap, dataSourceMap);
                }
                break block7;
            }
            if (!(dsHandle instanceof OdaDataSetHandle)) break block7;
            if (dataSetMap.get(dsHandle.getName()) != null) {
                pList = (List)dataSetMap.get(dsHandle.getName());
                i = 0;
                while (i < pList.size()) {
                    binding = (PropertyBinding)pList.get(i);
                    dsHandle.setPropertyBinding(binding.getName(), binding.getValue());
                    ++i;
                }
            }
            if (dataSourceMap.get(dsHandle.getDataSource().getName()) != null) {
                pList = (List)dataSourceMap.get(dsHandle.getDataSource().getName());
                i = 0;
                while (i < pList.size()) {
                    binding = (PropertyBinding)pList.get(i);
                    dsHandle.getDataSource().setPropertyBinding(binding.getName(), binding.getValue());
                    ++i;
                }
            }
        }
    }
}

