/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.IContextUiStartup;
import org.eclipse.mylyn.internal.resources.ui.EditorInteractionMonitor;
import org.eclipse.mylyn.internal.resources.ui.ResourceChangeMonitor;
import org.eclipse.mylyn.internal.resources.ui.ResourceInteractionMonitor;
import org.eclipse.mylyn.internal.resources.ui.ResourceInterestUpdater;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesUiBridgePlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.resources.ui";
    private static ResourcesUiBridgePlugin INSTANCE;
    private ResourceChangeMonitor resourceChangeMonitor;
    private ResourceInteractionMonitor resourceInteractionMonitor;
    private EditorInteractionMonitor interestEditorTracker;
    private ResourceInterestUpdater interestUpdater;
    private static final String PREF_STORE_DELIM = ", ";
    public static final String PREF_RESOURCES_IGNORED = "org.eclipse.mylyn.ide.resources.ignored.pattern";
    public static final String PREF_VAL_DEFAULT_RESOURCES_IGNORED = ".*, ";

    public ResourcesUiBridgePlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initPreferenceDefaults();
        this.interestUpdater = new ResourceInterestUpdater();
    }

    protected void lazyStart() {
        this.resourceChangeMonitor = new ResourceChangeMonitor();
        this.resourceInteractionMonitor = new ResourceInteractionMonitor();
        this.interestEditorTracker = new EditorInteractionMonitor();
        MonitorUi.getSelectionMonitors().add(this.resourceInteractionMonitor);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeMonitor, 1);
        this.interestEditorTracker.install(PlatformUI.getWorkbench());
    }

    protected void lazyStop() {
        if (this.resourceChangeMonitor != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeMonitor);
        }
        if (this.resourceInteractionMonitor != null) {
            MonitorUi.getSelectionMonitors().remove((Object)this.resourceInteractionMonitor);
        }
        if (this.interestEditorTracker != null) {
            this.interestEditorTracker.dispose(PlatformUI.getWorkbench());
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.lazyStop();
        super.stop(context);
        INSTANCE = null;
    }

    private void initPreferenceDefaults() {
        this.getPreferenceStore().setDefault(PREF_RESOURCES_IGNORED, PREF_VAL_DEFAULT_RESOURCES_IGNORED);
    }

    public List<IResource> getInterestingResources(IInteractionContext context) {
        ArrayList<IResource> interestingResources = new ArrayList<IResource>();
        Set resourceElements = ContextCore.getContextManager().getActiveDocuments(context);
        for (IInteractionElement element : resourceElements) {
            IResource resource = this.getResourceForElement(element, false);
            if (resource == null) continue;
            interestingResources.add(resource);
        }
        return interestingResources;
    }

    public void setExcludedResourcePatterns(Set<String> patterns) {
        StringBuilder store = new StringBuilder();
        for (String string : patterns) {
            store.append(string);
            store.append(PREF_STORE_DELIM);
        }
        this.getPreferenceStore().setValue(PREF_RESOURCES_IGNORED, store.toString());
    }

    public Set<String> getExcludedResourcePatterns() {
        HashSet<String> ignored = new HashSet<String>();
        String read = this.getPreferenceStore().getString(PREF_RESOURCES_IGNORED);
        if (read != null) {
            StringTokenizer st = new StringTokenizer(read, PREF_STORE_DELIM);
            while (st.hasMoreTokens()) {
                ignored.add(st.nextToken());
            }
        }
        return ignored;
    }

    public static ResourceInterestUpdater getInterestUpdater() {
        return ResourcesUiBridgePlugin.INSTANCE.interestUpdater;
    }

    public IResource getResourceForElement(IInteractionElement element, boolean findContainingResource) {
        Object adapted;
        if (element == null) {
            return null;
        }
        AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((String)element.getContentType());
        Object object = bridge.getObjectForHandle(element.getHandleIdentifier());
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable && (adapted = ((IAdaptable)object).getAdapter(IResource.class)) instanceof IResource) {
            return (IResource)adapted;
        }
        if (findContainingResource) {
            String parentHandle = bridge.getParentHandle(element.getHandleIdentifier());
            if (element.getHandleIdentifier().equals(parentHandle)) {
                return null;
            }
            return this.getResourceForElement(ContextCore.getContextManager().getElement(parentHandle), true);
        }
        return null;
    }

    public void setResourceMonitoringEnabled(boolean enabled) {
        this.resourceChangeMonitor.setEnabled(enabled);
    }

    public static ResourcesUiBridgePlugin getDefault() {
        return INSTANCE;
    }

    @Deprecated
    public ResourceBundle getResourceBundle() {
        return null;
    }

    public static class ResourcesUiBridgeStartup
    implements IContextUiStartup {
        public void lazyStartup() {
            ResourcesUiBridgePlugin.getDefault().lazyStart();
        }
    }
}

