/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.ArrayList;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.context.ui.ContextUi;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.resources.ui.Messages;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.ui.AbstractEditorTracker;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditorInteractionMonitor
extends AbstractEditorTracker {
    public static final String SOURCE_ID = "org.eclipse.mylyn.resources.ui.editor.tracker.interest";

    protected void editorBroughtToTop(IEditorPart part) {
        Object object = part.getEditorInput().getAdapter(IResource.class);
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)resource);
            InteractionEvent selectionEvent = new InteractionEvent(InteractionEvent.Kind.SELECTION, bridge.getContentType(), bridge.getHandleIdentifier((Object)resource), part.getSite().getId());
            ContextCore.getContextManager().processInteractionEvent(selectionEvent);
        }
    }

    public void editorOpened(IEditorPart editorPartOpened) {
        if (!ContextUi.isEditorAutoManageEnabled() || ContextCore.getContextManager().isContextCapturePaused()) {
            return;
        }
        IWorkbenchPage page = editorPartOpened.getSite().getPage();
        ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                IInteractionElement element = null;
                Object adapter = editorReference.getEditorInput().getAdapter(IResource.class);
                if (adapter instanceof IFile) {
                    String handle = ContextCore.getStructureBridge((Object)adapter).getHandleIdentifier(adapter);
                    element = ContextCore.getContextManager().getElement(handle);
                }
                if (element != null && !element.getInterest().isInteresting() && !this.isSameEditor(editorPartOpened, editorReference)) {
                    toClose.add(editorReference);
                }
            }
            catch (PartInitException partInitException) {}
            ++n2;
        }
        if (toClose.size() > 0) {
            page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
        }
    }

    private boolean isSameEditor(IEditorPart editorPart1, IEditorReference editorReference2) throws PartInitException {
        if (editorPart1 == null || editorReference2 == null) {
            return false;
        }
        return editorPart1.getEditorInput().equals(editorReference2.getEditorInput());
    }

    public void editorClosed(IEditorPart editorPart) {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        if (ContextUi.isEditorAutoCloseEnabled() && !this.otherEditorsOpenForResource(editorPart) && !(editorPart instanceof CompareEditor)) {
            Object adapter;
            IInteractionElement element = null;
            AbstractContextUiBridge uiBridge = ContextUi.getUiBridgeForEditor((IEditorPart)editorPart);
            Object object = uiBridge.getObjectForTextSelection(null, editorPart);
            if (object != null) {
                AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)object);
                element = ContextCore.getContextManager().getElement(bridge.getHandleIdentifier(object));
            }
            if (element == null && (adapter = editorPart.getEditorInput().getAdapter(IResource.class)) instanceof IResource) {
                IResource resource = (IResource)adapter;
                AbstractContextStructureBridge resourceBridge = ContextCore.getStructureBridge((Object)resource);
                element = ContextCore.getContextManager().getElement(resourceBridge.getHandleIdentifier((Object)resource));
            }
            if (element != null) {
                this.showEditorCloseWarning();
                ContextCorePlugin.getContextManager().manipulateInterestForElement(element, false, false, false, SOURCE_ID);
            }
        }
    }

    private void showEditorCloseWarning() {
        if (ContextCore.getContextManager().isContextActive() && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.close.action.manage.warning")) {
            try {
                if (!CoreUtil.TEST_MODE) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn", (String)Messages.EditorInteractionMonitor_Closing_a_file_automatically_removes_it_from_the_Task_Context);
                }
            }
            finally {
                ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.context.ui.close.action.manage.warning", false);
            }
        }
    }

    private boolean otherEditorsOpenForResource(IEditorPart editorPart) {
        Object adapter = editorPart.getEditorInput().getAdapter(IResource.class);
        if (adapter instanceof IResource) {
            IResource resource = (IResource)adapter;
            IWorkbenchPage page = editorPart.getSite().getPage();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                try {
                    Object otherAdapter = editorReference.getEditorInput().getAdapter(IResource.class);
                    if (otherAdapter instanceof IResource && otherAdapter.equals(resource)) {
                        return true;
                    }
                }
                catch (PartInitException partInitException) {}
                ++n2;
            }
        }
        return false;
    }
}

