/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.feature.AbstractFeatureSpecPage;
import org.eclipse.pde.internal.ui.wizards.feature.AbstractNewFeatureWizard;
import org.eclipse.pde.internal.ui.wizards.feature.CreateFeatureProjectFromLaunchOperation;
import org.eclipse.pde.internal.ui.wizards.feature.CreateFeatureProjectOperation;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureSpecPage;
import org.eclipse.pde.internal.ui.wizards.feature.PluginListPage;

public class NewFeatureProjectWizard
extends AbstractNewFeatureWizard {
    private String fId;
    private String fVersion;

    public NewFeatureProjectWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWFTRPRJ_WIZ);
        this.setWindowTitle(PDEUIMessages.NewFeatureWizard_wtitle);
    }

    public void addPages() {
        super.addPages();
        if (this.hasInterestingProjects()) {
            this.fSecondPage = new PluginListPage();
            this.addPage((IWizardPage)this.fSecondPage);
        }
    }

    private boolean hasInterestingProjects() {
        return PluginRegistry.getActiveModels().length > 0;
    }

    protected AbstractFeatureSpecPage createFirstPage() {
        return new FeatureSpecPage();
    }

    public String getFeatureId() {
        return this.fId;
    }

    public String getFeatureVersion() {
        return this.fVersion;
    }

    protected IRunnableWithProgress getOperation() {
        FeatureData data = this.fProvider.getFeatureData();
        this.fId = data.id;
        this.fVersion = data.version;
        ILaunchConfiguration config = this.fProvider.getLaunchConfiguration();
        if (config == null) {
            return new CreateFeatureProjectOperation(this.fProvider.getProject(), this.fProvider.getLocationPath(), data, this.fProvider.getPluginListSelection(), this.getShell());
        }
        return new CreateFeatureProjectFromLaunchOperation(this.fProvider.getProject(), this.fProvider.getLocationPath(), data, config, this.getShell());
    }
}

