/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.BaseBlock;
import org.eclipse.pde.internal.ui.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class WorkspaceDataBlock
extends BaseBlock {
    private Button fClearWorkspaceCheck;
    private Button fAskClearCheck;
    private Button fClearWorkspaceRadio;
    private Button fClearWorkspaceLogRadio;

    public WorkspaceDataBlock(AbstractLauncherTab tab) {
        super(tab);
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEUIMessages.WorkspaceDataBlock_workspace);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.createText((Composite)group, PDEUIMessages.WorkspaceDataBlock_location, 0);
        Composite buttons = new Composite((Composite)group, 0);
        layout = new GridLayout(7, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        buttons.setLayoutData((Object)gd);
        this.fClearWorkspaceCheck = new Button(buttons, 32);
        this.fClearWorkspaceCheck.setText(PDEUIMessages.WorkspaceDataBlock_clear);
        this.fClearWorkspaceCheck.setLayoutData((Object)new GridData(32));
        this.fClearWorkspaceCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceDataBlock.this.fAskClearCheck.setEnabled(WorkspaceDataBlock.this.fClearWorkspaceCheck.getSelection());
                WorkspaceDataBlock.this.fClearWorkspaceRadio.setEnabled(WorkspaceDataBlock.this.fClearWorkspaceCheck.getSelection());
                WorkspaceDataBlock.this.fClearWorkspaceLogRadio.setEnabled(WorkspaceDataBlock.this.fClearWorkspaceCheck.getSelection());
                WorkspaceDataBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
        this.fClearWorkspaceRadio = new Button(buttons, 16);
        this.fClearWorkspaceRadio.setText(PDEUIMessages.WorkspaceDataBlock_clearWorkspace);
        this.fClearWorkspaceRadio.setLayoutData((Object)new GridData(32));
        this.fClearWorkspaceRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceDataBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
        this.fClearWorkspaceLogRadio = new Button(buttons, 16);
        this.fClearWorkspaceLogRadio.setText(PDEUIMessages.WorkspaceDataBlock_clearLog);
        this.fClearWorkspaceLogRadio.setLayoutData((Object)new GridData(768));
        this.fClearWorkspaceLogRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceDataBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
        this.createButtons(buttons, new String[]{PDEUIMessages.BaseBlock_workspace, PDEUIMessages.BaseBlock_filesystem, PDEUIMessages.BaseBlock_variables});
        this.fAskClearCheck = new Button((Composite)group, 32);
        this.fAskClearCheck.setText(PDEUIMessages.WorkspaceDataBlock_askClear);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fAskClearCheck.setLayoutData((Object)gd);
        this.fAskClearCheck.addSelectionListener((SelectionListener)this.fListener);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("location", this.getLocation());
        config.setAttribute("clearws", this.fClearWorkspaceCheck.getSelection());
        config.setAttribute("askclear", this.fAskClearCheck.getSelection());
        config.setAttribute("clearwslog", this.fClearWorkspaceLogRadio.getSelection());
    }

    public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
        this.fLocationText.setText(configuration.getAttribute("location", LaunchArgumentsHelper.getDefaultWorkspaceLocation(configuration.getName())));
        this.fClearWorkspaceCheck.setSelection(configuration.getAttribute("clearws", false));
        this.fAskClearCheck.setSelection(configuration.getAttribute("askclear", true));
        this.fAskClearCheck.setEnabled(this.fClearWorkspaceCheck.getSelection());
        this.fClearWorkspaceLogRadio.setEnabled(this.fClearWorkspaceCheck.getSelection());
        this.fClearWorkspaceLogRadio.setSelection(configuration.getAttribute("clearwslog", false));
        this.fClearWorkspaceRadio.setEnabled(this.fClearWorkspaceCheck.getSelection());
        this.fClearWorkspaceRadio.setSelection(!configuration.getAttribute("clearwslog", false));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration, boolean isJUnit) {
        if (isJUnit) {
            configuration.setAttribute("location", LaunchArgumentsHelper.getDefaultJUnitWorkspaceLocation());
        } else {
            configuration.setAttribute("location", LaunchArgumentsHelper.getDefaultWorkspaceLocation(configuration.getName()));
        }
        configuration.setAttribute("clearws", isJUnit);
        configuration.setAttribute("askclear", !isJUnit);
        configuration.setAttribute("clearwslog", false);
    }

    protected String getName() {
        return PDEUIMessages.WorkspaceDataBlock_name;
    }

    protected boolean isFile() {
        return false;
    }

    protected void handleBrowseWorkspace() {
        super.handleBrowseWorkspace();
        if (this.fClearWorkspaceCheck.getSelection()) {
            this.fClearWorkspaceCheck.setSelection(false);
        }
    }

    protected void handleBrowseFileSystem() {
        super.handleBrowseFileSystem();
        if (this.fClearWorkspaceCheck.getSelection()) {
            this.fClearWorkspaceCheck.setSelection(false);
        }
    }

    public String validate() {
        int length = this.getLocation().length();
        this.fClearWorkspaceCheck.setEnabled(length > 0);
        this.fAskClearCheck.setEnabled(this.fClearWorkspaceCheck.getSelection() && length > 0);
        if (length == 0) {
            this.fClearWorkspaceCheck.setSelection(false);
        }
        return null;
    }
}

