/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class VMHelper {
    public static String getDefaultVMInstallName(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        IVMInstall vmInstall = null;
        if (javaProject != null) {
            vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
        }
        if (vmInstall != null) {
            return vmInstall.getName();
        }
        return VMUtil.getDefaultVMInstallName();
    }

    public static IVMInstall getVMInstall(ILaunchConfiguration configuration) throws CoreException {
        String jre = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, null);
        IVMInstall vm = null;
        if (jre == null) {
            String name = configuration.getAttribute("vminstall", null);
            if (name == null) {
                name = VMHelper.getDefaultVMInstallName(configuration);
            }
            if ((vm = VMHelper.getVMInstall(name)) == null) {
                throw new CoreException(LauncherUtils.createErrorStatus(NLS.bind((String)PDEUIMessages.WorkbenchLauncherConfigurationDelegate_noJRE, (Object)name)));
            }
        } else {
            IPath jrePath = Path.fromPortableString((String)jre);
            vm = JavaRuntime.getVMInstall((IPath)jrePath);
            if (vm == null) {
                String id = JavaRuntime.getExecutionEnvironmentId((IPath)jrePath);
                if (id == null) {
                    String name = JavaRuntime.getVMInstallName((IPath)jrePath);
                    throw new CoreException(LauncherUtils.createErrorStatus(NLS.bind((String)PDEUIMessages.WorkbenchLauncherConfigurationDelegate_noJRE, (Object)name)));
                }
                throw new CoreException(LauncherUtils.createErrorStatus(NLS.bind((String)PDEUIMessages.VMHelper_cannotFindExecEnv, (Object)id)));
            }
        }
        return vm;
    }

    public static IVMInstall getVMInstall(String name) {
        if (name != null) {
            IVMInstall[] installs = VMUtil.getAllVMInstances();
            int i = 0;
            while (i < installs.length) {
                if (installs[i].getName().equals(name)) {
                    return installs[i];
                }
                ++i;
            }
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    public static IVMInstall createLauncher(ILaunchConfiguration configuration) throws CoreException {
        IVMInstall launcher = VMHelper.getVMInstall(configuration);
        if (!launcher.getInstallLocation().exists()) {
            throw new CoreException(LauncherUtils.createErrorStatus(PDEUIMessages.WorkbenchLauncherConfigurationDelegate_jrePathNotFound));
        }
        return launcher;
    }
}

