/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.swt.custom;

import java.util.HashMap;
import org.eclipse.birt.core.ui.swt.custom.CustomChooserComposite;
import org.eclipse.birt.core.ui.swt.custom.ICustomChoice;
import org.eclipse.birt.core.ui.swt.custom.TextCanvas;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class TextCombo
extends CustomChooserComposite {
    private Font fontBold = new Font((Device)Display.getCurrent(), "arial", 9, 1);
    private HashMap choiceMarkerMap = new HashMap(10);

    public TextCombo(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextCombo.this.fontBold.dispose();
                TextCombo.this.choiceMarkerMap.clear();
            }
        });
    }

    protected ICustomChoice createChoice(Composite parent, Object choiceValue) {
        if (choiceValue == null) {
            choiceValue = "";
        }
        TextComboChoice choice = new TextComboChoice(parent, 0, (String)choiceValue);
        if (this.choiceMarkerMap.containsKey(choiceValue)) {
            choice.setTextFont(this.fontBold);
        } else {
            choice.setTextFont(null);
        }
        return choice;
    }

    public void setText(String text) {
        this.setChoiceValue(text);
    }

    public String getText() {
        return (String)this.getChoiceValue();
    }

    public void deselectAll() {
        this.choiceMarkerMap.clear();
    }

    public void markSelection(String text) {
        this.choiceMarkerMap.put(text, Boolean.TRUE);
    }

    public void unmarkSelection(String text) {
        this.choiceMarkerMap.remove(text);
    }

    private class TextComboChoice
    extends TextCanvas
    implements ICustomChoice {
        TextComboChoice(Composite parent, int iStyle, String comboText) {
            super(parent, iStyle, comboText);
        }

        public Object getValue() {
            return super.getText();
        }

        public void setValue(Object value) {
            super.setText((String)value);
            if (TextCombo.this.choiceMarkerMap.containsKey(value)) {
                this.setTextFont(TextCombo.this.fontBold);
            } else {
                this.setTextFont(null);
            }
        }
    }
}

