/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.util;

public class ParameterValueUtil {
    private static final char ESCAPE_QUOTE_CHAR = '\\';
    private static final String QUOTE_DELIMITER = "'";
    private static final String DOUBLE_QUOTE_DELIMITER = "\"";
    private static final String ESCAPED_LITERAL_QUOTE = "\\'";
    private static final char QUOTE_CHAR = '\'';
    private static final char DOUBLE_QUOTE_CHAR = '\"';

    public static String toJsExprValue(String literalValue, String quotationMark) {
        if (literalValue == null) {
            return literalValue;
        }
        StringBuffer value = new StringBuffer(literalValue);
        int index = 0;
        while ((index = value.indexOf(QUOTE_DELIMITER, index)) >= 0) {
            value.insert(index, '\\');
            index += 2;
        }
        if (quotationMark == null) {
            quotationMark = QUOTE_DELIMITER;
        }
        value.insert(0, quotationMark);
        value.append(quotationMark);
        return value.toString();
    }

    public static String toLiteralValue(String jsExprValue) {
        if (!ParameterValueUtil.isQuoted(jsExprValue)) {
            return jsExprValue;
        }
        StringBuffer value = new StringBuffer(jsExprValue);
        value.deleteCharAt(jsExprValue.length() - 1);
        value.deleteCharAt(0);
        int index = 0;
        while ((index = value.indexOf(ESCAPED_LITERAL_QUOTE, index)) >= 0) {
            value.deleteCharAt(index);
            ++index;
        }
        return value.toString();
    }

    public static boolean isQuoted(String jsExprValue) {
        int start;
        if (jsExprValue == null || jsExprValue.length() == 0) {
            return false;
        }
        boolean isDoubleQuoted = jsExprValue.startsWith(DOUBLE_QUOTE_DELIMITER);
        boolean isSingleQuoted = jsExprValue.startsWith(QUOTE_DELIMITER);
        if (!isDoubleQuoted && !isSingleQuoted) {
            return false;
        }
        if (jsExprValue.length() == 1) {
            return false;
        }
        String newStr = jsExprValue.substring(1);
        char quotation = '\'';
        if (isDoubleQuoted) {
            quotation = '\"';
        }
        return (start = ParameterValueUtil.searchQuotationMark(newStr, quotation)) == newStr.length();
    }

    /*
     * Unable to fully structure code
     */
    private static int searchQuotationMark(String str, char quotation) {
        tmpStr = str;
        index = tmpStr.indexOf(quotation);
        if (index != 0) ** GOTO lbl7
        return index + 1;
        while ((beforeChar = tmpStr.charAt(index - 1)) == '\\' && index != tmpStr.length() - 1) {
            index = tmpStr.indexOf(quotation, index + 1);
lbl7:
            // 2 sources

            if (index != -1) continue;
        }
        return index + 1;
    }
}

