/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.IAmbiguousAttribute;
import org.eclipse.birt.report.model.adapter.oda.impl.AmbiguousAttribute;
import org.eclipse.birt.report.model.adapter.oda.impl.CompareUtil;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultSetColumnChecker {
    List<IAmbiguousAttribute> ambiguousList;
    ColumnDefinition columnDefn = null;
    OdaResultSetColumnHandle columnHandle;

    ResultSetColumnChecker(ColumnDefinition columnDefn, OdaResultSetColumnHandle columnHandle) {
        if (columnDefn == null || columnHandle == null) {
            throw new IllegalArgumentException("The parameter definition and oda data set parameter handle can not be null!");
        }
        this.columnDefn = columnDefn;
        this.columnHandle = columnHandle;
        this.ambiguousList = new ArrayList<IAmbiguousAttribute>();
    }

    List<IAmbiguousAttribute> process() {
        DataElementAttributes dataAttrs = this.columnDefn.getAttributes();
        this.processDataElementAttributes(dataAttrs);
        return this.ambiguousList;
    }

    private void processDataElementAttributes(DataElementAttributes dataAttrs) {
        String oldValue;
        if (dataAttrs == null) {
            return;
        }
        String newValue = dataAttrs.getName();
        if (!CompareUtil.isEquals(newValue, oldValue = this.columnHandle.getNativeName())) {
            this.ambiguousList.add(new AmbiguousAttribute("nativeName", oldValue, newValue, false));
        }
        assert (dataAttrs.getPosition() == this.columnHandle.getPosition().intValue());
        int newNativeDataType = dataAttrs.getNativeDataTypeCode();
        Integer oldNativeDataType = this.columnHandle.getNativeDataType();
        if (!Integer.valueOf(newNativeDataType).equals(oldNativeDataType)) {
            this.ambiguousList.add(new AmbiguousAttribute("nativeDataType", oldNativeDataType, newNativeDataType, false));
        }
    }
}

