/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import org.eclipse.birt.report.model.adapter.oda.IODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.ODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.impl.AdapterUtil;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.DynamicValuesQuery;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterUIHints;
import org.eclipse.datatools.connectivity.oda.design.InputPromptControlStyle;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueChoices;
import org.eclipse.datatools.connectivity.oda.design.StaticValues;

class ReportParamUpdater {
    protected ScalarParameterHandle reportParam;
    protected ParameterDefinition currentParam;
    private OdaDataSetHandle setHandle;
    private OdaDataSetParameter newParam = null;
    protected final IODADesignFactory designFactory;

    ReportParamUpdater(ParameterDefinition currentParam, OdaDataSetParameter newParam, ScalarParameterHandle reportParam, OdaDataSetHandle setHandle) {
        this.currentParam = currentParam;
        this.reportParam = reportParam;
        this.newParam = newParam;
        this.setHandle = setHandle;
        this.designFactory = ODADesignFactory.getFactory();
    }

    public void process() throws SemanticException {
        String dataType = this.newParam.getDataType();
        CommandStack cmdStack = this.reportParam.getModuleHandle().getCommandStack();
        try {
            cmdStack.startTrans(null);
            if (dataType != null) {
                if (!"any".equalsIgnoreCase(dataType)) {
                    this.reportParam.setDataType(dataType);
                } else {
                    this.reportParam.setDataType("string");
                }
            }
            this.processDataSetParameter(this.currentParam);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    private void processDataSetParameter(ParameterDefinition param) throws SemanticException {
        DataElementAttributes dataAttrs = param.getAttributes();
        this.processDataElementAttributes(dataAttrs);
        InputParameterAttributes inputParamAttrs = param.getInputAttributes();
        this.processInputParameterAttributes(inputParamAttrs);
    }

    private void processDataElementAttributes(DataElementAttributes dataAttrs) throws SemanticException {
        if (dataAttrs == null) {
            return;
        }
        this.reportParam.setIsRequired(!dataAttrs.allowsNull());
        DataElementUIHints dataUIHints = dataAttrs.getUiHints();
        this.processDataElementUIHints(dataUIHints);
    }

    private void processDataElementUIHints(DataElementUIHints dataUiHints) throws SemanticException {
        if (dataUiHints == null) {
            return;
        }
        String displayName = dataUiHints.getDisplayName();
        this.reportParam.setPromptText(displayName);
        String description = dataUiHints.getDescription();
        this.reportParam.setHelpText(description);
    }

    private void processInputParameterAttributes(InputParameterAttributes attrs) throws SemanticException {
        if (attrs == null) {
            return;
        }
        InputElementAttributes inputElementAttrs = attrs.getElementAttributes();
        this.processInputElementAttributes(inputElementAttrs);
        InputParameterUIHints paramUIHints = attrs.getUiHints();
        this.processInputParameterUIHints(paramUIHints);
    }

    private void processInputParameterUIHints(InputParameterUIHints paramUiHints) throws SemanticException {
        if (paramUiHints == null) {
            return;
        }
        if (this.reportParam.getContainer() instanceof ParameterGroupHandle) {
            ParameterGroupHandle paramGroup = (ParameterGroupHandle)this.reportParam.getContainer();
            String groupPromptDisplayName = paramUiHints.getGroupPromptDisplayName();
            paramGroup.setDisplayName(groupPromptDisplayName);
        }
    }

    private void processInputElementAttributes(InputElementAttributes attrs) throws SemanticException {
        boolean isEnabled;
        if (attrs == null) {
            return;
        }
        this.reportParam.setIsRequired(!attrs.isOptional());
        this.reportParam.setConcealValue(attrs.isMasksValue());
        StaticValues values = attrs.getDefaultValues();
        this.processStaticValues(values);
        ScalarValueChoices choices = attrs.getStaticValueChoices();
        this.processScalarValueChoices(choices);
        DynamicValuesQuery valueQuery = attrs.getDynamicValueChoices();
        AdapterUtil.updateROMDyanmicList(valueQuery, null, (AbstractScalarParameterHandle)this.reportParam, this.setHandle);
        if (valueQuery == null) {
            valueQuery = this.designFactory.createDynamicValuesQuery();
        }
        if (isEnabled = valueQuery.isEnabled()) {
            this.reportParam.setValueType("dynamic");
        } else {
            this.reportParam.setValueType("static");
        }
        InputElementUIHints inputElementUIHints = attrs.getUiHints();
        this.processInputElementUIHints(inputElementUIHints);
    }

    private void processInputElementUIHints(InputElementUIHints inputElementUiHints) throws SemanticException {
        if (inputElementUiHints == null) {
            return;
        }
        this.reportParam.setAutoSuggestThreshold(inputElementUiHints.getAutoSuggestThreshold());
        InputPromptControlStyle style = inputElementUiHints.getPromptStyle();
        this.processInputPromptControlStyle(style);
    }

    private void processInputPromptControlStyle(InputPromptControlStyle style) throws SemanticException {
        this.reportParam.setControlType(style == null ? null : AdapterUtil.newROMControlType(style));
    }

    private void processStaticValues(StaticValues values) throws SemanticException {
        if (values == null) {
            return;
        }
        AdapterUtil.updateROMDefaultValues(values, (AbstractScalarParameterHandle)this.reportParam);
    }

    private void processScalarValueChoices(ScalarValueChoices choices) throws SemanticException {
        if (choices == null) {
            return;
        }
        AdapterUtil.updateROMSelectionList(choices, (AbstractScalarParameterHandle)this.reportParam);
    }
}

