/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.gen.internal2.JptGenMessages;
import org.eclipse.jpt.gen.internal2.JptGenPlugin;
import org.eclipse.jpt.gen.internal2.ORMGenCustomizer;
import org.eclipse.jpt.gen.internal2.ORMGenTable;
import org.eclipse.jpt.gen.internal2.OverwriteConfirmer;
import org.eclipse.jpt.gen.internal2.util.CompilationUnitModifier;
import org.eclipse.jpt.gen.internal2.util.FileUtil;
import org.eclipse.jpt.gen.internal2.util.UrlUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class PackageGenerator2 {
    private static final String LOGGER_NAME = "org.eclipse.jpt.entities.gen.log";
    private IJavaProject javaProject;
    private ORMGenCustomizer customizer;
    private static OverwriteConfirmer overwriteConfirmer = null;

    public static void setOverwriteConfirmer(OverwriteConfirmer confirmer) {
        overwriteConfirmer = confirmer;
    }

    public static void generate(IJavaProject jpaProject, ORMGenCustomizer customizer, IProgressMonitor monitor) throws CoreException {
        PackageGenerator2 generator = new PackageGenerator2();
        generator.setProject(jpaProject);
        generator.setCustomizer(customizer);
        try {
            generator.doGenerate(monitor);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jpt.gen", JptGenMessages.Error_Generating_Entities, (Throwable)e));
        }
    }

    private Object getCustomizer() {
        return this.customizer;
    }

    private void setCustomizer(ORMGenCustomizer customizer2) {
        this.customizer = customizer2;
    }

    private void setProject(IJavaProject proj) {
        this.javaProject = proj;
    }

    protected void doGenerate(IProgressMonitor monitor) throws Exception {
        this.generateInternal(monitor);
    }

    protected void generateInternal(IProgressMonitor progress) throws Exception {
        File templDir = this.prepareTemplatesFolder();
        ArrayList<String> genClasses = new ArrayList<String>();
        List<String> tableNames = this.customizer.getGenTableNames();
        String taskName = NLS.bind((String)JptGenMessages.EntityGenerator_taskName, (Object)("Total " + tableNames.size() + 2));
        progress.beginTask(taskName, tableNames.size() + 2);
        for (String tableName : tableNames) {
            ORMGenTable table = this.customizer.getTable(tableName);
            String className = table.getQualifiedClassName();
            this.generateClass(table, templDir.getAbsolutePath(), progress);
            progress.worked(1);
            genClasses.add(className);
            if (!table.isCompositeKey()) continue;
            genClasses.add(table.getQualifiedCompositeKeyClassName());
        }
        progress.done();
    }

    private File prepareTemplatesFolder() throws IOException, Exception, CoreException {
        String templatesPath;
        Path path;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jpt.gen");
        URL url = FileLocator.find((Bundle)bundle, (IPath)(path = new Path(templatesPath = "templates/entities/")), null);
        if (url == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jpt.gen", String.valueOf(JptGenMessages.Templates_notFound) + " " + "org.eclipse.jpt.gen" + "/" + templatesPath));
        }
        URL templUrl = FileLocator.resolve((URL)url);
        File templDir = null;
        templDir = UrlUtil.isJarUrl(templUrl) ? FileUtil.extractFilesFromBundle(templUrl, bundle, templatesPath) : UrlUtil.getUrlFile(templUrl);
        if (templDir == null || !templDir.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jpt.gen", String.valueOf(JptGenMessages.Templates_notFound) + " " + "org.eclipse.jpt.gen"));
        }
        return templDir;
    }

    protected void generateClass(ORMGenTable table, String templateDirPath, IProgressMonitor monitor) throws Exception {
        String subTaskName = NLS.bind((String)JptGenMessages.EntityGenerator_taskName, (Object)table.getName());
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)subTaskName, (int)100);
        try {
            IFolder javaPackageFolder = this.getJavaPackageFolder(table, monitor);
            IFile javaFile = javaPackageFolder.getFile(String.valueOf(table.getClassName()) + ".java");
            if (javaFile.exists() && overwriteConfirmer != null && !overwriteConfirmer.overwrite(javaFile.getName())) {
                return;
            }
            Logger logger = Logger.getLogger(LOGGER_NAME);
            logger.setLevel(Level.SEVERE);
            Properties vep = new Properties();
            vep.setProperty("file.resource.loader.path", templateDirPath);
            vep.setProperty("runtime.log.logsystem.jdk.logger", LOGGER_NAME);
            VelocityEngine ve = new VelocityEngine();
            ve.init(vep);
            sm.worked(20);
            this.generateJavaFile(table, javaFile, ve, "main.java.vm", true, monitor);
            sm.worked(80);
            if (table.isCompositeKey()) {
                IFile compositeKeyFile = javaPackageFolder.getFile(String.valueOf(table.getCompositeKeyClassName()) + ".java");
                this.generateJavaFile(table, compositeKeyFile, ve, "pk.java.vm", false, monitor);
            }
            javaFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Throwable e) {
            CoreException ce = new CoreException((IStatus)new Status(4, "org.eclipse.jpt.gen", String.valueOf(JptGenMessages.Templates_notFound) + "org.eclipse.jpt.gen", e));
            JptGenPlugin.logException(ce);
        }
        sm.setWorkRemaining(0);
    }

    private void generateJavaFile(ORMGenTable table, IFile javaFile, VelocityEngine ve, String templateName, boolean isDomainClass, IProgressMonitor monitor) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("table", (Object)table);
        context.put("customizer", this.getCustomizer());
        StringWriter w = new StringWriter();
        ve.mergeTemplate(templateName, (Context)context, (Writer)w);
        String fileContent = w.toString();
        if (javaFile.exists()) {
            if (isDomainClass) {
                this.updateExistingDomainClass(table.getQualifiedClassName(), javaFile, fileContent);
            } else {
                javaFile.setContents((InputStream)new ByteArrayInputStream(fileContent.getBytes()), true, true, monitor);
            }
        } else {
            this.createFile(javaFile, new ByteArrayInputStream(fileContent.getBytes()));
        }
    }

    protected void updateExistingDomainClass(String className, IFile javaFile, String fileContent) throws Exception {
        IJavaProject project = this.javaProject.getJavaProject();
        CompilationUnitModifier modifier = new CompilationUnitModifier(project, className);
        modifier.setJavaSource(fileContent);
        modifier.save();
    }

    public void createFile(IFile file, InputStream contents) throws CoreException {
        file.create(contents, false, null);
    }

    public IFolder getJavaPackageFolder(ORMGenTable table, IProgressMonitor monitor) throws CoreException {
        IPackageFragment packageFragment;
        IPackageFragmentRoot root = this.getDefaultJavaSrouceLocation(this.javaProject, table.getSourceFolder());
        String packageName = table.getPackage();
        if (packageName == null) {
            packageName = "";
        }
        if (!(packageFragment = root.getPackageFragment(packageName)).exists()) {
            root.createPackageFragment(packageName, true, monitor);
        }
        return (IFolder)packageFragment.getResource();
    }

    private IPackageFragmentRoot getDefaultJavaSrouceLocation(IJavaProject jproject, String sourceFolder) {
        IPackageFragmentRoot defaultSrcPath = null;
        if (jproject != null) {
            try {
                if (jproject.exists()) {
                    IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        if (roots[i].getKind() == 1) {
                            String path;
                            if (i == 0) {
                                defaultSrcPath = roots[i];
                            }
                            if ((path = roots[i].getPath().toString()).equals("/" + sourceFolder)) {
                                return roots[i];
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (JavaModelException e) {
                JptGenPlugin.logException((CoreException)e);
            }
        }
        return defaultSrcPath;
    }
}

