/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal2;

import java.io.Serializable;
import java.util.List;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.gen.internal2.AssociationRole;
import org.eclipse.jpt.gen.internal2.ORMGenColumn;
import org.eclipse.jpt.gen.internal2.ORMGenCustomizer;
import org.eclipse.jpt.gen.internal2.ORMGenTable;
import org.eclipse.jpt.gen.internal2.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Association
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String MANY_TO_ONE = "many-to-one";
    public static final String MANY_TO_MANY = "many-to-many";
    public static final String ONE_TO_ONE = "one-to-one";
    public static final String ONE_TO_MANY = "one-to-many";
    public static final String BI_DI = "bi-di";
    public static final String NORMAL_DI = "normal-di";
    public static final String OPPOSITE_DI = "opposite-di";
    private transient ORMGenCustomizer mCustomizer;
    private String mReferrerTableName;
    private String mReferencedTableName;
    private String mJoinTableName;
    private List<String> mReferrerColNames;
    private List<String> mReferencedColNames;
    private List<String> mReferrerJoinColNames;
    private List<String> mReferencedJoinColNames;
    private transient List<ORMGenColumn> mReferrerCols;
    private transient List<ORMGenColumn> mReferencedCols;
    private transient List<ORMGenColumn> mReferrerJoinCols;
    private transient List<ORMGenColumn> mReferencedJoinCols;
    private String mCardinality;
    private String mDirectionality;
    private byte mFlags = 1;
    private AssociationRole mReferrerRole;
    private AssociationRole mReferencedRole;
    private transient ForeignKey mForeignKey;
    private static final byte GENERATED = 1;
    private static final byte CUSTOM = 2;

    public Association(ORMGenCustomizer customizer, String referrerTableName, List<String> referrerColNames, String referencedTableName, List<String> referencedColNames) {
        this.mCustomizer = customizer;
        this.mReferrerTableName = referrerTableName;
        this.mReferencedTableName = referencedTableName;
        this.mReferrerColNames = referrerColNames;
        this.mReferencedColNames = referencedColNames;
        this.mCardinality = MANY_TO_ONE;
        this.mDirectionality = BI_DI;
        this.setCustom(true);
    }

    public Association(ORMGenCustomizer customizer, String referrerTableName, List<String> referrerColNames, String referencedTableName, List<String> referencedColNames, String joinTableName, List<String> referrerJoinColNames, List<String> referencedJoinColNames) {
        this.mCustomizer = customizer;
        this.mReferrerTableName = referrerTableName;
        this.mReferencedTableName = referencedTableName;
        this.mReferrerColNames = referrerColNames;
        this.mReferencedColNames = referencedColNames;
        this.mJoinTableName = joinTableName;
        this.mReferrerJoinColNames = referrerJoinColNames;
        this.mReferencedJoinColNames = referencedJoinColNames;
        this.mCardinality = MANY_TO_MANY;
        this.mDirectionality = BI_DI;
        this.setCustom(true);
    }

    public Association() {
    }

    public void computeCardinality() {
        this.mCardinality = MANY_TO_ONE;
        List<ORMGenColumn> referrerCols = this.getReferrerColumns();
        List<ORMGenColumn> pkCols = this.getReferrerTable().getPrimaryKeyColumns();
        if (pkCols.size() == referrerCols.size()) {
            boolean isFkPk = true;
            int i = 0;
            int n = pkCols.size();
            while (i < n) {
                if (!pkCols.get(i).getName().equals(referrerCols.get(i).getName())) {
                    isFkPk = false;
                    break;
                }
                ++i;
            }
            if (isFkPk) {
                this.mCardinality = ONE_TO_ONE;
            }
        }
        this.setCustom(false);
    }

    protected void restore(ORMGenCustomizer customizer) {
        this.mCustomizer = customizer;
        if (this.mReferrerRole != null) {
            this.mReferrerRole.restore(this);
        }
        if (this.mReferencedRole != null) {
            this.mReferencedRole.restore(this);
        }
    }

    public ORMGenTable getReferrerTable() {
        return this.mCustomizer.getTable(this.mReferrerTableName);
    }

    public String getReferrerTableName() {
        return this.mReferrerTableName;
    }

    public ORMGenTable getReferencedTable() {
        return this.mCustomizer.getTable(this.mReferencedTableName);
    }

    public String getReferencedTableName() {
        return this.mReferencedTableName;
    }

    public ORMGenTable getJoinTable() {
        return this.mCustomizer.getTable(this.mJoinTableName);
    }

    public String getJoinTableName() {
        return this.mJoinTableName;
    }

    public List<ORMGenColumn> getReferrerColumns() {
        if (this.mReferrerCols == null) {
            ORMGenTable referrerTable = this.getReferrerTable();
            this.mReferrerCols = referrerTable.getColumnsByNames(this.mReferrerColNames);
        }
        return this.mReferrerCols;
    }

    public List<String> getReferrerColumnNames() {
        return this.mReferrerColNames;
    }

    public List<ORMGenColumn> getReferencedColumns() {
        if (this.mReferencedCols == null) {
            this.mReferencedCols = this.getReferencedTable().getColumnsByNames(this.mReferencedColNames);
        }
        return this.mReferencedCols;
    }

    public List<String> getReferencedColumnNames() {
        return this.mReferencedColNames;
    }

    public List<ORMGenColumn> getReferrerJoinColumns() {
        if (this.mReferrerJoinCols == null) {
            this.mReferrerJoinCols = this.getJoinTable().getColumnsByNames(this.mReferrerJoinColNames);
        }
        return this.mReferrerJoinCols;
    }

    public List<String> getReferrerJoinColumnNames() {
        return this.mReferrerJoinColNames;
    }

    public List<ORMGenColumn> getReferencedJoinColumns() {
        if (this.mReferencedJoinCols == null) {
            this.mReferencedJoinCols = this.getJoinTable().getColumnsByNames(this.mReferencedJoinColNames);
        }
        return this.mReferencedJoinCols;
    }

    public List<String> getReferencedJoinColumnNames() {
        return this.mReferencedJoinColNames;
    }

    public String getCardinality() {
        return this.mCardinality;
    }

    public void setCardinality(String cardinality) {
        assert (cardinality.equals(MANY_TO_ONE) || cardinality.equals(MANY_TO_MANY) || cardinality.equals(ONE_TO_ONE) || cardinality.equals(ONE_TO_MANY));
        this.mCardinality = cardinality;
    }

    public String getDirectionality() {
        return this.mDirectionality;
    }

    public void setDirectionality(String dir) {
        assert (dir.equals(BI_DI) || dir.equals(NORMAL_DI) || dir.equals(OPPOSITE_DI));
        if (!dir.equals(this.mDirectionality)) {
            this.mDirectionality = dir;
            if (dir.equals(NORMAL_DI)) {
                this.mReferencedRole = null;
            } else if (dir.equals(OPPOSITE_DI)) {
                this.mReferrerRole = null;
            }
        }
    }

    public boolean isBidirectional() {
        return this.mDirectionality.equals(BI_DI);
    }

    public boolean isGenerated() {
        return (this.mFlags & 1) != 0;
    }

    public void setGenerated(boolean generated) {
        if (generated != this.isGenerated()) {
            this.mFlags = generated ? (byte)(this.mFlags | 1) : (byte)(this.mFlags & 0xFFFFFFFE);
            this.mReferencedRole = null;
            this.mReferrerRole = null;
        }
    }

    public boolean isCustom() {
        return (this.mFlags & 2) != 0;
    }

    public void setCustom(boolean custom) {
        this.mFlags = custom ? (byte)(this.mFlags | 2) : (byte)(this.mFlags & 0xFFFFFFFD);
    }

    public AssociationRole getReferrerRole() {
        if (this.mReferrerRole == null && this.isGenerated() && !this.getDirectionality().equals(OPPOSITE_DI)) {
            this.mReferrerRole = new AssociationRole(this, true);
        }
        return this.mReferrerRole;
    }

    public AssociationRole getReferencedRole() {
        if (this.mReferencedRole == null && this.isGenerated() && !this.getDirectionality().equals(NORMAL_DI)) {
            this.mReferencedRole = new AssociationRole(this, false);
        }
        return this.mReferencedRole;
    }

    protected boolean isValid() {
        if (!this.isValidTableAndColumns(this.mReferrerTableName, this.mReferrerColNames) || !this.isValidTableAndColumns(this.mReferencedTableName, this.mReferencedColNames)) {
            return false;
        }
        return this.mJoinTableName == null || this.isValidTableAndColumns(this.mJoinTableName, this.mReferrerJoinColNames) && this.isValidTableAndColumns(this.mJoinTableName, this.mReferencedJoinColNames);
    }

    private boolean isValidTableAndColumns(String tableName, List<String> columnNames) {
        ORMGenTable table = this.mCustomizer.getTable(tableName);
        if (table == null) {
            return false;
        }
        int i = 0;
        int n = columnNames.size();
        while (i < n) {
            String colName = columnNames.get(i);
            if (table.getColumnByName(colName) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setForeignKey(ForeignKey foreignKey) {
        this.mForeignKey = foreignKey;
    }

    public ForeignKey getForeignKey() {
        return this.mForeignKey;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Association) {
            Association association2 = (Association)obj;
            if (!(this.getReferrerTableName().equals(association2.getReferrerTableName()) && this.getReferencedTableName().equals(association2.getReferencedTableName()) && StringUtil.equalObjects(this.getJoinTableName(), association2.getJoinTableName()) && this.getReferrerColumnNames().equals(association2.getReferrerColumnNames()) && this.getReferencedColumnNames().equals(association2.getReferencedColumnNames()))) {
                return false;
            }
            if (this.getJoinTableName() == null) {
                return true;
            }
            if (this.getReferrerJoinColumnNames().equals(association2.getReferrerJoinColumnNames()) && this.getReferencedJoinColumnNames().equals(association2.getReferencedJoinColumnNames())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.mReferrerTableName) + " " + this.mCardinality + " " + this.mReferencedTableName;
    }
}

