/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.gen.internal.EntityGenTools;
import org.eclipse.jpt.gen.internal.EntityGenerator;
import org.eclipse.jpt.gen.internal.GenScope;
import org.eclipse.jpt.gen.internal.ManyToManyRelation;
import org.eclipse.jpt.gen.internal.ManyToOneRelation;
import org.eclipse.jpt.gen.internal.OneToManyRelation;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenTable {
    private final GenScope scope;
    private final Table table;
    private ManyToManyRelation joinTableRelation;
    private final ArrayList<ManyToManyRelation> ownedManyToManyRelations = new ArrayList();
    private final ArrayList<ManyToManyRelation> nonOwnedManyToManyRelations = new ArrayList();
    private final ArrayList<ManyToOneRelation> manyToOneRelations = new ArrayList();
    private final ArrayList<OneToManyRelation> oneToManyRelations = new ArrayList();
    private final HashSet<Column> foreignKeyColumns = new HashSet();
    private final HashSet<String> attributeNames = new HashSet();
    private String attributeNameForEmbeddedId;
    private final HashMap<Column, String> basicAttributeNames = new HashMap();
    private final HashMap<ManyToOneRelation, String> manyToOneAttributeNames = new HashMap();
    private final HashMap<OneToManyRelation, String> oneToManyAttributeNames = new HashMap();
    private final HashMap<ManyToManyRelation, String> ownedManyToManyAttributeNames = new HashMap();
    private final HashMap<ManyToManyRelation, String> nonOwnedManyToManyAttributeNames = new HashMap();

    GenTable(GenScope scope, Table table) {
        this.scope = scope;
        this.table = table;
    }

    EntityGenerator.Config getEntityConfig() {
        return this.scope.getEntityConfig();
    }

    String getCollectionAttributeName() {
        String name = this.getName();
        String suffix = this.getEntityConfig().getCollectionAttributeNameSuffix();
        if (StringTools.stringIsUppercase((String)name)) {
            suffix = String.valueOf('_') + suffix.toUpperCase();
        }
        return String.valueOf(name) + suffix;
    }

    void buildJoinTableRelation() {
        if (!this.table.isPossibleJoinTable()) {
            return;
        }
        ForeignKey owningFK = this.table.getJoinTableOwningForeignKey();
        GenTable owningGenTable = this.scope.getGenTable(owningFK.getReferencedTable());
        if (owningGenTable == null) {
            return;
        }
        ForeignKey nonOwningFK = this.table.getJoinTableNonOwningForeignKey();
        GenTable nonOwningGenTable = this.scope.getGenTable(nonOwningFK.getReferencedTable());
        if (nonOwningGenTable == null) {
            return;
        }
        this.joinTableRelation = new ManyToManyRelation(this, owningFK, owningGenTable, nonOwningFK, nonOwningGenTable);
    }

    void addReferencedGenTablesTo(Set<GenTable> referencedTables) {
        Iterator stream = this.table.foreignKeys();
        while (stream.hasNext()) {
            ForeignKey fk = (ForeignKey)stream.next();
            GenTable genTable = this.scope.getGenTable(fk.getReferencedTable());
            if (genTable == null) continue;
            referencedTables.add(genTable);
        }
    }

    void clearJoinTableRelation() {
        this.joinTableRelation.clear();
        this.joinTableRelation = null;
    }

    void buildManyToOneRelations() {
        Iterator stream = this.table.foreignKeys();
        while (stream.hasNext()) {
            ForeignKey fk = (ForeignKey)stream.next();
            GenTable referencedGenTable = this.scope.getGenTable(fk.getReferencedTable());
            if (referencedGenTable == null) continue;
            this.manyToOneRelations.add(new ManyToOneRelation(this, fk, referencedGenTable));
        }
    }

    void buildAttributeNames() {
        this.buildAttributeNameForEmbeddedId();
        HashSet columns = CollectionTools.set((Iterator)this.table.columns(), (int)this.table.columnsSize());
        this.buildManyToOneAttributeNames(columns);
        this.buildBasicAttributeNames(columns);
        this.buildOneToManyAttributeNames();
        this.buildOwnedManyToManyAttributeNames();
        this.buildNonOwnedManyToManyAttributeNames();
    }

    Iterator<Column> readOnlyPrimaryKeyColumns() {
        return new FilteringIterator<Column, Column>(this.table.primaryKeyColumns()){

            protected boolean accept(Column pkColumn) {
                return pkColumn.isPartOfForeignKey();
            }
        };
    }

    Iterator<Column> writablePrimaryKeyColumns() {
        return new FilteringIterator<Column, Column>(this.table.primaryKeyColumns()){

            protected boolean accept(Column pkColumn) {
                return !pkColumn.isPartOfForeignKey();
            }
        };
    }

    Iterator<Column> nonPrimaryKeyBasicColumns() {
        return new FilteringIterator<Column, Column>(this.table.columns()){

            protected boolean accept(Column column) {
                return !column.isPartOfPrimaryKey() && !column.isPartOfForeignKey();
            }
        };
    }

    Table getTable() {
        return this.table;
    }

    String getEntityName() {
        return this.getEntityConfig().getEntityName(this.table);
    }

    boolean isJoinTable() {
        return this.joinTableRelation != null;
    }

    void addOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.ownedManyToManyRelations.add(relation);
    }

    void removeOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.ownedManyToManyRelations.remove(relation);
    }

    void addNonOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.nonOwnedManyToManyRelations.add(relation);
    }

    void removeNonOwnedManyToManyRelation(ManyToManyRelation relation) {
        this.nonOwnedManyToManyRelations.remove(relation);
    }

    void addOneToManyRelation(OneToManyRelation relation) {
        this.oneToManyRelations.add(relation);
    }

    Iterator<ManyToOneRelation> manyToOneRelations() {
        return this.manyToOneRelations.iterator();
    }

    Iterator<OneToManyRelation> oneToManyRelations() {
        return this.oneToManyRelations.iterator();
    }

    Iterator<ManyToManyRelation> ownedManyToManyRelations() {
        return this.ownedManyToManyRelations.iterator();
    }

    Iterator<ManyToManyRelation> nonOwnedManyToManyRelations() {
        return this.nonOwnedManyToManyRelations.iterator();
    }

    String getAttributeNameForEmbeddedId() {
        return this.attributeNameForEmbeddedId;
    }

    String getAttributeNameFor(Column column) {
        return this.basicAttributeNames.get(column);
    }

    String getAttributeNameFor(ManyToOneRelation relation) {
        return this.manyToOneAttributeNames.get(relation);
    }

    String getAttributeNameFor(OneToManyRelation relation) {
        return this.oneToManyAttributeNames.get(relation);
    }

    String getAttributeNameForOwned(ManyToManyRelation relation) {
        return this.ownedManyToManyAttributeNames.get(relation);
    }

    String getAttributeNameForNonOwned(ManyToManyRelation relation) {
        return this.nonOwnedManyToManyAttributeNames.get(relation);
    }

    String getName() {
        return this.table.getName();
    }

    boolean joinTableNameIsDefault() {
        return this.table.joinTableNameIsDefault();
    }

    private void buildAttributeNameForEmbeddedId() {
        if (this.table.primaryKeyColumnsSize() > 1 && this.getEntityConfig().generateEmbeddedIdForCompoundPK()) {
            this.attributeNameForEmbeddedId = this.configureAttributeName(this.getEntityConfig().getEmbeddedIdAttributeName());
        }
    }

    private void buildManyToOneAttributeNames(Set<Column> columns) {
        for (ManyToOneRelation relation : this.manyToOneRelations) {
            CollectionTools.removeAll(columns, (Iterator)relation.getForeignKey().nonPrimaryKeyBaseColumns());
            CollectionTools.addAll(this.foreignKeyColumns, (Iterator)relation.getForeignKey().baseColumns());
            String attributeName = this.configureAttributeName(relation.getAttributeName());
            relation.setMappedBy(attributeName);
            this.manyToOneAttributeNames.put(relation, attributeName);
        }
    }

    private void buildBasicAttributeNames(Set<Column> columns) {
        for (Column column : columns) {
            String attributeName = this.configureAttributeName(column.getName());
            this.basicAttributeNames.put(column, attributeName);
        }
    }

    private void buildOneToManyAttributeNames() {
        for (OneToManyRelation relation : this.oneToManyRelations) {
            String attributeName = this.configureAttributeName(relation.getAttributeName());
            this.oneToManyAttributeNames.put(relation, attributeName);
        }
    }

    private void buildOwnedManyToManyAttributeNames() {
        for (ManyToManyRelation relation : this.ownedManyToManyRelations) {
            String attributeName = this.configureAttributeName(relation.getOwnedAttributeName());
            relation.setMappedBy(attributeName);
            this.ownedManyToManyAttributeNames.put(relation, attributeName);
        }
    }

    private void buildNonOwnedManyToManyAttributeNames() {
        for (ManyToManyRelation relation : this.nonOwnedManyToManyRelations) {
            String attributeName = this.configureAttributeName(relation.getNonOwnedAttributeName());
            this.nonOwnedManyToManyAttributeNames.put(relation, attributeName);
        }
    }

    private String configureAttributeName(String attributeName) {
        String result = attributeName;
        if (this.getEntityConfig().convertToJavaStyleIdentifiers()) {
            result = EntityGenTools.convertToUniqueJavaStyleAttributeName(result, this.attributeNames);
        } else {
            result = NameTools.convertToJavaIdentifier((String)result);
            result = NameTools.uniqueNameForIgnoreCase((String)attributeName, this.attributeNames);
        }
        this.attributeNames.add(result);
        return result;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.table);
    }
}

