/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.olap.api.query.ICubeElementFactory;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.SortElementHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrosstabQueryUtil
implements ICrosstabConstants {
    private static ICubeElementFactory factory = null;

    private CrosstabQueryUtil() {
    }

    public static synchronized ICubeElementFactory getCubeElementFactory() throws BirtException {
        if (factory != null) {
            return factory;
        }
        try {
            Class<?> cls = Class.forName("org.eclipse.birt.data.engine.olap.impl.query.CubeElementFactory");
            factory = (ICubeElementFactory)cls.newInstance();
        }
        catch (Exception e) {
            throw new CrosstabException(e);
        }
        return factory;
    }

    public static ICubeQueryDefinition createCubeQuery(CrosstabReportItemHandle crosstabItem, IDataQueryDefinition parentQuery, boolean needMeasure, boolean needRowDimension, boolean needColumnDimension, boolean needBinding, boolean needSorting, boolean needFilter) throws BirtException {
        ICubeQueryDefinition cubeQuery = CrosstabQueryUtil.getCubeElementFactory().createCubeQuery(crosstabItem.getCubeName());
        ArrayList<String> rowLevelNameList = new ArrayList<String>();
        ArrayList<String> columnLevelNameList = new ArrayList<String>();
        ArrayList<LevelViewHandle> levelViewList = new ArrayList<LevelViewHandle>();
        HashMap<LevelHandle, ILevelDefinition> levelMapping = new HashMap<LevelHandle, ILevelDefinition>();
        DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
        try {
            IModelAdapter modelAdapter = session.getModelAdaptor();
            if (needMeasure) {
                int i = 0;
                while (i < crosstabItem.getMeasureCount()) {
                    MeasureViewHandle mv = crosstabItem.getMeasure(i);
                    if (!(mv instanceof ComputedMeasureViewHandle)) {
                        if (mv.getCubeMeasure() == null) {
                            throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.measure", mv.getCubeMeasureName()));
                        }
                        IMeasureDefinition mDef = cubeQuery.createMeasure(mv.getCubeMeasure().getName());
                        mDef.setAggrFunction(mv.getCubeMeasure().getFunction() == null ? null : DataAdapterUtil.getRollUpAggregationName((String)mv.getCubeMeasure().getFunction()));
                        CrosstabQueryUtil.addFactTableOrMeasureFilter(mv.filtersIterator(), cubeQuery, modelAdapter);
                    }
                    ++i;
                }
            }
            if (needRowDimension && crosstabItem.getDimensionCount(0) > 0) {
                CrosstabQueryUtil.addEdgeDefinition(cubeQuery, crosstabItem, 0, rowLevelNameList, levelViewList, levelMapping);
            }
            if (needColumnDimension && crosstabItem.getDimensionCount(1) > 0) {
                CrosstabQueryUtil.addEdgeDefinition(cubeQuery, crosstabItem, 1, columnLevelNameList, levelViewList, levelMapping);
            }
            CrosstabQueryUtil.addFactTableOrMeasureFilter(crosstabItem.filtersIterator(), cubeQuery, modelAdapter);
            if (needSorting) {
                CrosstabQueryUtil.addLevelSorting(levelViewList, levelMapping, cubeQuery, modelAdapter);
            }
            if (needFilter) {
                CrosstabQueryUtil.addLevelFilter(levelViewList, levelMapping, cubeQuery, modelAdapter);
            }
            if (needBinding) {
                Iterator bindingItr = ((ExtendedItemHandle)crosstabItem.getModelHandle()).columnBindingsIterator();
                ModuleHandle module = ((ExtendedItemHandle)crosstabItem.getModelHandle()).getModuleHandle();
                if (bindingItr != null) {
                    HashMap<String, String> cache = new HashMap<String, String>();
                    while (bindingItr.hasNext()) {
                        ComputedColumnHandle column = (ComputedColumnHandle)bindingItr.next();
                        Binding binding = new Binding(column.getName());
                        binding.setAggrFunction(column.getAggregateFunction() == null ? null : DataAdapterUtil.adaptModelAggregationType((String)column.getAggregateFunction()));
                        binding.setExpression((IBaseExpression)modelAdapter.adaptExpression((Expression)column.getExpressionProperty("expression").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                        binding.setDataType(DataAdapterUtil.adaptModelDataType((String)column.getDataType()));
                        if (column.getFilterExpression() != null) {
                            binding.setFilter((IBaseExpression)modelAdapter.adaptExpression((Expression)column.getExpressionProperty("filterExpr").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                        }
                        Iterator argItr = column.argumentsIterator();
                        while (argItr.hasNext()) {
                            AggregationArgumentHandle aah = (AggregationArgumentHandle)argItr.next();
                            if (aah.getValue() == null) continue;
                            binding.addArgument(aah.getName(), (IBaseExpression)modelAdapter.adaptExpression((Expression)aah.getExpressionProperty("value").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                        }
                        List aggrList = column.getAggregateOnList();
                        if (aggrList != null) {
                            for (String baseLevel : aggrList) {
                                CrosstabUtil.addHierachyAggregateOn(module, binding, baseLevel, rowLevelNameList, columnLevelNameList, cache);
                            }
                        }
                        cubeQuery.addBinding((IBinding)binding);
                    }
                }
            }
        }
        finally {
            session.shutdown();
        }
        return cubeQuery;
    }

    private static void addEdgeDefinition(ICubeQueryDefinition cubeQuery, CrosstabReportItemHandle crosstabItem, int axis, List<String> levelNameList, List<LevelViewHandle> levelViewList, Map<LevelHandle, ILevelDefinition> levelMapping) throws BirtException {
        List members;
        IEdgeDefinition edge = cubeQuery.createEdge(axis == 1 ? 2 : 1);
        LevelHandle mirrorLevel = crosstabItem.getCrosstabView(axis).getMirroredStartingLevel();
        int i = 0;
        while (i < crosstabItem.getDimensionCount(axis)) {
            DimensionViewHandle dv = crosstabItem.getDimension(axis, i);
            if (dv.getCubeDimension() == null) {
                if (axis == 1) {
                    throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.dimension.column", dv.getCubeDimensionName()));
                }
                throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.dimension.row", dv.getCubeDimensionName()));
            }
            IDimensionDefinition dimDef = edge.createDimension(dv.getCubeDimension().getName());
            IHierarchyDefinition hieDef = dimDef.createHierarchy(dv.getCubeDimension().getDefaultHierarchy().getName());
            int j = 0;
            while (j < dv.getLevelCount()) {
                LevelViewHandle lv = dv.getLevel(j);
                if (lv.getCubeLevel() == null) {
                    if (axis == 1) {
                        throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.level.column", lv.getCubeLevelName()));
                    }
                    throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.level.row", lv.getCubeLevelName()));
                }
                ILevelDefinition levelDef = hieDef.createLevel(lv.getCubeLevel().getName());
                levelNameList.add(lv.getCubeLevel().getFullName());
                if (mirrorLevel != null && mirrorLevel.getQualifiedName().equals(lv.getCubeLevelName())) {
                    edge.setMirrorStartingLevel(levelDef);
                }
                levelViewList.add(lv);
                levelMapping.put(lv.getCubeLevel(), levelDef);
                ++j;
            }
            ++i;
        }
        CrosstabViewHandle view = crosstabItem.getCrosstabView(axis);
        if (view != null && (members = view.getMembers()) != null && members.size() > 0) {
            int i2 = 0;
            while (i2 < members.size()) {
                MemberValueHandle mvh = (MemberValueHandle)members.get(i2);
                if (mvh != null) {
                    CrosstabQueryUtil.addDrillDefinition(edge, mvh, levelMapping);
                }
                ++i2;
            }
        }
    }

    private static void addDrillDefinition(IEdgeDefinition edge, MemberValueHandle member, Map<LevelHandle, ILevelDefinition> levelMapping) {
        IHierarchyDefinition targetHierarchy = null;
        String targetLevelName = null;
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        Object[] output = new Object[]{targetLevelName, targetHierarchy};
        CrosstabQueryUtil.traverseDrillMember(output, member, levelMapping, values, 0);
        targetLevelName = (String)output[0];
        targetHierarchy = (IHierarchyDefinition)output[1];
        IEdgeDrillFilter drillDef = edge.createDrillFilter(null);
        drillDef.setTargetHierarchy(targetHierarchy);
        drillDef.setTargetLevelName(targetLevelName);
        ArrayList<Object[]> tuples = new ArrayList<Object[]>();
        int i = 0;
        while (i < values.size()) {
            List vals = (List)values.get(i);
            if (vals == null || vals.size() == 0) {
                tuples.add(null);
            } else {
                tuples.add(vals.toArray(new Object[vals.size()]));
            }
            ++i;
        }
        drillDef.setTuple(tuples);
    }

    /*
     * Unable to fully structure code
     */
    private static void traverseDrillMember(Object[] output, MemberValueHandle member, Map<LevelHandle, ILevelDefinition> levelMapping, List<List<Object>> values, int depth) {
        targetLevel = member.getLevel();
        if (targetLevel != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            values.add(new ArrayList<E>());
lbl6:
            // 2 sources

            ** while (depth >= values.size())
        }
lbl7:
        // 1 sources

        val = member.getValue();
        if (val != null) {
            vals = values.get(depth);
            vals.add(val);
        }
        targetLevelDef = levelMapping.get(targetLevel);
        output[0] = targetLevel.getName();
        if (targetLevelDef != null) {
            output[1] = targetLevelDef.getHierarchy();
        }
        if ((children = member.getContents("memberValues")) != null) {
            i = 0;
            while (i < children.size()) {
                child = (MemberValueHandle)children.get(i);
                if (child != null) {
                    CrosstabQueryUtil.traverseDrillMember(output, child, levelMapping, values, depth + 1);
                }
                ++i;
            }
        }
    }

    private static void addMembers(Map<LevelHandle, ILevelDefinition> levelMapping, List<ILevelDefinition> levels, List<Object> values, MemberValueHandle member) {
        ILevelDefinition levelDef;
        if (member != null && (levelDef = levelMapping.get(member.getLevel())) != null) {
            levels.add(levelDef);
            values.add(member.getValue());
            if (member.getContentCount("memberValues") > 0) {
                CrosstabQueryUtil.addMembers(levelMapping, levels, values, (MemberValueHandle)member.getContent("memberValues", 0));
            }
        }
    }

    private static void addLevelSorting(List<LevelViewHandle> levelViews, Map<LevelHandle, ILevelDefinition> levelMapping, ICubeQueryDefinition cubeQuery, IModelAdapter modelAdapter) throws BirtException {
        ArrayList<ILevelDefinition> levels = new ArrayList<ILevelDefinition>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (LevelViewHandle lv : levelViews) {
            Iterator sortItr = lv.sortsIterator();
            if (sortItr == null) continue;
            while (sortItr.hasNext()) {
                SortElementHandle sortKey = (SortElementHandle)sortItr.next();
                levels.clear();
                values.clear();
                CrosstabQueryUtil.addMembers(levelMapping, levels, values, sortKey.getMember());
                ILevelDefinition[] qualifyLevels = null;
                Object[] qualifyValues = null;
                if (levels.size() > 0) {
                    qualifyLevels = levels.toArray(new ILevelDefinition[levels.size()]);
                    qualifyValues = values.toArray(new Object[values.size()]);
                }
                ICubeSortDefinition sortDef = CrosstabQueryUtil.getCubeElementFactory().createCubeSortDefinition((IScriptExpression)modelAdapter.adaptExpression((Expression)sortKey.getExpressionProperty("key").getValue(), IModelAdapter.ExpressionLocation.CUBE), levelMapping.get(lv.getCubeLevel()), qualifyLevels, qualifyValues, DataAdapterUtil.adaptModelSortDirection((String)sortKey.getDirection()));
                sortDef.setSortLocale(sortKey.getLocale());
                sortDef.setSortStrength(sortKey.getStrength());
                cubeQuery.addSort((ISortDefinition)sortDef);
            }
        }
    }

    private static void addLevelFilter(List<LevelViewHandle> levelViews, Map<LevelHandle, ILevelDefinition> levelMapping, ICubeQueryDefinition cubeQuery, IModelAdapter modelAdapter) throws BirtException {
        ArrayList<ILevelDefinition> levels = new ArrayList<ILevelDefinition>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (LevelViewHandle lv : levelViews) {
            Iterator filterItr = lv.filtersIterator();
            if (filterItr == null) continue;
            while (filterItr.hasNext()) {
                ConditionalExpression filterCondExpr;
                FilterConditionElementHandle filterCon = (FilterConditionElementHandle)filterItr.next();
                levels.clear();
                values.clear();
                CrosstabQueryUtil.addMembers(levelMapping, levels, values, filterCon.getMember());
                ILevelDefinition[] qualifyLevels = null;
                Object[] qualifyValues = null;
                if (levels.size() > 0) {
                    qualifyLevels = levels.toArray(new ILevelDefinition[levels.size()]);
                    qualifyValues = values.toArray(new Object[values.size()]);
                }
                if (ModuleUtil.isListFilterValue((FilterConditionElementHandle)filterCon)) {
                    filterCondExpr = new ConditionalExpression((IScriptExpression)modelAdapter.adaptExpression((Expression)filterCon.getExpressionProperty("expr").getValue(), IModelAdapter.ExpressionLocation.CUBE), DataAdapterUtil.adaptModelFilterOperator((String)filterCon.getOperator()), filterCon.getValue1ExpressionList().getListValue());
                } else {
                    Expression value1 = null;
                    List val1list = filterCon.getValue1ExpressionList().getListValue();
                    if (val1list != null && val1list.size() > 0) {
                        value1 = (Expression)val1list.get(0);
                    }
                    filterCondExpr = new ConditionalExpression((IScriptExpression)modelAdapter.adaptExpression((Expression)filterCon.getExpressionProperty("expr").getValue(), IModelAdapter.ExpressionLocation.CUBE), DataAdapterUtil.adaptModelFilterOperator((String)filterCon.getOperator()), (IBaseExpression)modelAdapter.adaptExpression(value1, IModelAdapter.ExpressionLocation.CUBE), (IBaseExpression)modelAdapter.adaptExpression((Expression)filterCon.getExpressionProperty("value2").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                }
                ICubeFilterDefinition filterDef = CrosstabQueryUtil.getCubeElementFactory().creatCubeFilterDefinition((IBaseExpression)filterCondExpr, levelMapping.get(lv.getCubeLevel()), qualifyLevels, qualifyValues);
                cubeQuery.addFilter((IFilterDefinition)filterDef);
            }
        }
    }

    private static void addFactTableOrMeasureFilter(Iterator<FilterConditionElementHandle> filters, ICubeQueryDefinition cubeQuery, IModelAdapter modelAdapter) throws BirtException {
        if (filters != null) {
            while (filters.hasNext()) {
                ConditionalExpression filterCondExpr;
                FilterConditionElementHandle filterCon = filters.next();
                if (ModuleUtil.isListFilterValue((FilterConditionElementHandle)filterCon)) {
                    filterCondExpr = new ConditionalExpression((IScriptExpression)modelAdapter.adaptExpression((Expression)filterCon.getExpressionProperty("expr").getValue(), IModelAdapter.ExpressionLocation.CUBE), DataAdapterUtil.adaptModelFilterOperator((String)filterCon.getOperator()), filterCon.getValue1ExpressionList().getListValue());
                } else {
                    Expression value1 = null;
                    List val1list = filterCon.getValue1ExpressionList().getListValue();
                    if (val1list != null && val1list.size() > 0) {
                        value1 = (Expression)val1list.get(0);
                    }
                    filterCondExpr = new ConditionalExpression((IScriptExpression)modelAdapter.adaptExpression((Expression)filterCon.getExpressionProperty("expr").getValue(), IModelAdapter.ExpressionLocation.CUBE), DataAdapterUtil.adaptModelFilterOperator((String)filterCon.getOperator()), (IBaseExpression)modelAdapter.adaptExpression(value1, IModelAdapter.ExpressionLocation.CUBE), (IBaseExpression)modelAdapter.adaptExpression((Expression)filterCon.getExpressionProperty("value2").getValue(), IModelAdapter.ExpressionLocation.CUBE));
                }
                ICubeFilterDefinition filterDef = CrosstabQueryUtil.getCubeElementFactory().creatCubeFilterDefinition((IBaseExpression)filterCondExpr, null, null, null);
                cubeQuery.addFilter((IFilterDefinition)filterDef);
            }
        }
    }
}

