/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script;

import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugTarget;
import org.eclipse.birt.report.debug.internal.script.model.ScriptStackFrame;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public class ScriptWatchExpressionDelegate
implements IWatchExpressionDelegate {
    private IWatchExpressionListener fListener;

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        this.fListener = listener;
        IStackFrame frame = null;
        if (context instanceof IStackFrame) {
            frame = (IStackFrame)context;
        } else if (context instanceof IThread) {
            try {
                frame = ((IThread)context).getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        final IStackFrame tempFrame = frame;
        final String tempStr = expression;
        IWatchExpressionResult watchResult = new IWatchExpressionResult(){

            public IValue getValue() {
                if (tempFrame != null) {
                    return ((ScriptDebugTarget)tempFrame.getDebugTarget()).evaluate((ScriptStackFrame)tempFrame, tempStr);
                }
                return null;
            }

            public boolean hasErrors() {
                return this.getValue() == null;
            }

            public String[] getErrorMessages() {
                return new String[]{"(Watch expressions not supported)"};
            }

            public String getExpressionText() {
                return tempStr;
            }

            public DebugException getException() {
                return null;
            }
        };
        if (frame == null) {
            this.fListener.watchEvaluationFinished(watchResult);
        } else {
            this.fListener.watchEvaluationFinished(watchResult);
        }
    }
}

