/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script;

import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugTarget;
import org.eclipse.birt.report.debug.internal.script.model.ScriptModelPresentation;
import org.eclipse.birt.report.debug.internal.script.model.ScriptStackFrame;
import org.eclipse.birt.report.debug.internal.script.model.ScriptValue;
import org.eclipse.birt.report.debug.internal.ui.script.util.ScriptDebugUtil;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class ScriptDebugHover
implements ITextHoverExtension,
ITextHover {
    static /* synthetic */ Class class$0;

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String variableName;
        ScriptStackFrame frame;
        block6: {
            frame = this.getFrame();
            if (frame == null) {
                return null;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return null;
            }
            try {
                String str = TextUtilities.getContentType((IDocument)document, (String)"__dftl_partitioning", (int)(hoverRegion.getOffset() + 1), (boolean)true);
                variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                if (!"__js_keyword".equals(str) || "this".equals(variableName)) break block6;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        ScriptValue var = ((ScriptDebugTarget)frame.getDebugTarget()).evaluate(frame, variableName);
        if (var != null) {
            return ScriptDebugHover.getVariableText(var);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return ScriptDebugUtil.findWord(textViewer.getDocument(), offset);
    }

    private static String replaceHTMLChars(String variableText) {
        StringBuffer buffer = new StringBuffer(variableText.length());
        char[] characters = variableText.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            switch (character) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(character);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private static String getVariableText(ScriptValue variable) {
        StringBuffer buffer = new StringBuffer();
        ScriptModelPresentation modelPresentation = new ScriptModelPresentation();
        buffer.append("<p><pre>");
        String variableText = modelPresentation.getVariableText(variable);
        buffer.append(ScriptDebugHover.replaceHTMLChars(variableText));
        buffer.append("</pre></p>");
        modelPresentation.dispose();
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    private ScriptStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.debug.internal.script.model.ScriptStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ScriptStackFrame)((Object)adaptable.getAdapter((Class)clazz));
        }
        return null;
    }
}

