/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util.copy;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.util.IElementCopy;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.strategy.DummyCopyPolicy;

class ContextCopiedElement
implements IElementCopy,
Cloneable {
    private final DesignElement copy;
    private final DesignElement localizedCopy;
    private final String rootLocation;
    private final String xpath;
    private final String libLocation;
    private final long extendsElementID;

    ContextCopiedElement(DesignElement element, DesignElement localizedElement, String xpath, String rootLocation, String libLocation, long extendsElementID) {
        this.copy = element;
        this.localizedCopy = localizedElement;
        this.rootLocation = rootLocation;
        this.xpath = xpath;
        this.libLocation = libLocation;
        this.extendsElementID = extendsElementID;
    }

    public Object clone() throws CloneNotSupportedException {
        DesignElement newCopy = null;
        if (this.copy != null) {
            newCopy = (DesignElement)this.copy.doClone(DummyCopyPolicy.getInstance());
        }
        DesignElement newLocalized = (DesignElement)this.localizedCopy.doClone(DummyCopyPolicy.getInstance());
        ContextCopiedElement retValue = new ContextCopiedElement(newCopy, newLocalized, this.xpath, this.rootLocation, this.libLocation, this.extendsElementID);
        return retValue;
    }

    DesignElement getCopy() {
        if (this.extendsElementID != 0L) {
            return this.copy;
        }
        return this.localizedCopy;
    }

    String getRootLocation() {
        return this.rootLocation;
    }

    DesignElement getLocalizedCopy() {
        return this.localizedCopy;
    }

    String getLibLocation() {
        return this.libLocation;
    }

    long getExtendsElementID() {
        return this.extendsElementID;
    }

    public DesignElementHandle getHandle(ModuleHandle handle) {
        return this.getCopy().getHandle(handle.getModule());
    }
}

