/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class FloatPropertyType
extends PropertyType {
    private static final String DISPLAY_NAME_KEY = "Property.float";
    private static final DecimalFormat formatter = new DecimalFormat("#0.0#", new DecimalFormatSymbols(DEFAULT_LOCALE));

    public FloatPropertyType() {
        super(DISPLAY_NAME_KEY);
        formatter.setMaximumFractionDigits(32);
        formatter.setMaximumIntegerDigits(32);
    }

    public int getTypeCode() {
        return 14;
    }

    public String getName() {
        return "float";
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Float) {
            return new Double(((Float)value).doubleValue());
        }
        if (value instanceof Integer) {
            return new Double(((Integer)value).intValue());
        }
        if (value instanceof BigDecimal) {
            return new Double(((BigDecimal)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return new Double((Boolean)value != false ? 1 : 0);
        }
        if (value instanceof String) {
            return this.validateInputString(module, defn, (String)value);
        }
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 14);
    }

    public Object validateXml(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        assert (value == null || value instanceof String);
        String tmpValue = (String)value;
        if ((tmpValue = StringUtil.trimString(tmpValue)) == null) {
            return null;
        }
        return this.parseDouble(tmpValue);
    }

    public double toDouble(Module module, Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        return (Double)value;
    }

    public int toInteger(Module module, Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return ((Double)value).intValue();
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return formatter.format((Double)value);
    }

    public String toDisplayString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        ULocale locale = module == null ? ThreadResources.getLocale() : module.getLocale();
        NumberFormat formatter = NumberFormat.getNumberInstance(locale.toLocale());
        return formatter.format((Double)value);
    }

    public Object validateInputString(Module module, PropertyDefn defn, String value) throws PropertyValueException {
        if ((value = StringUtil.trimString(value)) == null) {
            return null;
        }
        ULocale locale = module == null ? ThreadResources.getLocale() : module.getLocale();
        NumberFormat localeFormatter = NumberFormat.getNumberInstance(locale.toLocale());
        Number number = null;
        try {
            number = localeFormatter.parse(value);
        }
        catch (ParseException parseException) {
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 1);
        }
        return new Double(number.doubleValue());
    }

    protected Double parseDouble(String value) throws PropertyValueException {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 14);
        }
    }
}

