/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.TextualPropertyType;

public class ExpressionPropertyType
extends TextualPropertyType {
    private static final String DISPLAY_NAME_KEY = "Property.expression";

    public ExpressionPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public int getTypeCode() {
        return 7;
    }

    public String getName() {
        return "expression";
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        int trimOption = defn.getTrimOption();
        if (value instanceof Expression) {
            String expr = ((Expression)value).getStringExpression();
            String tmpType = ((Expression)value).getUserDefinedType();
            String trimExpr = this.trimString(expr, trimOption);
            if (trimExpr == null) {
                if (tmpType == null) {
                    return null;
                }
                return new Expression(null, tmpType);
            }
            return value;
        }
        if (value instanceof String) {
            String expr = this.trimString((String)value, trimOption);
            if (expr == null) {
                return null;
            }
            return new Expression(expr, null);
        }
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 7);
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value instanceof Expression) {
            return ((Expression)value).getStringExpression();
        }
        if (value == null || value instanceof String) {
            return (String)value;
        }
        assert (false);
        return null;
    }

    public String toDisplayString(Module module, PropertyDefn defn, Object value) {
        return this.toString(module, defn, value);
    }
}

