/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class StructureContext {
    protected final ContainerInfo containerInfo;
    protected final Structure struct;

    private StructureContext(ContainerInfo info, Structure struct) {
        this.containerInfo = info;
        this.struct = struct;
    }

    public StructureContext(DesignElement element, ElementPropertyDefn elementPropDefn, Structure obj) {
        this.containerInfo = new ElementContainerInfo(element, elementPropDefn);
        this.struct = obj;
    }

    public StructureContext(IStructure struct, PropertyDefn propDefn, Structure obj) {
        this.containerInfo = new StructureContainerInfo(struct, propDefn);
        this.struct = obj;
    }

    public void add(Structure struct) {
        this.add(-1, struct);
    }

    public void add(int index, Structure struct) {
        ArrayList values = this.getLocalValue();
        if (this.containerInfo.getPropDefn().isList()) {
            if (values == null) {
                values = new ArrayList();
                this.containerInfo.setValue(values);
            }
            if (index == -1) {
                index = ((List)values).size();
            }
            ((List)values).add(index, struct);
        } else {
            assert (values == null);
            this.containerInfo.setValue(struct);
        }
        StructureContext context = new StructureContext(this.containerInfo.getCopy(), struct);
        struct.setContext(context);
    }

    public StructureContext cacheStructure(Structure struct) {
        return new StructureContext(this.containerInfo.getCopy(), struct);
    }

    public Structure getStructureAt(Module module, int posn) {
        Object value = this.getValue(module);
        if (value instanceof List) {
            List listValue = (List)value;
            if (posn < 0 || posn >= listValue.size()) {
                return null;
            }
            Object item = listValue.get(posn);
            return item instanceof Structure ? (Structure)item : null;
        }
        if (value instanceof Structure) {
            return posn == 0 ? (Structure)value : null;
        }
        return null;
    }

    public void remove(Structure struct) {
        Object values = this.getLocalValue();
        assert (values != null);
        if (this.containerInfo.getPropDefn().isList()) {
            List list = (List)values;
            int index = list.indexOf(struct);
            assert (index != -1);
            list.remove(index);
        } else {
            assert (values == struct);
            this.containerInfo.setValue(null);
        }
        struct.setContext(null);
    }

    public void remove(int index) {
        Object values = this.getLocalValue();
        assert (values != null);
        Structure struct = null;
        if (this.containerInfo.getPropDefn().isList()) {
            List list = (List)values;
            struct = (Structure)list.get(index);
            list.remove(index);
        } else assert (false);
        assert (struct != null);
        struct.setContext(null);
    }

    public Object getValueContainer() {
        return this.containerInfo.getContainer();
    }

    public PropertyDefn getPropDefn() {
        return this.containerInfo.getPropDefn();
    }

    public IStructureDefn getStructDefn() {
        PropertyDefn propDefn = this.getPropDefn();
        if (propDefn.getTypeCode() == 16) {
            return propDefn.getStructDefn();
        }
        return null;
    }

    public int getIndex(Module module) {
        Structure struct = this.getStructure();
        if (struct == null) {
            return -1;
        }
        Object value = this.getValue(module);
        if (value instanceof Structure) {
            assert (struct == value);
            return 0;
        }
        if (value instanceof List) {
            return ((List)value).indexOf(struct);
        }
        return -1;
    }

    public ElementPropertyDefn getElementProp() {
        ElementContainerInfo elementContainerInfo = this.getElementContainerInfo();
        return elementContainerInfo == null ? null : (ElementPropertyDefn)elementContainerInfo.getPropDefn();
    }

    public DesignElement getElement() {
        ElementContainerInfo elementContainerInfo = this.getElementContainerInfo();
        return elementContainerInfo == null ? null : (DesignElement)elementContainerInfo.getContainer();
    }

    private ElementContainerInfo getElementContainerInfo() {
        StructureContext tmpContext = this;
        while (tmpContext != null && tmpContext.containerInfo.getType() != 0) {
            tmpContext = ((Structure)tmpContext.getValueContainer()).getContext();
        }
        if (tmpContext != null) {
            assert (tmpContext.containerInfo instanceof ElementContainerInfo);
            return (ElementContainerInfo)tmpContext.containerInfo;
        }
        return null;
    }

    public Object getLocalValue(Module root) {
        return this.containerInfo.getLocalValue(root);
    }

    private Object getLocalValue() {
        return this.containerInfo.getLocalValue();
    }

    public Object getValue(Module module) {
        DesignElement element = this.getElement();
        Module root = null;
        if (element != null && (root = element.getRoot()) == null) {
            root = module;
        }
        return this.containerInfo.getValue(root);
    }

    public Structure getStructure() {
        if (this.struct != null) {
            return this.struct;
        }
        Object container = this.containerInfo.getContainer();
        if (container instanceof Structure) {
            return (Structure)container;
        }
        return null;
    }

    public List getList(Module module) {
        Structure struct;
        StructureContext context;
        if (this.struct != null) {
            Object value = this.containerInfo.getValue(module);
            return value instanceof List ? (List)value : null;
        }
        PropertyDefn propDefn = this.getPropDefn();
        if (propDefn.isListType()) {
            return (List)this.getValue(module);
        }
        Object container = this.containerInfo.getContainer();
        if (container instanceof DesignElement) {
            return null;
        }
        if (container instanceof Structure && (context = (struct = (Structure)container).getContext()) != null) {
            Object value = context.containerInfo.getValue(module);
            return value instanceof List ? (List)value : null;
        }
        return null;
    }

    public boolean isListRef() {
        PropertyDefn propDefn = this.getPropDefn();
        return propDefn.isListType();
    }

    public StructureContext getParentContext() {
        Object container = this.getValueContainer();
        if (container instanceof DesignElement) {
            return null;
        }
        return ((Structure)container).getContext();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StructureContext)) {
            return false;
        }
        StructureContext context = (StructureContext)obj;
        return this.containerInfo.equals(context.containerInfo) && (this.struct == null && context.struct == null || this.struct != null && this.struct.equals(context.struct));
    }

    abstract class ContainerInfo {
        protected static final int ELEMENT_CONTAINER_TYPE = 0;
        protected static final int STRUCTURE_CONTAINER_TYPE = 1;

        ContainerInfo() {
        }

        abstract int getType();

        abstract Object getValue(Module var1);

        abstract Object getContainer();

        abstract PropertyDefn getPropDefn();

        abstract Object getLocalValue();

        abstract Object getLocalValue(Module var1);

        abstract void setValue(Object var1);

        abstract ContainerInfo getCopy();
    }

    class ElementContainerInfo
    extends ContainerInfo {
        protected final DesignElement container;
        protected final ElementPropertyDefn propDefn;

        ElementContainerInfo(DesignElement element, ElementPropertyDefn propDefn) {
            this.container = element;
            this.propDefn = propDefn;
            if (propDefn == null || propDefn != element.getPropertyDefn(propDefn.getName())) {
                throw new IllegalArgumentException();
            }
        }

        int getType() {
            return 0;
        }

        Object getContainer() {
            return this.container;
        }

        PropertyDefn getPropDefn() {
            return this.propDefn;
        }

        Object getLocalValue() {
            return this.getLocalValue(this.container.getRoot());
        }

        Object getLocalValue(Module module) {
            return this.container.getLocalProperty(module, this.propDefn);
        }

        Object getValue(Module module) {
            return this.container.getProperty(module, this.propDefn);
        }

        void setValue(Object value) {
            this.container.setProperty(this.propDefn, value);
        }

        ContainerInfo getCopy() {
            return new ElementContainerInfo(this.container, this.propDefn);
        }
    }

    class StructureContainerInfo
    extends ContainerInfo {
        protected final Structure container;
        protected final PropertyDefn propDefn;

        StructureContainerInfo(IStructure struct, PropertyDefn propDefn) {
            if (!(struct instanceof Structure)) {
                throw new IllegalArgumentException();
            }
            this.container = (Structure)struct;
            this.propDefn = propDefn;
            if (propDefn == null || !propDefn.equals(this.container.getMemberDefn(propDefn.getName()))) {
                throw new IllegalArgumentException();
            }
        }

        int getType() {
            return 1;
        }

        Object getContainer() {
            return this.container;
        }

        PropertyDefn getPropDefn() {
            return this.propDefn;
        }

        Object getValue(Module module) {
            return this.container.getProperty(module, this.propDefn);
        }

        Object getLocalValue() {
            return this.getLocalValue(null);
        }

        Object getLocalValue(Module module) {
            return this.container.getLocalProperty(module, this.propDefn);
        }

        void setValue(Object value) {
            this.container.setProperty(this.propDefn, value);
        }

        ContainerInfo getCopy() {
            return new StructureContainerInfo(this.container, this.propDefn);
        }
    }
}

