/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.scripts;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.scripts.ConstructorInfo;
import org.eclipse.birt.report.model.api.scripts.MemberInfo;
import org.eclipse.birt.report.model.api.scripts.MethodInfo;

public class ClassInfo
implements IClassInfo {
    private final Class clazz;
    private Map methods;
    private Map members;
    private IMethodInfo constructor;

    public ClassInfo(Class clazz) {
        this.clazz = clazz;
        this.initialize();
    }

    private void initialize() {
        this.methods = new LinkedHashMap();
        this.members = new LinkedHashMap();
        Method[] classMethods = this.clazz.getMethods();
        int i = 0;
        while (i < classMethods.length) {
            String methodName;
            IMethodInfo method;
            Method classMethod = classMethods[i];
            if (!classMethod.isAnnotationPresent(Deprecated.class) && (method = (IMethodInfo)this.methods.get(methodName = classMethod.getName())) == null && (method = this.createMethodInfo(classMethod)) != null) {
                this.methods.put(methodName, method);
            }
            ++i;
        }
        Constructor<?>[] classConstructors = this.clazz.getConstructors();
        int i2 = 0;
        while (i2 < classConstructors.length) {
            Constructor<?> classMethod = classConstructors[i2];
            if (this.constructor == null) {
                this.constructor = this.createConstructorInfo(classMethod);
            }
            ++i2;
        }
        Field[] fields = this.clazz.getFields();
        int i3 = 0;
        while (i3 < fields.length) {
            Field classField = fields[i3];
            IMemberInfo memberInfo = this.createMemberInfo(classField);
            if (memberInfo != null) {
                this.members.put(classField.getName(), memberInfo);
            }
            ++i3;
        }
    }

    protected IMemberInfo createMemberInfo(Field classField) {
        return new MemberInfo(classField);
    }

    protected IMethodInfo createConstructorInfo(Constructor classMethod) {
        return new ConstructorInfo(classMethod);
    }

    protected IMethodInfo createMethodInfo(Method classMethod) {
        return new MethodInfo(classMethod);
    }

    public List getMethods() {
        if (this.methods != null) {
            return new ArrayList(this.methods.values());
        }
        return Collections.EMPTY_LIST;
    }

    public IMethodInfo getMethod(String name) {
        return (IMethodInfo)ClassInfo.findInfo(this.methods, name);
    }

    private static Object findInfo(Map objs, String name) {
        if (objs == null || name == null) {
            return null;
        }
        return objs.get(name.toLowerCase());
    }

    public List getMembers() {
        Field[] fields = this.clazz.getFields();
        ArrayList<MemberInfo> retList = new ArrayList<MemberInfo>();
        int i = 0;
        while (i < fields.length) {
            retList.add(new MemberInfo(fields[i]));
            ++i;
        }
        return retList;
    }

    public IMemberInfo getMember(String name) {
        try {
            Field field = this.clazz.getField(name);
            return new MemberInfo(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public IMethodInfo getConstructor() {
        return this.constructor;
    }

    public boolean isNative() {
        return false;
    }

    public String getDisplayNameKey() {
        return "";
    }

    public String getName() {
        return this.clazz.getName();
    }

    public String getToolTipKey() {
        return "";
    }

    public String getDisplayName() {
        return "";
    }

    public String getToolTip() {
        return "";
    }
}

