/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.List;
import java.util.Stack;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.activity.CompoundRecord;
import org.eclipse.birt.report.model.activity.FilterEventsCompoundRecord;
import org.eclipse.birt.report.model.activity.LayoutCompoundRecord;
import org.eclipse.birt.report.model.activity.NonUndoableCompoundRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionAdapter {
    static final int DEFAULT_RECORD = 0;
    static final int FILTER_RECORD = 1;
    static final int LAYOUT_RECORD = 2;
    static final int PERSISTENT_RECORD = 3;
    static final int NONUNDOABLE_RECORD = 4;
    private ActivityStack stack;
    protected Stack<List<ActivityRecord>> needUndoPersistentRecords = new Stack();

    TransactionAdapter(ActivityStack stack) {
        this.stack = stack;
    }

    void handleCommit(ActivityRecord record) {
        Stack<CompoundRecord> transStack = this.stack.transStack;
        Stack<ActivityRecord> undoStack = this.stack.undoStack;
        if (transStack.empty() && !(record instanceof NonUndoableCompoundRecord)) {
            undoStack.push(record);
            this.handlePersistentRecords(undoStack);
        }
    }

    private void handlePersistentRecords(Stack<ActivityRecord> undoStack) {
        if (!this.needUndoPersistentRecords.isEmpty()) {
            List<ActivityRecord> needToUndoRecords = null;
            while (!this.needUndoPersistentRecords.isEmpty()) {
                needToUndoRecords = this.needUndoPersistentRecords.pop();
                int j = 0;
                while (j < needToUndoRecords.size()) {
                    needToUndoRecords.get(j).setTransNo(this.stack.increaseTransCount());
                    undoStack.push(needToUndoRecords.get(j));
                    ++j;
                }
            }
        }
        this.stack.trimUndoStack();
    }

    protected void handleRollback(CompoundRecord record) {
        Stack<CompoundRecord> transStack = this.stack.transStack;
        List<ActivityRecord> persistentRecord = record.getDonePersistentTrans();
        Stack<ActivityRecord> undoStack = this.stack.undoStack;
        if (persistentRecord.size() != 0) {
            if (!transStack.isEmpty()) {
                this.needUndoPersistentRecords.push(persistentRecord);
            } else {
                int i = 0;
                while (i < persistentRecord.size()) {
                    persistentRecord.get(i).setTransNo(this.stack.increaseTransCount());
                    undoStack.push(persistentRecord.get(i));
                    ++i;
                }
                this.stack.trimUndoStack();
            }
        } else if (transStack.isEmpty()) {
            this.handlePersistentRecords(undoStack);
        }
    }

    protected CompoundRecord createNewRecord(int recordType, String label) {
        Stack<CompoundRecord> transStack = this.stack.transStack;
        CompoundRecord retRecord = null;
        boolean outerMost = true;
        switch (recordType) {
            case 1: {
                if (!transStack.isEmpty()) {
                    if (transStack.peek() instanceof LayoutCompoundRecord) {
                        return this.createNewRecord(2, label);
                    }
                    if (transStack.peek() instanceof NonUndoableCompoundRecord) {
                        return this.createNewRecord(4, label);
                    }
                }
                if (!transStack.isEmpty() && transStack.peek() instanceof FilterEventsCompoundRecord) {
                    outerMost = false;
                }
                retRecord = new FilterEventsCompoundRecord(label, outerMost);
                break;
            }
            case 2: {
                if (!transStack.isEmpty() && transStack.peek() instanceof LayoutCompoundRecord) {
                    outerMost = false;
                }
                retRecord = new LayoutCompoundRecord(label, outerMost);
                break;
            }
            case 3: {
                retRecord = new CompoundRecord(label, true);
                break;
            }
            case 4: {
                retRecord = new NonUndoableCompoundRecord(label);
                break;
            }
            default: {
                if (!transStack.isEmpty()) {
                    if (transStack.peek() instanceof LayoutCompoundRecord) {
                        return this.createNewRecord(2, label);
                    }
                    if (transStack.peek() instanceof FilterEventsCompoundRecord) {
                        return this.createNewRecord(1, label);
                    }
                    if (transStack.peek() instanceof NonUndoableCompoundRecord) {
                        return this.createNewRecord(4, label);
                    }
                }
                retRecord = new CompoundRecord(label);
            }
        }
        return retRecord;
    }
}

