/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.UBiDiProps;
import com.ibm.icu.text.ArabicShapingException;
import java.io.IOException;
import java.util.MissingResourceException;

public final class ArabicShaping {
    private final int options;
    private boolean isLogical;
    public static final int LENGTH_GROW_SHRINK = 0;
    public static final int LENGTH_FIXED_SPACES_NEAR = 1;
    public static final int LENGTH_FIXED_SPACES_AT_END = 2;
    public static final int LENGTH_FIXED_SPACES_AT_BEGINNING = 3;
    public static final int LENGTH_MASK = 3;
    public static final int TEXT_DIRECTION_LOGICAL = 0;
    public static final int TEXT_DIRECTION_VISUAL_LTR = 4;
    public static final int TEXT_DIRECTION_MASK = 4;
    public static final int LETTERS_NOOP = 0;
    public static final int LETTERS_SHAPE = 8;
    public static final int LETTERS_UNSHAPE = 16;
    public static final int LETTERS_SHAPE_TASHKEEL_ISOLATED = 24;
    public static final int LETTERS_MASK = 24;
    public static final int DIGITS_NOOP = 0;
    public static final int DIGITS_EN2AN = 32;
    public static final int DIGITS_AN2EN = 64;
    public static final int DIGITS_EN2AN_INIT_LR = 96;
    public static final int DIGITS_EN2AN_INIT_AL = 128;
    public static final int DIGITS_MASK = 224;
    public static final int DIGIT_TYPE_AN = 0;
    public static final int DIGIT_TYPE_AN_EXTENDED = 256;
    public static final int DIGIT_TYPE_MASK = 256;
    private static final int IRRELEVANT = 4;
    private static final int LAMTYPE = 16;
    private static final int ALEFTYPE = 32;
    private static final int LINKR = 1;
    private static final int LINKL = 2;
    private static final int LINK_MASK = 3;
    private static final int[] irrelevantPos;
    private static final char[] convertNormalizedLamAlef;
    private static final int[] araLink;
    private static final int[] presLink;
    private static int[] convertFEto06;
    private static final int[][][] shapeTable;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[8];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 6;
        nArray[4] = 8;
        nArray[5] = 10;
        nArray[6] = 12;
        nArray[7] = 14;
        irrelevantPos = nArray;
        convertNormalizedLamAlef = new char[]{'\u0622', '\u0623', '\u0625', '\u0627'};
        int[] nArray2 = new int[178];
        nArray2[0] = 4385;
        nArray2[1] = 4897;
        nArray2[2] = 5377;
        nArray2[3] = 5921;
        nArray2[4] = 6403;
        nArray2[5] = 7457;
        nArray2[6] = 7939;
        nArray2[7] = 8961;
        nArray2[8] = 9475;
        nArray2[9] = 10499;
        nArray2[10] = 11523;
        nArray2[11] = 12547;
        nArray2[12] = 13571;
        nArray2[13] = 14593;
        nArray2[14] = 15105;
        nArray2[15] = 15617;
        nArray2[16] = 16129;
        nArray2[17] = 16643;
        nArray2[18] = 17667;
        nArray2[19] = 18691;
        nArray2[20] = 19715;
        nArray2[21] = 20739;
        nArray2[22] = 21763;
        nArray2[23] = 22787;
        nArray2[24] = 23811;
        nArray2[30] = 3;
        nArray2[31] = 24835;
        nArray2[32] = 25859;
        nArray2[33] = 26883;
        nArray2[34] = 27923;
        nArray2[35] = 28931;
        nArray2[36] = 29955;
        nArray2[37] = 30979;
        nArray2[38] = 32001;
        nArray2[39] = 32513;
        nArray2[40] = 33027;
        nArray2[41] = 4;
        nArray2[42] = 4;
        nArray2[43] = 4;
        nArray2[44] = 4;
        nArray2[45] = 4;
        nArray2[46] = 4;
        nArray2[47] = 4;
        nArray2[48] = 4;
        nArray2[49] = 4;
        nArray2[50] = 4;
        nArray2[51] = 4;
        nArray2[58] = 34049;
        nArray2[59] = 34561;
        nArray2[60] = 35073;
        nArray2[61] = 35585;
        nArray2[78] = 4;
        nArray2[80] = 33;
        nArray2[81] = 33;
        nArray2[83] = 33;
        nArray2[84] = 1;
        nArray2[85] = 1;
        nArray2[86] = 3;
        nArray2[87] = 3;
        nArray2[88] = 3;
        nArray2[89] = 3;
        nArray2[90] = 3;
        nArray2[91] = 3;
        nArray2[92] = 3;
        nArray2[93] = 3;
        nArray2[94] = 3;
        nArray2[95] = 3;
        nArray2[96] = 3;
        nArray2[97] = 3;
        nArray2[98] = 3;
        nArray2[99] = 3;
        nArray2[100] = 3;
        nArray2[101] = 3;
        nArray2[102] = 1;
        nArray2[103] = 1;
        nArray2[104] = 1;
        nArray2[105] = 1;
        nArray2[106] = 1;
        nArray2[107] = 1;
        nArray2[108] = 1;
        nArray2[109] = 1;
        nArray2[110] = 1;
        nArray2[111] = 1;
        nArray2[112] = 1;
        nArray2[113] = 1;
        nArray2[114] = 1;
        nArray2[115] = 1;
        nArray2[116] = 1;
        nArray2[117] = 1;
        nArray2[118] = 1;
        nArray2[119] = 1;
        nArray2[120] = 3;
        nArray2[121] = 3;
        nArray2[122] = 3;
        nArray2[123] = 3;
        nArray2[124] = 3;
        nArray2[125] = 3;
        nArray2[126] = 3;
        nArray2[127] = 3;
        nArray2[128] = 3;
        nArray2[129] = 3;
        nArray2[130] = 3;
        nArray2[131] = 3;
        nArray2[132] = 3;
        nArray2[133] = 3;
        nArray2[134] = 3;
        nArray2[135] = 3;
        nArray2[136] = 3;
        nArray2[137] = 3;
        nArray2[138] = 3;
        nArray2[139] = 3;
        nArray2[140] = 3;
        nArray2[141] = 3;
        nArray2[142] = 3;
        nArray2[143] = 3;
        nArray2[144] = 3;
        nArray2[145] = 3;
        nArray2[146] = 3;
        nArray2[147] = 3;
        nArray2[148] = 3;
        nArray2[149] = 3;
        nArray2[150] = 3;
        nArray2[151] = 3;
        nArray2[152] = 3;
        nArray2[153] = 3;
        nArray2[154] = 3;
        nArray2[155] = 3;
        nArray2[156] = 3;
        nArray2[157] = 3;
        nArray2[158] = 1;
        nArray2[159] = 3;
        nArray2[160] = 1;
        nArray2[161] = 1;
        nArray2[162] = 1;
        nArray2[163] = 1;
        nArray2[164] = 1;
        nArray2[165] = 1;
        nArray2[166] = 1;
        nArray2[167] = 1;
        nArray2[168] = 1;
        nArray2[169] = 1;
        nArray2[170] = 3;
        nArray2[171] = 1;
        nArray2[172] = 3;
        nArray2[173] = 3;
        nArray2[174] = 3;
        nArray2[175] = 3;
        nArray2[176] = 1;
        nArray2[177] = 1;
        araLink = nArray2;
        int[] nArray3 = new int[141];
        nArray3[0] = 3;
        nArray3[1] = 3;
        nArray3[2] = 3;
        nArray3[4] = 3;
        nArray3[6] = 3;
        nArray3[7] = 3;
        nArray3[8] = 3;
        nArray3[9] = 3;
        nArray3[10] = 3;
        nArray3[11] = 3;
        nArray3[12] = 3;
        nArray3[13] = 3;
        nArray3[14] = 3;
        nArray3[15] = 3;
        nArray3[17] = 32;
        nArray3[18] = 33;
        nArray3[19] = 32;
        nArray3[20] = 33;
        nArray3[22] = 1;
        nArray3[23] = 32;
        nArray3[24] = 33;
        nArray3[26] = 2;
        nArray3[27] = 3;
        nArray3[28] = 1;
        nArray3[29] = 32;
        nArray3[30] = 33;
        nArray3[32] = 2;
        nArray3[33] = 3;
        nArray3[34] = 1;
        nArray3[36] = 1;
        nArray3[38] = 2;
        nArray3[39] = 3;
        nArray3[40] = 1;
        nArray3[42] = 2;
        nArray3[43] = 3;
        nArray3[44] = 1;
        nArray3[46] = 2;
        nArray3[47] = 3;
        nArray3[48] = 1;
        nArray3[50] = 2;
        nArray3[51] = 3;
        nArray3[52] = 1;
        nArray3[54] = 2;
        nArray3[55] = 3;
        nArray3[56] = 1;
        nArray3[58] = 1;
        nArray3[60] = 1;
        nArray3[62] = 1;
        nArray3[64] = 1;
        nArray3[66] = 2;
        nArray3[67] = 3;
        nArray3[68] = 1;
        nArray3[70] = 2;
        nArray3[71] = 3;
        nArray3[72] = 1;
        nArray3[74] = 2;
        nArray3[75] = 3;
        nArray3[76] = 1;
        nArray3[78] = 2;
        nArray3[79] = 3;
        nArray3[80] = 1;
        nArray3[82] = 2;
        nArray3[83] = 3;
        nArray3[84] = 1;
        nArray3[86] = 2;
        nArray3[87] = 3;
        nArray3[88] = 1;
        nArray3[90] = 2;
        nArray3[91] = 3;
        nArray3[92] = 1;
        nArray3[94] = 2;
        nArray3[95] = 3;
        nArray3[96] = 1;
        nArray3[98] = 2;
        nArray3[99] = 3;
        nArray3[100] = 1;
        nArray3[102] = 2;
        nArray3[103] = 3;
        nArray3[104] = 1;
        nArray3[106] = 2;
        nArray3[107] = 3;
        nArray3[108] = 1;
        nArray3[109] = 16;
        nArray3[110] = 18;
        nArray3[111] = 19;
        nArray3[112] = 17;
        nArray3[114] = 2;
        nArray3[115] = 3;
        nArray3[116] = 1;
        nArray3[118] = 2;
        nArray3[119] = 3;
        nArray3[120] = 1;
        nArray3[122] = 2;
        nArray3[123] = 3;
        nArray3[124] = 1;
        nArray3[126] = 1;
        nArray3[128] = 1;
        nArray3[130] = 2;
        nArray3[131] = 3;
        nArray3[132] = 1;
        nArray3[134] = 1;
        nArray3[136] = 1;
        nArray3[138] = 1;
        nArray3[140] = 1;
        presLink = nArray3;
        convertFEto06 = new int[]{1611, 1611, 1612, 1612, 1613, 1613, 1614, 1614, 1615, 1615, 1616, 1616, 1617, 1617, 1618, 1618, 1569, 1570, 1570, 1571, 1571, 1572, 1572, 1573, 1573, 1574, 1574, 1574, 1574, 1575, 1575, 1576, 1576, 1576, 1576, 1577, 1577, 1578, 1578, 1578, 1578, 1579, 1579, 1579, 1579, 1580, 1580, 1580, 1580, 1581, 1581, 1581, 1581, 1582, 1582, 1582, 1582, 1583, 1583, 1584, 1584, 1585, 1585, 1586, 1586, 1587, 1587, 1587, 1587, 1588, 1588, 1588, 1588, 1589, 1589, 1589, 1589, 1590, 1590, 1590, 1590, 1591, 1591, 1591, 1591, 1592, 1592, 1592, 1592, 1593, 1593, 1593, 1593, 1594, 1594, 1594, 1594, 1601, 1601, 1601, 1601, 1602, 1602, 1602, 1602, 1603, 1603, 1603, 1603, 1604, 1604, 1604, 1604, 1605, 1605, 1605, 1605, 1606, 1606, 1606, 1606, 1607, 1607, 1607, 1607, 1608, 1608, 1609, 1609, 1610, 1610, 1610, 1610, 1628, 1628, 1629, 1629, 1630, 1630, 1631, 1631};
        int[][][] nArrayArray = new int[4][][];
        int[][] nArrayArray2 = new int[4][];
        nArrayArray2[0] = new int[4];
        nArrayArray2[1] = new int[4];
        int[] nArray4 = new int[4];
        nArray4[1] = 1;
        nArray4[3] = 3;
        nArrayArray2[2] = nArray4;
        int[] nArray5 = new int[4];
        nArray5[1] = 1;
        nArray5[3] = 1;
        nArrayArray2[3] = nArray5;
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[4][];
        int[] nArray6 = new int[4];
        nArray6[2] = 2;
        nArray6[3] = 2;
        nArrayArray3[0] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[2] = 1;
        nArray7[3] = 2;
        nArrayArray3[1] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[1] = 1;
        nArray8[2] = 1;
        nArray8[3] = 2;
        nArrayArray3[2] = nArray8;
        int[] nArray9 = new int[4];
        nArray9[1] = 1;
        nArray9[2] = 1;
        nArray9[3] = 3;
        nArrayArray3[3] = nArray9;
        nArrayArray[1] = nArrayArray3;
        int[][] nArrayArray4 = new int[4][];
        nArrayArray4[0] = new int[4];
        nArrayArray4[1] = new int[4];
        int[] nArray10 = new int[4];
        nArray10[1] = 1;
        nArray10[3] = 3;
        nArrayArray4[2] = nArray10;
        int[] nArray11 = new int[4];
        nArray11[1] = 1;
        nArray11[3] = 3;
        nArrayArray4[3] = nArray11;
        nArrayArray[2] = nArrayArray4;
        int[][] nArrayArray5 = new int[4][];
        int[] nArray12 = new int[4];
        nArray12[2] = 1;
        nArray12[3] = 2;
        nArrayArray5[0] = nArray12;
        int[] nArray13 = new int[4];
        nArray13[2] = 1;
        nArray13[3] = 2;
        nArrayArray5[1] = nArray13;
        int[] nArray14 = new int[4];
        nArray14[1] = 1;
        nArray14[2] = 1;
        nArray14[3] = 2;
        nArrayArray5[2] = nArray14;
        int[] nArray15 = new int[4];
        nArray15[1] = 1;
        nArray15[2] = 1;
        nArray15[3] = 3;
        nArrayArray5[3] = nArray15;
        nArrayArray[3] = nArrayArray5;
        shapeTable = nArrayArray;
    }

    public int shape(char[] source, int sourceStart, int sourceLength, char[] dest, int destStart, int destSize) throws ArabicShapingException {
        if (source == null) {
            throw new IllegalArgumentException("source can not be null");
        }
        if (sourceStart < 0 || sourceLength < 0 || sourceStart + sourceLength > source.length) {
            throw new IllegalArgumentException("bad source start (" + sourceStart + ") or length (" + sourceLength + ") for buffer of length " + source.length);
        }
        if (dest == null && destSize != 0) {
            throw new IllegalArgumentException("null dest requires destSize == 0");
        }
        if (destSize != 0 && (destStart < 0 || destSize < 0 || destStart + destSize > dest.length)) {
            throw new IllegalArgumentException("bad dest start (" + destStart + ") or size (" + destSize + ") for buffer of length " + dest.length);
        }
        return this.internalShape(source, sourceStart, sourceLength, dest, destStart, destSize);
    }

    public void shape(char[] source, int start, int length) throws ArabicShapingException {
        if ((this.options & 3) == 0) {
            throw new ArabicShapingException("Cannot shape in place with length option grow/shrink.");
        }
        this.shape(source, start, length, source, start, length);
    }

    public String shape(String text) throws ArabicShapingException {
        char[] src;
        char[] dest = src = text.toCharArray();
        if ((this.options & 3) == 0 && (this.options & 0x18) == 16) {
            dest = new char[src.length * 2];
        }
        int len = this.shape(src, 0, src.length, dest, 0, dest.length);
        return new String(dest, 0, len);
    }

    public ArabicShaping(int options) {
        this.options = options;
        if ((options & 0xE0) > 128) {
            throw new IllegalArgumentException("bad DIGITS options");
        }
        this.isLogical = (options & 4) == 0;
    }

    public boolean equals(Object rhs) {
        if (rhs != null) {
            Class<?> clazz = rhs.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.ibm.icu.text.ArabicShaping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2 && this.options == ((ArabicShaping)rhs).options) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.options;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append('[');
        switch (this.options & 3) {
            case 0: {
                buf.append("grow/shrink");
                break;
            }
            case 1: {
                buf.append("spaces near");
                break;
            }
            case 2: {
                buf.append("spaces at end");
                break;
            }
            case 3: {
                buf.append("spaces at beginning");
            }
        }
        switch (this.options & 4) {
            case 0: {
                buf.append(", logical");
                break;
            }
            case 4: {
                buf.append(", visual");
            }
        }
        switch (this.options & 0x18) {
            case 0: {
                buf.append(", no letter shaping");
                break;
            }
            case 8: {
                buf.append(", shape letters");
                break;
            }
            case 24: {
                buf.append(", shape letters tashkeel isolated");
                break;
            }
            case 16: {
                buf.append(", unshape letters");
            }
        }
        switch (this.options & 0xE0) {
            case 0: {
                buf.append(", no digit shaping");
                break;
            }
            case 32: {
                buf.append(", shape digits to AN");
                break;
            }
            case 64: {
                buf.append(", shape digits to EN");
                break;
            }
            case 96: {
                buf.append(", shape digits to AN contextually: default EN");
                break;
            }
            case 128: {
                buf.append(", shape digits to AN contextually: default AL");
            }
        }
        switch (this.options & 0x100) {
            case 0: {
                buf.append(", standard Arabic-Indic digits");
                break;
            }
            case 256: {
                buf.append(", extended Arabic-Indic digits");
            }
        }
        buf.append("]");
        return buf.toString();
    }

    private void shapeToArabicDigitsWithContext(char[] dest, int start, int length, char digitBase, boolean lastStrongWasAL) {
        UBiDiProps bdp;
        try {
            bdp = UBiDiProps.getSingleton();
        }
        catch (IOException e) {
            throw new MissingResourceException(e.getMessage(), "(BidiProps)", "");
        }
        digitBase = (char)(digitBase - 48);
        int i = start + length;
        block7: while (--i >= start) {
            char ch = dest[i];
            switch (bdp.getClass(ch)) {
                case 0: 
                case 1: {
                    lastStrongWasAL = false;
                    break;
                }
                case 13: {
                    lastStrongWasAL = true;
                    break;
                }
                case 2: {
                    if (!lastStrongWasAL || ch > '9') continue block7;
                    dest[i] = (char)(ch + digitBase);
                    break;
                }
            }
        }
    }

    private static void invertBuffer(char[] buffer, int start, int length) {
        int i = start;
        int j = start + length - 1;
        while (i < j) {
            char temp = buffer[i];
            buffer[i] = buffer[j];
            buffer[j] = temp;
            ++i;
            --j;
        }
    }

    private static char changeLamAlef(char ch) {
        switch (ch) {
            case '\u0622': {
                return '\u065c';
            }
            case '\u0623': {
                return '\u065d';
            }
            case '\u0625': {
                return '\u065e';
            }
            case '\u0627': {
                return '\u065f';
            }
        }
        return '\u0000';
    }

    private static int specialChar(char ch) {
        if (ch > '\u0621' && ch < '\u0626' || ch == '\u0627' || ch > '\u062e' && ch < '\u0633' || ch > '\u0647' && ch < '\u064a' || ch == '\u0629') {
            return 1;
        }
        if (ch >= '\u064b' && ch <= '\u0652') {
            return 2;
        }
        if (ch >= '\u0653' && ch <= '\u0655' || ch == '\u0670' || ch >= '\ufe70' && ch <= '\ufe7f') {
            return 3;
        }
        return 0;
    }

    private static int getLink(char ch) {
        if (ch >= '\u0622' && ch <= '\u06d3') {
            return araLink[ch - 1570];
        }
        if (ch == '\u200d') {
            return 3;
        }
        if (ch >= '\u206d' && ch <= '\u206f') {
            return 4;
        }
        if (ch >= '\ufe70' && ch <= '\ufefc') {
            return presLink[ch - 65136];
        }
        return 0;
    }

    private static int countSpacesLeft(char[] dest, int start, int count) {
        int i = start;
        int e = start + count;
        while (i < e) {
            if (dest[i] != ' ') {
                return i - start;
            }
            ++i;
        }
        return count;
    }

    private static int countSpacesRight(char[] dest, int start, int count) {
        int i = start + count;
        while (--i >= start) {
            if (dest[i] == ' ') continue;
            return start + count - 1 - i;
        }
        return count;
    }

    private static boolean isTashkeelChar(char ch) {
        return ch >= '\u064b' && ch <= '\u0652';
    }

    private static boolean isAlefChar(char ch) {
        return ch == '\u0622' || ch == '\u0623' || ch == '\u0625' || ch == '\u0627';
    }

    private static boolean isLamAlefChar(char ch) {
        return ch >= '\ufef5' && ch <= '\ufefc';
    }

    private static boolean isNormalizedLamAlefChar(char ch) {
        return ch >= '\u065c' && ch <= '\u065f';
    }

    private int calculateSize(char[] source, int sourceStart, int sourceLength) {
        int destSize = sourceLength;
        switch (this.options & 0x18) {
            case 8: 
            case 24: {
                if (this.isLogical) {
                    int i = sourceStart;
                    int e = sourceStart + sourceLength - 1;
                    while (i < e) {
                        if (source[i] == '\u0644' && ArabicShaping.isAlefChar(source[i + 1])) {
                            --destSize;
                        }
                        ++i;
                    }
                } else {
                    int i = sourceStart + 1;
                    int e = sourceStart + sourceLength;
                    while (i < e) {
                        if (source[i] == '\u0644' && ArabicShaping.isAlefChar(source[i - 1])) {
                            --destSize;
                        }
                        ++i;
                    }
                }
                break;
            }
            case 16: {
                int i = sourceStart;
                int e = sourceStart + sourceLength;
                while (i < e) {
                    if (ArabicShaping.isLamAlefChar(source[i])) {
                        ++destSize;
                    }
                    ++i;
                }
                break;
            }
        }
        return destSize;
    }

    /*
     * Unable to fully structure code
     */
    private int removeLamAlefSpaces(char[] dest, int start, int length) {
        block14: {
            block15: {
                block13: {
                    lenOptions = this.options & 3;
                    if (!this.isLogical) {
                        switch (lenOptions) {
                            case 3: {
                                lenOptions = 2;
                                break;
                            }
                            case 2: {
                                lenOptions = 3;
                                break;
                            }
                        }
                    }
                    if (lenOptions != 1) break block13;
                    i = start;
                    e = i + length;
                    while (i < e) {
                        if (dest[i] == '\uffff') {
                            dest[i] = 32;
                        }
                        ++i;
                    }
                    break block14;
                }
                w = e = start + length;
                r = e;
                while (--r >= start) {
                    ch = dest[r];
                    if (ch == '\uffff' || --w == r) continue;
                    dest[w] = ch;
                }
                if (lenOptions != 2) break block15;
                while (w > start) {
                    dest[--w] = 32;
                }
                break block14;
            }
            if (w > start) {
                r = w;
                w = start;
                while (r < e) {
                    dest[w++] = dest[r++];
                }
            } else {
                w = e;
            }
            if (lenOptions != 0) ** GOTO lbl45
            length = w - start;
            break block14;
lbl-1000:
            // 1 sources

            {
                dest[w++] = 32;
lbl45:
                // 2 sources

                ** while (w < e)
            }
        }
        return length;
    }

    private int expandLamAlef(char[] dest, int start, int length, int lacount) throws ArabicShapingException {
        int lenOptions = this.options & 3;
        if (!this.isLogical) {
            switch (lenOptions) {
                case 3: {
                    lenOptions = 2;
                    break;
                }
                case 2: {
                    lenOptions = 3;
                    break;
                }
            }
        }
        switch (lenOptions) {
            case 0: {
                int r = start + length;
                int w = r + lacount;
                while (--r >= start) {
                    char ch = dest[r];
                    if (ArabicShaping.isNormalizedLamAlefChar(ch)) {
                        dest[--w] = 1604;
                        dest[--w] = convertNormalizedLamAlef[ch - 1628];
                        continue;
                    }
                    dest[--w] = ch;
                }
                length += lacount;
                break;
            }
            case 1: {
                if (ArabicShaping.isNormalizedLamAlefChar(dest[start])) {
                    throw new ArabicShapingException("no space for lamalef");
                }
                int i = start + length;
                while (--i > start) {
                    char ch = dest[i];
                    if (!ArabicShaping.isNormalizedLamAlefChar(ch)) continue;
                    if (dest[i - 1] == ' ') {
                        dest[i] = 1604;
                        dest[--i] = convertNormalizedLamAlef[ch - 1628];
                        continue;
                    }
                    throw new ArabicShapingException("no space for lamalef");
                }
                break;
            }
            case 2: {
                if (lacount > ArabicShaping.countSpacesLeft(dest, start, length)) {
                    throw new ArabicShapingException("no space for lamalef");
                }
                int r = start + lacount;
                int w = start;
                int e = start + length;
                while (r < e) {
                    char ch = dest[r];
                    if (ArabicShaping.isNormalizedLamAlefChar(ch)) {
                        dest[w++] = convertNormalizedLamAlef[ch - 1628];
                        dest[w++] = 1604;
                    } else {
                        dest[w++] = ch;
                    }
                    ++r;
                }
                break;
            }
            case 3: {
                if (lacount > ArabicShaping.countSpacesRight(dest, start, length)) {
                    throw new ArabicShapingException("no space for lamalef");
                }
                int r = start + length - lacount;
                int w = start + length;
                while (--r >= start) {
                    char ch = dest[r];
                    if (ArabicShaping.isNormalizedLamAlefChar(ch)) {
                        dest[--w] = 1604;
                        dest[--w] = convertNormalizedLamAlef[ch - 1628];
                        continue;
                    }
                    dest[--w] = ch;
                }
                break;
            }
        }
        return length;
    }

    private int normalize(char[] dest, int start, int length) {
        int lacount = 0;
        int i = start;
        int e = i + length;
        while (i < e) {
            char ch = dest[i];
            if (ch >= '\ufe70' && ch <= '\ufefc') {
                if (ArabicShaping.isLamAlefChar(ch)) {
                    ++lacount;
                }
                dest[i] = (char)convertFEto06[ch - 65136];
            }
            ++i;
        }
        return lacount;
    }

    private int shapeUnicode(char[] dest, int start, int length, int destSize, int tashkeelFlag) {
        this.normalize(dest, start, length);
        boolean lamalef_found = false;
        int i = start + length - 1;
        int currLink = ArabicShaping.getLink(dest[i]);
        int nextLink = 0;
        int prevLink = 0;
        int lastLink = 0;
        int lastPos = i;
        int nx = -2;
        int nw = 0;
        while (i >= 0) {
            if ((currLink & 0xFF00) > 0 || ArabicShaping.isTashkeelChar(dest[i])) {
                nw = i - 1;
                nx = -2;
                while (nx < 0) {
                    if (nw == -1) {
                        nextLink = 0;
                        nx = Integer.MAX_VALUE;
                        continue;
                    }
                    nextLink = ArabicShaping.getLink(dest[nw]);
                    if ((nextLink & 4) == 0) {
                        nx = nw;
                        continue;
                    }
                    --nw;
                }
                if ((currLink & 0x20) > 0 && (lastLink & 0x10) > 0) {
                    lamalef_found = true;
                    char wLamalef = ArabicShaping.changeLamAlef(dest[i]);
                    if (wLamalef != '\u0000') {
                        dest[i] = 65535;
                        dest[lastPos] = wLamalef;
                        i = lastPos;
                    }
                    lastLink = prevLink;
                    currLink = ArabicShaping.getLink(wLamalef);
                }
                int flag = ArabicShaping.specialChar(dest[i]);
                int shape = shapeTable[nextLink & 3][lastLink & 3][currLink & 3];
                if (flag == 1) {
                    shape &= 1;
                } else if (flag == 2) {
                    shape = tashkeelFlag == 0 && (lastLink & 2) != 0 && (nextLink & 1) != 0 && dest[i] != '\u064c' && dest[i] != '\u064d' && ((nextLink & 0x20) != 32 || (lastLink & 0x10) != 16) ? 1 : 0;
                }
                if (flag == 2) {
                    if (tashkeelFlag < 2) {
                        dest[i] = (char)(65136 + irrelevantPos[dest[i] - 1611] + shape);
                    }
                } else {
                    dest[i] = (char)(65136 + (currLink >> 8) + shape);
                }
            }
            if ((currLink & 4) == 0) {
                prevLink = lastLink;
                lastLink = currLink;
                lastPos = i;
            }
            if (--i == nx) {
                currLink = nextLink;
                nx = -2;
                continue;
            }
            if (i == -1) continue;
            currLink = ArabicShaping.getLink(dest[i]);
        }
        destSize = lamalef_found ? this.removeLamAlefSpaces(dest, start, length) : length;
        return destSize;
    }

    private int deShapeUnicode(char[] dest, int start, int length, int destSize) throws ArabicShapingException {
        int lamalef_count = this.normalize(dest, start, length);
        destSize = lamalef_count != 0 ? this.expandLamAlef(dest, start, length, lamalef_count) : length;
        return destSize;
    }

    private int internalShape(char[] source, int sourceStart, int sourceLength, char[] dest, int destStart, int destSize) throws ArabicShapingException {
        if (sourceLength == 0) {
            return 0;
        }
        if (destSize == 0) {
            if ((this.options & 0x18) != 0 && (this.options & 3) == 0) {
                return this.calculateSize(source, sourceStart, sourceLength);
            }
            return sourceLength;
        }
        char[] temp = new char[sourceLength * 2];
        System.arraycopy(source, sourceStart, temp, 0, sourceLength);
        if (this.isLogical) {
            ArabicShaping.invertBuffer(temp, 0, sourceLength);
        }
        int outputSize = sourceLength;
        switch (this.options & 0x18) {
            case 24: {
                outputSize = this.shapeUnicode(temp, 0, sourceLength, destSize, 1);
                break;
            }
            case 8: {
                outputSize = this.shapeUnicode(temp, 0, sourceLength, destSize, 0);
                break;
            }
            case 16: {
                outputSize = this.deShapeUnicode(temp, 0, sourceLength, destSize);
                break;
            }
        }
        if (outputSize > destSize) {
            throw new ArabicShapingException("not enough room for result data");
        }
        if ((this.options & 0xE0) != 0) {
            char digitBase = '0';
            switch (this.options & 0x100) {
                case 0: {
                    digitBase = '\u0660';
                    break;
                }
                case 256: {
                    digitBase = '\u06f0';
                    break;
                }
            }
            switch (this.options & 0xE0) {
                case 32: {
                    int digitDelta = digitBase - 48;
                    int i = 0;
                    while (i < outputSize) {
                        char ch = temp[i];
                        if (ch <= '9' && ch >= '0') {
                            int n = i;
                            temp[n] = (char)(temp[n] + digitDelta);
                        }
                        ++i;
                    }
                    break;
                }
                case 64: {
                    char digitTop = (char)(digitBase + 9);
                    int digitDelta = 48 - digitBase;
                    int i = 0;
                    while (i < outputSize) {
                        char ch = temp[i];
                        if (ch <= digitTop && ch >= digitBase) {
                            int n = i;
                            temp[n] = (char)(temp[n] + digitDelta);
                        }
                        ++i;
                    }
                    break;
                }
                case 96: {
                    this.shapeToArabicDigitsWithContext(temp, 0, outputSize, digitBase, false);
                    break;
                }
                case 128: {
                    this.shapeToArabicDigitsWithContext(temp, 0, outputSize, digitBase, true);
                    break;
                }
            }
        }
        if (this.isLogical) {
            ArabicShaping.invertBuffer(temp, 0, outputSize);
        }
        System.arraycopy(temp, 0, dest, destStart, outputSize);
        return outputSize;
    }
}

