/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.team;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertySetContainer;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewPropertySetNode;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemTeamViewPropertySetAdapter
extends AbstractSystemViewAdapter {
    private boolean actionsCreated = false;
    private static PropertyDescriptor[] propertyDescriptorArray = null;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        if (!this.actionsCreated) {
            this.createActions();
        }
    }

    private void createActions() {
        this.actionsCreated = true;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        return ((SystemTeamViewPropertySetNode)element).getImageDescriptor();
    }

    public String getText(Object element) {
        return ((SystemTeamViewPropertySetNode)element).getLabel();
    }

    public String getName(Object element) {
        return ((SystemTeamViewPropertySetNode)element).getLabel();
    }

    public String getAbsoluteName(Object element) {
        SystemTeamViewPropertySetNode factory = (SystemTeamViewPropertySetNode)element;
        return factory.getLabel();
    }

    public String getType(Object element) {
        return SystemViewResources.RESID_PROPERTY_TEAM_PROPERTYSET_TYPE_VALUE;
    }

    public String getStatusLineText(Object element) {
        SystemTeamViewPropertySetNode factory = (SystemTeamViewPropertySetNode)element;
        return String.valueOf(SystemResources.RESID_TEAMVIEW_PROPERTYSET_VALUE) + ": " + factory.getLabel();
    }

    public Object getParent(Object element) {
        SystemTeamViewPropertySetNode factory = (SystemTeamViewPropertySetNode)element;
        return factory.getParent();
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        SystemTeamViewPropertySetNode propertySetNode = (SystemTeamViewPropertySetNode)element;
        IPropertySet propertySet = propertySetNode.getPropertySet();
        IPropertySet[] children = propertySet.getPropertySets();
        if (children == null || children.length == 0) {
            return new Object[0];
        }
        Object[] nodes = new SystemTeamViewPropertySetNode[children.length];
        int i = 0;
        while (i < children.length) {
            nodes[i] = new SystemTeamViewPropertySetNode((IPropertySetContainer)propertySet, children[i]);
            ++i;
        }
        return nodes;
    }

    public boolean hasChildren(IAdaptable element) {
        SystemTeamViewPropertySetNode propertySetNode = (SystemTeamViewPropertySetNode)element;
        IPropertySet propertySet = propertySetNode.getPropertySet();
        IPropertySet[] children = propertySet.getPropertySets();
        return children != null && children.length != 0;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.internalGetPropertyDescriptors();
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        SystemTeamViewPropertySetNode propertySetNode = (SystemTeamViewPropertySetNode)this.propertySourceInput;
        IPropertySet propertySet = propertySetNode.getPropertySet();
        String[] propertyKeys = propertySet.getPropertyKeys();
        int size = propertyKeys.length;
        IProperty nameProperty = propertySet.getProperty("name");
        if (nameProperty == null) {
            nameProperty = propertySet.getProperty("Name");
        }
        int startingIndex = 0;
        if (nameProperty == null) {
            ++size;
        }
        propertyDescriptorArray = new PropertyDescriptor[size];
        if (nameProperty == null) {
            SystemTeamViewPropertySetAdapter.propertyDescriptorArray[startingIndex++] = SystemTeamViewPropertySetAdapter.createSimplePropertyDescriptor("name", "name", propertySet.getName());
        }
        int i = startingIndex;
        int j = 0;
        while (i < size) {
            SystemTeamViewPropertySetAdapter.propertyDescriptorArray[i] = SystemTeamViewPropertySetAdapter.createSimplePropertyDescriptor(propertyKeys[j], propertyKeys[j], propertySet.getPropertyValue(propertyKeys[j]));
            ++i;
            ++j;
        }
        return propertyDescriptorArray;
    }

    public Object internalGetPropertyValue(Object key) {
        SystemTeamViewPropertySetNode propertySetNode = (SystemTeamViewPropertySetNode)this.propertySourceInput;
        IPropertySet propertySet = propertySetNode.getPropertySet();
        return propertySet.getPropertyValue((String)key);
    }

    public String getMementoHandle(Object element) {
        SystemTeamViewPropertySetNode factory = (SystemTeamViewPropertySetNode)element;
        return factory.getMementoHandle();
    }

    public String getMementoHandleKey(Object element) {
        SystemTeamViewPropertySetNode factory = (SystemTeamViewPropertySetNode)element;
        return factory.getLabel();
    }

    public boolean isRemote(Object element) {
        return false;
    }
}

