/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyCompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;
import org.eclipse.jpt.utility.internal.model.value.ListValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.StaticListValueModel;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeListValueModel<E1, E2>
extends ListValueModelWrapper<E1>
implements ListValueModel<E2> {
    private final Transformer<E1, ListValueModel<E2>> transformer;
    private final ArrayList<Info> infoList;
    private final ListChangeListener componentLVMListener;
    private int size;

    public CompositeListValueModel(ListValueModel<? extends E1> listHolder) {
        this(listHolder, Transformer.Null.instance());
    }

    public CompositeListValueModel(ListValueModel<? extends E1> listHolder, Transformer<E1, ListValueModel<E2>> transformer) {
        super(listHolder);
        this.transformer = transformer;
        this.infoList = new ArrayList();
        this.componentLVMListener = this.buildComponentLVMListener();
        this.size = 0;
    }

    public CompositeListValueModel(List<? extends E1> list) {
        this((ListValueModel<? extends E1>)new StaticListValueModel<E1>(list));
    }

    public CompositeListValueModel(List<? extends E1> list, Transformer<E1, ListValueModel<E2>> transformer) {
        this(new StaticListValueModel<E1>(list), transformer);
    }

    protected ListChangeListener buildComponentLVMListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent event) {
                CompositeListValueModel.this.componentItemsAdded(event);
            }

            public void itemsRemoved(ListChangeEvent event) {
                CompositeListValueModel.this.componentItemsRemoved(event);
            }

            public void itemsReplaced(ListChangeEvent event) {
                CompositeListValueModel.this.componentItemsReplaced(event);
            }

            public void itemsMoved(ListChangeEvent event) {
                CompositeListValueModel.this.componentItemsMoved(event);
            }

            public void listCleared(ListChangeEvent event) {
                CompositeListValueModel.this.componentListCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                CompositeListValueModel.this.componentListChanged(event);
            }

            public String toString() {
                return "component LVM listener";
            }
        };
    }

    @Override
    public E2 get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int i = this.infoList.size();
        while (i-- > 0) {
            Info info = this.infoList.get(i);
            if (index < info.begin) continue;
            return info.items.get(index - info.begin);
        }
        throw new IllegalStateException();
    }

    @Override
    public Iterator<E2> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E2> listIterator() {
        return new ReadOnlyCompositeListIterator<E2>(this.buildListsIterators());
    }

    protected ListIterator<ListIterator<E2>> buildListsIterators() {
        return new TransformationListIterator<Info, ListIterator<E2>>(this.infoList.listIterator()){

            @Override
            protected ListIterator<E2> transform(Info info) {
                return info.items.listIterator();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        return CollectionTools.array(this.listIterator(), this.size);
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.addComponentSources(0, this.listHolder.listIterator(), this.listHolder.size());
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        for (Info info : this.infoList) {
            info.componentLVM.removeListChangeListener("list values", this.componentLVMListener);
        }
        this.infoList.clear();
        this.size = 0;
    }

    @Override
    protected void itemsAdded(ListChangeEvent event) {
        this.addComponentSources(event.getIndex(), this.items(event), event.itemsSize(), true);
    }

    protected void addComponentSources(int addedSourcesIndex, ListIterator<? extends E1> addedSources, int addedSourcesSize) {
        this.addComponentSources(addedSourcesIndex, addedSources, addedSourcesSize, false);
    }

    protected void addComponentSources(int addedSourcesIndex, ListIterator<? extends E1> addedSources, int addedSourcesSize, boolean fireEvent) {
        int movedInfosIndex;
        int newItemsIndex;
        ArrayList<Info> newInfoList = new ArrayList<Info>(addedSourcesSize);
        int begin = newItemsIndex = addedSourcesIndex == this.infoList.size() ? this.size : this.infoList.get((int)addedSourcesIndex).begin;
        while (addedSources.hasNext()) {
            E1 source = addedSources.next();
            ListValueModel<E2> componentLVM = this.transform(source);
            componentLVM.addListChangeListener("list values", this.componentLVMListener);
            ArrayList items = new ArrayList(componentLVM.size());
            CollectionTools.addAll(items, componentLVM.listIterator());
            newInfoList.add(new Info(source, componentLVM, items, begin));
            begin += items.size();
        }
        this.infoList.addAll(addedSourcesIndex, newInfoList);
        int newItemsSize = begin - newItemsIndex;
        this.size += newItemsSize;
        int i = movedInfosIndex = addedSourcesIndex + addedSourcesSize;
        while (i < this.infoList.size()) {
            this.infoList.get((int)i).begin += newItemsSize;
            ++i;
        }
        if (fireEvent) {
            ArrayList newItems = new ArrayList(newItemsSize);
            int i2 = addedSourcesIndex;
            while (i2 < movedInfosIndex) {
                newItems.addAll(this.infoList.get((int)i2).items);
                ++i2;
            }
            this.fireItemsAdded("list values", newItemsIndex, newItems);
        }
    }

    @Override
    protected void itemsRemoved(ListChangeEvent event) {
        this.removeComponentSources(event.getIndex(), event.itemsSize(), true);
    }

    protected void removeComponentSources(int removedSourcesIndex, int removedSourcesSize) {
        this.removeComponentSources(removedSourcesIndex, removedSourcesSize, false);
    }

    protected void removeComponentSources(int removedSourcesIndex, int removedSourcesSize, boolean fireEvent) {
        int removedItemsIndex = this.infoList.get((int)removedSourcesIndex).begin;
        int movedSourcesIndex = removedSourcesIndex + removedSourcesSize;
        int movedItemsIndex = movedSourcesIndex == this.infoList.size() ? this.size : this.infoList.get((int)movedSourcesIndex).begin;
        int removedItemsSize = movedItemsIndex - removedItemsIndex;
        this.size -= removedItemsSize;
        List<Info> subList = this.infoList.subList(removedSourcesIndex, removedSourcesIndex + removedSourcesSize);
        ArrayList<Info> removedInfoList = new ArrayList<Info>(subList);
        subList.clear();
        int i = removedSourcesIndex;
        while (i < this.infoList.size()) {
            this.infoList.get((int)i).begin -= removedItemsSize;
            ++i;
        }
        for (Info removedInfo : removedInfoList) {
            removedInfo.componentLVM.removeListChangeListener("list values", this.componentLVMListener);
        }
        if (fireEvent) {
            ArrayList removedItems = new ArrayList(removedItemsSize);
            for (Info removedInfo : removedInfoList) {
                removedItems.addAll(removedInfo.items);
            }
            this.fireItemsRemoved("list values", removedItemsIndex, removedItems);
        }
    }

    @Override
    protected void itemsReplaced(ListChangeEvent event) {
        this.replaceComponentSources(event.getIndex(), this.items(event), event.itemsSize(), true);
    }

    protected void replaceComponentSources(int replacedSourcesIndex, ListIterator<? extends E1> newSources, int replacedSourcesSize, boolean fireEvent) {
        this.removeComponentSources(replacedSourcesIndex, replacedSourcesSize, fireEvent);
        this.addComponentSources(replacedSourcesIndex, newSources, replacedSourcesSize, fireEvent);
    }

    @Override
    protected void itemsMoved(ListChangeEvent event) {
        this.moveComponentSources(event.getTargetIndex(), event.getSourceIndex(), event.getMoveLength(), true);
    }

    protected void moveComponentSources(int targetSourcesIndex, int sourceSourcesIndex, int movedSourcesLength, boolean fireEvent) {
        int sourceItemsIndex = this.infoList.get((int)sourceSourcesIndex).begin;
        int nextSourceSourceIndex = sourceSourcesIndex + movedSourcesLength;
        int nextSourceItemIndex = nextSourceSourceIndex == this.infoList.size() ? this.size : this.infoList.get((int)nextSourceSourceIndex).begin;
        int moveItemsLength = nextSourceItemIndex - sourceItemsIndex;
        int targetItemsIndex = -1;
        if (sourceSourcesIndex > targetSourcesIndex) {
            targetItemsIndex = this.infoList.get((int)targetSourcesIndex).begin;
        } else {
            int nextTargetSourceIndex = targetSourcesIndex + movedSourcesLength;
            targetItemsIndex = nextTargetSourceIndex == this.infoList.size() ? this.size : this.infoList.get((int)nextTargetSourceIndex).begin;
            targetItemsIndex -= moveItemsLength;
        }
        CollectionTools.move(this.infoList, targetSourcesIndex, sourceSourcesIndex, movedSourcesLength);
        int min = Math.min(targetSourcesIndex, sourceSourcesIndex);
        int max = Math.max(targetSourcesIndex, sourceSourcesIndex) + movedSourcesLength;
        int begin = Math.min(targetItemsIndex, sourceItemsIndex);
        int i = min;
        while (i < max) {
            Info info = this.infoList.get(i);
            info.begin = begin;
            begin += info.componentLVM.size();
            ++i;
        }
        if (fireEvent) {
            this.fireItemsMoved("list values", targetItemsIndex, sourceItemsIndex, moveItemsLength);
        }
    }

    @Override
    protected void listCleared(ListChangeEvent event) {
        this.removeComponentSources(0, this.infoList.size());
        this.fireListCleared("list values");
    }

    @Override
    protected void listChanged(ListChangeEvent event) {
        this.removeComponentSources(0, this.infoList.size());
        this.addComponentSources(0, this.listHolder.listIterator(), this.listHolder.size());
        this.fireListChanged("list values");
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(CollectionTools.list(this.listIterator(), this.size));
    }

    protected ListValueModel<E2> transform(E1 value) {
        return this.transformer.transform(value);
    }

    protected int indexOf(ListValueModel<E2> componentLVM) {
        int i = 0;
        while (i < this.infoList.size()) {
            if (this.infoList.get((int)i).componentLVM == componentLVM) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("invalid component LVM: " + componentLVM);
    }

    protected int indexFor(ListChangeEvent event) {
        return this.indexOf(this.componentLVM(event));
    }

    protected void componentItemsAdded(ListChangeEvent event) {
        int componentLVMIndex = this.indexFor(event);
        int newItemsSize = event.itemsSize();
        int i = componentLVMIndex + 1;
        while (i < this.infoList.size()) {
            this.infoList.get((int)i).begin += newItemsSize;
            ++i;
        }
        this.size += newItemsSize;
        Info info = this.infoList.get(componentLVMIndex);
        CollectionTools.addAll(info.items, event.getIndex(), this.componentItems(event), event.itemsSize());
        this.fireItemsAdded(event.cloneWithSource(this, "list values", info.begin));
    }

    protected void componentItemsRemoved(ListChangeEvent event) {
        int componentLVMIndex = this.indexFor(event);
        int removedItemsSize = event.itemsSize();
        int i = componentLVMIndex + 1;
        while (i < this.infoList.size()) {
            this.infoList.get((int)i).begin -= removedItemsSize;
            ++i;
        }
        this.size -= removedItemsSize;
        Info info = this.infoList.get(componentLVMIndex);
        int itemIndex = event.getIndex();
        info.items.subList(itemIndex, itemIndex + event.itemsSize()).clear();
        this.fireItemsRemoved(event.cloneWithSource(this, "list values", info.begin));
    }

    protected void componentItemsReplaced(ListChangeEvent event) {
        int componentLVMIndex = this.indexFor(event);
        Info info = this.infoList.get(componentLVMIndex);
        int i = event.getIndex();
        ListIterator<E2> stream = this.componentItems(event);
        while (stream.hasNext()) {
            info.items.set(i++, stream.next());
        }
        this.fireItemsReplaced(event.cloneWithSource(this, "list values", info.begin));
    }

    protected void componentItemsMoved(ListChangeEvent event) {
        int componentLVMIndex = this.indexFor(event);
        Info info = this.infoList.get(componentLVMIndex);
        CollectionTools.move(info.items, event.getTargetIndex(), event.getSourceIndex(), event.getMoveLength());
        this.fireItemsMoved(event.cloneWithSource(this, "list values", info.begin));
    }

    protected void componentListCleared(ListChangeEvent event) {
        int componentLVMIndex = this.indexFor(event);
        this.clearComponentList(componentLVMIndex, this.infoList.get(componentLVMIndex));
    }

    protected void clearComponentList(int componentLVMIndex, Info info) {
        int removedItemsSize = info.items.size();
        int i = componentLVMIndex + 1;
        while (i < this.infoList.size()) {
            this.infoList.get((int)i).begin -= removedItemsSize;
            ++i;
        }
        this.size -= removedItemsSize;
        ArrayList items = new ArrayList(info.items);
        info.items.clear();
        this.fireItemsRemoved("list values", info.begin, items);
    }

    protected void componentListChanged(ListChangeEvent event) {
        int componentLVMIndex = this.indexFor(event);
        Info info = this.infoList.get(componentLVMIndex);
        this.clearComponentList(componentLVMIndex, info);
        int newItemsSize = info.componentLVM.size();
        int i = componentLVMIndex + 1;
        while (i < this.infoList.size()) {
            this.infoList.get((int)i).begin += newItemsSize;
            ++i;
        }
        this.size += newItemsSize;
        CollectionTools.addAll(info.items, info.componentLVM.listIterator(), newItemsSize);
        this.fireItemsAdded("list values", info.begin, info.items);
    }

    protected ListIterator<E2> componentItems(ListChangeEvent event) {
        return event.items();
    }

    protected ListValueModel<E2> componentLVM(ListChangeEvent event) {
        return (ListValueModel)event.getSource();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Info {
        final E1 source;
        final ListValueModel<E2> componentLVM;
        final ArrayList<E2> items;
        int begin;

        Info(E1 source, ListValueModel<E2> componentLVM, ArrayList<E2> items, int begin) {
            this.source = source;
            this.componentLVM = componentLVM;
            this.items = items;
            this.begin = begin;
        }
    }
}

