/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.model.listener.TreeChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModel
implements Model,
Serializable {
    protected ChangeSupport changeSupport;

    protected AbstractModel() {
    }

    protected synchronized ChangeSupport getChangeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = this.buildChangeSupport();
        }
        return this.changeSupport;
    }

    protected ChangeSupport buildChangeSupport() {
        return new ChangeSupport(this);
    }

    @Override
    public void addStateChangeListener(StateChangeListener listener) {
        this.getChangeSupport().addStateChangeListener(listener);
    }

    @Override
    public void removeStateChangeListener(StateChangeListener listener) {
        this.getChangeSupport().removeStateChangeListener(listener);
    }

    public boolean hasAnyStateChangeListeners() {
        return this.changeSupport != null && this.changeSupport.hasAnyStateChangeListeners();
    }

    public boolean hasNoStateChangeListeners() {
        return !this.hasAnyStateChangeListeners();
    }

    protected final void fireStateChanged(StateChangeEvent event) {
        this.getChangeSupport().fireStateChanged(event);
    }

    protected final void fireStateChanged() {
        this.getChangeSupport().fireStateChanged();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getChangeSupport().addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getChangeSupport().removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    public boolean hasAnyPropertyChangeListeners(String propertyName) {
        return this.changeSupport != null && this.changeSupport.hasAnyPropertyChangeListeners(propertyName);
    }

    public boolean hasNoPropertyChangeListeners(String propertyName) {
        return !this.hasAnyPropertyChangeListeners(propertyName);
    }

    public boolean hasAnyPropertyChangeListeners() {
        return this.changeSupport != null && this.changeSupport.hasAnyPropertyChangeListeners();
    }

    public boolean hasNoPropertyChangeListeners() {
        return !this.hasAnyPropertyChangeListeners();
    }

    protected final void firePropertyChanged(PropertyChangeEvent event) {
        this.getChangeSupport().firePropertyChanged(event);
    }

    protected final void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.getChangeSupport().firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChanged(String propertyName, int oldValue, int newValue) {
        this.getChangeSupport().firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChanged(String propertyName, boolean oldValue, boolean newValue) {
        this.getChangeSupport().firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChanged(String propertyName, Object newValue) {
        this.firePropertyChanged(propertyName, null, newValue);
    }

    @Override
    public void addCollectionChangeListener(CollectionChangeListener listener) {
        this.getChangeSupport().addCollectionChangeListener(listener);
    }

    @Override
    public void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.getChangeSupport().addCollectionChangeListener(collectionName, listener);
    }

    @Override
    public void removeCollectionChangeListener(CollectionChangeListener listener) {
        this.getChangeSupport().removeCollectionChangeListener(listener);
    }

    @Override
    public void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.getChangeSupport().removeCollectionChangeListener(collectionName, listener);
    }

    public boolean hasAnyCollectionChangeListeners(String collectionName) {
        return this.changeSupport != null && this.changeSupport.hasAnyCollectionChangeListeners(collectionName);
    }

    public boolean hasNoCollectionChangeListeners(String collectionName) {
        return !this.hasAnyCollectionChangeListeners(collectionName);
    }

    public boolean hasAnyCollectionChangeListeners() {
        return this.changeSupport != null && this.changeSupport.hasAnyCollectionChangeListeners();
    }

    public boolean hasNoCollectionChangeListeners() {
        return !this.hasAnyCollectionChangeListeners();
    }

    protected final void fireItemsAdded(CollectionChangeEvent event) {
        this.getChangeSupport().fireItemsAdded(event);
    }

    protected final void fireItemsAdded(String collectionName, Collection<?> addedItems) {
        this.getChangeSupport().fireItemsAdded(collectionName, addedItems);
    }

    protected final void fireItemAdded(String collectionName, Object addedItem) {
        this.getChangeSupport().fireItemAdded(collectionName, addedItem);
    }

    protected final void fireItemsRemoved(CollectionChangeEvent event) {
        this.getChangeSupport().fireItemsRemoved(event);
    }

    protected final void fireItemsRemoved(String collectionName, Collection<?> removedItems) {
        this.getChangeSupport().fireItemsRemoved(collectionName, removedItems);
    }

    protected final void fireItemRemoved(String collectionName, Object removedItem) {
        this.getChangeSupport().fireItemRemoved(collectionName, removedItem);
    }

    protected final void fireCollectionCleared(CollectionChangeEvent event) {
        this.getChangeSupport().fireCollectionCleared(event);
    }

    protected final void fireCollectionCleared(String collectionName) {
        this.getChangeSupport().fireCollectionCleared(collectionName);
    }

    protected final void fireCollectionChanged(CollectionChangeEvent event) {
        this.getChangeSupport().fireCollectionChanged(event);
    }

    protected final void fireCollectionChanged(String collectionName) {
        this.getChangeSupport().fireCollectionChanged(collectionName);
    }

    protected <E> boolean addItemToCollection(E item, Collection<E> collection, String collectionName) {
        return this.getChangeSupport().addItemToCollection(item, collection, collectionName);
    }

    protected <E> boolean addItemsToCollection(E[] items, Collection<E> collection, String collectionName) {
        return this.getChangeSupport().addItemsToCollection(items, collection, collectionName);
    }

    protected <E> boolean addItemsToCollection(Collection<? extends E> items, Collection<E> collection, String collectionName) {
        return this.getChangeSupport().addItemsToCollection(items, collection, collectionName);
    }

    protected <E> boolean addItemsToCollection(Iterable<? extends E> items, Collection<E> collection, String collectionName) {
        return this.getChangeSupport().addItemsToCollection(items, collection, collectionName);
    }

    protected <E> boolean addItemsToCollection(Iterator<? extends E> items, Collection<E> collection, String collectionName) {
        return this.getChangeSupport().addItemsToCollection(items, collection, collectionName);
    }

    protected boolean removeItemFromCollection(Object item, Collection<?> collection, String collectionName) {
        return this.getChangeSupport().removeItemFromCollection(item, collection, collectionName);
    }

    protected boolean removeItemsFromCollection(Object[] items, Collection<?> collection, String collectionName) {
        return this.getChangeSupport().removeItemsFromCollection(items, collection, collectionName);
    }

    protected boolean removeItemsFromCollection(Collection<?> items, Collection<?> collection, String collectionName) {
        return this.getChangeSupport().removeItemsFromCollection(items, collection, collectionName);
    }

    protected boolean removeItemsFromCollection(Iterable<?> items, Collection<?> collection, String collectionName) {
        return this.getChangeSupport().removeItemsFromCollection(items, collection, collectionName);
    }

    protected boolean removeItemsFromCollection(Iterator<?> items, Collection<?> collection, String collectionName) {
        return this.getChangeSupport().removeItemsFromCollection(items, collection, collectionName);
    }

    protected boolean retainItemsInCollection(Object[] items, Collection<?> collection, String collectionName) {
        return this.getChangeSupport().retainItemsInCollection(items, collection, collectionName);
    }

    protected boolean retainItemsInCollection(Collection<?> items, Collection<?> collection, String collectionName) {
        return this.getChangeSupport().retainItemsInCollection(items, collection, collectionName);
    }

    protected boolean retainItemsInCollection(Iterable<?> items, Collection<?> collection, String collectionName) {
        return this.getChangeSupport().retainItemsInCollection(items, collection, collectionName);
    }

    protected boolean retainItemsInCollection(Iterator<?> items, Collection<?> collection, String collectionName) {
        return this.getChangeSupport().retainItemsInCollection(items, collection, collectionName);
    }

    protected boolean clearCollection(Collection<?> collection, String collectionName) {
        return this.getChangeSupport().clearCollection(collection, collectionName);
    }

    protected <E> boolean synchronizeCollection(Collection<E> newCollection, Collection<E> collection, String collectionName) {
        return this.getChangeSupport().synchronizeCollection(newCollection, collection, collectionName);
    }

    protected <E> boolean synchronizeCollection(Iterator<E> newCollection, Collection<E> collection, String collectionName) {
        return this.getChangeSupport().synchronizeCollection(newCollection, collection, collectionName);
    }

    @Override
    public void addListChangeListener(ListChangeListener listener) {
        this.getChangeSupport().addListChangeListener(listener);
    }

    @Override
    public void addListChangeListener(String listName, ListChangeListener listener) {
        this.getChangeSupport().addListChangeListener(listName, listener);
    }

    @Override
    public void removeListChangeListener(ListChangeListener listener) {
        this.getChangeSupport().removeListChangeListener(listener);
    }

    @Override
    public void removeListChangeListener(String listName, ListChangeListener listener) {
        this.getChangeSupport().removeListChangeListener(listName, listener);
    }

    public boolean hasAnyListChangeListeners(String listName) {
        return this.changeSupport != null && this.changeSupport.hasAnyListChangeListeners(listName);
    }

    public boolean hasNoListChangeListeners(String listName) {
        return !this.hasAnyListChangeListeners(listName);
    }

    public boolean hasAnyListChangeListeners() {
        return this.changeSupport != null && this.changeSupport.hasAnyListChangeListeners();
    }

    public boolean hasNoListChangeListeners() {
        return !this.hasAnyListChangeListeners();
    }

    protected final void fireItemsAdded(ListChangeEvent event) {
        this.getChangeSupport().fireItemsAdded(event);
    }

    protected final void fireItemsAdded(String listName, int index, List<?> addedItems) {
        this.getChangeSupport().fireItemsAdded(listName, index, addedItems);
    }

    protected final void fireItemAdded(String listName, int index, Object addedItem) {
        this.getChangeSupport().fireItemAdded(listName, index, addedItem);
    }

    protected final void fireItemsRemoved(ListChangeEvent event) {
        this.getChangeSupport().fireItemsRemoved(event);
    }

    protected final void fireItemsRemoved(String listName, int index, List<?> removedItems) {
        this.getChangeSupport().fireItemsRemoved(listName, index, removedItems);
    }

    protected final void fireItemRemoved(String listName, int index, Object removedItem) {
        this.getChangeSupport().fireItemRemoved(listName, index, removedItem);
    }

    protected final void fireItemsReplaced(ListChangeEvent event) {
        this.getChangeSupport().fireItemsReplaced(event);
    }

    protected final <E> void fireItemsReplaced(String listName, int index, List<? extends E> newItems, List<E> replacedItems) {
        this.getChangeSupport().fireItemsReplaced(listName, index, newItems, replacedItems);
    }

    protected final void fireItemReplaced(String listName, int index, Object newItem, Object replacedItem) {
        this.getChangeSupport().fireItemReplaced(listName, index, newItem, replacedItem);
    }

    protected final void fireItemsMoved(ListChangeEvent event) {
        this.getChangeSupport().fireItemsMoved(event);
    }

    protected final <E> void fireItemsMoved(String listName, int targetIndex, int sourceIndex, int length) {
        this.getChangeSupport().fireItemsMoved(listName, targetIndex, sourceIndex, length);
    }

    protected final void fireItemMoved(String listName, int targetIndex, int sourceIndex) {
        this.getChangeSupport().fireItemMoved(listName, targetIndex, sourceIndex);
    }

    protected final void fireListCleared(ListChangeEvent event) {
        this.getChangeSupport().fireListCleared(event);
    }

    protected final void fireListCleared(String listName) {
        this.getChangeSupport().fireListCleared(listName);
    }

    protected final void fireListChanged(ListChangeEvent event) {
        this.getChangeSupport().fireListChanged(event);
    }

    protected final void fireListChanged(String listName) {
        this.getChangeSupport().fireListChanged(listName);
    }

    protected <E> void addItemToList(int index, E item, List<E> list, String listName) {
        this.getChangeSupport().addItemToList(index, item, list, listName);
    }

    protected <E> boolean addItemToList(E item, List<E> list, String listName) {
        return this.getChangeSupport().addItemToList(item, list, listName);
    }

    protected <E> boolean addItemsToList(int index, E[] items, List<E> list, String listName) {
        return this.getChangeSupport().addItemsToList(index, items, list, listName);
    }

    protected <E> boolean addItemsToList(int index, Collection<? extends E> items, List<E> list, String listName) {
        return this.getChangeSupport().addItemsToList(index, items, list, listName);
    }

    protected <E> boolean addItemsToList(int index, Iterable<? extends E> items, List<E> list, String listName) {
        return this.getChangeSupport().addItemsToList(index, items, list, listName);
    }

    protected <E> boolean addItemsToList(int index, Iterator<? extends E> items, List<E> list, String listName) {
        return this.getChangeSupport().addItemsToList(index, items, list, listName);
    }

    protected <E> boolean addItemsToList(E[] items, List<E> list, String listName) {
        return this.getChangeSupport().addItemsToList(items, list, listName);
    }

    protected <E> boolean addItemsToList(Collection<? extends E> items, List<E> list, String listName) {
        return this.getChangeSupport().addItemsToList(items, list, listName);
    }

    protected <E> boolean addItemsToList(Iterable<? extends E> items, List<E> list, String listName) {
        return this.getChangeSupport().addItemsToList(items, list, listName);
    }

    protected <E> boolean addItemsToList(Iterator<? extends E> items, List<E> list, String listName) {
        return this.getChangeSupport().addItemsToList(items, list, listName);
    }

    protected <E> E removeItemFromList(int index, List<E> list, String listName) {
        return this.getChangeSupport().removeItemFromList(index, list, listName);
    }

    protected boolean removeItemFromList(Object item, List<?> list, String listName) {
        return this.getChangeSupport().removeItemFromList(item, list, listName);
    }

    protected <E> List<E> removeItemsFromList(int index, int length, List<E> list, String listName) {
        return this.getChangeSupport().removeItemsFromList(index, length, list, listName);
    }

    protected boolean removeItemsFromList(Object[] items, List<?> list, String listName) {
        return this.getChangeSupport().removeItemsFromList(items, list, listName);
    }

    protected boolean removeItemsFromList(Collection<?> items, List<?> list, String listName) {
        return this.getChangeSupport().removeItemsFromList(items, list, listName);
    }

    protected boolean removeItemsFromList(Iterable<?> items, List<?> list, String listName) {
        return this.getChangeSupport().removeItemsFromList(items, list, listName);
    }

    protected boolean removeItemsFromList(Iterator<?> items, List<?> list, String listName) {
        return this.getChangeSupport().removeItemsFromList(items, list, listName);
    }

    protected boolean retainItemsInList(Object[] items, List<?> list, String listName) {
        return this.getChangeSupport().retainItemsInList(items, list, listName);
    }

    protected boolean retainItemsInList(Collection<?> items, List<?> list, String listName) {
        return this.getChangeSupport().retainItemsInList(items, list, listName);
    }

    protected boolean retainItemsInList(Iterable<?> items, List<?> list, String listName) {
        return this.getChangeSupport().retainItemsInList(items, list, listName);
    }

    protected boolean retainItemsInList(Iterator<?> items, List<?> list, String listName) {
        return this.getChangeSupport().retainItemsInList(items, list, listName);
    }

    protected <E> E setItemInList(int index, E item, List<E> list, String listName) {
        return this.getChangeSupport().setItemInList(index, item, list, listName);
    }

    protected <E> int replaceItemInList(E oldItem, E newItem, List<E> list, String listName) {
        return this.getChangeSupport().replaceItemInList(oldItem, newItem, list, listName);
    }

    protected <E> List<E> setItemsInList(int index, E[] items, List<E> list, String listName) {
        return this.getChangeSupport().setItemsInList(index, items, list, listName);
    }

    protected <E> List<E> setItemsInList(int index, List<? extends E> items, List<E> list, String listName) {
        return this.getChangeSupport().setItemsInList(index, items, list, listName);
    }

    protected <E> void moveItemsInList(int targetIndex, int sourceIndex, int length, List<E> list, String listName) {
        this.getChangeSupport().moveItemsInList(targetIndex, sourceIndex, length, list, listName);
    }

    protected <E> void moveItemInList(int targetIndex, int sourceIndex, List<E> list, String listName) {
        this.getChangeSupport().moveItemInList(targetIndex, sourceIndex, list, listName);
    }

    protected boolean clearList(List<?> list, String listName) {
        return this.getChangeSupport().clearList(list, listName);
    }

    protected <E> boolean synchronizeList(List<E> newList, List<E> list, String listName) {
        return this.getChangeSupport().synchronizeList(newList, list, listName);
    }

    protected <E> boolean synchronizeList(Iterator<E> newList, List<E> list, String listName) {
        return this.getChangeSupport().synchronizeList(newList, list, listName);
    }

    @Override
    public void addTreeChangeListener(TreeChangeListener listener) {
        this.getChangeSupport().addTreeChangeListener(listener);
    }

    @Override
    public void addTreeChangeListener(String treeName, TreeChangeListener listener) {
        this.getChangeSupport().addTreeChangeListener(treeName, listener);
    }

    @Override
    public void removeTreeChangeListener(TreeChangeListener listener) {
        this.getChangeSupport().removeTreeChangeListener(listener);
    }

    @Override
    public void removeTreeChangeListener(String treeName, TreeChangeListener listener) {
        this.getChangeSupport().removeTreeChangeListener(treeName, listener);
    }

    public boolean hasAnyTreeChangeListeners(String treeName) {
        return this.changeSupport != null && this.changeSupport.hasAnyTreeChangeListeners(treeName);
    }

    public boolean hasNoTreeChangeListeners(String treeName) {
        return !this.hasAnyTreeChangeListeners(treeName);
    }

    public boolean hasAnyTreeChangeListeners() {
        return this.changeSupport != null && this.changeSupport.hasAnyTreeChangeListeners();
    }

    public boolean hasNoTreeChangeListeners() {
        return !this.hasAnyTreeChangeListeners();
    }

    protected final void fireNodeAdded(TreeChangeEvent event) {
        this.getChangeSupport().fireNodeAdded(event);
    }

    protected final void fireNodeAdded(String treeName, Object[] path) {
        this.getChangeSupport().fireNodeAdded(treeName, path);
    }

    protected final void fireNodeRemoved(TreeChangeEvent event) {
        this.getChangeSupport().fireNodeRemoved(event);
    }

    protected final void fireNodeRemoved(String treeName, Object[] path) {
        this.getChangeSupport().fireNodeRemoved(treeName, path);
    }

    protected final void fireTreeCleared(TreeChangeEvent event) {
        this.getChangeSupport().fireTreeCleared(event);
    }

    protected final void fireTreeCleared(String treeName, Object[] path) {
        this.getChangeSupport().fireTreeCleared(treeName, path);
    }

    protected final void fireTreeCleared(String treeName) {
        this.getChangeSupport().fireTreeCleared(treeName);
    }

    protected final void fireTreeChanged(TreeChangeEvent event) {
        this.getChangeSupport().fireTreeChanged(event);
    }

    protected final void fireTreeChanged(String treeName, Object[] path) {
        this.getChangeSupport().fireTreeChanged(treeName, path);
    }

    protected final void fireTreeChanged(String treeName) {
        this.getChangeSupport().fireTreeChanged(treeName);
    }

    protected final boolean valuesAreEqual(Object value1, Object value2) {
        return this.getChangeSupport().valuesAreEqual(value1, value2);
    }

    protected final boolean attributeValueHasNotChanged(Object oldValue, Object newValue) {
        return this.valuesAreEqual(oldValue, newValue);
    }

    protected final boolean valuesAreDifferent(Object value1, Object value2) {
        return this.getChangeSupport().valuesAreDifferent(value1, value2);
    }

    protected final boolean attributeValueHasChanged(Object oldValue, Object newValue) {
        return this.valuesAreDifferent(oldValue, newValue);
    }

    protected AbstractModel clone() throws CloneNotSupportedException {
        AbstractModel clone = (AbstractModel)super.clone();
        clone.changeSupport = null;
        return clone;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringTools.buildSimpleToStringOn((Object)this, sb);
        sb.append(" (");
        this.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
    }
}

