/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.Serializable;
import org.eclipse.jpt.utility.Command;

public class SynchronizedBoolean
implements Cloneable,
Serializable {
    private boolean value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedBoolean(boolean value, Object mutex) {
        this.value = value;
        this.mutex = mutex;
    }

    public SynchronizedBoolean(boolean value) {
        this.value = value;
        this.mutex = this;
    }

    public SynchronizedBoolean(Object mutex) {
        this(false, mutex);
    }

    public SynchronizedBoolean() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean value() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTrue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFalse() {
        Object object = this.mutex;
        synchronized (object) {
            return !this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean is(boolean v) {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(boolean value) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.value != value) {
                this.value = value;
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrue() {
        Object object = this.mutex;
        synchronized (object) {
            this.setValue(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFalse() {
        Object object = this.mutex;
        synchronized (object) {
            this.setValue(false);
        }
    }

    public Object mutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIs(boolean v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            while (this.value != v) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilTrue() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFalse() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetValue(boolean v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs(!v);
            this.setValue(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetTrue() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitToSetValue(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetFalse() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitToSetValue(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIs(boolean v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            block5: {
                if (timeout != 0L) break block5;
                this.waitUntilValueIs(v);
                return true;
            }
            long stop = System.currentTimeMillis() + timeout;
            long remaining = timeout;
            while (this.value != v && remaining > 0L) {
                this.mutex.wait(remaining);
                remaining = stop - System.currentTimeMillis();
            }
            return this.value == v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilTrue(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs(true, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilFalse(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs(false, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetValue(boolean v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilValueIs(!v, timeout);
            if (success) {
                this.setValue(v);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetTrue(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitToSetValue(true, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetFalse(long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitToSetValue(false, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                return super.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof SynchronizedBoolean) {
            return this.value() == ((SynchronizedBoolean)o).value();
        }
        return false;
    }

    public int hashCode() {
        return this.value() ? 1 : 0;
    }

    public String toString() {
        return String.valueOf(this.value());
    }
}

